/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import javax.annotation.Nullable;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.common.type.TimestampTZ;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateDiffColCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateDiffColScalar;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorUDFDateDiffScalarCol;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.io.TimestampLocalTZWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.io.IntWritable;

@Description(name="datediff", value="_FUNC_(date1, date2) - Returns the number of days between date1 and date2", extended="date1 and date2 are strings in the format 'yyyy-MM-dd HH:mm:ss' or 'yyyy-MM-dd'. The time parts are ignored.If date1 is earlier than date2, the result is negative.\nExample:\n   > SELECT _FUNC_('2009-07-30', '2009-07-31') FROM src LIMIT 1;\n  1")
@VectorizedExpressions(value={VectorUDFDateDiffColScalar.class, VectorUDFDateDiffColCol.class, VectorUDFDateDiffScalarCol.class})
public class GenericUDFDateDiff
extends GenericUDF {
    private transient ObjectInspectorConverters.Converter inputConverter1;
    private transient ObjectInspectorConverters.Converter inputConverter2;
    private IntWritable output = new IntWritable();
    private transient PrimitiveObjectInspector.PrimitiveCategory inputType1;
    private transient PrimitiveObjectInspector.PrimitiveCategory inputType2;
    private IntWritable result = new IntWritable();

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 2) {
            throw new UDFArgumentLengthException("datediff() requires 2 argument, got " + arguments.length);
        }
        this.inputConverter1 = this.checkArguments(arguments, 0);
        this.inputConverter2 = this.checkArguments(arguments, 1);
        this.inputType1 = ((PrimitiveObjectInspector)arguments[0]).getPrimitiveCategory();
        this.inputType2 = ((PrimitiveObjectInspector)arguments[1]).getPrimitiveCategory();
        WritableIntObjectInspector outputOI = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        return outputOI;
    }

    public IntWritable evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        this.output = this.evaluate(this.convertToDate(this.inputType1, this.inputConverter1, arguments[0]), this.convertToDate(this.inputType2, this.inputConverter2, arguments[1]));
        return this.output;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("datediff", children);
    }

    @Nullable
    private Date convertToDate(PrimitiveObjectInspector.PrimitiveCategory inputType, ObjectInspectorConverters.Converter converter, GenericUDF.DeferredObject argument) throws HiveException {
        assert (converter != null);
        assert (argument != null);
        if (argument.get() == null) {
            return null;
        }
        switch (inputType) {
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                String dateString = converter.convert(argument.get()).toString();
                try {
                    return Date.valueOf(dateString);
                }
                catch (IllegalArgumentException e) {
                    Timestamp ts = PrimitiveObjectInspectorUtils.getTimestampFromString(dateString);
                    if (ts != null) {
                        return Date.ofEpochMilli(ts.toEpochMilli());
                    }
                    return null;
                }
            }
            case TIMESTAMP: {
                Timestamp ts = ((TimestampWritableV2)converter.convert(argument.get())).getTimestamp();
                return Date.ofEpochMilli(ts.toEpochMilli());
            }
            case DATE: {
                DateWritableV2 dw = (DateWritableV2)converter.convert(argument.get());
                return dw.get();
            }
            case TIMESTAMPLOCALTZ: {
                TimestampTZ tsz = ((TimestampLocalTZWritable)converter.convert(argument.get())).getTimestampTZ();
                return Date.ofEpochMilli(tsz.getEpochSecond() * 1000L);
            }
        }
        throw new UDFArgumentException("TO_DATE() only takes STRING/TIMESTAMP/TIMESTAMPLOCALTZ types, got " + inputType);
    }

    private ObjectInspectorConverters.Converter checkArguments(ObjectInspector[] arguments, int i) throws UDFArgumentException {
        if (arguments[i].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentTypeException(0, "Only primitive type arguments are accepted but " + arguments[i].getTypeName() + " is passed. as first arguments");
        }
        PrimitiveObjectInspector.PrimitiveCategory inputType = ((PrimitiveObjectInspector)arguments[i]).getPrimitiveCategory();
        switch (inputType) {
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                return ObjectInspectorConverters.getConverter(arguments[i], (ObjectInspector)PrimitiveObjectInspectorFactory.writableStringObjectInspector);
            }
            case TIMESTAMP: {
                return new PrimitiveObjectInspectorConverter.TimestampConverter((PrimitiveObjectInspector)arguments[i], PrimitiveObjectInspectorFactory.writableTimestampObjectInspector);
            }
            case TIMESTAMPLOCALTZ: {
                return new PrimitiveObjectInspectorConverter.TimestampLocalTZConverter((PrimitiveObjectInspector)arguments[i], PrimitiveObjectInspectorFactory.writableTimestampTZObjectInspector);
            }
            case DATE: {
                return ObjectInspectorConverters.getConverter(arguments[i], (ObjectInspector)PrimitiveObjectInspectorFactory.writableDateObjectInspector);
            }
        }
        throw new UDFArgumentException(" DATEDIFF() only takes STRING/TIMESTAMP/DATEWRITABLE/TIMESTAMPLOCALTZ types as " + (i + 1) + "-th argument, got " + inputType);
    }

    private IntWritable evaluate(Date date, Date date2) {
        if (date == null || date2 == null) {
            return null;
        }
        this.result.set(DateWritableV2.dateToDays(date) - DateWritableV2.dateToDays(date2));
        return this.result;
    }
}

