/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.translator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.Tree;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlMonotonicBinaryOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.util.Util;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.functions.CanAggregateDistinct;
import org.apache.hadoop.hive.ql.optimizer.calcite.functions.HiveSqlAverageAggFunction;
import org.apache.hadoop.hive.ql.optimizer.calcite.functions.HiveSqlCountAggFunction;
import org.apache.hadoop.hive.ql.optimizer.calcite.functions.HiveSqlMinMaxAggFunction;
import org.apache.hadoop.hive.ql.optimizer.calcite.functions.HiveSqlSumAggFunction;
import org.apache.hadoop.hive.ql.optimizer.calcite.functions.HiveSqlVarianceAggFunction;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveBetween;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveConcat;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveDateAddSqlOperator;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveDateSubSqlOperator;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveExtractDate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFloorDate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFromUnixTimeSqlOperator;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveIn;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveToDateSqlOperator;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTruncSqlOperator;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveUnixTimestampSqlOperator;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.TypeConverter;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.SettableUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNegative;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPPositive;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TimestampLocalTZTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlFunctionConverter {
    private static final Logger LOG = LoggerFactory.getLogger(SqlFunctionConverter.class);
    static final Map<String, SqlOperator> hiveToCalcite;
    static final Map<SqlOperator, HiveToken> calciteToHiveToken;
    static final Map<SqlOperator, String> reverseOperatorMap;

    public static SqlOperator getCalciteOperator(String funcTextName, GenericUDF hiveUDF, ImmutableList<RelDataType> calciteArgTypes, RelDataType retType) throws SemanticException {
        if (hiveUDF instanceof GenericUDFOPNegative) {
            return SqlStdOperatorTable.UNARY_MINUS;
        }
        if (hiveUDF instanceof GenericUDFOPPositive) {
            return SqlStdOperatorTable.UNARY_PLUS;
        }
        String name = null;
        if (StringUtils.isEmpty(funcTextName)) {
            name = SqlFunctionConverter.getName(hiveUDF);
            LOG.warn("The function text was empty, name from annotation is " + name);
        } else {
            name = FunctionRegistry.getNormalizedFunctionName(funcTextName);
        }
        boolean isDeterministic = FunctionRegistry.isConsistentWithinQuery(hiveUDF);
        boolean isDynamicFunction = FunctionRegistry.isRuntimeConstant(hiveUDF);
        return SqlFunctionConverter.getCalciteFn(name, calciteArgTypes, retType, isDeterministic, isDynamicFunction);
    }

    public static SqlOperator getCalciteOperator(String funcTextName, GenericUDTF hiveUDTF, ImmutableList<RelDataType> calciteArgTypes, RelDataType retType) throws SemanticException {
        String name = FunctionRegistry.getNormalizedFunctionName(funcTextName);
        return SqlFunctionConverter.getCalciteFn(name, calciteArgTypes, retType, false, false);
    }

    public static GenericUDF getHiveUDF(SqlOperator op, RelDataType dt, int argsLength) {
        FunctionInfo hFn;
        String name = reverseOperatorMap.get(op);
        if (name == null) {
            name = op.getName();
        }
        if (argsLength == 1) {
            if ("+".equals(name)) {
                name = "positive";
            } else if ("-".equals(name)) {
                name = "negative";
            }
        }
        try {
            hFn = name != null ? FunctionRegistry.getFunctionInfo(name) : null;
        }
        catch (SemanticException e) {
            LOG.warn("Failed to load udf " + name, (Throwable)e);
            hFn = null;
        }
        if (hFn == null) {
            try {
                hFn = SqlFunctionConverter.handleExplicitCast(op, dt);
            }
            catch (SemanticException e) {
                LOG.warn("Failed to load udf " + name, (Throwable)e);
                hFn = null;
            }
        }
        return hFn == null ? null : hFn.getGenericUDF();
    }

    private static FunctionInfo handleExplicitCast(SqlOperator op, RelDataType dt) throws SemanticException {
        FunctionInfo castUDF = null;
        if (op.kind == SqlKind.CAST) {
            TypeInfo castType = TypeConverter.convert(dt);
            if (castType.equals(TypeInfoFactory.byteTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("tinyint");
            } else if (castType instanceof CharTypeInfo) {
                castUDF = SqlFunctionConverter.handleCastForParameterizedType(castType, FunctionRegistry.getFunctionInfo("char"));
            } else if (castType instanceof VarcharTypeInfo) {
                castUDF = SqlFunctionConverter.handleCastForParameterizedType(castType, FunctionRegistry.getFunctionInfo("varchar"));
            } else if (castType.equals(TypeInfoFactory.stringTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("string");
            } else if (castType.equals(TypeInfoFactory.booleanTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("boolean");
            } else if (castType.equals(TypeInfoFactory.shortTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("smallint");
            } else if (castType.equals(TypeInfoFactory.intTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("int");
            } else if (castType.equals(TypeInfoFactory.longTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("bigint");
            } else if (castType.equals(TypeInfoFactory.floatTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("float");
            } else if (castType.equals(TypeInfoFactory.doubleTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("double");
            } else if (castType.equals(TypeInfoFactory.timestampTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("timestamp");
            } else if (castType instanceof TimestampLocalTZTypeInfo) {
                castUDF = SqlFunctionConverter.handleCastForParameterizedType(castType, FunctionRegistry.getFunctionInfo("timestamp with local time zone"));
            } else if (castType.equals(TypeInfoFactory.dateTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("date");
            } else if (castType instanceof DecimalTypeInfo) {
                castUDF = SqlFunctionConverter.handleCastForParameterizedType(castType, FunctionRegistry.getFunctionInfo("decimal"));
            } else if (castType.equals(TypeInfoFactory.binaryTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("binary");
            } else if (castType.equals(TypeInfoFactory.intervalDayTimeTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("interval_day_time");
            } else if (castType.equals(TypeInfoFactory.intervalYearMonthTypeInfo)) {
                castUDF = FunctionRegistry.getFunctionInfo("interval_year_month");
            } else {
                throw new IllegalStateException("Unexpected type : " + castType.getQualifiedName());
            }
        }
        return castUDF;
    }

    private static FunctionInfo handleCastForParameterizedType(TypeInfo ti, FunctionInfo fi) {
        SettableUDF udf = (SettableUDF)((Object)fi.getGenericUDF());
        try {
            udf.setTypeInfo(ti);
        }
        catch (UDFArgumentException e) {
            throw new RuntimeException(e);
        }
        return new FunctionInfo(fi.getFunctionType(), fi.getDisplayName(), (GenericUDF)((Object)udf), fi.getResources());
    }

    public static ASTNode buildAST(SqlOperator op, List<ASTNode> children) {
        ASTNode node;
        HiveToken hToken = calciteToHiveToken.get(op);
        if (hToken != null) {
            switch (op.kind) {
                case IN: 
                case BETWEEN: 
                case ROW: 
                case IS_NOT_NULL: 
                case IS_NULL: 
                case CASE: 
                case EXTRACT: 
                case FLOOR: 
                case CEIL: 
                case LIKE: 
                case OTHER_FUNCTION: {
                    node = (ASTNode)ParseDriver.adaptor.create(844, "TOK_FUNCTION");
                    node.addChild((Tree)((ASTNode)ParseDriver.adaptor.create(hToken.type, hToken.text)));
                    break;
                }
                default: {
                    node = (ASTNode)ParseDriver.adaptor.create(hToken.type, hToken.text);
                    break;
                }
            }
        } else {
            node = (ASTNode)ParseDriver.adaptor.create(844, "TOK_FUNCTION");
            if (op.kind != SqlKind.CAST) {
                if (op.kind == SqlKind.MINUS_PREFIX) {
                    node = (ASTNode)ParseDriver.adaptor.create(365, "MINUS");
                } else if (op.kind == SqlKind.PLUS_PREFIX) {
                    node = (ASTNode)ParseDriver.adaptor.create(370, "PLUS");
                } else {
                    if (op instanceof HiveSqlCountAggFunction || op instanceof HiveSqlSumAggFunction || op instanceof CalciteUDAF && op.getName().equalsIgnoreCase(SqlStdOperatorTable.AVG.getName())) {
                        if (children.size() == 0) {
                            node = (ASTNode)ParseDriver.adaptor.create(846, "TOK_FUNCTIONSTAR");
                        } else {
                            CanAggregateDistinct distinctFunction = (CanAggregateDistinct)op;
                            if (distinctFunction.isDistinct()) {
                                node = (ASTNode)ParseDriver.adaptor.create(845, "TOK_FUNCTIONDI");
                            }
                        }
                    }
                    node.addChild((Tree)((ASTNode)ParseDriver.adaptor.create(24, op.getName())));
                }
            }
        }
        for (ASTNode c : children) {
            ParseDriver.adaptor.addChild((Object)node, (Object)c);
        }
        return node;
    }

    public static ASTNode buildAST(SqlOperator op, List<ASTNode> children, int i) {
        if (i + 1 < children.size()) {
            HiveToken hToken = calciteToHiveToken.get(op);
            ASTNode curNode = (ASTNode)ParseDriver.adaptor.create(hToken.type, hToken.text);
            ParseDriver.adaptor.addChild((Object)curNode, (Object)children.get(i));
            ParseDriver.adaptor.addChild((Object)curNode, (Object)SqlFunctionConverter.buildAST(op, children, i + 1));
            return curNode;
        }
        return children.get(i);
    }

    private static String getName(GenericUDF hiveUDF) {
        String udfName = null;
        if (hiveUDF instanceof GenericUDFBridge) {
            udfName = ((GenericUDFBridge)hiveUDF).getUdfName();
        } else {
            int indx;
            String[] aliases;
            Description udfDescription;
            Class<?> udfClass = hiveUDF.getClass();
            Description udfAnnotation = udfClass.getAnnotation(Description.class);
            if (udfAnnotation != null && udfAnnotation instanceof Description && (udfName = (udfDescription = udfAnnotation).name()) != null && (aliases = udfName.split(",")).length > 0) {
                udfName = aliases[0];
            }
            if ((udfName == null || udfName.isEmpty()) && (indx = (udfName = hiveUDF.getClass().getName()).lastIndexOf(".")) >= 0) {
                udfName = udfName.substring(++indx);
            }
        }
        return udfName;
    }

    private static HiveToken hToken(int type, String text) {
        return new HiveToken(type, text, new String[0]);
    }

    private static CalciteUDFInfo getUDFInfo(String hiveUdfName, ImmutableList<RelDataType> calciteArgTypes, RelDataType calciteRetType) {
        CalciteUDFInfo udfInfo = new CalciteUDFInfo();
        udfInfo.udfName = hiveUdfName;
        udfInfo.returnTypeInference = ReturnTypes.explicit((RelDataType)calciteRetType);
        udfInfo.operandTypeInference = InferTypes.explicit(calciteArgTypes);
        ImmutableList.Builder typeFamilyBuilder = new ImmutableList.Builder();
        for (RelDataType at : calciteArgTypes) {
            typeFamilyBuilder.add((SqlTypeFamily)Util.first((Object)at.getSqlTypeName().getFamily(), (Object)SqlTypeFamily.ANY));
        }
        udfInfo.operandTypeChecker = OperandTypes.family((List)((Object)typeFamilyBuilder.build()));
        return udfInfo;
    }

    public static SqlOperator getCalciteFn(String hiveUdfName, ImmutableList<RelDataType> calciteArgTypes, RelDataType calciteRetType, boolean deterministic, boolean dynamicFunction) throws CalciteSemanticException {
        Object calciteOp;
        if (hiveUdfName != null && hiveUdfName.trim().equals("<=>")) {
            throw new CalciteSemanticException("<=> is not yet supported for cbo.", CalciteSemanticException.UnsupportedFeature.Less_than_equal_greater_than);
        }
        CalciteUDFInfo uInf = SqlFunctionConverter.getUDFInfo(hiveUdfName, calciteArgTypes, calciteRetType);
        switch (hiveUdfName) {
            case "-": {
                calciteOp = new SqlMonotonicBinaryOperator("-", SqlKind.MINUS, 40, true, uInf.returnTypeInference, uInf.operandTypeInference, (SqlOperandTypeChecker)OperandTypes.MINUS_OPERATOR);
                break;
            }
            case "+": {
                calciteOp = new SqlMonotonicBinaryOperator("+", SqlKind.PLUS, 40, true, uInf.returnTypeInference, uInf.operandTypeInference, (SqlOperandTypeChecker)OperandTypes.PLUS_OPERATOR);
                break;
            }
            default: {
                calciteOp = hiveToCalcite.get(hiveUdfName);
                if (null != calciteOp) break;
                calciteOp = new CalciteSqlFn(uInf.udfName, SqlKind.OTHER_FUNCTION, uInf.returnTypeInference, uInf.operandTypeInference, uInf.operandTypeChecker, SqlFunctionCategory.USER_DEFINED_FUNCTION, deterministic, dynamicFunction);
            }
        }
        return calciteOp;
    }

    public static SqlAggFunction getCalciteAggFn(String hiveUdfName, boolean isDistinct, ImmutableList<RelDataType> calciteArgTypes, RelDataType calciteRetType) {
        SqlAggFunction calciteAggFn = (SqlAggFunction)hiveToCalcite.get(hiveUdfName);
        if (calciteAggFn == null) {
            CalciteUDFInfo udfInfo = SqlFunctionConverter.getUDFInfo(hiveUdfName, calciteArgTypes, calciteRetType);
            switch (hiveUdfName.toLowerCase()) {
                case "sum": {
                    calciteAggFn = new HiveSqlSumAggFunction(isDistinct, udfInfo.returnTypeInference, udfInfo.operandTypeInference, udfInfo.operandTypeChecker);
                    break;
                }
                case "count": {
                    calciteAggFn = new HiveSqlCountAggFunction(isDistinct, udfInfo.returnTypeInference, udfInfo.operandTypeInference, udfInfo.operandTypeChecker);
                    break;
                }
                case "min": {
                    calciteAggFn = new HiveSqlMinMaxAggFunction(udfInfo.returnTypeInference, udfInfo.operandTypeInference, udfInfo.operandTypeChecker, true);
                    break;
                }
                case "max": {
                    calciteAggFn = new HiveSqlMinMaxAggFunction(udfInfo.returnTypeInference, udfInfo.operandTypeInference, udfInfo.operandTypeChecker, false);
                    break;
                }
                case "avg": {
                    calciteAggFn = new HiveSqlAverageAggFunction(udfInfo.returnTypeInference, udfInfo.operandTypeInference, udfInfo.operandTypeChecker);
                    break;
                }
                case "std": 
                case "stddev": 
                case "stddev_pop": {
                    calciteAggFn = new HiveSqlVarianceAggFunction("stddev_pop", SqlKind.STDDEV_POP, udfInfo.returnTypeInference, udfInfo.operandTypeInference, udfInfo.operandTypeChecker);
                    break;
                }
                case "stddev_samp": {
                    calciteAggFn = new HiveSqlVarianceAggFunction("stddev_samp", SqlKind.STDDEV_SAMP, udfInfo.returnTypeInference, udfInfo.operandTypeInference, udfInfo.operandTypeChecker);
                    break;
                }
                case "variance": 
                case "var_pop": {
                    calciteAggFn = new HiveSqlVarianceAggFunction("var_pop", SqlKind.VAR_POP, udfInfo.returnTypeInference, udfInfo.operandTypeInference, udfInfo.operandTypeChecker);
                    break;
                }
                case "var_samp": {
                    calciteAggFn = new HiveSqlVarianceAggFunction("var_samp", SqlKind.VAR_SAMP, udfInfo.returnTypeInference, udfInfo.operandTypeInference, udfInfo.operandTypeChecker);
                    break;
                }
                default: {
                    calciteAggFn = new CalciteUDAF(isDistinct, udfInfo.udfName, udfInfo.returnTypeInference, udfInfo.operandTypeInference, udfInfo.operandTypeChecker);
                }
            }
        }
        return calciteAggFn;
    }

    static {
        StaticBlockBuilder builder = new StaticBlockBuilder();
        hiveToCalcite = ImmutableMap.copyOf(builder.hiveToCalcite);
        calciteToHiveToken = ImmutableMap.copyOf(builder.calciteToHiveToken);
        reverseOperatorMap = ImmutableMap.copyOf(builder.reverseOperatorMap);
    }

    static class HiveToken {
        int type;
        String text;
        String[] args;

        HiveToken(int type, String text, String ... args) {
            this.type = type;
            this.text = text;
            this.args = args;
        }
    }

    private static class CalciteUDFInfo {
        private String udfName;
        private SqlReturnTypeInference returnTypeInference;
        private SqlOperandTypeInference operandTypeInference;
        private SqlOperandTypeChecker operandTypeChecker;

        private CalciteUDFInfo() {
        }
    }

    private static class CalciteSqlFn
    extends SqlFunction {
        private final boolean deterministic;
        private final boolean dynamicFunction;

        public CalciteSqlFn(String name, SqlKind kind, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, SqlFunctionCategory category, boolean deterministic, boolean dynamicFunction) {
            super(name, kind, returnTypeInference, operandTypeInference, operandTypeChecker, category);
            this.deterministic = deterministic;
            this.dynamicFunction = dynamicFunction;
        }

        public boolean isDeterministic() {
            return this.deterministic;
        }

        public boolean isDynamicFunction() {
            return this.dynamicFunction;
        }
    }

    public static class CalciteUDAF
    extends SqlAggFunction
    implements CanAggregateDistinct {
        private final boolean isDistinct;

        public CalciteUDAF(boolean isDistinct, String opName, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker) {
            super(opName, SqlKind.OTHER_FUNCTION, returnTypeInference, operandTypeInference, operandTypeChecker, SqlFunctionCategory.USER_DEFINED_FUNCTION);
            this.isDistinct = isDistinct;
        }

        @Override
        public boolean isDistinct() {
            return this.isDistinct;
        }
    }

    private static class StaticBlockBuilder {
        final Map<String, SqlOperator> hiveToCalcite = Maps.newHashMap();
        final Map<SqlOperator, HiveToken> calciteToHiveToken = Maps.newHashMap();
        final Map<SqlOperator, String> reverseOperatorMap = Maps.newHashMap();

        StaticBlockBuilder() {
            this.registerFunction("+", (SqlOperator)SqlStdOperatorTable.PLUS, SqlFunctionConverter.hToken(370, "+"));
            this.registerFunction("-", (SqlOperator)SqlStdOperatorTable.MINUS, SqlFunctionConverter.hToken(365, "-"));
            this.registerFunction("*", (SqlOperator)SqlStdOperatorTable.MULTIPLY, SqlFunctionConverter.hToken(379, "*"));
            this.registerFunction("/", (SqlOperator)SqlStdOperatorTable.DIVIDE, SqlFunctionConverter.hToken(14, "/"));
            this.registerFunction("%", (SqlOperator)SqlStdOperatorTable.MOD, SqlFunctionConverter.hToken(366, "%"));
            this.registerFunction("and", (SqlOperator)SqlStdOperatorTable.AND, SqlFunctionConverter.hToken(36, "and"));
            this.registerFunction("or", (SqlOperator)SqlStdOperatorTable.OR, SqlFunctionConverter.hToken(216, "or"));
            this.registerFunction("=", (SqlOperator)SqlStdOperatorTable.EQUALS, SqlFunctionConverter.hToken(18, "="));
            this.registerDuplicateFunction("==", (SqlOperator)SqlStdOperatorTable.EQUALS, SqlFunctionConverter.hToken(18, "="));
            this.registerFunction("<", (SqlOperator)SqlStdOperatorTable.LESS_THAN, SqlFunctionConverter.hToken(359, "<"));
            this.registerFunction("<=", (SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, SqlFunctionConverter.hToken(360, "<="));
            this.registerFunction(">", (SqlOperator)SqlStdOperatorTable.GREATER_THAN, SqlFunctionConverter.hToken(21, ">"));
            this.registerFunction(">=", (SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, SqlFunctionConverter.hToken(22, ">="));
            this.registerFunction("not", (SqlOperator)SqlStdOperatorTable.NOT, SqlFunctionConverter.hToken(206, "not"));
            this.registerDuplicateFunction("!", (SqlOperator)SqlStdOperatorTable.NOT, SqlFunctionConverter.hToken(206, "not"));
            this.registerFunction("<>", (SqlOperator)SqlStdOperatorTable.NOT_EQUALS, SqlFunctionConverter.hToken(367, "<>"));
            this.registerDuplicateFunction("!=", (SqlOperator)SqlStdOperatorTable.NOT_EQUALS, SqlFunctionConverter.hToken(367, "<>"));
            this.registerFunction("in", (SqlOperator)HiveIn.INSTANCE, SqlFunctionConverter.hToken(24, "in"));
            this.registerFunction("between", (SqlOperator)HiveBetween.INSTANCE, SqlFunctionConverter.hToken(24, "between"));
            this.registerFunction("struct", (SqlOperator)SqlStdOperatorTable.ROW, SqlFunctionConverter.hToken(24, "struct"));
            this.registerFunction("isnotnull", (SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, SqlFunctionConverter.hToken(24, "isnotnull"));
            this.registerFunction("isnull", (SqlOperator)SqlStdOperatorTable.IS_NULL, SqlFunctionConverter.hToken(24, "isnull"));
            this.registerFunction("is not distinct from", (SqlOperator)SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, SqlFunctionConverter.hToken(19, "<=>"));
            this.registerFunction("when", (SqlOperator)SqlStdOperatorTable.CASE, SqlFunctionConverter.hToken(24, "when"));
            this.registerDuplicateFunction("case", (SqlOperator)SqlStdOperatorTable.CASE, SqlFunctionConverter.hToken(24, "when"));
            this.registerFunction("year", (SqlOperator)HiveExtractDate.YEAR, SqlFunctionConverter.hToken(24, "year"));
            this.registerFunction("quarter", (SqlOperator)HiveExtractDate.QUARTER, SqlFunctionConverter.hToken(24, "quarter"));
            this.registerFunction("month", (SqlOperator)HiveExtractDate.MONTH, SqlFunctionConverter.hToken(24, "month"));
            this.registerFunction("weekofyear", (SqlOperator)HiveExtractDate.WEEK, SqlFunctionConverter.hToken(24, "weekofyear"));
            this.registerFunction("day", (SqlOperator)HiveExtractDate.DAY, SqlFunctionConverter.hToken(24, "day"));
            this.registerFunction("hour", (SqlOperator)HiveExtractDate.HOUR, SqlFunctionConverter.hToken(24, "hour"));
            this.registerFunction("minute", (SqlOperator)HiveExtractDate.MINUTE, SqlFunctionConverter.hToken(24, "minute"));
            this.registerFunction("second", (SqlOperator)HiveExtractDate.SECOND, SqlFunctionConverter.hToken(24, "second"));
            this.registerFunction("floor_year", (SqlOperator)HiveFloorDate.YEAR, SqlFunctionConverter.hToken(24, "floor_year"));
            this.registerFunction("floor_quarter", (SqlOperator)HiveFloorDate.QUARTER, SqlFunctionConverter.hToken(24, "floor_quarter"));
            this.registerFunction("floor_month", (SqlOperator)HiveFloorDate.MONTH, SqlFunctionConverter.hToken(24, "floor_month"));
            this.registerFunction("floor_week", (SqlOperator)HiveFloorDate.WEEK, SqlFunctionConverter.hToken(24, "floor_week"));
            this.registerFunction("floor_day", (SqlOperator)HiveFloorDate.DAY, SqlFunctionConverter.hToken(24, "floor_day"));
            this.registerFunction("floor_hour", (SqlOperator)HiveFloorDate.HOUR, SqlFunctionConverter.hToken(24, "floor_hour"));
            this.registerFunction("floor_minute", (SqlOperator)HiveFloorDate.MINUTE, SqlFunctionConverter.hToken(24, "floor_minute"));
            this.registerFunction("floor_second", (SqlOperator)HiveFloorDate.SECOND, SqlFunctionConverter.hToken(24, "floor_second"));
            this.registerFunction("power", (SqlOperator)SqlStdOperatorTable.POWER, SqlFunctionConverter.hToken(24, "power"));
            this.registerDuplicateFunction("pow", (SqlOperator)SqlStdOperatorTable.POWER, SqlFunctionConverter.hToken(24, "power"));
            this.registerFunction("ceil", (SqlOperator)SqlStdOperatorTable.CEIL, SqlFunctionConverter.hToken(24, "ceil"));
            this.registerDuplicateFunction("ceiling", (SqlOperator)SqlStdOperatorTable.CEIL, SqlFunctionConverter.hToken(24, "ceil"));
            this.registerFunction("floor", (SqlOperator)SqlStdOperatorTable.FLOOR, SqlFunctionConverter.hToken(24, "floor"));
            this.registerFunction("log10", (SqlOperator)SqlStdOperatorTable.LOG10, SqlFunctionConverter.hToken(24, "log10"));
            this.registerFunction("ln", (SqlOperator)SqlStdOperatorTable.LN, SqlFunctionConverter.hToken(24, "ln"));
            this.registerFunction("cos", (SqlOperator)SqlStdOperatorTable.COS, SqlFunctionConverter.hToken(24, "cos"));
            this.registerFunction("sin", (SqlOperator)SqlStdOperatorTable.SIN, SqlFunctionConverter.hToken(24, "sin"));
            this.registerFunction("tan", (SqlOperator)SqlStdOperatorTable.TAN, SqlFunctionConverter.hToken(24, "tan"));
            this.registerFunction("concat", (SqlOperator)HiveConcat.INSTANCE, SqlFunctionConverter.hToken(24, "concat"));
            this.registerFunction("substring", (SqlOperator)SqlStdOperatorTable.SUBSTRING, SqlFunctionConverter.hToken(24, "substring"));
            this.registerFunction("like", (SqlOperator)SqlStdOperatorTable.LIKE, SqlFunctionConverter.hToken(24, "like"));
            this.registerFunction("exp", (SqlOperator)SqlStdOperatorTable.EXP, SqlFunctionConverter.hToken(24, "exp"));
            this.registerFunction("div", (SqlOperator)SqlStdOperatorTable.DIVIDE_INTEGER, SqlFunctionConverter.hToken(13, "div"));
            this.registerFunction("sqrt", (SqlOperator)SqlStdOperatorTable.SQRT, SqlFunctionConverter.hToken(24, "sqrt"));
            this.registerFunction("lower", (SqlOperator)SqlStdOperatorTable.LOWER, SqlFunctionConverter.hToken(24, "lower"));
            this.registerFunction("upper", (SqlOperator)SqlStdOperatorTable.UPPER, SqlFunctionConverter.hToken(24, "upper"));
            this.registerFunction("abs", (SqlOperator)SqlStdOperatorTable.ABS, SqlFunctionConverter.hToken(24, "abs"));
            this.registerFunction("character_length", (SqlOperator)SqlStdOperatorTable.CHAR_LENGTH, SqlFunctionConverter.hToken(24, "character_length"));
            this.registerDuplicateFunction("char_length", (SqlOperator)SqlStdOperatorTable.CHAR_LENGTH, SqlFunctionConverter.hToken(24, "character_length"));
            this.registerFunction("length", (SqlOperator)SqlStdOperatorTable.CHARACTER_LENGTH, SqlFunctionConverter.hToken(24, "length"));
            this.registerFunction("trunc", (SqlOperator)HiveTruncSqlOperator.INSTANCE, SqlFunctionConverter.hToken(24, "trunc"));
            this.registerFunction("to_date", (SqlOperator)HiveToDateSqlOperator.INSTANCE, SqlFunctionConverter.hToken(24, "to_date"));
            this.registerFunction("to_unix_timestamp", (SqlOperator)HiveUnixTimestampSqlOperator.INSTANCE, SqlFunctionConverter.hToken(24, "to_unix_timestamp"));
            this.registerFunction("from_unixtime", (SqlOperator)HiveFromUnixTimeSqlOperator.INSTANCE, SqlFunctionConverter.hToken(24, "from_unixtime"));
            this.registerFunction("date_add", (SqlOperator)HiveDateAddSqlOperator.INSTANCE, SqlFunctionConverter.hToken(24, "date_add"));
            this.registerFunction("date_sub", (SqlOperator)HiveDateSubSqlOperator.INSTANCE, SqlFunctionConverter.hToken(24, "date_sub"));
        }

        private void registerFunction(String name, SqlOperator calciteFn, HiveToken hiveToken) {
            FunctionInfo hFn;
            this.reverseOperatorMap.put(calciteFn, name);
            try {
                hFn = FunctionRegistry.getFunctionInfo(name);
            }
            catch (SemanticException e) {
                LOG.warn("Failed to load udf " + name, (Throwable)e);
                hFn = null;
            }
            if (hFn != null) {
                String hFnName = SqlFunctionConverter.getName(hFn.getGenericUDF());
                this.hiveToCalcite.put(hFnName, calciteFn);
                if (hiveToken != null) {
                    this.calciteToHiveToken.put(calciteFn, hiveToken);
                }
            }
        }

        private void registerDuplicateFunction(String name, SqlOperator calciteFn, HiveToken hiveToken) {
            this.hiveToCalcite.put(name, calciteFn);
            if (hiveToken != null) {
                this.calciteToHiveToken.put(calciteFn, hiveToken);
            }
        }
    }
}

