/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public abstract class VectorUDFMapIndexBaseCol
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int mapColumnNum;
    private int indexColumnNum;
    private ColumnVector indexColumnVector;

    public VectorUDFMapIndexBaseCol() {
    }

    public VectorUDFMapIndexBaseCol(int mapColumnNum, int indexColumnNum, int outputColumnNum) {
        super(outputColumnNum);
        this.mapColumnNum = mapColumnNum;
        this.indexColumnNum = indexColumnNum;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        ColumnVector outV = batch.cols[this.outputColumnNum];
        MapColumnVector mapV = (MapColumnVector)batch.cols[this.mapColumnNum];
        this.indexColumnVector = batch.cols[this.indexColumnNum];
        ColumnVector valuesV = mapV.values;
        int[] sel = batch.selected;
        boolean[] indexIsNull = this.indexColumnVector.isNull;
        boolean[] mapIsNull = mapV.isNull;
        boolean[] outputIsNull = outV.isNull;
        outV.isRepeating = false;
        if (this.indexColumnVector.isRepeating) {
            if (this.indexColumnVector.noNulls || !indexIsNull[0]) {
                if (mapV.isRepeating) {
                    if (mapV.noNulls || !mapIsNull[0]) {
                        int repeatedMapIndex = this.findInMap(this.indexColumnVector, 0, mapV, 0);
                        if (repeatedMapIndex == -1) {
                            outV.isNull[0] = true;
                            outV.noNulls = false;
                        } else {
                            outV.isNull[0] = false;
                            outV.setElement(0, repeatedMapIndex, valuesV);
                        }
                    } else {
                        outputIsNull[0] = true;
                        outV.noNulls = false;
                    }
                    outV.isRepeating = true;
                    return;
                }
                if (mapV.noNulls) {
                    if (batch.selectedInUse) {
                        if (!outV.noNulls) {
                            for (int j = 0; j < n; ++j) {
                                int i = sel[j];
                                int mapIndex = this.findInMap(this.indexColumnVector, 0, mapV, i);
                                if (mapIndex == -1) {
                                    outV.isNull[i] = true;
                                    outV.noNulls = false;
                                    continue;
                                }
                                outV.isNull[i] = false;
                                outV.setElement(i, mapIndex, valuesV);
                            }
                        } else {
                            for (int j = 0; j < n; ++j) {
                                int i = sel[j];
                                int mapIndex = this.findInMap(this.indexColumnVector, 0, mapV, i);
                                if (mapIndex == -1) {
                                    outV.isNull[i] = true;
                                    outV.noNulls = false;
                                    continue;
                                }
                                outV.setElement(i, mapIndex, valuesV);
                            }
                        }
                    } else {
                        if (!outV.noNulls) {
                            Arrays.fill(outputIsNull, false);
                            outV.noNulls = true;
                        }
                        for (int i = 0; i < n; ++i) {
                            int mapIndex = this.findInMap(this.indexColumnVector, 0, mapV, i);
                            if (mapIndex == -1) {
                                outV.isNull[i] = true;
                                outV.noNulls = false;
                                continue;
                            }
                            outV.setElement(i, mapIndex, valuesV);
                        }
                    }
                } else if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (!mapIsNull[i]) {
                            int mapIndex = this.findInMap(this.indexColumnVector, 0, mapV, i);
                            if (mapIndex == -1) {
                                outV.isNull[i] = true;
                                outV.noNulls = false;
                                continue;
                            }
                            outV.isNull[i] = false;
                            outV.setElement(i, mapIndex, valuesV);
                            continue;
                        }
                        outputIsNull[i] = true;
                        outV.noNulls = false;
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        if (!mapIsNull[i]) {
                            int mapIndex = this.findInMap(this.indexColumnVector, 0, mapV, i);
                            if (mapIndex == -1) {
                                outV.isNull[i] = true;
                                outV.noNulls = false;
                                continue;
                            }
                            outV.isNull[i] = false;
                            outV.setElement(i, mapIndex, valuesV);
                            continue;
                        }
                        outputIsNull[i] = true;
                        outV.noNulls = false;
                    }
                }
            } else {
                outputIsNull[0] = true;
                outV.noNulls = false;
                outV.isRepeating = true;
            }
            return;
        }
        if (mapV.isRepeating) {
            if (mapV.noNulls || !mapIsNull[0]) {
                if (this.indexColumnVector.noNulls) {
                    if (batch.selectedInUse) {
                        if (!outV.noNulls) {
                            for (int j = 0; j != n; ++j) {
                                int i = sel[j];
                                int mapIndex = this.findInMap(this.indexColumnVector, i, mapV, 0);
                                if (mapIndex == -1) {
                                    outV.isNull[i] = true;
                                    outV.noNulls = false;
                                    continue;
                                }
                                outV.isNull[i] = false;
                                outV.setElement(i, mapIndex, valuesV);
                            }
                        } else {
                            for (int j = 0; j != n; ++j) {
                                int i = sel[j];
                                int mapIndex = this.findInMap(this.indexColumnVector, i, mapV, 0);
                                if (mapIndex == -1) {
                                    outV.isNull[i] = true;
                                    outV.noNulls = false;
                                    continue;
                                }
                                outV.setElement(i, mapIndex, valuesV);
                            }
                        }
                    } else {
                        if (!outV.noNulls) {
                            Arrays.fill(outputIsNull, false);
                            outV.noNulls = true;
                        }
                        for (int i = 0; i != n; ++i) {
                            int mapIndex = this.findInMap(this.indexColumnVector, i, mapV, 0);
                            if (mapIndex == -1) {
                                outV.isNull[i] = true;
                                outV.noNulls = false;
                                continue;
                            }
                            outV.setElement(i, mapIndex, valuesV);
                        }
                    }
                } else if (batch.selectedInUse) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (!indexIsNull[i]) {
                            int mapIndex = this.findInMap(this.indexColumnVector, i, mapV, 0);
                            if (mapIndex == -1) {
                                outV.isNull[i] = true;
                                outV.noNulls = false;
                                continue;
                            }
                            outV.isNull[i] = false;
                            outV.setElement(i, mapIndex, valuesV);
                            continue;
                        }
                        outputIsNull[i] = true;
                        outV.noNulls = false;
                    }
                } else {
                    for (int i = 0; i != n; ++i) {
                        if (!indexIsNull[i]) {
                            int mapIndex = this.findInMap(this.indexColumnVector, i, mapV, 0);
                            if (mapIndex == -1) {
                                outV.isNull[i] = true;
                                outV.noNulls = false;
                                continue;
                            }
                            outV.isNull[i] = false;
                            outV.setElement(i, mapIndex, valuesV);
                            continue;
                        }
                        outputIsNull[i] = true;
                        outV.noNulls = false;
                    }
                }
            } else {
                outputIsNull[0] = true;
                outV.noNulls = false;
                outV.isRepeating = true;
            }
            return;
        }
        boolean listNoNulls = mapV.noNulls;
        if (this.indexColumnVector.noNulls) {
            if (batch.selectedInUse) {
                if (!outV.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (listNoNulls || !mapIsNull[i]) {
                            int mapIndex = this.findInMap(this.indexColumnVector, i, mapV, i);
                            if (mapIndex == -1) {
                                outV.isNull[i] = true;
                                outV.noNulls = false;
                                continue;
                            }
                            outV.isNull[i] = false;
                            outV.setElement(i, mapIndex, valuesV);
                            continue;
                        }
                        outputIsNull[i] = true;
                        outV.noNulls = false;
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (listNoNulls || !mapIsNull[i]) {
                            int mapIndex = this.findInMap(this.indexColumnVector, i, mapV, i);
                            if (mapIndex == -1) {
                                outV.isNull[i] = true;
                                outV.noNulls = false;
                                continue;
                            }
                            outV.setElement(i, mapIndex, valuesV);
                            continue;
                        }
                        outputIsNull[i] = true;
                        outV.noNulls = false;
                    }
                }
            } else {
                if (!outV.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outV.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    if (listNoNulls || !mapIsNull[i]) {
                        int mapIndex = this.findInMap(this.indexColumnVector, i, mapV, i);
                        if (mapIndex == -1) {
                            outV.isNull[i] = true;
                            outV.noNulls = false;
                            continue;
                        }
                        outV.setElement(i, mapIndex, valuesV);
                        continue;
                    }
                    outputIsNull[i] = true;
                    outV.noNulls = false;
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!indexIsNull[i]) {
                    if (listNoNulls || !mapIsNull[i]) {
                        int mapIndex = this.findInMap(this.indexColumnVector, i, mapV, i);
                        if (mapIndex == -1) {
                            outV.isNull[i] = true;
                            outV.noNulls = false;
                            continue;
                        }
                        outV.isNull[i] = false;
                        outV.setElement(i, mapIndex, valuesV);
                        continue;
                    }
                    outputIsNull[i] = true;
                    outV.noNulls = false;
                    continue;
                }
                outputIsNull[i] = true;
                outV.noNulls = false;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (!indexIsNull[i]) {
                    if (listNoNulls || !mapIsNull[i]) {
                        int mapIndex = this.findInMap(this.indexColumnVector, i, mapV, i);
                        if (mapIndex == -1) {
                            outV.isNull[i] = true;
                            outV.noNulls = false;
                            continue;
                        }
                        outV.isNull[i] = false;
                        outV.setElement(i, mapIndex, valuesV);
                        continue;
                    }
                    outputIsNull[i] = true;
                    outV.noNulls = false;
                    continue;
                }
                outputIsNull[i] = true;
                outV.noNulls = false;
            }
        }
    }

    public int findInMap(ColumnVector indexColumnVector, int indexBatchIndex, MapColumnVector mapColumnVector, int mapBatchIndex) {
        throw new RuntimeException("Not implemented");
    }

    public int getMapColumnNum() {
        return this.mapColumnNum;
    }

    public int getIndexColumnNum() {
        return this.indexColumnNum;
    }
}

