/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.json;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.hadoop.hive.metastore.messaging.AbortTxnMessage;
import org.apache.hadoop.hive.metastore.messaging.AddForeignKeyMessage;
import org.apache.hadoop.hive.metastore.messaging.AddNotNullConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.AddPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.AddPrimaryKeyMessage;
import org.apache.hadoop.hive.metastore.messaging.AddUniqueConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.AllocWriteIdMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterCatalogMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterTableMessage;
import org.apache.hadoop.hive.metastore.messaging.CommitTxnMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateCatalogMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateFunctionMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateTableMessage;
import org.apache.hadoop.hive.metastore.messaging.DropCatalogMessage;
import org.apache.hadoop.hive.metastore.messaging.DropConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.DropDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.DropFunctionMessage;
import org.apache.hadoop.hive.metastore.messaging.DropPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.DropTableMessage;
import org.apache.hadoop.hive.metastore.messaging.InsertMessage;
import org.apache.hadoop.hive.metastore.messaging.MessageDeserializer;
import org.apache.hadoop.hive.metastore.messaging.MessageFactory;
import org.apache.hadoop.hive.metastore.messaging.OpenTxnMessage;
import org.apache.hadoop.hive.metastore.messaging.PartitionFiles;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAbortTxnMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAddForeignKeyMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAddNotNullConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAddPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAddPrimaryKeyMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAddUniqueConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAllocWriteIdMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAlterCatalogMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAlterDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAlterPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAlterTableMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONCommitTxnMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONCreateCatalogMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONCreateDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONCreateFunctionMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONCreateTableMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONDropCatalogMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONDropConstraintMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONDropDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONDropFunctionMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONDropPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONDropTableMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONInsertMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;
import org.apache.hadoop.hive.metastore.messaging.json.JSONOpenTxnMessage;
import org.apache.hive.com.fasterxml.jackson.core.JsonFactory;
import org.apache.hive.com.fasterxml.jackson.core.JsonParser;
import org.apache.hive.com.fasterxml.jackson.databind.JsonNode;
import org.apache.hive.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TJSONProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONMessageFactory
extends MessageFactory {
    private static final Logger LOG = LoggerFactory.getLogger((String)JSONMessageFactory.class.getName());
    private static JSONMessageDeserializer deserializer = new JSONMessageDeserializer();

    @Override
    public MessageDeserializer getDeserializer() {
        return deserializer;
    }

    @Override
    public String getMessageFormat() {
        return "json-0.2";
    }

    @Override
    public CreateDatabaseMessage buildCreateDatabaseMessage(Database db) {
        return new JSONCreateDatabaseMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, db, this.now());
    }

    @Override
    public AlterDatabaseMessage buildAlterDatabaseMessage(Database beforeDb, Database afterDb) {
        return new JSONAlterDatabaseMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, beforeDb, afterDb, this.now());
    }

    @Override
    public DropDatabaseMessage buildDropDatabaseMessage(Database db) {
        return new JSONDropDatabaseMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, db.getName(), this.now());
    }

    @Override
    public CreateTableMessage buildCreateTableMessage(Table table, Iterator<String> fileIter) {
        return new JSONCreateTableMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, table, fileIter, (Long)this.now());
    }

    @Override
    public AlterTableMessage buildAlterTableMessage(Table before, Table after, boolean isTruncateOp) {
        return new JSONAlterTableMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, before, after, isTruncateOp, this.now());
    }

    @Override
    public DropTableMessage buildDropTableMessage(Table table) {
        return new JSONDropTableMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, table, this.now());
    }

    @Override
    public AddPartitionMessage buildAddPartitionMessage(Table table, Iterator<Partition> partitionsIterator, Iterator<PartitionFiles> partitionFileIter) {
        return new JSONAddPartitionMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, table, partitionsIterator, partitionFileIter, this.now());
    }

    @Override
    public AlterPartitionMessage buildAlterPartitionMessage(Table table, Partition before, Partition after, boolean isTruncateOp) {
        return new JSONAlterPartitionMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, table, before, after, isTruncateOp, this.now());
    }

    @Override
    public DropPartitionMessage buildDropPartitionMessage(Table table, Iterator<Partition> partitionsIterator) {
        return new JSONDropPartitionMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, table, JSONMessageFactory.getPartitionKeyValues(table, partitionsIterator), this.now());
    }

    @Override
    public CreateFunctionMessage buildCreateFunctionMessage(org.apache.hadoop.hive.metastore.api.Function fn) {
        return new JSONCreateFunctionMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, fn, this.now());
    }

    @Override
    public DropFunctionMessage buildDropFunctionMessage(org.apache.hadoop.hive.metastore.api.Function fn) {
        return new JSONDropFunctionMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, fn, this.now());
    }

    @Override
    public InsertMessage buildInsertMessage(Table tableObj, Partition partObj, boolean replace, Iterator<String> fileIter) {
        return new JSONInsertMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, tableObj, partObj, replace, fileIter, this.now());
    }

    @Override
    public AddPrimaryKeyMessage buildAddPrimaryKeyMessage(List<SQLPrimaryKey> pks) {
        return new JSONAddPrimaryKeyMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, pks, this.now());
    }

    @Override
    public AddForeignKeyMessage buildAddForeignKeyMessage(List<SQLForeignKey> fks) {
        return new JSONAddForeignKeyMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, fks, this.now());
    }

    @Override
    public AddUniqueConstraintMessage buildAddUniqueConstraintMessage(List<SQLUniqueConstraint> uks) {
        return new JSONAddUniqueConstraintMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, uks, this.now());
    }

    @Override
    public AddNotNullConstraintMessage buildAddNotNullConstraintMessage(List<SQLNotNullConstraint> nns) {
        return new JSONAddNotNullConstraintMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, nns, this.now());
    }

    @Override
    public DropConstraintMessage buildDropConstraintMessage(String dbName, String tableName, String constraintName) {
        return new JSONDropConstraintMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, dbName, tableName, constraintName, this.now());
    }

    @Override
    public CreateCatalogMessage buildCreateCatalogMessage(Catalog catalog) {
        return new JSONCreateCatalogMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, catalog.getName(), this.now());
    }

    @Override
    public AlterCatalogMessage buildAlterCatalogMessage(Catalog beforeCat, Catalog afterCat) {
        return new JSONAlterCatalogMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, beforeCat, afterCat, this.now());
    }

    @Override
    public DropCatalogMessage buildDropCatalogMessage(Catalog catalog) {
        return new JSONDropCatalogMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, catalog.getName(), this.now());
    }

    @Override
    public OpenTxnMessage buildOpenTxnMessage(Long fromTxnId, Long toTxnId) {
        return new JSONOpenTxnMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, fromTxnId, toTxnId, this.now());
    }

    @Override
    public CommitTxnMessage buildCommitTxnMessage(Long txnId) {
        return new JSONCommitTxnMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, txnId, this.now());
    }

    @Override
    public AbortTxnMessage buildAbortTxnMessage(Long txnId) {
        return new JSONAbortTxnMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, txnId, this.now());
    }

    @Override
    public AllocWriteIdMessage buildAllocWriteIdMessage(List<TxnToWriteId> txnToWriteIdList, String dbName, String tableName) {
        return new JSONAllocWriteIdMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, txnToWriteIdList, dbName, tableName, this.now());
    }

    private long now() {
        return System.currentTimeMillis() / 1000L;
    }

    static Map<String, String> getPartitionKeyValues(Table table, Partition partition) {
        LinkedHashMap<String, String> partitionKeys = new LinkedHashMap<String, String>();
        for (int i = 0; i < table.getPartitionKeysSize(); ++i) {
            partitionKeys.put(table.getPartitionKeys().get(i).getName(), partition.getValues().get(i));
        }
        return partitionKeys;
    }

    static List<Map<String, String>> getPartitionKeyValues(final Table table, Iterator<Partition> iterator) {
        return Lists.newArrayList(Iterators.transform(iterator, new Function<Partition, Map<String, String>>(){

            @Override
            public Map<String, String> apply(@Nullable Partition partition) {
                return JSONMessageFactory.getPartitionKeyValues(table, partition);
            }
        }));
    }

    static String createPrimaryKeyObjJson(SQLPrimaryKey primaryKeyObj) throws TException {
        TSerializer serializer = new TSerializer(new TJSONProtocol.Factory());
        return serializer.toString(primaryKeyObj);
    }

    static String createForeignKeyObjJson(SQLForeignKey foreignKeyObj) throws TException {
        TSerializer serializer = new TSerializer(new TJSONProtocol.Factory());
        return serializer.toString(foreignKeyObj);
    }

    static String createUniqueConstraintObjJson(SQLUniqueConstraint uniqueConstraintObj) throws TException {
        TSerializer serializer = new TSerializer(new TJSONProtocol.Factory());
        return serializer.toString(uniqueConstraintObj);
    }

    static String createNotNullConstraintObjJson(SQLNotNullConstraint notNullConstaintObj) throws TException {
        TSerializer serializer = new TSerializer(new TJSONProtocol.Factory());
        return serializer.toString(notNullConstaintObj);
    }

    static String createDatabaseObjJson(Database dbObj) throws TException {
        TSerializer serializer = new TSerializer(new TJSONProtocol.Factory());
        return serializer.toString(dbObj);
    }

    static String createCatalogObjJson(Catalog catObj) throws TException {
        TSerializer serializer = new TSerializer(new TJSONProtocol.Factory());
        return serializer.toString(catObj);
    }

    static String createTableObjJson(Table tableObj) throws TException {
        TSerializer serializer = new TSerializer(new TJSONProtocol.Factory());
        return serializer.toString(tableObj);
    }

    static String createPartitionObjJson(Partition partitionObj) throws TException {
        TSerializer serializer = new TSerializer(new TJSONProtocol.Factory());
        return serializer.toString(partitionObj);
    }

    static String createFunctionObjJson(org.apache.hadoop.hive.metastore.api.Function functionObj) throws TException {
        TSerializer serializer = new TSerializer(new TJSONProtocol.Factory());
        return serializer.toString(functionObj);
    }

    public static ObjectNode getJsonTree(NotificationEvent event) throws Exception {
        return JSONMessageFactory.getJsonTree(event.getMessage());
    }

    public static ObjectNode getJsonTree(String eventMessage) throws Exception {
        JsonParser jsonParser = new JsonFactory().createJsonParser(eventMessage);
        ObjectMapper mapper = new ObjectMapper();
        return mapper.readValue(jsonParser, ObjectNode.class);
    }

    public static Table getTableObj(ObjectNode jsonTree) throws Exception {
        TDeserializer deSerializer = new TDeserializer(new TJSONProtocol.Factory());
        Table tableObj = new Table();
        String tableJson = jsonTree.get("tableObjJson").asText();
        deSerializer.deserialize(tableObj, tableJson, "UTF-8");
        return tableObj;
    }

    public static TBase getTObj(String tSerialized, Class<? extends TBase> objClass) throws Exception {
        TDeserializer thriftDeSerializer = new TDeserializer(new TJSONProtocol.Factory());
        TBase obj = objClass.newInstance();
        thriftDeSerializer.deserialize(obj, tSerialized, "UTF-8");
        return obj;
    }

    public static Iterable<? extends TBase> getTObjs(Iterable<String> objRefStrs, final Class<? extends TBase> objClass) throws Exception {
        try {
            return Iterables.transform(objRefStrs, new Function<String, TBase>(){

                @Override
                public TBase apply(@Nullable String objStr) {
                    try {
                        return JSONMessageFactory.getTObj(objStr, objClass);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (RuntimeException re) {
            Throwable t = re.getCause();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw re;
        }
    }

    public static Iterable<? extends TBase> getTObjs(ObjectNode jsonTree, String objRefListName, Class<? extends TBase> objClass) throws Exception {
        JsonNode jsonArrayIterator = jsonTree.get(objRefListName);
        Function<JsonNode, String> textExtractor = new Function<JsonNode, String>(){

            @Override
            @Nullable
            public String apply(@Nullable JsonNode input) {
                return input.asText();
            }
        };
        return JSONMessageFactory.getTObjs(Iterables.transform(jsonArrayIterator, textExtractor), objClass);
    }
}

