/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import junit.framework.TestCase;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFSoundex;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.io.Text;

public class TestGenericUDFSoundex
extends TestCase {
    public void testSoundex() throws HiveException {
        GenericUDFSoundex udf = new GenericUDFSoundex();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0};
        udf.initialize(arguments);
        this.runAndVerify("Miller", "M460", (GenericUDF)udf);
        this.runAndVerify("miler", "M460", (GenericUDF)udf);
        this.runAndVerify("myller", "M460", (GenericUDF)udf);
        this.runAndVerify("muller", "M460", (GenericUDF)udf);
        this.runAndVerify("m", "M000", (GenericUDF)udf);
        this.runAndVerify("mu", "M000", (GenericUDF)udf);
        this.runAndVerify("mil", "M400", (GenericUDF)udf);
        this.runAndVerify("Peterson", "P362", (GenericUDF)udf);
        this.runAndVerify("Pittersen", "P362", (GenericUDF)udf);
        this.runAndVerify("", "", (GenericUDF)udf);
        this.runAndVerify(null, null, (GenericUDF)udf);
        this.runAndVerify("\u3500\u3501\u3502\u3503", null, (GenericUDF)udf);
    }

    public void testSoundexWrongType0() throws HiveException {
        GenericUDFSoundex udf = new GenericUDFSoundex();
        WritableIntObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0};
        try {
            udf.initialize(arguments);
            TestGenericUDFSoundex.assertTrue((String)"soundex test. UDFArgumentTypeException is expected", (boolean)false);
        }
        catch (UDFArgumentTypeException e) {
            TestGenericUDFSoundex.assertEquals((String)"soundex test", (String)"soundex only takes STRING_GROUP types as 1st argument, got INT", (String)e.getMessage());
        }
    }

    public void testSoundexWrongLength() throws HiveException {
        GenericUDFSoundex udf = new GenericUDFSoundex();
        WritableHiveVarcharObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableHiveVarcharObjectInspector;
        WritableHiveVarcharObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableHiveVarcharObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        try {
            udf.initialize(arguments);
            TestGenericUDFSoundex.assertTrue((String)"soundex test. UDFArgumentLengthException is expected", (boolean)false);
        }
        catch (UDFArgumentLengthException e) {
            TestGenericUDFSoundex.assertEquals((String)"soundex test", (String)"soundex requires 1 argument, got 2", (String)e.getMessage());
        }
    }

    private void runAndVerify(String str0, String expResult, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)(str0 != null ? new Text(str0) : null));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj0};
        Text output = (Text)udf.evaluate(args);
        if (expResult == null) {
            TestGenericUDFSoundex.assertNull((String)"soundex test ", (Object)output);
        } else {
            TestGenericUDFSoundex.assertNotNull((String)"soundex test", (Object)output);
            TestGenericUDFSoundex.assertEquals((String)"soundex test", (String)expResult, (String)output.toString());
        }
    }
}

