/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.io.IOException;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLikeAny;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableVoidObjectInspector;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFLikeAny {
    GenericUDFLikeAny udf = null;

    @Test
    public void testTrue() throws HiveException {
        this.udf = new GenericUDFLikeAny();
        WritableStringObjectInspector valueOIOne = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        WritableStringObjectInspector valueOITwo = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        WritableStringObjectInspector valueOIThree = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOIOne, valueOITwo, valueOIThree};
        this.udf.initialize(arguments);
        GenericUDF.DeferredJavaObject valueObjOne = new GenericUDF.DeferredJavaObject((Object)new Text("abc"));
        GenericUDF.DeferredJavaObject valueObjTwo = new GenericUDF.DeferredJavaObject((Object)new Text("%b%"));
        HiveVarchar vc = new HiveVarchar();
        vc.setValue("a%");
        GenericUDF.DeferredJavaObject[] args = new GenericUDF.DeferredJavaObject[]{valueObjOne, valueObjTwo, new GenericUDF.DeferredJavaObject((Object)new HiveVarcharWritable(vc))};
        BooleanWritable output = (BooleanWritable)this.udf.evaluate((GenericUDF.DeferredObject[])args);
        Assert.assertEquals((Object)true, (Object)output.get());
    }

    @Test(expected=UDFArgumentException.class)
    public void testExpectException() throws IOException, HiveException {
        this.udf = new GenericUDFLikeAny();
        WritableStringObjectInspector valueOIOne = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOIOne};
        this.udf.initialize(arguments);
        this.udf.close();
    }

    @Test
    public void testNull() throws HiveException {
        this.udf = new GenericUDFLikeAny();
        WritableStringObjectInspector valueOIOne = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        WritableVoidObjectInspector valueOITwo = PrimitiveObjectInspectorFactory.writableVoidObjectInspector;
        WritableStringObjectInspector valueOIThree = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOIOne, valueOITwo, valueOIThree};
        this.udf.initialize(arguments);
        GenericUDF.DeferredJavaObject valueObjOne = new GenericUDF.DeferredJavaObject((Object)new Text("abc"));
        GenericUDF.DeferredJavaObject valueObjTwo = new GenericUDF.DeferredJavaObject((Object)NullWritable.get());
        GenericUDF.DeferredJavaObject valueObjThree = new GenericUDF.DeferredJavaObject((Object)new Text("%b%"));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObjOne, valueObjTwo, valueObjThree};
        BooleanWritable output = (BooleanWritable)this.udf.evaluate(args);
        Assert.assertEquals(null, (Object)output);
    }
}

