/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomBatchSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomRowSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIf;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFWhen;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.LongWritable;
import org.junit.Test;

public class TestVectorIfStatement {
    @Test
    public void testBoolean() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "boolean");
    }

    @Test
    public void testInt() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "int");
    }

    @Test
    public void testBigInt() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "bigint");
    }

    @Test
    public void testString() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "string");
    }

    @Test
    public void testTimestamp() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "timestamp");
    }

    @Test
    public void testDate() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "date");
    }

    @Test
    public void testIntervalDayTime() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "interval_day_time");
    }

    @Test
    public void testIntervalYearMonth() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "interval_year_month");
    }

    @Test
    public void testDouble() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "double");
    }

    @Test
    public void testChar() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "char(10)");
    }

    @Test
    public void testVarchar() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "varchar(15)");
    }

    @Test
    public void testBinary() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "binary");
    }

    @Test
    public void testDecimalLarge() throws Exception {
        Random random = new Random(9300L);
        this.doIfTests(random, "decimal(20,8)");
    }

    @Test
    public void testDecimalSmall() throws Exception {
        Random random = new Random(12882L);
        this.doIfTests(random, "decimal(10,4)");
    }

    private void doIfTests(Random random, String typeName) throws Exception {
        this.doIfTests(random, typeName, DataTypePhysicalVariation.NONE);
    }

    private void doIfTests(Random random, String typeName, DataTypePhysicalVariation dataTypePhysicalVariation) throws Exception {
        this.doIfTestsWithDiffColumnScalar(random, typeName, ColumnScalarMode.COLUMN_COLUMN, dataTypePhysicalVariation, false, false);
        this.doIfTestsWithDiffColumnScalar(random, typeName, ColumnScalarMode.COLUMN_SCALAR, dataTypePhysicalVariation, false, false);
        this.doIfTestsWithDiffColumnScalar(random, typeName, ColumnScalarMode.COLUMN_SCALAR, dataTypePhysicalVariation, false, true);
        this.doIfTestsWithDiffColumnScalar(random, typeName, ColumnScalarMode.SCALAR_COLUMN, dataTypePhysicalVariation, false, false);
        this.doIfTestsWithDiffColumnScalar(random, typeName, ColumnScalarMode.SCALAR_COLUMN, dataTypePhysicalVariation, true, false);
        this.doIfTestsWithDiffColumnScalar(random, typeName, ColumnScalarMode.SCALAR_SCALAR, dataTypePhysicalVariation, false, false);
    }

    private void doIfTestsWithDiffColumnScalar(Random random, String typeName, ColumnScalarMode columnScalarMode, DataTypePhysicalVariation dataTypePhysicalVariation, boolean isNullScalar1, boolean isNullScalar2) throws Exception {
        int i;
        ExprNodeColumnDesc col3Expr;
        ExprNodeColumnDesc col2Expr;
        System.out.println("*DEBUG* typeName " + typeName + " columnScalarMode " + columnScalarMode + " isNullScalar1 " + isNullScalar1 + " isNullScalar2 " + isNullScalar2);
        TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)typeName);
        boolean isDecimal64 = dataTypePhysicalVariation == DataTypePhysicalVariation.DECIMAL_64;
        int decimal64Scale = isDecimal64 ? ((DecimalTypeInfo)typeInfo).getScale() : 0;
        ArrayList<String> explicitTypeNameList = new ArrayList<String>();
        ArrayList<DataTypePhysicalVariation> explicitDataTypePhysicalVariationList = new ArrayList<DataTypePhysicalVariation>();
        explicitTypeNameList.add("boolean");
        explicitDataTypePhysicalVariationList.add(DataTypePhysicalVariation.NONE);
        if (columnScalarMode != ColumnScalarMode.SCALAR_SCALAR) {
            explicitTypeNameList.add(typeName);
            explicitDataTypePhysicalVariationList.add(dataTypePhysicalVariation);
            if (columnScalarMode == ColumnScalarMode.COLUMN_COLUMN) {
                explicitTypeNameList.add(typeName);
                explicitDataTypePhysicalVariationList.add(dataTypePhysicalVariation);
            }
        }
        VectorRandomRowSource rowSource = new VectorRandomRowSource();
        rowSource.initExplicitSchema(random, explicitTypeNameList, 0, true, explicitDataTypePhysicalVariationList);
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("col0");
        ExprNodeColumnDesc col1Expr = new ExprNodeColumnDesc(Boolean.class, "col0", "table", false);
        int columnNum = 1;
        if (columnScalarMode == ColumnScalarMode.COLUMN_COLUMN || columnScalarMode == ColumnScalarMode.COLUMN_SCALAR) {
            String columnName = "col" + columnNum++;
            col2Expr = new ExprNodeColumnDesc(typeInfo, columnName, "table", false);
            columns.add(columnName);
        } else {
            Object scalar1Object = isNullScalar1 ? null : VectorRandomRowSource.randomPrimitiveObject(random, (PrimitiveTypeInfo)typeInfo);
            col2Expr = new ExprNodeConstantDesc(typeInfo, scalar1Object);
        }
        if (columnScalarMode == ColumnScalarMode.COLUMN_COLUMN || columnScalarMode == ColumnScalarMode.SCALAR_COLUMN) {
            String columnName = "col" + columnNum++;
            col3Expr = new ExprNodeColumnDesc(typeInfo, columnName, "table", false);
            columns.add(columnName);
        } else {
            Object scalar2Object = isNullScalar2 ? null : VectorRandomRowSource.randomPrimitiveObject(random, (PrimitiveTypeInfo)typeInfo);
            col3Expr = new ExprNodeConstantDesc(typeInfo, scalar2Object);
        }
        ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
        children.add((ExprNodeDesc)col1Expr);
        children.add((ExprNodeDesc)col2Expr);
        children.add((ExprNodeDesc)col3Expr);
        String[] columnNames = columns.toArray(new String[0]);
        String[] outputScratchTypeNames = new String[]{typeName};
        DataTypePhysicalVariation[] outputDataTypePhysicalVariations = new DataTypePhysicalVariation[]{dataTypePhysicalVariation};
        VectorizedRowBatchCtx batchContext = new VectorizedRowBatchCtx(columnNames, rowSource.typeInfos(), rowSource.dataTypePhysicalVariations(), null, 0, 0, null, outputScratchTypeNames, outputDataTypePhysicalVariations);
        Object[][] randomRows = rowSource.randomRows(100000);
        VectorRandomBatchSource batchSource = VectorRandomBatchSource.createInterestingBatches(random, rowSource, randomRows, null);
        int rowCount = randomRows.length;
        Object[][] resultObjectsArray = new Object[IfStmtTestMode.count][];
        block4: for (i = 0; i < IfStmtTestMode.count; ++i) {
            Object[] resultObjects = new Object[rowCount];
            resultObjectsArray[i] = resultObjects;
            IfStmtTestMode ifStmtTestMode = IfStmtTestMode.values()[i];
            switch (ifStmtTestMode) {
                case ROW_MODE: {
                    this.doRowIfTest(typeInfo, columns, children, randomRows, (ObjectInspector)rowSource.rowStructObjectInspector(), resultObjects);
                    continue block4;
                }
                case ADAPTOR_WHEN: 
                case VECTOR_EXPRESSION: {
                    this.doVectorIfTest(typeInfo, columns, rowSource.typeInfos(), rowSource.dataTypePhysicalVariations(), children, ifStmtTestMode, columnScalarMode, batchSource, batchContext, resultObjects);
                    continue block4;
                }
                default: {
                    throw new RuntimeException("Unexpected IF statement test mode " + ifStmtTestMode);
                }
            }
        }
        for (i = 0; i < rowCount; ++i) {
            Object expectedResult = resultObjectsArray[0][i];
            for (int v = 1; v < IfStmtTestMode.count; ++v) {
                Object vectorResult = resultObjectsArray[v][i];
                if (expectedResult == null || vectorResult == null) {
                    if (expectedResult == null && vectorResult == null) continue;
                    Assert.fail((String)("Row " + i + " " + IfStmtTestMode.values()[v] + " " + columnScalarMode + " result is NULL " + (vectorResult == null) + " does not match row-mode expected result is NULL " + (expectedResult == null)));
                    continue;
                }
                if (isDecimal64 && expectedResult instanceof LongWritable) {
                    HiveDecimalWritable expectedHiveDecimalWritable = new HiveDecimalWritable(0L);
                    expectedHiveDecimalWritable.deserialize64(((LongWritable)expectedResult).get(), decimal64Scale);
                    expectedResult = expectedHiveDecimalWritable;
                }
                if (expectedResult.equals(vectorResult)) continue;
                Assert.fail((String)("Row " + i + " " + IfStmtTestMode.values()[v] + " " + columnScalarMode + " result " + vectorResult.toString() + " (" + vectorResult.getClass().getSimpleName() + ") does not match row-mode expected result " + expectedResult.toString() + " (" + expectedResult.getClass().getSimpleName() + ")"));
            }
        }
    }

    private void doRowIfTest(TypeInfo typeInfo, List<String> columns, List<ExprNodeDesc> children, Object[][] randomRows, ObjectInspector rowInspector, Object[] resultObjects) throws Exception {
        GenericUDFIf udf = new GenericUDFIf();
        ExprNodeGenericFuncDesc exprDesc = new ExprNodeGenericFuncDesc(typeInfo, (GenericUDF)udf, children);
        HiveConf hiveConf = new HiveConf();
        ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get((ExprNodeDesc)exprDesc, (Configuration)hiveConf);
        evaluator.initialize(rowInspector);
        for (Object[] row : randomRows) {
            Object result;
            resultObjects[i] = result = evaluator.evaluate((Object)row);
        }
    }

    private void extractResultObjects(VectorizedRowBatch batch, int rowIndex, VectorExtractRow resultVectorExtractRow, Object[] scrqtchRow, TypeInfo targetTypeInfo, Object[] resultObjects) {
        ObjectInspector objectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)targetTypeInfo);
        boolean selectedInUse = batch.selectedInUse;
        int[] selected = batch.selected;
        for (int logicalIndex = 0; logicalIndex < batch.size; ++logicalIndex) {
            int batchIndex = selectedInUse ? selected[logicalIndex] : logicalIndex;
            resultVectorExtractRow.extractRow(batch, batchIndex, scrqtchRow);
            Object copyResult = ObjectInspectorUtils.copyToStandardObject((Object)scrqtchRow[0], (ObjectInspector)objectInspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            resultObjects[rowIndex++] = copyResult;
        }
    }

    private void doVectorIfTest(TypeInfo typeInfo, List<String> columns, TypeInfo[] typeInfos, DataTypePhysicalVariation[] dataTypePhysicalVariations, List<ExprNodeDesc> children, IfStmtTestMode ifStmtTestMode, ColumnScalarMode columnScalarMode, VectorRandomBatchSource batchSource, VectorizedRowBatchCtx batchContext, Object[] resultObjects) throws Exception {
        GenericUDFIf udf;
        switch (ifStmtTestMode) {
            case VECTOR_EXPRESSION: {
                udf = new GenericUDFIf();
                break;
            }
            case ADAPTOR_WHEN: {
                udf = new GenericUDFWhen();
                break;
            }
            default: {
                throw new RuntimeException("Unexpected IF statement test mode " + ifStmtTestMode);
            }
        }
        ExprNodeGenericFuncDesc exprDesc = new ExprNodeGenericFuncDesc(typeInfo, (GenericUDF)udf, children);
        String ifExprMode = ifStmtTestMode != IfStmtTestMode.VECTOR_EXPRESSION ? "adaptor" : "good";
        HiveConf hiveConf = new HiveConf();
        hiveConf.setVar(HiveConf.ConfVars.HIVE_VECTORIZED_IF_EXPR_MODE, ifExprMode);
        VectorizationContext vectorizationContext = new VectorizationContext("name", columns, Arrays.asList(typeInfos), Arrays.asList(dataTypePhysicalVariations), hiveConf);
        VectorExpression vectorExpression = vectorizationContext.getVectorExpression((ExprNodeDesc)exprDesc);
        VectorizedRowBatch batch = batchContext.createVectorizedRowBatch();
        VectorExtractRow resultVectorExtractRow = new VectorExtractRow();
        resultVectorExtractRow.init(new TypeInfo[]{typeInfo}, new int[]{columns.size()});
        Object[] scrqtchRow = new Object[1];
        System.out.println("*DEBUG* typeInfo " + typeInfo.toString() + " ifStmtTestMode " + ifStmtTestMode + " columnScalarMode " + columnScalarMode + " vectorExpression " + vectorExpression.getClass().getSimpleName());
        batchSource.resetBatchIteration();
        int rowIndex = 0;
        while (batchSource.fillNextBatch(batch)) {
            vectorExpression.evaluate(batch);
            this.extractResultObjects(batch, rowIndex, resultVectorExtractRow, scrqtchRow, typeInfo, resultObjects);
            rowIndex += batch.size;
        }
    }

    public static enum ColumnScalarMode {
        COLUMN_COLUMN,
        COLUMN_SCALAR,
        SCALAR_COLUMN,
        SCALAR_SCALAR;

        static final int count;

        static {
            count = ColumnScalarMode.values().length;
        }
    }

    public static enum IfStmtTestMode {
        ROW_MODE,
        ADAPTOR_WHEN,
        VECTOR_EXPRESSION;

        static final int count;

        static {
            count = IfStmtTestMode.values().length;
        }
    }
}

