/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.com.zaxxer.hikari.util;

import java.lang.reflect.Array;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import org.apache.hive.com.zaxxer.hikari.pool.ProxyCallableStatement;
import org.apache.hive.com.zaxxer.hikari.pool.ProxyConnection;
import org.apache.hive.com.zaxxer.hikari.pool.ProxyPreparedStatement;
import org.apache.hive.com.zaxxer.hikari.pool.ProxyResultSet;
import org.apache.hive.com.zaxxer.hikari.pool.ProxyStatement;

public final class JavassistProxyFactory {
    private static ClassPool classPool;

    public static void main(String ... args) {
        classPool = new ClassPool();
        classPool.importPackage("java.sql");
        classPool.appendClassPath((ClassPath)new LoaderClassPath(JavassistProxyFactory.class.getClassLoader()));
        try {
            String methodBody = "{ try { return delegate.method($$); } catch (SQLException e) { throw checkException(e); } }";
            JavassistProxyFactory.generateProxyClass(Connection.class, ProxyConnection.class.getName(), methodBody);
            JavassistProxyFactory.generateProxyClass(Statement.class, ProxyStatement.class.getName(), methodBody);
            JavassistProxyFactory.generateProxyClass(ResultSet.class, ProxyResultSet.class.getName(), methodBody);
            methodBody = "{ try { return ((cast) delegate).method($$); } catch (SQLException e) { throw checkException(e); } }";
            JavassistProxyFactory.generateProxyClass(PreparedStatement.class, ProxyPreparedStatement.class.getName(), methodBody);
            JavassistProxyFactory.generateProxyClass(CallableStatement.class, ProxyCallableStatement.class.getName(), methodBody);
            JavassistProxyFactory.modifyProxyFactory();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void modifyProxyFactory() throws Exception {
        System.out.println("Generating method bodies for com.zaxxer.hikari.proxy.ProxyFactory");
        String packageName = ProxyConnection.class.getPackage().getName();
        CtClass proxyCt = classPool.getCtClass("org.apache.hive.com.zaxxer.hikari.pool.ProxyFactory");
        block14: for (CtMethod method : proxyCt.getMethods()) {
            switch (method.getName()) {
                case "getProxyConnection": {
                    method.setBody("{return new " + packageName + ".HikariProxyConnection($$);}");
                    continue block14;
                }
                case "getProxyStatement": {
                    method.setBody("{return new " + packageName + ".HikariProxyStatement($$);}");
                    continue block14;
                }
                case "getProxyPreparedStatement": {
                    method.setBody("{return new " + packageName + ".HikariProxyPreparedStatement($$);}");
                    continue block14;
                }
                case "getProxyCallableStatement": {
                    method.setBody("{return new " + packageName + ".HikariProxyCallableStatement($$);}");
                    continue block14;
                }
                case "getProxyResultSet": {
                    method.setBody("{return new " + packageName + ".HikariProxyResultSet($$);}");
                    continue block14;
                }
            }
        }
        proxyCt.writeFile("target/classes");
    }

    private static <T> void generateProxyClass(Class<T> primaryInterface, String superClassName, String methodBody) throws Exception {
        String newClassName = superClassName.replaceAll("(.+)\\.(\\w+)", "$1.Hikari$2");
        CtClass superCt = classPool.getCtClass(superClassName);
        CtClass targetCt = classPool.makeClass(newClassName, superCt);
        targetCt.setModifiers(16);
        System.out.println("Generating " + newClassName);
        targetCt.setModifiers(1);
        HashSet<String> superSigs = new HashSet<String>();
        for (CtMethod method : superCt.getMethods()) {
            if ((method.getModifiers() & 0x10) != 16) continue;
            superSigs.add(method.getName() + method.getSignature());
        }
        HashSet<String> methods = new HashSet<String>();
        Set<Class<?>> interfaces = JavassistProxyFactory.getAllInterfaces(primaryInterface);
        for (Class<?> intf : interfaces) {
            CtClass intfCt = classPool.getCtClass(intf.getName());
            targetCt.addInterface(intfCt);
            for (CtMethod intfMethod : intfCt.getDeclaredMethods()) {
                String signature = intfMethod.getName() + intfMethod.getSignature();
                if (superSigs.contains(signature) || methods.contains(signature)) continue;
                methods.add(signature);
                CtMethod method = CtNewMethod.copy((CtMethod)intfMethod, (CtClass)targetCt, null);
                String modifiedBody = methodBody;
                CtMethod superMethod = superCt.getMethod(intfMethod.getName(), intfMethod.getSignature());
                if ((superMethod.getModifiers() & 0x400) != 1024 && !JavassistProxyFactory.isDefaultMethod(intf, intfCt, intfMethod)) {
                    modifiedBody = modifiedBody.replace("((cast) ", "");
                    modifiedBody = modifiedBody.replace("delegate", "super");
                    modifiedBody = modifiedBody.replace("super)", "super");
                }
                modifiedBody = modifiedBody.replace("cast", primaryInterface.getName());
                modifiedBody = JavassistProxyFactory.isThrowsSqlException(intfMethod) ? modifiedBody.replace("method", method.getName()) : "{ return ((cast) delegate).method($$); }".replace("method", method.getName()).replace("cast", primaryInterface.getName());
                if (method.getReturnType() == CtClass.voidType) {
                    modifiedBody = modifiedBody.replace("return", "");
                }
                method.setBody(modifiedBody);
                targetCt.addMethod(method);
            }
        }
        targetCt.getClassFile().setMajorVersion(51);
        targetCt.writeFile("target/classes");
    }

    private static boolean isThrowsSqlException(CtMethod method) {
        try {
            for (CtClass clazz : method.getExceptionTypes()) {
                if (!clazz.getSimpleName().equals("SQLException")) continue;
                return true;
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return false;
    }

    private static boolean isDefaultMethod(Class<?> intf, CtClass intfCt, CtMethod intfMethod) throws Exception {
        ArrayList paramTypes = new ArrayList();
        for (CtClass pt : intfMethod.getParameterTypes()) {
            paramTypes.add(JavassistProxyFactory.toJavaClass(pt));
        }
        return intf.getDeclaredMethod(intfMethod.getName(), paramTypes.toArray(new Class[paramTypes.size()])).toString().contains("default ");
    }

    private static Set<Class<?>> getAllInterfaces(Class<?> clazz) {
        HashSet interfaces = new HashSet();
        for (Class<?> intf : Arrays.asList(clazz.getInterfaces())) {
            if (intf.getInterfaces().length > 0) {
                interfaces.addAll(JavassistProxyFactory.getAllInterfaces(intf));
            }
            interfaces.add(intf);
        }
        if (clazz.getSuperclass() != null) {
            interfaces.addAll(JavassistProxyFactory.getAllInterfaces(clazz.getSuperclass()));
        }
        if (clazz.isInterface()) {
            interfaces.add(clazz);
        }
        return interfaces;
    }

    private static Class<?> toJavaClass(CtClass cls) throws Exception {
        if (cls.getName().endsWith("[]")) {
            return Array.newInstance(JavassistProxyFactory.toJavaClass(cls.getName().replace("[]", "")), 0).getClass();
        }
        return JavassistProxyFactory.toJavaClass(cls.getName());
    }

    private static Class<?> toJavaClass(String cn) throws Exception {
        switch (cn) {
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "void": {
                return Void.TYPE;
            }
        }
        return Class.forName(cn);
    }
}

