/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.signature;

import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.optimizer.signature.OpTreeSignatureFactory;
import org.apache.hadoop.hive.ql.optimizer.signature.Signature;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.verification.VerificationMode;

public class TestOpSigFactory {
    CompilationOpContext cCtx = new CompilationOpContext();
    @Rule
    public MockitoRule a = MockitoJUnit.rule();
    @Spy
    OpTreeSignatureFactory f = OpTreeSignatureFactory.newCache();

    @Test
    public void checkExplicit() {
        SampleOperator so = new SampleOperator();
        SampleDesc sd = new SampleDesc();
        so.setConf((OperatorDesc)sd);
        this.f.getSignature((Operator)so);
        this.f.getSignature((Operator)so);
        ((OpTreeSignatureFactory)Mockito.verify((Object)this.f, (VerificationMode)Mockito.times((int)2))).getSignature((Operator)Mockito.any());
        Assert.assertEquals((long)1L, (long)sd.getDesc_invocations());
    }

    @Test
    public void checkImplicit() {
        SampleOperator so = new SampleOperator();
        SampleDesc sd = new SampleDesc();
        so.setConf((OperatorDesc)sd);
        SampleOperator so2 = new SampleOperator();
        SampleDesc sd2 = new SampleDesc();
        so2.setConf((OperatorDesc)sd2);
        so.getParentOperators().add(so2);
        so2.getChildOperators().add(so);
        this.f.getSignature((Operator)so);
        ((OpTreeSignatureFactory)Mockito.verify((Object)this.f, (VerificationMode)Mockito.times((int)2))).getSignature((Operator)Mockito.any());
        Assert.assertEquals((long)1L, (long)sd.getDesc_invocations());
        Assert.assertEquals((long)1L, (long)sd2.getDesc_invocations());
        this.f.getSignature((Operator)so);
        this.f.getSignature((Operator)so2);
        ((OpTreeSignatureFactory)Mockito.verify((Object)this.f, (VerificationMode)Mockito.times((int)4))).getSignature((Operator)Mockito.any());
        Assert.assertEquals((long)1L, (long)sd.getDesc_invocations());
        Assert.assertEquals((long)1L, (long)sd2.getDesc_invocations());
    }

    static class SampleOperator
    extends Operator<SampleDesc> {
        private static final long serialVersionUID = 1L;

        SampleOperator() {
        }

        public void process(Object row, int tag) throws HiveException {
        }

        public String getName() {
            return "A1";
        }

        public OperatorType getType() {
            return OperatorType.FILTER;
        }
    }

    public static class SampleDesc
    extends AbstractOperatorDesc {
        private static final long serialVersionUID = 1L;
        private int desc_invocations;

        @Signature
        public int asd() {
            ++this.desc_invocations;
            return 8;
        }

        public int getDesc_invocations() {
            return this.desc_invocations;
        }
    }
}

