/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.parse.repl.CopyUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestCopyUtils {
    @Test
    public void distcpShouldNotBeCalledOnlyForOneFile() {
        HiveConf conf = new HiveConf();
        conf.setLongVar(HiveConf.ConfVars.HIVE_EXEC_COPYFILE_MAXSIZE, 1L);
        CopyUtils copyUtils = new CopyUtils("", conf);
        long MB_128 = 0x8000000L;
        Assert.assertFalse((boolean)copyUtils.limitReachedForLocalCopy(MB_128, 1L));
    }

    @Test
    public void distcpShouldNotBeCalledForSmallerFileSize() {
        HiveConf conf = new HiveConf();
        CopyUtils copyUtils = new CopyUtils("", conf);
        long MB_16 = 0x1000000L;
        Assert.assertFalse((boolean)copyUtils.limitReachedForLocalCopy(MB_16, 100L));
    }
}

