/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.signature;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.signature.OpSignature;
import org.apache.hadoop.hive.ql.optimizer.signature.OpTreeSignature;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFConcat;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestOperatorSignature {
    GenericUDF udf = new GenericUDFConcat();
    CompilationOpContext cCtx = new CompilationOpContext();

    @Test
    public void testFilterOpEquals() {
        Operator<? extends OperatorDesc> op7 = this.getFilterOp(7);
        Operator<? extends OperatorDesc> op8 = this.getFilterOp(8);
        Operator<? extends OperatorDesc> op7b = this.getFilterOp(7);
        TestOperatorSignature.checkEquals(op7, op7b);
        TestOperatorSignature.checkNotEquals(op7, op8);
    }

    @Test
    public void testTree1() {
        Operator<?> tr37 = this.getFilTsOp(3, 7);
        Operator<?> tr37a = this.getFilTsOp(3, 7);
        Operator<?> tr17 = this.getFilTsOp(1, 7);
        Operator<?> tr31 = this.getFilTsOp(3, 1);
        TestOperatorSignature.checkEquals(tr37, tr37a);
        TestOperatorSignature.checkTreeNotEquals(tr37, tr17);
        TestOperatorSignature.checkTreeEquals(tr37, tr37a);
        TestOperatorSignature.checkTreeNotEquals(tr37, tr31);
    }

    private Operator<?> getFilTsOp(int i, int j) {
        Operator<TableScanDesc> ts = this.getTsOp(i);
        Operator<? extends OperatorDesc> fil = this.getFilterOp(j);
        this.connectOperators(ts, fil);
        return fil;
    }

    private void connectOperators(Operator<?> parent, Operator<?> child) {
        parent.getChildOperators().add(child);
        child.getParentOperators().add(parent);
    }

    @Test
    public void testTableScand() {
        Operator<TableScanDesc> t1 = this.getTsOp(3);
        Operator<TableScanDesc> t1a = this.getTsOp(3);
        Operator<TableScanDesc> t2 = this.getTsOp(4);
        TestOperatorSignature.checkEquals(t1, t1a);
        TestOperatorSignature.checkNotEquals(t1, t2);
    }

    public static void checkEquals(Operator<?> o1, Operator<?> o2) {
        Assert.assertTrue((boolean)o1.logicalEquals(o2));
        OpSignature s1 = OpSignature.of(o1);
        OpSignature s2 = OpSignature.of(o2);
        s1.proveEquals(s2);
        Assert.assertTrue((String)"sigCmp", (boolean)s1.signatureCompare(s2));
        Assert.assertEquals((long)s1.hashCode(), (long)s2.hashCode());
        Assert.assertEquals((Object)s1, (Object)s2);
    }

    public static void checkNotEquals(Operator<? extends OperatorDesc> o1, Operator<? extends OperatorDesc> o2) {
        Assert.assertFalse((boolean)o1.logicalEquals(o2));
        OpSignature s1 = OpSignature.of(o1);
        OpSignature s2 = OpSignature.of(o2);
        Assert.assertFalse((boolean)s1.signatureCompare(s2));
        Assert.assertNotEquals((long)s1.hashCode(), (long)s2.hashCode());
        Assert.assertNotEquals((Object)s1, (Object)s2);
    }

    public static void checkTreeEquals(Operator<?> o1, Operator<?> o2) {
        OpTreeSignature ts1 = OpTreeSignature.of(o1);
        OpTreeSignature ts2 = OpTreeSignature.of(o2);
        Assert.assertEquals((long)ts1.hashCode(), (long)ts2.hashCode());
        Assert.assertEquals((Object)ts1, (Object)ts2);
    }

    public static void checkTreeNotEquals(Operator<? extends OperatorDesc> o1, Operator<? extends OperatorDesc> o2) {
        OpTreeSignature ts1 = OpTreeSignature.of(o1);
        OpTreeSignature ts2 = OpTreeSignature.of(o2);
        Assert.assertNotEquals((long)ts1.hashCode(), (long)ts2.hashCode());
        ts1.equals((Object)ts2);
        Assert.assertNotEquals((Object)ts1, (Object)ts2);
    }

    private Operator<? extends OperatorDesc> getFilterOp(int constVal) {
        ExprNodeConstantDesc pred = new ExprNodeConstantDesc((Object)constVal);
        FilterDesc fd = new FilterDesc((ExprNodeDesc)pred, true);
        Operator op = OperatorFactory.get((CompilationOpContext)this.cCtx, (OperatorDesc)fd);
        return op;
    }

    private Operator<TableScanDesc> getTsOp(int i) {
        Table tblMetadata = new Table("db", "table");
        TableScanDesc desc = new TableScanDesc("alias_" + this.cCtx.nextOperatorId(), tblMetadata);
        ArrayList as = Lists.newArrayList((Object[])new ExprNodeDesc[]{new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.intTypeInfo, (Object)i), new ExprNodeColumnDesc((TypeInfo)TypeInfoFactory.intTypeInfo, "c1", "aa", false)});
        ExprNodeGenericFuncDesc f1 = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, this.udf, (List)as);
        desc.setFilterExpr(f1);
        Operator ts = OperatorFactory.get((CompilationOpContext)this.cCtx, (OperatorDesc)desc);
        return ts;
    }
}

