/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import junit.framework.TestCase;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastBytesHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastBytesHashMultiSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastBytesHashSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastLongHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastLongHashMultiSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastLongHashSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMapResult;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMultiSetResult;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashSetResult;
import org.apache.hadoop.hive.serde2.WriteBuffers;
import org.apache.hadoop.io.BytesWritable;
import org.junit.Assert;

public class CheckFastHashTable {
    public static boolean findMatch(int valueIndex, byte[] valueBytes, List<byte[]> actualValues, int actualCount, boolean[] actualTaken, int[] actualToValueMap) {
        for (int i = 0; i < actualCount; ++i) {
            byte[] actualBytes;
            if (actualTaken[i] || StringExpr.compare((byte[])valueBytes, (int)0, (int)valueBytes.length, (byte[])(actualBytes = actualValues.get(i)), (int)0, (int)actualBytes.length) != 0) continue;
            actualToValueMap[i] = valueIndex;
            actualTaken[i] = true;
            return true;
        }
        return false;
    }

    public static int[] verifyHashMapValues(VectorMapJoinHashMapResult hashMapResult, List<byte[]> values) {
        int valueCount = values.size();
        WriteBuffers.ByteSegmentRef ref = hashMapResult.first();
        ArrayList<byte[]> actualValues = new ArrayList<byte[]>();
        do {
            byte[] bytes = ref.getBytes();
            int offset = (int)ref.getOffset();
            int length = ref.getLength();
            if (length == 0) {
                actualValues.add(new byte[0]);
                continue;
            }
            actualValues.add(Arrays.copyOfRange(bytes, offset, offset + length));
        } while ((ref = hashMapResult.next()) != null);
        int actualCount = actualValues.size();
        if (valueCount != actualCount) {
            TestCase.fail((String)("values.size() " + valueCount + " does not match actualCount " + actualCount));
        }
        boolean[] actualTaken = new boolean[actualCount];
        int[] actualToValueMap = new int[actualCount];
        for (int i = 0; i < actualCount; ++i) {
            byte[] valueBytes = values.get(i);
            if (CheckFastHashTable.findMatch(i, valueBytes, actualValues, actualCount, actualTaken, actualToValueMap)) continue;
            ArrayList<Integer> availableLengths = new ArrayList<Integer>();
            for (int a = 0; a < actualCount; ++a) {
                if (actualTaken[a]) continue;
                availableLengths.add(((byte[])actualValues.get(a)).length);
            }
            TestCase.fail((String)("No match for actual value (valueBytes length " + valueBytes.length + ", availableLengths " + ((Object)availableLengths).toString() + " of " + actualCount + " total)"));
        }
        return actualToValueMap;
    }

    public static class VerifyFastBytesHashSet {
        private int count = 0;
        private FastBytesHashSetElement[] array = new FastBytesHashSetElement[50];
        private TreeMap<BytesWritable, Integer> keyValueMap = new TreeMap();

        public int getCount() {
            return this.count;
        }

        public boolean contains(byte[] key) {
            BytesWritable keyBytesWritable = new BytesWritable(key, key.length);
            return this.keyValueMap.containsKey(keyBytesWritable);
        }

        public void add(byte[] key) {
            BytesWritable keyBytesWritable = new BytesWritable(key, key.length);
            if (!this.keyValueMap.containsKey(keyBytesWritable)) {
                if (this.count >= this.array.length) {
                    FastBytesHashSetElement[] newArray = new FastBytesHashSetElement[this.array.length * 2];
                    System.arraycopy(this.array, 0, newArray, 0, this.count);
                    this.array = newArray;
                }
                this.array[this.count] = new FastBytesHashSetElement(key);
                this.keyValueMap.put(keyBytesWritable, this.count);
                ++this.count;
            }
        }

        public byte[] addRandomExisting(byte[] value, Random r) {
            Preconditions.checkState((this.count > 0 ? 1 : 0) != 0);
            int index = r.nextInt(this.count);
            return this.array[index].getKey();
        }

        public byte[] getKey(int index) {
            return this.array[index].getKey();
        }

        public void verify(VectorMapJoinFastBytesHashSet map) {
            int mapSize = map.size();
            if (mapSize != this.count) {
                TestCase.fail((String)"map.size() does not match expected count");
            }
            for (int index = 0; index < this.count; ++index) {
                VectorMapJoinHashSetResult hashSetResult;
                FastBytesHashSetElement element = this.array[index];
                byte[] key = element.getKey();
                JoinUtil.JoinResult joinResult = map.contains(key, 0, key.length, hashSetResult = map.createHashSetResult());
                if (joinResult == JoinUtil.JoinResult.MATCH) continue;
                Assert.assertTrue((boolean)false);
            }
        }
    }

    public static class FastBytesHashSetElement {
        private byte[] key;

        public FastBytesHashSetElement(byte[] key) {
            this.key = key;
        }

        public byte[] getKey() {
            return this.key;
        }
    }

    public static class VerifyFastLongHashSet {
        private int count = 0;
        private FastLongHashSetElement[] array = new FastLongHashSetElement[50];
        private HashMap<Long, Integer> keyValueMap = new HashMap();

        public int getCount() {
            return this.count;
        }

        public boolean contains(long key) {
            return this.keyValueMap.containsKey(key);
        }

        public void add(long key) {
            if (!this.keyValueMap.containsKey(key)) {
                if (this.count >= this.array.length) {
                    FastLongHashSetElement[] newArray = new FastLongHashSetElement[this.array.length * 2];
                    System.arraycopy(this.array, 0, newArray, 0, this.count);
                    this.array = newArray;
                }
                this.array[this.count] = new FastLongHashSetElement(key);
                this.keyValueMap.put(key, this.count);
                ++this.count;
            }
        }

        public long addRandomExisting(byte[] value, Random r) {
            Preconditions.checkState((this.count > 0 ? 1 : 0) != 0);
            int index = r.nextInt(this.count);
            return this.array[index].getKey();
        }

        public long getKey(int index) {
            return this.array[index].getKey();
        }

        public void verify(VectorMapJoinFastLongHashSet map) {
            int mapSize = map.size();
            if (mapSize != this.count) {
                TestCase.fail((String)"map.size() does not match expected count");
            }
            for (int index = 0; index < this.count; ++index) {
                VectorMapJoinHashSetResult hashSetResult;
                FastLongHashSetElement element = this.array[index];
                long key = element.getKey();
                JoinUtil.JoinResult joinResult = map.contains(key, hashSetResult = map.createHashSetResult());
                if (joinResult == JoinUtil.JoinResult.MATCH) continue;
                Assert.assertTrue((boolean)false);
            }
        }
    }

    public static class FastLongHashSetElement {
        private long key;

        public FastLongHashSetElement(long key) {
            this.key = key;
        }

        public long getKey() {
            return this.key;
        }
    }

    public static class VerifyFastBytesHashMultiSet {
        private int count = 0;
        private FastBytesHashMultiSetElement[] array = new FastBytesHashMultiSetElement[50];
        private TreeMap<BytesWritable, Integer> keyValueMap = new TreeMap();

        public int getCount() {
            return this.count;
        }

        public boolean contains(byte[] key) {
            BytesWritable keyBytesWritable = new BytesWritable(key, key.length);
            return this.keyValueMap.containsKey(keyBytesWritable);
        }

        public void add(byte[] key) {
            BytesWritable keyBytesWritable = new BytesWritable(key, key.length);
            if (this.keyValueMap.containsKey(keyBytesWritable)) {
                int index = this.keyValueMap.get(keyBytesWritable);
                this.array[index].incrementMultiSetCount();
            } else {
                if (this.count >= this.array.length) {
                    FastBytesHashMultiSetElement[] newArray = new FastBytesHashMultiSetElement[this.array.length * 2];
                    System.arraycopy(this.array, 0, newArray, 0, this.count);
                    this.array = newArray;
                }
                this.array[this.count] = new FastBytesHashMultiSetElement(key);
                this.keyValueMap.put(keyBytesWritable, this.count);
                ++this.count;
            }
        }

        public byte[] addRandomExisting(byte[] value, Random r) {
            Preconditions.checkState((this.count > 0 ? 1 : 0) != 0);
            int index = r.nextInt(this.count);
            this.array[index].incrementMultiSetCount();
            return this.array[index].getKey();
        }

        public byte[] getKey(int index) {
            return this.array[index].getKey();
        }

        public int getMultiSetCount(int index) {
            return this.array[index].getMultiSetCount();
        }

        public void verify(VectorMapJoinFastBytesHashMultiSet map) {
            int mapSize = map.size();
            if (mapSize != this.count) {
                TestCase.fail((String)"map.size() does not match expected count");
            }
            for (int index = 0; index < this.count; ++index) {
                FastBytesHashMultiSetElement element = this.array[index];
                byte[] key = element.getKey();
                int multiSetCount = element.getMultiSetCount();
                VectorMapJoinHashMultiSetResult hashMultiSetResult = map.createHashMultiSetResult();
                JoinUtil.JoinResult joinResult = map.contains(key, 0, key.length, hashMultiSetResult);
                if (joinResult != JoinUtil.JoinResult.MATCH) {
                    Assert.assertTrue((boolean)false);
                }
                Assert.assertEquals((long)hashMultiSetResult.count(), (long)multiSetCount);
            }
        }
    }

    public static class FastBytesHashMultiSetElement {
        private byte[] key;
        private int multiSetCount;

        public FastBytesHashMultiSetElement(byte[] key) {
            this.key = key;
            this.multiSetCount = 1;
        }

        public byte[] getKey() {
            return this.key;
        }

        public int getMultiSetCount() {
            return this.multiSetCount;
        }

        public void incrementMultiSetCount() {
            ++this.multiSetCount;
        }
    }

    public static class VerifyFastLongHashMultiSet {
        private int count = 0;
        private FastLongHashMultiSetElement[] array = new FastLongHashMultiSetElement[50];
        private HashMap<Long, Integer> keyValueMap = new HashMap();

        public int getCount() {
            return this.count;
        }

        public boolean contains(long key) {
            return this.keyValueMap.containsKey(key);
        }

        public void add(long key) {
            if (this.keyValueMap.containsKey(key)) {
                int index = this.keyValueMap.get(key);
                this.array[index].incrementMultiSetCount();
            } else {
                if (this.count >= this.array.length) {
                    FastLongHashMultiSetElement[] newArray = new FastLongHashMultiSetElement[this.array.length * 2];
                    System.arraycopy(this.array, 0, newArray, 0, this.count);
                    this.array = newArray;
                }
                this.array[this.count] = new FastLongHashMultiSetElement(key);
                this.keyValueMap.put(key, this.count);
                ++this.count;
            }
        }

        public long addRandomExisting(byte[] value, Random r) {
            Preconditions.checkState((this.count > 0 ? 1 : 0) != 0);
            int index = r.nextInt(this.count);
            this.array[index].incrementMultiSetCount();
            return this.array[index].getKey();
        }

        public long getKey(int index) {
            return this.array[index].getKey();
        }

        public int getMultiSetCount(int index) {
            return this.array[index].getMultiSetCount();
        }

        public void verify(VectorMapJoinFastLongHashMultiSet map) {
            int mapSize = map.size();
            if (mapSize != this.count) {
                TestCase.fail((String)"map.size() does not match expected count");
            }
            for (int index = 0; index < this.count; ++index) {
                FastLongHashMultiSetElement element = this.array[index];
                long key = element.getKey();
                int multiSetCount = element.getMultiSetCount();
                VectorMapJoinHashMultiSetResult hashMultiSetResult = map.createHashMultiSetResult();
                JoinUtil.JoinResult joinResult = map.contains(key, hashMultiSetResult);
                if (joinResult != JoinUtil.JoinResult.MATCH) {
                    Assert.assertTrue((boolean)false);
                }
                Assert.assertEquals((long)hashMultiSetResult.count(), (long)multiSetCount);
            }
        }
    }

    public static class FastLongHashMultiSetElement {
        private long key;
        private int multiSetCount;

        public FastLongHashMultiSetElement(long key) {
            this.key = key;
            this.multiSetCount = 1;
        }

        public long getKey() {
            return this.key;
        }

        public int getMultiSetCount() {
            return this.multiSetCount;
        }

        public void incrementMultiSetCount() {
            ++this.multiSetCount;
        }
    }

    public static class VerifyFastBytesHashMap {
        private int count = 0;
        private FastBytesHashMapElement[] array = new FastBytesHashMapElement[50];
        private TreeMap<BytesWritable, Integer> keyValueMap = new TreeMap();

        public int getCount() {
            return this.count;
        }

        public boolean contains(byte[] key) {
            BytesWritable keyBytesWritable = new BytesWritable(key, key.length);
            return this.keyValueMap.containsKey(keyBytesWritable);
        }

        public void add(byte[] key, byte[] value) {
            BytesWritable keyBytesWritable = new BytesWritable(key, key.length);
            if (this.keyValueMap.containsKey(keyBytesWritable)) {
                int index = this.keyValueMap.get(keyBytesWritable);
                this.array[index].addValue(value);
            } else {
                if (this.count >= this.array.length) {
                    FastBytesHashMapElement[] newArray = new FastBytesHashMapElement[this.array.length * 2];
                    System.arraycopy(this.array, 0, newArray, 0, this.count);
                    this.array = newArray;
                }
                this.array[this.count] = new FastBytesHashMapElement(key, value);
                this.keyValueMap.put(keyBytesWritable, this.count);
                ++this.count;
            }
        }

        public byte[] addRandomExisting(byte[] value, Random r) {
            Preconditions.checkState((this.count > 0 ? 1 : 0) != 0);
            int index = r.nextInt(this.count);
            this.array[index].addValue(value);
            return this.array[index].getKey();
        }

        public byte[] getKey(int index) {
            return this.array[index].getKey();
        }

        public List<byte[]> getValues(int index) {
            return this.array[index].getValues();
        }

        public void verify(VectorMapJoinFastBytesHashMap map) {
            int mapSize = map.size();
            if (mapSize != this.count) {
                TestCase.fail((String)"map.size() does not match expected count");
            }
            for (int index = 0; index < this.count; ++index) {
                FastBytesHashMapElement element = this.array[index];
                byte[] key = element.getKey();
                List<byte[]> values = element.getValues();
                VectorMapJoinHashMapResult hashMapResult = map.createHashMapResult();
                JoinUtil.JoinResult joinResult = map.lookup(key, 0, key.length, hashMapResult);
                if (joinResult != JoinUtil.JoinResult.MATCH) {
                    Assert.assertTrue((boolean)false);
                }
                CheckFastHashTable.verifyHashMapValues(hashMapResult, values);
            }
        }
    }

    public static class FastBytesHashMapElement {
        private byte[] key;
        private List<byte[]> values;

        public FastBytesHashMapElement(byte[] key, byte[] firstValue) {
            this.key = key;
            this.values = new ArrayList<byte[]>();
            this.values.add(firstValue);
        }

        public byte[] getKey() {
            return this.key;
        }

        public int getValueCount() {
            return this.values.size();
        }

        public List<byte[]> getValues() {
            return this.values;
        }

        public void addValue(byte[] value) {
            this.values.add(value);
        }
    }

    public static class VerifyFastLongHashMap {
        private int count = 0;
        private FastLongHashMapElement[] array = new FastLongHashMapElement[50];
        private HashMap<Long, Integer> keyValueMap = new HashMap();

        public int getCount() {
            return this.count;
        }

        public boolean contains(long key) {
            return this.keyValueMap.containsKey(key);
        }

        public void add(long key, byte[] value) {
            if (this.keyValueMap.containsKey(key)) {
                int index = this.keyValueMap.get(key);
                this.array[index].addValue(value);
            } else {
                if (this.count >= this.array.length) {
                    FastLongHashMapElement[] newArray = new FastLongHashMapElement[this.array.length * 2];
                    System.arraycopy(this.array, 0, newArray, 0, this.count);
                    this.array = newArray;
                }
                this.array[this.count] = new FastLongHashMapElement(key, value);
                this.keyValueMap.put(key, this.count);
                ++this.count;
            }
        }

        public long addRandomExisting(byte[] value, Random r) {
            Preconditions.checkState((this.count > 0 ? 1 : 0) != 0);
            int index = r.nextInt(this.count);
            this.array[index].addValue(value);
            return this.array[index].getKey();
        }

        public long getKey(int index) {
            return this.array[index].getKey();
        }

        public List<byte[]> getValues(int index) {
            return this.array[index].getValues();
        }

        public void verify(VectorMapJoinFastLongHashMap map) {
            int mapSize = map.size();
            if (mapSize != this.count) {
                TestCase.fail((String)"map.size() does not match expected count");
            }
            for (int index = 0; index < this.count; ++index) {
                FastLongHashMapElement element = this.array[index];
                long key = element.getKey();
                List<byte[]> values = element.getValues();
                VectorMapJoinHashMapResult hashMapResult = map.createHashMapResult();
                JoinUtil.JoinResult joinResult = map.lookup(key, hashMapResult);
                if (joinResult != JoinUtil.JoinResult.MATCH) {
                    Assert.assertTrue((boolean)false);
                }
                CheckFastHashTable.verifyHashMapValues(hashMapResult, values);
            }
        }
    }

    public static class FastLongHashMapElement {
        private long key;
        private List<byte[]> values;

        public FastLongHashMapElement(long key, byte[] firstValue) {
            this.key = key;
            this.values = new ArrayList<byte[]>();
            this.values.add(firstValue);
        }

        public long getKey() {
            return this.key;
        }

        public int getValueCount() {
            return this.values.size();
        }

        public List<byte[]> getValues() {
            return this.values;
        }

        public void addValue(byte[] value) {
            this.values.add(value);
        }
    }
}

