/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.serde2.RandomTypeUtil;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardUnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveWritableObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableBooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableFloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveIntervalDayTimeObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveIntervalYearMonthObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableHiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableLongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableTimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

public class VectorRandomRowSource {
    private Random r;
    private int columnCount;
    private List<String> typeNames;
    private ObjectInspector.Category[] categories;
    private TypeInfo[] typeInfos;
    private DataTypePhysicalVariation[] dataTypePhysicalVariations;
    private List<ObjectInspector> objectInspectorList;
    private PrimitiveObjectInspector.PrimitiveCategory[] primitiveCategories;
    private PrimitiveTypeInfo[] primitiveTypeInfos;
    private List<ObjectInspector> primitiveObjectInspectorList;
    private StructObjectInspector rowStructObjectInspector;
    private List<GenerationSpec> generationSpecList;
    private String[] alphabets;
    private boolean allowNull;
    private boolean addEscapables;
    private String needsEscapeStr;
    private static String[] possibleHivePrimitiveTypeNames = new String[]{"boolean", "tinyint", "smallint", "int", "bigint", "date", "float", "double", "string", "char", "varchar", "binary", "date", "timestamp", "interval_year_month", "interval_day_time", "decimal"};
    private static String[] possibleHiveComplexTypeNames = new String[]{"array", "struct", "uniontype", "map"};
    private static ThreadLocal<DateFormat> DATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    private static long MIN_FOUR_DIGIT_YEAR_MILLIS = VectorRandomRowSource.parseToMillis("0001-01-01 00:00:00");
    private static long MAX_FOUR_DIGIT_YEAR_MILLIS = VectorRandomRowSource.parseToMillis("9999-01-01 00:00:00");
    private static String[] randomWords = new String[]{"groovy", "attack", "wacky", "kiss", "to", "the", "a", "thoughtless", "blushing", "pay", "rule", "profuse", "need", "smell", "bucket", "board", "eggs", "laughable", "idiotic", "direful", "thoughtful", "curious", "show", "surge", "opines", "cowl", "signal", ""};
    private static int randomWordCount = randomWords.length;
    private static final String DECIMAL_CHARS = "0123456789";

    public List<String> typeNames() {
        return this.typeNames;
    }

    public ObjectInspector.Category[] categories() {
        return this.categories;
    }

    public TypeInfo[] typeInfos() {
        return this.typeInfos;
    }

    public DataTypePhysicalVariation[] dataTypePhysicalVariations() {
        return this.dataTypePhysicalVariations;
    }

    public PrimitiveObjectInspector.PrimitiveCategory[] primitiveCategories() {
        return this.primitiveCategories;
    }

    public PrimitiveTypeInfo[] primitiveTypeInfos() {
        return this.primitiveTypeInfos;
    }

    public StructObjectInspector rowStructObjectInspector() {
        return this.rowStructObjectInspector;
    }

    public StructObjectInspector partialRowStructObjectInspector(int partialFieldCount) {
        ArrayList<ObjectInspector> partialObjectInspectorList = new ArrayList<ObjectInspector>(partialFieldCount);
        ArrayList<String> columnNames = new ArrayList<String>(partialFieldCount);
        for (int i = 0; i < partialFieldCount; ++i) {
            columnNames.add(String.format("partial%d", i));
            partialObjectInspectorList.add(this.getObjectInspector(this.typeInfos[i]));
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, this.objectInspectorList);
    }

    public void init(Random r, SupportedTypes supportedTypes, int maxComplexDepth) {
        this.init(r, supportedTypes, maxComplexDepth, true);
    }

    public void init(Random r, SupportedTypes supportedTypes, int maxComplexDepth, boolean allowNull) {
        this.r = r;
        this.allowNull = allowNull;
        this.chooseSchema(supportedTypes, null, null, null, maxComplexDepth);
    }

    public void init(Random r, Set<String> allowedTypeNameSet, int maxComplexDepth, boolean allowNull) {
        this.r = r;
        this.allowNull = allowNull;
        this.chooseSchema(SupportedTypes.ALL, allowedTypeNameSet, null, null, maxComplexDepth);
    }

    public void initExplicitSchema(Random r, List<String> explicitTypeNameList, int maxComplexDepth, boolean allowNull, List<DataTypePhysicalVariation> explicitDataTypePhysicalVariationList) {
        this.r = r;
        this.allowNull = allowNull;
        ArrayList<GenerationSpec> generationSpecList = new ArrayList<GenerationSpec>();
        for (String explicitTypeName : explicitTypeNameList) {
            TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)explicitTypeName);
            generationSpecList.add(GenerationSpec.createSameType(typeInfo));
        }
        this.chooseSchema(SupportedTypes.ALL, null, generationSpecList, explicitDataTypePhysicalVariationList, maxComplexDepth);
    }

    public void initGenerationSpecSchema(Random r, List<GenerationSpec> generationSpecList, int maxComplexDepth, boolean allowNull, List<DataTypePhysicalVariation> explicitDataTypePhysicalVariationList) {
        this.r = r;
        this.allowNull = allowNull;
        this.chooseSchema(SupportedTypes.ALL, null, generationSpecList, explicitDataTypePhysicalVariationList, maxComplexDepth);
    }

    private static String getRandomTypeName(Random random, SupportedTypes supportedTypes, Set<String> allowedTypeNameSet) {
        String typeName = null;
        do {
            if (random.nextInt(10) != 0) {
                typeName = possibleHivePrimitiveTypeNames[random.nextInt(possibleHivePrimitiveTypeNames.length)];
                continue;
            }
            switch (supportedTypes) {
                case PRIMITIVES: {
                    typeName = possibleHivePrimitiveTypeNames[random.nextInt(possibleHivePrimitiveTypeNames.length)];
                    break;
                }
                case ALL_EXCEPT_MAP: {
                    typeName = possibleHiveComplexTypeNames[random.nextInt(possibleHiveComplexTypeNames.length - 1)];
                    break;
                }
                case ALL: {
                    typeName = possibleHiveComplexTypeNames[random.nextInt(possibleHiveComplexTypeNames.length)];
                }
            }
        } while (allowedTypeNameSet != null && !allowedTypeNameSet.contains(typeName));
        return typeName;
    }

    public static String getDecoratedTypeName(Random random, String typeName) {
        return VectorRandomRowSource.getDecoratedTypeName(random, typeName, null, null, 0, 1);
    }

    private static String getDecoratedTypeName(Random random, String typeName, SupportedTypes supportedTypes, Set<String> allowedTypeNameSet, int depth, int maxDepth) {
        if (++depth < maxDepth) {
            supportedTypes = SupportedTypes.PRIMITIVES;
        }
        if (typeName.equals("char")) {
            int maxLength = 1 + random.nextInt(100);
            typeName = String.format("char(%d)", maxLength);
        } else if (typeName.equals("varchar")) {
            int maxLength = 1 + random.nextInt(100);
            typeName = String.format("varchar(%d)", maxLength);
        } else if (typeName.equals("decimal")) {
            typeName = String.format("decimal(%d,%d)", 38, 18);
        } else if (typeName.equals("array")) {
            String elementTypeName = VectorRandomRowSource.getRandomTypeName(random, supportedTypes, allowedTypeNameSet);
            elementTypeName = VectorRandomRowSource.getDecoratedTypeName(random, elementTypeName, supportedTypes, allowedTypeNameSet, depth, maxDepth);
            typeName = String.format("array<%s>", elementTypeName);
        } else if (typeName.equals("map")) {
            String keyTypeName = VectorRandomRowSource.getRandomTypeName(random, SupportedTypes.PRIMITIVES, allowedTypeNameSet);
            keyTypeName = VectorRandomRowSource.getDecoratedTypeName(random, keyTypeName, supportedTypes, allowedTypeNameSet, depth, maxDepth);
            String valueTypeName = VectorRandomRowSource.getRandomTypeName(random, supportedTypes, allowedTypeNameSet);
            valueTypeName = VectorRandomRowSource.getDecoratedTypeName(random, valueTypeName, supportedTypes, allowedTypeNameSet, depth, maxDepth);
            typeName = String.format("map<%s,%s>", keyTypeName, valueTypeName);
        } else if (typeName.equals("struct")) {
            int fieldCount = 1 + random.nextInt(10);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < fieldCount; ++i) {
                String fieldTypeName = VectorRandomRowSource.getRandomTypeName(random, supportedTypes, allowedTypeNameSet);
                fieldTypeName = VectorRandomRowSource.getDecoratedTypeName(random, fieldTypeName, supportedTypes, allowedTypeNameSet, depth, maxDepth);
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("col");
                sb.append(i);
                sb.append(":");
                sb.append(fieldTypeName);
            }
            typeName = String.format("struct<%s>", sb.toString());
        } else if (typeName.equals("struct") || typeName.equals("uniontype")) {
            int fieldCount = 1 + random.nextInt(10);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < fieldCount; ++i) {
                String fieldTypeName = VectorRandomRowSource.getRandomTypeName(random, supportedTypes, allowedTypeNameSet);
                fieldTypeName = VectorRandomRowSource.getDecoratedTypeName(random, fieldTypeName, supportedTypes, allowedTypeNameSet, depth, maxDepth);
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(fieldTypeName);
            }
            typeName = String.format("uniontype<%s>", sb.toString());
        }
        return typeName;
    }

    private String getDecoratedTypeName(String typeName, SupportedTypes supportedTypes, Set<String> allowedTypeNameSet, int depth, int maxDepth) {
        return VectorRandomRowSource.getDecoratedTypeName(this.r, typeName, supportedTypes, allowedTypeNameSet, depth, maxDepth);
    }

    private ObjectInspector getObjectInspector(TypeInfo typeInfo) {
        return this.getObjectInspector(typeInfo, DataTypePhysicalVariation.NONE);
    }

    private ObjectInspector getObjectInspector(TypeInfo typeInfo, DataTypePhysicalVariation dataTypePhysicalVariation) {
        AbstractPrimitiveWritableObjectInspector objectInspector;
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)typeInfo;
                if (primitiveTypeInfo instanceof DecimalTypeInfo && dataTypePhysicalVariation == DataTypePhysicalVariation.DECIMAL_64) {
                    objectInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.longTypeInfo);
                    break;
                }
                objectInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)primitiveTypeInfo);
                break;
            }
            case MAP: {
                MapTypeInfo mapType = (MapTypeInfo)typeInfo;
                StandardMapObjectInspector mapInspector = ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)this.getObjectInspector(mapType.getMapKeyTypeInfo()), (ObjectInspector)this.getObjectInspector(mapType.getMapValueTypeInfo()));
                objectInspector = mapInspector;
                break;
            }
            case LIST: {
                ListTypeInfo listType = (ListTypeInfo)typeInfo;
                StandardListObjectInspector listInspector = ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)this.getObjectInspector(listType.getListElementTypeInfo()));
                objectInspector = listInspector;
                break;
            }
            case STRUCT: {
                StructTypeInfo structType = (StructTypeInfo)typeInfo;
                ArrayList fieldTypes = structType.getAllStructFieldTypeInfos();
                ArrayList<ObjectInspector> fieldInspectors = new ArrayList<ObjectInspector>();
                for (TypeInfo fieldType : fieldTypes) {
                    fieldInspectors.add(this.getObjectInspector(fieldType));
                }
                StandardStructObjectInspector structInspector = ObjectInspectorFactory.getStandardStructObjectInspector((List)structType.getAllStructFieldNames(), fieldInspectors);
                objectInspector = structInspector;
                break;
            }
            case UNION: {
                UnionTypeInfo unionType = (UnionTypeInfo)typeInfo;
                List fieldTypes = unionType.getAllUnionObjectTypeInfos();
                ArrayList<ObjectInspector> fieldInspectors = new ArrayList<ObjectInspector>();
                for (TypeInfo fieldType : fieldTypes) {
                    fieldInspectors.add(this.getObjectInspector(fieldType));
                }
                StandardUnionObjectInspector unionInspector = ObjectInspectorFactory.getStandardUnionObjectInspector(fieldInspectors);
                objectInspector = unionInspector;
                break;
            }
            default: {
                throw new RuntimeException("Unexpected category " + typeInfo.getCategory());
            }
        }
        Preconditions.checkState((objectInspector != null ? 1 : 0) != 0);
        return objectInspector;
    }

    private void chooseSchema(SupportedTypes supportedTypes, Set<String> allowedTypeNameSet, List<GenerationSpec> generationSpecList, List<DataTypePhysicalVariation> explicitDataTypePhysicalVariationList, int maxComplexDepth) {
        boolean onlyOne;
        boolean allTypes;
        HashSet<Integer> hashSet = null;
        if (generationSpecList != null) {
            this.columnCount = generationSpecList.size();
            allTypes = false;
            onlyOne = false;
        } else if (allowedTypeNameSet != null) {
            this.columnCount = 1 + this.r.nextInt(20);
            allTypes = false;
            onlyOne = false;
        } else {
            boolean bl = onlyOne = this.r.nextInt(100) == 7;
            if (onlyOne) {
                this.columnCount = 1;
                allTypes = false;
            } else {
                allTypes = this.r.nextBoolean();
                if (allTypes) {
                    switch (supportedTypes) {
                        case ALL: {
                            this.columnCount = possibleHivePrimitiveTypeNames.length + possibleHiveComplexTypeNames.length;
                            break;
                        }
                        case ALL_EXCEPT_MAP: {
                            this.columnCount = possibleHivePrimitiveTypeNames.length + possibleHiveComplexTypeNames.length - 1;
                            break;
                        }
                        case PRIMITIVES: {
                            this.columnCount = possibleHivePrimitiveTypeNames.length;
                        }
                    }
                    hashSet = new HashSet<Integer>();
                } else {
                    this.columnCount = 1 + this.r.nextInt(20);
                }
            }
        }
        this.typeNames = new ArrayList<String>(this.columnCount);
        this.categories = new ObjectInspector.Category[this.columnCount];
        this.typeInfos = new TypeInfo[this.columnCount];
        this.dataTypePhysicalVariations = new DataTypePhysicalVariation[this.columnCount];
        this.objectInspectorList = new ArrayList<ObjectInspector>(this.columnCount);
        this.primitiveCategories = new PrimitiveObjectInspector.PrimitiveCategory[this.columnCount];
        this.primitiveTypeInfos = new PrimitiveTypeInfo[this.columnCount];
        this.primitiveObjectInspectorList = new ArrayList<ObjectInspector>(this.columnCount);
        ArrayList<String> columnNames = new ArrayList<String>(this.columnCount);
        for (int c = 0; c < this.columnCount; ++c) {
            ObjectInspector.Category category;
            TypeInfo typeInfo;
            String typeName;
            columnNames.add(String.format("col%d", c));
            DataTypePhysicalVariation dataTypePhysicalVariation = DataTypePhysicalVariation.NONE;
            if (generationSpecList != null) {
                typeName = generationSpecList.get(c).getTypeInfo().getTypeName();
                dataTypePhysicalVariation = explicitDataTypePhysicalVariationList.get(c);
            } else if (onlyOne || allowedTypeNameSet != null) {
                typeName = VectorRandomRowSource.getRandomTypeName(this.r, supportedTypes, allowedTypeNameSet);
            } else {
                int typeNum;
                if (allTypes) {
                    Integer typeNumInteger;
                    int maxTypeNum = 0;
                    switch (supportedTypes) {
                        case PRIMITIVES: {
                            maxTypeNum = possibleHivePrimitiveTypeNames.length;
                            break;
                        }
                        case ALL_EXCEPT_MAP: {
                            maxTypeNum = possibleHivePrimitiveTypeNames.length + possibleHiveComplexTypeNames.length - 1;
                            break;
                        }
                        case ALL: {
                            maxTypeNum = possibleHivePrimitiveTypeNames.length + possibleHiveComplexTypeNames.length;
                        }
                    }
                    while (hashSet.contains(typeNumInteger = new Integer(typeNum = this.r.nextInt(maxTypeNum)))) {
                    }
                    hashSet.add(typeNumInteger);
                } else if (supportedTypes == SupportedTypes.PRIMITIVES || this.r.nextInt(10) != 0) {
                    typeNum = this.r.nextInt(possibleHivePrimitiveTypeNames.length);
                } else {
                    typeNum = possibleHivePrimitiveTypeNames.length + this.r.nextInt(possibleHiveComplexTypeNames.length);
                    if (supportedTypes == SupportedTypes.ALL_EXCEPT_MAP) {
                        --typeNum;
                    }
                }
                typeName = typeNum < possibleHivePrimitiveTypeNames.length ? possibleHivePrimitiveTypeNames[typeNum] : possibleHiveComplexTypeNames[typeNum - possibleHivePrimitiveTypeNames.length];
            }
            String decoratedTypeName = this.getDecoratedTypeName(typeName, supportedTypes, allowedTypeNameSet, 0, maxComplexDepth);
            try {
                typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)decoratedTypeName);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot convert type name " + decoratedTypeName + " to a type " + e);
            }
            this.typeInfos[c] = typeInfo;
            this.dataTypePhysicalVariations[c] = dataTypePhysicalVariation;
            this.categories[c] = category = typeInfo.getCategory();
            ObjectInspector objectInspector = this.getObjectInspector(typeInfo, dataTypePhysicalVariation);
            switch (category) {
                case PRIMITIVE: {
                    PrimitiveObjectInspector.PrimitiveCategory primitiveCategory;
                    PrimitiveTypeInfo primitiveTypeInfo;
                    this.primitiveTypeInfos[c] = primitiveTypeInfo = (PrimitiveTypeInfo)typeInfo;
                    this.primitiveCategories[c] = primitiveCategory = primitiveTypeInfo.getPrimitiveCategory();
                    this.primitiveObjectInspectorList.add(objectInspector);
                    break;
                }
                case MAP: 
                case LIST: 
                case STRUCT: 
                case UNION: {
                    this.primitiveObjectInspectorList.add(null);
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected catagory " + category);
                }
            }
            this.objectInspectorList.add(objectInspector);
            if (category == ObjectInspector.Category.PRIMITIVE) {
                // empty if block
            }
            this.typeNames.add(decoratedTypeName);
        }
        this.rowStructObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(columnNames, this.objectInspectorList);
        this.alphabets = new String[this.columnCount];
        this.generationSpecList = generationSpecList;
    }

    private static long parseToMillis(String s) {
        try {
            return DATE_FORMAT.get().parse(s).getTime();
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Object toStringFamilyObject(TypeInfo typeInfo, String string, boolean isWritable) {
        String object;
        PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)typeInfo;
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = primitiveTypeInfo.getPrimitiveCategory();
        switch (primitiveCategory) {
            case STRING: {
                if (isWritable) {
                    object = new Text(string);
                    break;
                }
                object = string;
                break;
            }
            case CHAR: {
                HiveChar hiveChar = new HiveChar(string, ((CharTypeInfo)typeInfo).getLength());
                if (isWritable) {
                    object = new HiveCharWritable(hiveChar);
                    break;
                }
                object = hiveChar;
                break;
            }
            case VARCHAR: {
                HiveVarchar hiveVarchar = new HiveVarchar(string, ((VarcharTypeInfo)typeInfo).getLength());
                if (isWritable) {
                    object = new HiveVarcharWritable(hiveVarchar);
                    break;
                }
                object = hiveVarchar;
                break;
            }
            default: {
                throw new RuntimeException("Unexpected string family category " + primitiveCategory);
            }
        }
        return object;
    }

    public static Object randomStringFamilyOtherTypeValue(Random random, TypeInfo typeInfo, TypeInfo specialValueTypeInfo, boolean isWritable) {
        String string = VectorRandomRowSource.randomPrimitiveObject(random, (PrimitiveTypeInfo)specialValueTypeInfo).toString();
        return VectorRandomRowSource.toStringFamilyObject(typeInfo, string, isWritable);
    }

    public static Object randomStringFamily(Random random, TypeInfo typeInfo, StringGenerationOption stringGenerationOption, boolean isWritable) {
        String string;
        if (stringGenerationOption == null) {
            string = VectorRandomRowSource.randomPrimitiveObject(random, (PrimitiveTypeInfo)typeInfo).toString();
        } else {
            boolean generateSentences = stringGenerationOption.getGenerateSentences();
            boolean addPadding = stringGenerationOption.getAddPadding();
            StringBuilder sb = new StringBuilder();
            if (addPadding && random.nextBoolean()) {
                sb.append(StringUtils.leftPad((String)"", (int)random.nextInt(5)));
            }
            if (generateSentences) {
                boolean capitalizeFirstWord = random.nextBoolean();
                int n = random.nextInt(10);
                for (int i = 0; i < n; ++i) {
                    Object randomWord = randomWords[random.nextInt(randomWordCount)];
                    if (((String)randomWord).length() > 0 && (i == 0 && capitalizeFirstWord || random.nextInt(20) == 0)) {
                        randomWord = Character.toUpperCase(((String)randomWord).charAt(0)) + ((String)randomWord).substring(1);
                    }
                    if (i > 0) {
                        sb.append(" ");
                    }
                    sb.append((String)randomWord);
                }
            } else {
                sb.append(VectorRandomRowSource.randomPrimitiveObject(random, (PrimitiveTypeInfo)typeInfo).toString());
            }
            if (addPadding && random.nextBoolean()) {
                sb.append(StringUtils.leftPad((String)"", (int)random.nextInt(5)));
            }
            string = sb.toString();
        }
        return VectorRandomRowSource.toStringFamilyObject(typeInfo, string, isWritable);
    }

    public Object[][] randomRows(int n) {
        Object[][] result = new Object[n][];
        for (int i = 0; i < n; ++i) {
            result[i] = this.randomRow();
        }
        return result;
    }

    public Object[] randomRow() {
        Object[] row = new Object[this.columnCount];
        if (this.generationSpecList == null) {
            for (int c = 0; c < this.columnCount; ++c) {
                row[c] = this.randomWritable(c);
            }
        } else {
            for (int c = 0; c < this.columnCount; ++c) {
                Object object;
                GenerationSpec generationSpec = this.generationSpecList.get(c);
                GenerationSpec.GenerationKind generationKind = generationSpec.getGenerationKind();
                switch (generationKind) {
                    case SAME_TYPE: {
                        object = this.randomWritable(c);
                        break;
                    }
                    case OMIT_GENERATION: {
                        object = null;
                        break;
                    }
                    case STRING_FAMILY: {
                        TypeInfo typeInfo = generationSpec.getTypeInfo();
                        StringGenerationOption stringGenerationOption = generationSpec.getStringGenerationOption();
                        object = VectorRandomRowSource.randomStringFamily(this.r, typeInfo, stringGenerationOption, true);
                        break;
                    }
                    case STRING_FAMILY_OTHER_TYPE_VALUE: {
                        TypeInfo typeInfo = generationSpec.getTypeInfo();
                        TypeInfo otherTypeTypeInfo = generationSpec.getSourceTypeInfo();
                        object = VectorRandomRowSource.randomStringFamilyOtherTypeValue(this.r, typeInfo, otherTypeTypeInfo, true);
                        break;
                    }
                    case TIMESTAMP_MILLISECONDS: {
                        LongWritable longWritable = (LongWritable)this.randomWritable(c);
                        if (longWritable != null) {
                            long longValue;
                            while ((longValue = longWritable.get()) < MIN_FOUR_DIGIT_YEAR_MILLIS || longValue > MAX_FOUR_DIGIT_YEAR_MILLIS) {
                                longWritable.set(((Long)VectorRandomRowSource.randomPrimitiveObject(this.r, TypeInfoFactory.longTypeInfo)).longValue());
                            }
                        }
                        object = longWritable;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unexpected generationKind " + generationKind);
                    }
                }
                row[c] = object;
            }
        }
        return row;
    }

    public Object[] randomRow(boolean allowNull) {
        Object[] row = new Object[this.columnCount];
        for (int c = 0; c < this.columnCount; ++c) {
            row[c] = this.randomWritable(this.typeInfos[c], this.objectInspectorList.get(c), allowNull);
        }
        return row;
    }

    public Object[] randomPrimitiveRow(int columnCount) {
        return VectorRandomRowSource.randomPrimitiveRow(columnCount, this.r, this.primitiveTypeInfos, this.dataTypePhysicalVariations);
    }

    public static Object[] randomPrimitiveRow(int columnCount, Random r, PrimitiveTypeInfo[] primitiveTypeInfos, DataTypePhysicalVariation[] dataTypePhysicalVariations) {
        Object[] row = new Object[columnCount];
        for (int c = 0; c < columnCount; ++c) {
            row[c] = VectorRandomRowSource.randomPrimitiveObject(r, primitiveTypeInfos[c], dataTypePhysicalVariations[c]);
        }
        return row;
    }

    public static Object[] randomWritablePrimitiveRow(int columnCount, Random r, PrimitiveTypeInfo[] primitiveTypeInfos) {
        return VectorRandomRowSource.randomWritablePrimitiveRow(columnCount, r, primitiveTypeInfos, null);
    }

    public static Object[] randomWritablePrimitiveRow(int columnCount, Random r, PrimitiveTypeInfo[] primitiveTypeInfos, DataTypePhysicalVariation[] dataTypePhysicalVariations) {
        Object[] row = new Object[columnCount];
        for (int c = 0; c < columnCount; ++c) {
            PrimitiveTypeInfo primitiveTypeInfo = primitiveTypeInfos[c];
            DataTypePhysicalVariation dataTypePhysicalVariation = dataTypePhysicalVariations != null ? dataTypePhysicalVariations[c] : DataTypePhysicalVariation.NONE;
            AbstractPrimitiveWritableObjectInspector objectInspector = primitiveTypeInfo instanceof DecimalTypeInfo && dataTypePhysicalVariation == DataTypePhysicalVariation.DECIMAL_64 ? PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.longTypeInfo) : PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)primitiveTypeInfo);
            Object object = VectorRandomRowSource.randomPrimitiveObject(r, primitiveTypeInfo);
            row[c] = VectorRandomRowSource.getWritablePrimitiveObject(primitiveTypeInfo, (ObjectInspector)objectInspector, object);
        }
        return row;
    }

    public void addBinarySortableAlphabets() {
        block3: for (int c = 0; c < this.columnCount; ++c) {
            if (this.primitiveCategories[c] == null) continue;
            switch (this.primitiveCategories[c]) {
                case STRING: 
                case CHAR: 
                case VARCHAR: {
                    byte[] bytes = new byte[10 + this.r.nextInt(10)];
                    for (int i = 0; i < bytes.length; ++i) {
                        bytes[i] = (byte)(32 + this.r.nextInt(96));
                    }
                    int alwaysIndex = this.r.nextInt(bytes.length);
                    bytes[alwaysIndex] = 0;
                    int alwaysIndex2 = this.r.nextInt(bytes.length);
                    bytes[alwaysIndex2] = 1;
                    this.alphabets[c] = new String(bytes, Charsets.UTF_8);
                    continue block3;
                }
            }
        }
    }

    public void addEscapables(String needsEscapeStr) {
        this.addEscapables = true;
        this.needsEscapeStr = needsEscapeStr;
    }

    public static void sort(Object[][] rows, ObjectInspector oi) {
        for (int i = 0; i < rows.length; ++i) {
            for (int j = i + 1; j < rows.length; ++j) {
                if (ObjectInspectorUtils.compare((Object)rows[i], (ObjectInspector)oi, (Object)rows[j], (ObjectInspector)oi) <= 0) continue;
                Object[] t = rows[i];
                rows[i] = rows[j];
                rows[j] = t;
            }
        }
    }

    public void sort(Object[][] rows) {
        VectorRandomRowSource.sort(rows, (ObjectInspector)this.rowStructObjectInspector);
    }

    public static Object getWritablePrimitiveObject(PrimitiveTypeInfo primitiveTypeInfo, ObjectInspector objectInspector, Object object) {
        return VectorRandomRowSource.getWritablePrimitiveObject(primitiveTypeInfo, objectInspector, DataTypePhysicalVariation.NONE, object);
    }

    public static Object getWritablePrimitiveObject(PrimitiveTypeInfo primitiveTypeInfo, ObjectInspector objectInspector, DataTypePhysicalVariation dataTypePhysicalVariation, Object object) {
        switch (primitiveTypeInfo.getPrimitiveCategory()) {
            case BOOLEAN: {
                return ((WritableBooleanObjectInspector)objectInspector).create(((Boolean)object).booleanValue());
            }
            case BYTE: {
                return ((WritableByteObjectInspector)objectInspector).create(((Byte)object).byteValue());
            }
            case SHORT: {
                return ((WritableShortObjectInspector)objectInspector).create(((Short)object).shortValue());
            }
            case INT: {
                return ((WritableIntObjectInspector)objectInspector).create(((Integer)object).intValue());
            }
            case LONG: {
                return ((WritableLongObjectInspector)objectInspector).create(((Long)object).longValue());
            }
            case DATE: {
                return ((WritableDateObjectInspector)objectInspector).create((Date)object);
            }
            case FLOAT: {
                return ((WritableFloatObjectInspector)objectInspector).create(((Float)object).floatValue());
            }
            case DOUBLE: {
                return ((WritableDoubleObjectInspector)objectInspector).create(((Double)object).doubleValue());
            }
            case STRING: {
                return ((WritableStringObjectInspector)objectInspector).create((String)object);
            }
            case CHAR: {
                WritableHiveCharObjectInspector writableCharObjectInspector = new WritableHiveCharObjectInspector((CharTypeInfo)primitiveTypeInfo);
                return writableCharObjectInspector.create((HiveChar)object);
            }
            case VARCHAR: {
                WritableHiveVarcharObjectInspector writableVarcharObjectInspector = new WritableHiveVarcharObjectInspector((VarcharTypeInfo)primitiveTypeInfo);
                return writableVarcharObjectInspector.create((HiveVarchar)object);
            }
            case BINARY: {
                return PrimitiveObjectInspectorFactory.writableBinaryObjectInspector.create((byte[])object);
            }
            case TIMESTAMP: {
                return ((WritableTimestampObjectInspector)objectInspector).create((Timestamp)object);
            }
            case INTERVAL_YEAR_MONTH: {
                return ((WritableHiveIntervalYearMonthObjectInspector)objectInspector).create((HiveIntervalYearMonth)object);
            }
            case INTERVAL_DAY_TIME: {
                return ((WritableHiveIntervalDayTimeObjectInspector)objectInspector).create((HiveIntervalDayTime)object);
            }
            case DECIMAL: {
                if (dataTypePhysicalVariation == DataTypePhysicalVariation.DECIMAL_64) {
                    long value;
                    if (object instanceof HiveDecimal) {
                        DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)primitiveTypeInfo;
                        value = new HiveDecimalWritable((HiveDecimal)object).serialize64(decimalTypeInfo.getScale());
                    } else {
                        value = (Long)object;
                    }
                    return ((WritableLongObjectInspector)objectInspector).create(value);
                }
                WritableHiveDecimalObjectInspector writableDecimalObjectInspector = new WritableHiveDecimalObjectInspector((DecimalTypeInfo)primitiveTypeInfo);
                return writableDecimalObjectInspector.create((HiveDecimal)object);
            }
        }
        throw new Error("Unknown primitive category " + primitiveTypeInfo.getPrimitiveCategory());
    }

    public Object randomWritable(int column) {
        return this.randomWritable(this.typeInfos[column], this.objectInspectorList.get(column), this.dataTypePhysicalVariations[column], this.allowNull);
    }

    public Object randomWritable(TypeInfo typeInfo, ObjectInspector objectInspector) {
        return this.randomWritable(typeInfo, objectInspector, DataTypePhysicalVariation.NONE, this.allowNull);
    }

    public Object randomWritable(TypeInfo typeInfo, ObjectInspector objectInspector, boolean allowNull) {
        return this.randomWritable(typeInfo, objectInspector, DataTypePhysicalVariation.NONE, allowNull);
    }

    public Object randomWritable(TypeInfo typeInfo, ObjectInspector objectInspector, DataTypePhysicalVariation dataTypePhysicalVariation, boolean allowNull) {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                if (allowNull && this.r.nextInt(20) == 0) {
                    return null;
                }
                Object object = VectorRandomRowSource.randomPrimitiveObject(this.r, (PrimitiveTypeInfo)typeInfo);
                return VectorRandomRowSource.getWritablePrimitiveObject((PrimitiveTypeInfo)typeInfo, objectInspector, dataTypePhysicalVariation, object);
            }
            case LIST: {
                if (allowNull && this.r.nextInt(20) == 0) {
                    return null;
                }
                int elementCount = 1 + this.r.nextInt(100);
                StandardListObjectInspector listObjectInspector = (StandardListObjectInspector)objectInspector;
                ObjectInspector elementObjectInspector = listObjectInspector.getListElementObjectInspector();
                TypeInfo elementTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)elementObjectInspector);
                boolean isStringFamily = false;
                PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = null;
                if (elementTypeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE && ((primitiveCategory = ((PrimitiveTypeInfo)elementTypeInfo).getPrimitiveCategory()) == PrimitiveObjectInspector.PrimitiveCategory.STRING || primitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.BINARY || primitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.CHAR || primitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.VARCHAR)) {
                    isStringFamily = true;
                }
                Object listObj = listObjectInspector.create(elementCount);
                for (int i = 0; i < elementCount; ++i) {
                    Object ele = this.randomWritable(elementTypeInfo, elementObjectInspector, allowNull);
                    if (ele == null && elementCount == 1) {
                        return null;
                    }
                    if (isStringFamily && elementCount == 1) {
                        switch (primitiveCategory) {
                            case STRING: {
                                if (((Text)ele).getLength() != 0) break;
                                return null;
                            }
                            case BINARY: {
                                if (((BytesWritable)ele).getLength() != 0) break;
                                return null;
                            }
                            case CHAR: {
                                if (!((HiveCharWritable)ele).getHiveChar().getStrippedValue().isEmpty()) break;
                                return null;
                            }
                            case VARCHAR: {
                                if (!((HiveVarcharWritable)ele).getHiveVarchar().getValue().isEmpty()) break;
                                return null;
                            }
                            default: {
                                throw new RuntimeException("Unexpected primitive category " + primitiveCategory);
                            }
                        }
                    }
                    listObjectInspector.set(listObj, i, ele);
                }
                return listObj;
            }
            case MAP: {
                if (allowNull && this.r.nextInt(20) == 0) {
                    return null;
                }
                int keyPairCount = this.r.nextInt(100);
                StandardMapObjectInspector mapObjectInspector = (StandardMapObjectInspector)objectInspector;
                ObjectInspector keyObjectInspector = mapObjectInspector.getMapKeyObjectInspector();
                TypeInfo keyTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)keyObjectInspector);
                ObjectInspector valueObjectInspector = mapObjectInspector.getMapValueObjectInspector();
                TypeInfo valueTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)valueObjectInspector);
                Object mapObj = mapObjectInspector.create();
                for (int i = 0; i < keyPairCount; ++i) {
                    Object key = this.randomWritable(keyTypeInfo, keyObjectInspector);
                    Object value = this.randomWritable(valueTypeInfo, valueObjectInspector);
                    mapObjectInspector.put(mapObj, key, value);
                }
                return mapObj;
            }
            case STRUCT: {
                if (allowNull && this.r.nextInt(20) == 0) {
                    return null;
                }
                StandardStructObjectInspector structObjectInspector = (StandardStructObjectInspector)objectInspector;
                List fieldRefsList = structObjectInspector.getAllStructFieldRefs();
                int fieldCount = fieldRefsList.size();
                Object structObj = structObjectInspector.create();
                for (int i = 0; i < fieldCount; ++i) {
                    StructField fieldRef = (StructField)fieldRefsList.get(i);
                    ObjectInspector fieldObjectInspector = fieldRef.getFieldObjectInspector();
                    TypeInfo fieldTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)fieldObjectInspector);
                    Object fieldObj = this.randomWritable(fieldTypeInfo, fieldObjectInspector);
                    structObjectInspector.setStructFieldData(structObj, fieldRef, fieldObj);
                }
                return structObj;
            }
            case UNION: {
                StandardUnionObjectInspector unionObjectInspector = (StandardUnionObjectInspector)objectInspector;
                List objectInspectorList = unionObjectInspector.getObjectInspectors();
                int unionCount = objectInspectorList.size();
                byte tag = (byte)this.r.nextInt(unionCount);
                ObjectInspector fieldObjectInspector = (ObjectInspector)objectInspectorList.get(tag);
                TypeInfo fieldTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)fieldObjectInspector);
                Object fieldObj = this.randomWritable(fieldTypeInfo, fieldObjectInspector, false);
                if (fieldObj == null) {
                    throw new RuntimeException();
                }
                return new StandardUnionObjectInspector.StandardUnion(tag, fieldObj);
            }
        }
        throw new RuntimeException("Unexpected category " + typeInfo.getCategory());
    }

    public Object randomPrimitiveObject(int column) {
        return VectorRandomRowSource.randomPrimitiveObject(this.r, this.primitiveTypeInfos[column]);
    }

    public static Object randomPrimitiveObject(Random r, PrimitiveTypeInfo primitiveTypeInfo) {
        return VectorRandomRowSource.randomPrimitiveObject(r, primitiveTypeInfo, DataTypePhysicalVariation.NONE);
    }

    public static Object randomPrimitiveObject(Random r, PrimitiveTypeInfo primitiveTypeInfo, DataTypePhysicalVariation dataTypePhysicalVariation) {
        switch (primitiveTypeInfo.getPrimitiveCategory()) {
            case BOOLEAN: {
                return r.nextBoolean();
            }
            case BYTE: {
                return (byte)r.nextInt();
            }
            case SHORT: {
                return (short)r.nextInt();
            }
            case INT: {
                return r.nextInt();
            }
            case LONG: {
                return r.nextLong();
            }
            case DATE: {
                return RandomTypeUtil.getRandDate((Random)r);
            }
            case FLOAT: {
                return Float.valueOf(r.nextFloat() * 10.0f - 5.0f);
            }
            case DOUBLE: {
                return r.nextDouble() * 10.0 - 5.0;
            }
            case STRING: {
                return RandomTypeUtil.getRandString((Random)r);
            }
            case CHAR: {
                return VectorRandomRowSource.getRandHiveChar(r, (CharTypeInfo)primitiveTypeInfo);
            }
            case VARCHAR: {
                return VectorRandomRowSource.getRandHiveVarchar(r, (VarcharTypeInfo)primitiveTypeInfo);
            }
            case BINARY: {
                return VectorRandomRowSource.getRandBinary(r, 1 + r.nextInt(100));
            }
            case TIMESTAMP: {
                return RandomTypeUtil.getRandTimestamp((Random)r);
            }
            case INTERVAL_YEAR_MONTH: {
                return VectorRandomRowSource.getRandIntervalYearMonth(r);
            }
            case INTERVAL_DAY_TIME: {
                return VectorRandomRowSource.getRandIntervalDayTime(r);
            }
            case DECIMAL: {
                DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)primitiveTypeInfo;
                HiveDecimal hiveDecimal = VectorRandomRowSource.getRandHiveDecimal(r, decimalTypeInfo);
                if (dataTypePhysicalVariation == DataTypePhysicalVariation.DECIMAL_64) {
                    return new HiveDecimalWritable(hiveDecimal).serialize64(decimalTypeInfo.getScale());
                }
                return hiveDecimal;
            }
        }
        throw new Error("Unknown primitive category " + primitiveTypeInfo.getCategory());
    }

    public static String randomPrimitiveDateStringObject(Random r) {
        return RandomTypeUtil.getRandDate((Random)r).toString();
    }

    public static String randomPrimitiveTimestampStringObject(Random r) {
        return RandomTypeUtil.getRandTimestamp((Random)r).toString();
    }

    public static HiveChar getRandHiveChar(Random r, CharTypeInfo charTypeInfo) {
        int maxLength = 1 + r.nextInt(charTypeInfo.getLength());
        String randomString = RandomTypeUtil.getRandString((Random)r, (String)"abcdefghijklmnopqrstuvwxyz", (int)100);
        return new HiveChar(randomString, maxLength);
    }

    public static HiveVarchar getRandHiveVarchar(Random r, VarcharTypeInfo varcharTypeInfo, String alphabet) {
        int maxLength = 1 + r.nextInt(varcharTypeInfo.getLength());
        String randomString = RandomTypeUtil.getRandString((Random)r, (String)alphabet, (int)100);
        return new HiveVarchar(randomString, maxLength);
    }

    public static HiveVarchar getRandHiveVarchar(Random r, VarcharTypeInfo varcharTypeInfo) {
        return VectorRandomRowSource.getRandHiveVarchar(r, varcharTypeInfo, "abcdefghijklmnopqrstuvwxyz");
    }

    public static byte[] getRandBinary(Random r, int len) {
        byte[] bytes = new byte[len];
        for (int j = 0; j < len; ++j) {
            bytes[j] = (byte)r.nextInt();
        }
        return bytes;
    }

    public static HiveDecimal getRandHiveDecimal(Random r, DecimalTypeInfo decimalTypeInfo) {
        HiveDecimal dec;
        do {
            StringBuilder sb = new StringBuilder();
            int precision = 1 + r.nextInt(18);
            int scale = 0 + r.nextInt(precision + 1);
            int integerDigits = precision - scale;
            if (r.nextBoolean()) {
                sb.append("-");
            }
            if (integerDigits == 0) {
                sb.append("0");
            } else {
                sb.append(RandomTypeUtil.getRandString((Random)r, (String)DECIMAL_CHARS, (int)integerDigits));
            }
            if (scale != 0) {
                sb.append(".");
                sb.append(RandomTypeUtil.getRandString((Random)r, (String)DECIMAL_CHARS, (int)scale));
            }
            dec = HiveDecimal.create((String)sb.toString());
        } while ((dec = HiveDecimal.enforcePrecisionScale((HiveDecimal)dec, (int)decimalTypeInfo.getPrecision(), (int)decimalTypeInfo.getScale())) == null);
        return dec;
    }

    public static HiveIntervalYearMonth getRandIntervalYearMonth(Random r) {
        String yearMonthSignStr = r.nextInt(2) == 0 ? "" : "-";
        String intervalYearMonthStr = String.format("%s%d-%d", yearMonthSignStr, 1800 + r.nextInt(500), 0 + r.nextInt(12));
        HiveIntervalYearMonth intervalYearMonthVal = HiveIntervalYearMonth.valueOf((String)intervalYearMonthStr);
        return intervalYearMonthVal;
    }

    public static HiveIntervalDayTime getRandIntervalDayTime(Random r) {
        String optionalNanos = "";
        if (r.nextInt(2) == 1) {
            optionalNanos = String.format(".%09d", 0 + r.nextInt(1000000000));
        }
        String yearMonthSignStr = r.nextInt(2) == 0 ? "" : "-";
        String dayTimeStr = String.format("%s%d %02d:%02d:%02d%s", yearMonthSignStr, 1 + r.nextInt(28), 0 + r.nextInt(24), 0 + r.nextInt(60), 0 + r.nextInt(60), optionalNanos);
        HiveIntervalDayTime intervalDayTimeVal = HiveIntervalDayTime.valueOf((String)dayTimeStr);
        return intervalDayTimeVal;
    }

    public static enum SupportedTypes {
        ALL,
        PRIMITIVES,
        ALL_EXCEPT_MAP;

    }

    public static class GenerationSpec {
        private final GenerationKind generationKind;
        private final TypeInfo typeInfo;
        private final TypeInfo sourceTypeInfo;
        private final StringGenerationOption stringGenerationOption;

        private GenerationSpec(GenerationKind generationKind, TypeInfo typeInfo, TypeInfo sourceTypeInfo, StringGenerationOption stringGenerationOption) {
            this.generationKind = generationKind;
            this.typeInfo = typeInfo;
            this.sourceTypeInfo = sourceTypeInfo;
            this.stringGenerationOption = stringGenerationOption;
        }

        public GenerationKind getGenerationKind() {
            return this.generationKind;
        }

        public TypeInfo getTypeInfo() {
            return this.typeInfo;
        }

        public TypeInfo getSourceTypeInfo() {
            return this.sourceTypeInfo;
        }

        public StringGenerationOption getStringGenerationOption() {
            return this.stringGenerationOption;
        }

        public static GenerationSpec createSameType(TypeInfo typeInfo) {
            return new GenerationSpec(GenerationKind.SAME_TYPE, typeInfo, null, null);
        }

        public static GenerationSpec createOmitGeneration(TypeInfo typeInfo) {
            return new GenerationSpec(GenerationKind.OMIT_GENERATION, typeInfo, null, null);
        }

        public static GenerationSpec createStringFamily(TypeInfo typeInfo, StringGenerationOption stringGenerationOption) {
            return new GenerationSpec(GenerationKind.STRING_FAMILY, typeInfo, null, stringGenerationOption);
        }

        public static GenerationSpec createStringFamilyOtherTypeValue(TypeInfo typeInfo, TypeInfo otherTypeTypeInfo) {
            return new GenerationSpec(GenerationKind.STRING_FAMILY_OTHER_TYPE_VALUE, typeInfo, otherTypeTypeInfo, null);
        }

        public static GenerationSpec createTimestampMilliseconds(TypeInfo typeInfo) {
            return new GenerationSpec(GenerationKind.TIMESTAMP_MILLISECONDS, typeInfo, null, null);
        }

        public static enum GenerationKind {
            SAME_TYPE,
            OMIT_GENERATION,
            STRING_FAMILY,
            STRING_FAMILY_OTHER_TYPE_VALUE,
            TIMESTAMP_MILLISECONDS;

        }
    }

    public static class StringGenerationOption {
        private boolean generateSentences;
        private boolean addPadding;

        public StringGenerationOption(boolean generateSentences, boolean addPadding) {
            this.generateSentences = generateSentences;
            this.addPadding = addPadding;
        }

        public boolean getGenerateSentences() {
            return this.generateSentences;
        }

        public boolean getAddPadding() {
            return this.addPadding;
        }
    }
}

