/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lockmgr;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockMode;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObject;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.LockDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.LockTableDesc;
import org.apache.hadoop.hive.ql.plan.UnlockDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.UnlockTableDesc;

abstract class HiveTxnManagerImpl
implements HiveTxnManager {
    protected HiveConf conf;
    private boolean isAutoCommit = true;

    HiveTxnManagerImpl() {
    }

    void setHiveConf(HiveConf c) {
        this.conf = c;
    }

    protected abstract void destruct();

    @Override
    public void closeTxnManager() {
        this.destruct();
    }

    @Override
    public void acquireLocks(QueryPlan plan, Context ctx, String username, Driver.LockedDriverState lDrvState) throws LockException {
        this.acquireLocks(plan, ctx, username);
    }

    protected void finalize() throws Throwable {
        this.destruct();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws LockException {
        this.isAutoCommit = autoCommit;
    }

    @Override
    public boolean getAutoCommit() {
        return this.isAutoCommit;
    }

    @Override
    public int lockTable(Hive db, LockTableDesc lockTbl) throws HiveException {
        HiveLockManager lockMgr = this.getAndCheckLockManager();
        HiveLockMode mode = HiveLockMode.valueOf(lockTbl.getMode());
        String tabName = lockTbl.getTableName();
        Table tbl = db.getTable(tabName);
        if (tbl == null) {
            throw new HiveException("Table " + tabName + " does not exist ");
        }
        Map<String, String> partSpec = lockTbl.getPartSpec();
        HiveLockObject.HiveLockObjectData lockData = new HiveLockObject.HiveLockObjectData(lockTbl.getQueryId(), String.valueOf(System.currentTimeMillis()), "EXPLICIT", lockTbl.getQueryStr(), this.conf);
        if (partSpec == null) {
            HiveLock lck = lockMgr.lock(new HiveLockObject(tbl, lockData), mode, true);
            if (lck == null) {
                return 1;
            }
            return 0;
        }
        Partition par = db.getPartition(tbl, partSpec, false);
        if (par == null) {
            throw new HiveException("Partition " + partSpec + " for table " + tabName + " does not exist");
        }
        HiveLock lck = lockMgr.lock(new HiveLockObject(par, lockData), mode, true);
        if (lck == null) {
            return 1;
        }
        return 0;
    }

    @Override
    public int unlockTable(Hive hiveDB, UnlockTableDesc unlockTbl) throws HiveException {
        String tabName;
        HiveLockObject obj;
        HiveLockManager lockMgr = this.getAndCheckLockManager();
        List<HiveLock> locks = lockMgr.getLocks(obj = HiveLockObject.createFrom(hiveDB, tabName = unlockTbl.getTableName(), unlockTbl.getPartSpec()), false, false);
        if (locks == null || locks.isEmpty()) {
            throw new HiveException("Table " + tabName + " is not locked ");
        }
        for (HiveLock lock2 : locks) {
            lockMgr.unlock(lock2);
        }
        return 0;
    }

    @Override
    public int lockDatabase(Hive hiveDB, LockDatabaseDesc lockDb) throws HiveException {
        HiveLockManager lockMgr = this.getAndCheckLockManager();
        HiveLockMode mode = HiveLockMode.valueOf(lockDb.getMode());
        String dbName = lockDb.getDatabaseName();
        Database dbObj = hiveDB.getDatabase(dbName);
        if (dbObj == null) {
            throw new HiveException("Database " + dbName + " does not exist ");
        }
        HiveLockObject.HiveLockObjectData lockData = new HiveLockObject.HiveLockObjectData(lockDb.getQueryId(), String.valueOf(System.currentTimeMillis()), "EXPLICIT", lockDb.getQueryStr(), this.conf);
        HiveLock lck = lockMgr.lock(new HiveLockObject(dbObj.getName(), lockData), mode, true);
        if (lck == null) {
            return 1;
        }
        return 0;
    }

    @Override
    public int unlockDatabase(Hive hiveDB, UnlockDatabaseDesc unlockDb) throws HiveException {
        HiveLockManager lockMgr = this.getAndCheckLockManager();
        String dbName = unlockDb.getDatabaseName();
        Database dbObj = hiveDB.getDatabase(dbName);
        if (dbObj == null) {
            throw new HiveException("Database " + dbName + " does not exist ");
        }
        HiveLockObject obj = new HiveLockObject(dbObj.getName(), null);
        List<HiveLock> locks = lockMgr.getLocks(obj, false, false);
        if (locks == null || locks.isEmpty()) {
            throw new HiveException("Database " + dbName + " is not locked ");
        }
        for (HiveLock lock2 : locks) {
            lockMgr.unlock(lock2);
        }
        return 0;
    }

    protected HiveLockManager getAndCheckLockManager() throws HiveException {
        HiveLockManager lockMgr = this.getLockManager();
        if (lockMgr == null) {
            throw new HiveException("LockManager cannot be acquired");
        }
        if (!this.supportsExplicitLock()) {
            throw new HiveException(ErrorMsg.LOCK_REQUEST_UNSUPPORTED, this.conf.getVar(HiveConf.ConfVars.HIVE_TXN_MANAGER));
        }
        return lockMgr;
    }
}

