/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnSetInfo;
import org.apache.hadoop.hive.ql.exec.vector.VectorHashKeyWrapper;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class VectorHashKeyWrapperBatch
extends VectorColumnSetInfo {
    private static final int MODEL_REFERENCES_COUNT = 7;
    private VectorExpression[] keyExpressions;
    private VectorHashKeyWrapper[] vectorHashKeyWrappers;
    private int keysFixedSize;

    public VectorHashKeyWrapperBatch(int keyCount) {
        super(keyCount);
    }

    public int getKeysFixedSize() {
        return this.keysFixedSize;
    }

    public VectorHashKeyWrapper[] getVectorHashKeyWrappers() {
        return this.vectorHashKeyWrappers;
    }

    public void evaluateBatch(VectorizedRowBatch batch) throws HiveException {
        ColumnVector columnVector;
        int columnIndex;
        int keyIndex;
        int i;
        for (int i2 = 0; i2 < batch.size; ++i2) {
            this.vectorHashKeyWrappers[i2].clearIsNull();
        }
        for (i = 0; i < this.longIndices.length; ++i) {
            keyIndex = this.longIndices[i];
            columnIndex = this.keyExpressions[keyIndex].getOutputColumn();
            columnVector = (LongColumnVector)batch.cols[columnIndex];
            if (columnVector.noNulls && !columnVector.isRepeating && !batch.selectedInUse) {
                this.assignLongNoNullsNoRepeatingNoSelection(i, batch.size, (LongColumnVector)columnVector);
                continue;
            }
            if (columnVector.noNulls && !columnVector.isRepeating && batch.selectedInUse) {
                this.assignLongNoNullsNoRepeatingSelection(i, batch.size, (LongColumnVector)columnVector, batch.selected);
                continue;
            }
            if (columnVector.noNulls && columnVector.isRepeating) {
                this.assignLongNoNullsRepeating(i, batch.size, (LongColumnVector)columnVector);
                continue;
            }
            if (!(columnVector.noNulls || columnVector.isRepeating || batch.selectedInUse)) {
                this.assignLongNullsNoRepeatingNoSelection(keyIndex, i, batch.size, (LongColumnVector)columnVector);
                continue;
            }
            if (!columnVector.noNulls && columnVector.isRepeating) {
                this.assignLongNullsRepeating(keyIndex, i, batch.size, (LongColumnVector)columnVector);
                continue;
            }
            if (!columnVector.noNulls && !columnVector.isRepeating && batch.selectedInUse) {
                this.assignLongNullsNoRepeatingSelection(keyIndex, i, batch.size, (LongColumnVector)columnVector, batch.selected);
                continue;
            }
            throw new HiveException(String.format("Unimplemented Long null/repeat/selected combination %b/%b/%b", columnVector.noNulls, columnVector.isRepeating, batch.selectedInUse));
        }
        for (i = 0; i < this.doubleIndices.length; ++i) {
            keyIndex = this.doubleIndices[i];
            columnIndex = this.keyExpressions[keyIndex].getOutputColumn();
            columnVector = (DoubleColumnVector)batch.cols[columnIndex];
            if (((DoubleColumnVector)columnVector).noNulls && !((DoubleColumnVector)columnVector).isRepeating && !batch.selectedInUse) {
                this.assignDoubleNoNullsNoRepeatingNoSelection(i, batch.size, (DoubleColumnVector)columnVector);
                continue;
            }
            if (((DoubleColumnVector)columnVector).noNulls && !((DoubleColumnVector)columnVector).isRepeating && batch.selectedInUse) {
                this.assignDoubleNoNullsNoRepeatingSelection(i, batch.size, (DoubleColumnVector)columnVector, batch.selected);
                continue;
            }
            if (((DoubleColumnVector)columnVector).noNulls && ((DoubleColumnVector)columnVector).isRepeating) {
                this.assignDoubleNoNullsRepeating(i, batch.size, (DoubleColumnVector)columnVector);
                continue;
            }
            if (!(((DoubleColumnVector)columnVector).noNulls || ((DoubleColumnVector)columnVector).isRepeating || batch.selectedInUse)) {
                this.assignDoubleNullsNoRepeatingNoSelection(keyIndex, i, batch.size, (DoubleColumnVector)columnVector);
                continue;
            }
            if (!((DoubleColumnVector)columnVector).noNulls && ((DoubleColumnVector)columnVector).isRepeating) {
                this.assignDoubleNullsRepeating(keyIndex, i, batch.size, (DoubleColumnVector)columnVector);
                continue;
            }
            if (!((DoubleColumnVector)columnVector).noNulls && !((DoubleColumnVector)columnVector).isRepeating && batch.selectedInUse) {
                this.assignDoubleNullsNoRepeatingSelection(keyIndex, i, batch.size, (DoubleColumnVector)columnVector, batch.selected);
                continue;
            }
            throw new HiveException(String.format("Unimplemented Double null/repeat/selected combination %b/%b/%b", ((DoubleColumnVector)columnVector).noNulls, ((DoubleColumnVector)columnVector).isRepeating, batch.selectedInUse));
        }
        for (i = 0; i < this.stringIndices.length; ++i) {
            keyIndex = this.stringIndices[i];
            columnIndex = this.keyExpressions[keyIndex].getOutputColumn();
            columnVector = (BytesColumnVector)batch.cols[columnIndex];
            if (((BytesColumnVector)columnVector).noNulls && !((BytesColumnVector)columnVector).isRepeating && !batch.selectedInUse) {
                this.assignStringNoNullsNoRepeatingNoSelection(i, batch.size, (BytesColumnVector)columnVector);
                continue;
            }
            if (((BytesColumnVector)columnVector).noNulls && !((BytesColumnVector)columnVector).isRepeating && batch.selectedInUse) {
                this.assignStringNoNullsNoRepeatingSelection(i, batch.size, (BytesColumnVector)columnVector, batch.selected);
                continue;
            }
            if (((BytesColumnVector)columnVector).noNulls && ((BytesColumnVector)columnVector).isRepeating) {
                this.assignStringNoNullsRepeating(i, batch.size, (BytesColumnVector)columnVector);
                continue;
            }
            if (!(((BytesColumnVector)columnVector).noNulls || ((BytesColumnVector)columnVector).isRepeating || batch.selectedInUse)) {
                this.assignStringNullsNoRepeatingNoSelection(keyIndex, i, batch.size, (BytesColumnVector)columnVector);
                continue;
            }
            if (!((BytesColumnVector)columnVector).noNulls && ((BytesColumnVector)columnVector).isRepeating) {
                this.assignStringNullsRepeating(keyIndex, i, batch.size, (BytesColumnVector)columnVector);
                continue;
            }
            if (!((BytesColumnVector)columnVector).noNulls && !((BytesColumnVector)columnVector).isRepeating && batch.selectedInUse) {
                this.assignStringNullsNoRepeatingSelection(keyIndex, i, batch.size, (BytesColumnVector)columnVector, batch.selected);
                continue;
            }
            throw new HiveException(String.format("Unimplemented String null/repeat/selected combination %b/%b/%b", ((BytesColumnVector)columnVector).noNulls, ((BytesColumnVector)columnVector).isRepeating, batch.selectedInUse));
        }
        for (i = 0; i < this.decimalIndices.length; ++i) {
            keyIndex = this.decimalIndices[i];
            columnIndex = this.keyExpressions[keyIndex].getOutputColumn();
            columnVector = (DecimalColumnVector)batch.cols[columnIndex];
            if (((DecimalColumnVector)columnVector).noNulls && !((DecimalColumnVector)columnVector).isRepeating && !batch.selectedInUse) {
                this.assignDecimalNoNullsNoRepeatingNoSelection(i, batch.size, (DecimalColumnVector)columnVector);
                continue;
            }
            if (((DecimalColumnVector)columnVector).noNulls && !((DecimalColumnVector)columnVector).isRepeating && batch.selectedInUse) {
                this.assignDecimalNoNullsNoRepeatingSelection(i, batch.size, (DecimalColumnVector)columnVector, batch.selected);
                continue;
            }
            if (((DecimalColumnVector)columnVector).noNulls && ((DecimalColumnVector)columnVector).isRepeating) {
                this.assignDecimalNoNullsRepeating(i, batch.size, (DecimalColumnVector)columnVector);
                continue;
            }
            if (!(((DecimalColumnVector)columnVector).noNulls || ((DecimalColumnVector)columnVector).isRepeating || batch.selectedInUse)) {
                this.assignDecimalNullsNoRepeatingNoSelection(keyIndex, i, batch.size, (DecimalColumnVector)columnVector);
                continue;
            }
            if (!((DecimalColumnVector)columnVector).noNulls && ((DecimalColumnVector)columnVector).isRepeating) {
                this.assignDecimalNullsRepeating(keyIndex, i, batch.size, (DecimalColumnVector)columnVector);
                continue;
            }
            if (!((DecimalColumnVector)columnVector).noNulls && !((DecimalColumnVector)columnVector).isRepeating && batch.selectedInUse) {
                this.assignDecimalNullsNoRepeatingSelection(keyIndex, i, batch.size, (DecimalColumnVector)columnVector, batch.selected);
                continue;
            }
            throw new HiveException(String.format("Unimplemented Decimal null/repeat/selected combination %b/%b/%b", ((DecimalColumnVector)columnVector).noNulls, ((DecimalColumnVector)columnVector).isRepeating, batch.selectedInUse));
        }
        for (i = 0; i < this.timestampIndices.length; ++i) {
            keyIndex = this.timestampIndices[i];
            columnIndex = this.keyExpressions[keyIndex].getOutputColumn();
            columnVector = (TimestampColumnVector)batch.cols[columnIndex];
            if (((TimestampColumnVector)columnVector).noNulls && !((TimestampColumnVector)columnVector).isRepeating && !batch.selectedInUse) {
                this.assignTimestampNoNullsNoRepeatingNoSelection(i, batch.size, (TimestampColumnVector)columnVector);
                continue;
            }
            if (((TimestampColumnVector)columnVector).noNulls && !((TimestampColumnVector)columnVector).isRepeating && batch.selectedInUse) {
                this.assignTimestampNoNullsNoRepeatingSelection(i, batch.size, (TimestampColumnVector)columnVector, batch.selected);
                continue;
            }
            if (((TimestampColumnVector)columnVector).noNulls && ((TimestampColumnVector)columnVector).isRepeating) {
                this.assignTimestampNoNullsRepeating(i, batch.size, (TimestampColumnVector)columnVector);
                continue;
            }
            if (!(((TimestampColumnVector)columnVector).noNulls || ((TimestampColumnVector)columnVector).isRepeating || batch.selectedInUse)) {
                this.assignTimestampNullsNoRepeatingNoSelection(keyIndex, i, batch.size, (TimestampColumnVector)columnVector);
                continue;
            }
            if (!((TimestampColumnVector)columnVector).noNulls && ((TimestampColumnVector)columnVector).isRepeating) {
                this.assignTimestampNullsRepeating(keyIndex, i, batch.size, (TimestampColumnVector)columnVector);
                continue;
            }
            if (!((TimestampColumnVector)columnVector).noNulls && !((TimestampColumnVector)columnVector).isRepeating && batch.selectedInUse) {
                this.assignTimestampNullsNoRepeatingSelection(keyIndex, i, batch.size, (TimestampColumnVector)columnVector, batch.selected);
                continue;
            }
            throw new HiveException(String.format("Unimplemented timestamp null/repeat/selected combination %b/%b/%b", ((TimestampColumnVector)columnVector).noNulls, ((TimestampColumnVector)columnVector).isRepeating, batch.selectedInUse));
        }
        for (i = 0; i < this.intervalDayTimeIndices.length; ++i) {
            keyIndex = this.intervalDayTimeIndices[i];
            columnIndex = this.keyExpressions[keyIndex].getOutputColumn();
            columnVector = (IntervalDayTimeColumnVector)batch.cols[columnIndex];
            if (((IntervalDayTimeColumnVector)columnVector).noNulls && !((IntervalDayTimeColumnVector)columnVector).isRepeating && !batch.selectedInUse) {
                this.assignIntervalDayTimeNoNullsNoRepeatingNoSelection(i, batch.size, (IntervalDayTimeColumnVector)columnVector);
                continue;
            }
            if (((IntervalDayTimeColumnVector)columnVector).noNulls && !((IntervalDayTimeColumnVector)columnVector).isRepeating && batch.selectedInUse) {
                this.assignIntervalDayTimeNoNullsNoRepeatingSelection(i, batch.size, (IntervalDayTimeColumnVector)columnVector, batch.selected);
                continue;
            }
            if (((IntervalDayTimeColumnVector)columnVector).noNulls && ((IntervalDayTimeColumnVector)columnVector).isRepeating) {
                this.assignIntervalDayTimeNoNullsRepeating(i, batch.size, (IntervalDayTimeColumnVector)columnVector);
                continue;
            }
            if (!(((IntervalDayTimeColumnVector)columnVector).noNulls || ((IntervalDayTimeColumnVector)columnVector).isRepeating || batch.selectedInUse)) {
                this.assignIntervalDayTimeNullsNoRepeatingNoSelection(keyIndex, i, batch.size, (IntervalDayTimeColumnVector)columnVector);
                continue;
            }
            if (!((IntervalDayTimeColumnVector)columnVector).noNulls && ((IntervalDayTimeColumnVector)columnVector).isRepeating) {
                this.assignIntervalDayTimeNullsRepeating(keyIndex, i, batch.size, (IntervalDayTimeColumnVector)columnVector);
                continue;
            }
            if (!((IntervalDayTimeColumnVector)columnVector).noNulls && !((IntervalDayTimeColumnVector)columnVector).isRepeating && batch.selectedInUse) {
                this.assignIntervalDayTimeNullsNoRepeatingSelection(keyIndex, i, batch.size, (IntervalDayTimeColumnVector)columnVector, batch.selected);
                continue;
            }
            throw new HiveException(String.format("Unimplemented intervalDayTime null/repeat/selected combination %b/%b/%b", ((IntervalDayTimeColumnVector)columnVector).noNulls, ((IntervalDayTimeColumnVector)columnVector).isRepeating, batch.selectedInUse));
        }
        for (i = 0; i < batch.size; ++i) {
            this.vectorHashKeyWrappers[i].setHashKey();
        }
    }

    public void evaluateBatchGroupingSets(VectorizedRowBatch batch, boolean[] groupingSetsOverrideIsNulls) throws HiveException {
        int columnIndex;
        int r;
        int keyIndex;
        int i;
        for (int i2 = 0; i2 < batch.size; ++i2) {
            this.vectorHashKeyWrappers[i2].clearIsNull();
        }
        for (i = 0; i < this.longIndices.length; ++i) {
            keyIndex = this.longIndices[i];
            if (groupingSetsOverrideIsNulls[keyIndex]) {
                int batchSize = batch.size;
                for (r = 0; r < batchSize; ++r) {
                    this.vectorHashKeyWrappers[r].assignNullLong(keyIndex, i);
                }
                continue;
            }
            columnIndex = this.keyExpressions[keyIndex].getOutputColumn();
            LongColumnVector columnVector = (LongColumnVector)batch.cols[columnIndex];
            if (columnVector.noNulls && !columnVector.isRepeating && !batch.selectedInUse) {
                this.assignLongNoNullsNoRepeatingNoSelection(i, batch.size, columnVector);
                continue;
            }
            if (columnVector.noNulls && !columnVector.isRepeating && batch.selectedInUse) {
                this.assignLongNoNullsNoRepeatingSelection(i, batch.size, columnVector, batch.selected);
                continue;
            }
            if (columnVector.noNulls && columnVector.isRepeating) {
                this.assignLongNoNullsRepeating(i, batch.size, columnVector);
                continue;
            }
            if (!(columnVector.noNulls || columnVector.isRepeating || batch.selectedInUse)) {
                this.assignLongNullsNoRepeatingNoSelection(keyIndex, i, batch.size, columnVector);
                continue;
            }
            if (!columnVector.noNulls && columnVector.isRepeating) {
                this.assignLongNullsRepeating(keyIndex, i, batch.size, columnVector);
                continue;
            }
            if (!columnVector.noNulls && !columnVector.isRepeating && batch.selectedInUse) {
                this.assignLongNullsNoRepeatingSelection(keyIndex, i, batch.size, columnVector, batch.selected);
                continue;
            }
            throw new HiveException(String.format("Unimplemented Long null/repeat/selected combination %b/%b/%b", columnVector.noNulls, columnVector.isRepeating, batch.selectedInUse));
        }
        for (i = 0; i < this.doubleIndices.length; ++i) {
            keyIndex = this.doubleIndices[i];
            if (groupingSetsOverrideIsNulls[keyIndex]) {
                int batchSize = batch.size;
                for (r = 0; r < batchSize; ++r) {
                    this.vectorHashKeyWrappers[r].assignNullDouble(keyIndex, i);
                }
                continue;
            }
            columnIndex = this.keyExpressions[keyIndex].getOutputColumn();
            DoubleColumnVector columnVector = (DoubleColumnVector)batch.cols[columnIndex];
            if (columnVector.noNulls && !columnVector.isRepeating && !batch.selectedInUse) {
                this.assignDoubleNoNullsNoRepeatingNoSelection(i, batch.size, columnVector);
                continue;
            }
            if (columnVector.noNulls && !columnVector.isRepeating && batch.selectedInUse) {
                this.assignDoubleNoNullsNoRepeatingSelection(i, batch.size, columnVector, batch.selected);
                continue;
            }
            if (columnVector.noNulls && columnVector.isRepeating) {
                this.assignDoubleNoNullsRepeating(i, batch.size, columnVector);
                continue;
            }
            if (!(columnVector.noNulls || columnVector.isRepeating || batch.selectedInUse)) {
                this.assignDoubleNullsNoRepeatingNoSelection(keyIndex, i, batch.size, columnVector);
                continue;
            }
            if (!columnVector.noNulls && columnVector.isRepeating) {
                this.assignDoubleNullsRepeating(keyIndex, i, batch.size, columnVector);
                continue;
            }
            if (!columnVector.noNulls && !columnVector.isRepeating && batch.selectedInUse) {
                this.assignDoubleNullsNoRepeatingSelection(keyIndex, i, batch.size, columnVector, batch.selected);
                continue;
            }
            throw new HiveException(String.format("Unimplemented Double null/repeat/selected combination %b/%b/%b", columnVector.noNulls, columnVector.isRepeating, batch.selectedInUse));
        }
        for (i = 0; i < this.stringIndices.length; ++i) {
            keyIndex = this.stringIndices[i];
            if (groupingSetsOverrideIsNulls[keyIndex]) {
                int batchSize = batch.size;
                for (r = 0; r < batchSize; ++r) {
                    this.vectorHashKeyWrappers[r].assignNullString(keyIndex, i);
                }
                continue;
            }
            columnIndex = this.keyExpressions[keyIndex].getOutputColumn();
            BytesColumnVector columnVector = (BytesColumnVector)batch.cols[columnIndex];
            if (columnVector.noNulls && !columnVector.isRepeating && !batch.selectedInUse) {
                this.assignStringNoNullsNoRepeatingNoSelection(i, batch.size, columnVector);
                continue;
            }
            if (columnVector.noNulls && !columnVector.isRepeating && batch.selectedInUse) {
                this.assignStringNoNullsNoRepeatingSelection(i, batch.size, columnVector, batch.selected);
                continue;
            }
            if (columnVector.noNulls && columnVector.isRepeating) {
                this.assignStringNoNullsRepeating(i, batch.size, columnVector);
                continue;
            }
            if (!(columnVector.noNulls || columnVector.isRepeating || batch.selectedInUse)) {
                this.assignStringNullsNoRepeatingNoSelection(keyIndex, i, batch.size, columnVector);
                continue;
            }
            if (!columnVector.noNulls && columnVector.isRepeating) {
                this.assignStringNullsRepeating(keyIndex, i, batch.size, columnVector);
                continue;
            }
            if (!columnVector.noNulls && !columnVector.isRepeating && batch.selectedInUse) {
                this.assignStringNullsNoRepeatingSelection(keyIndex, i, batch.size, columnVector, batch.selected);
                continue;
            }
            throw new HiveException(String.format("Unimplemented String null/repeat/selected combination %b/%b/%b", columnVector.noNulls, columnVector.isRepeating, batch.selectedInUse));
        }
        for (i = 0; i < this.decimalIndices.length; ++i) {
            keyIndex = this.decimalIndices[i];
            if (groupingSetsOverrideIsNulls[keyIndex]) {
                int batchSize = batch.size;
                for (r = 0; r < batchSize; ++r) {
                    this.vectorHashKeyWrappers[r].assignNullDecimal(keyIndex, i);
                }
                continue;
            }
            columnIndex = this.keyExpressions[keyIndex].getOutputColumn();
            DecimalColumnVector columnVector = (DecimalColumnVector)batch.cols[columnIndex];
            if (columnVector.noNulls && !columnVector.isRepeating && !batch.selectedInUse) {
                this.assignDecimalNoNullsNoRepeatingNoSelection(i, batch.size, columnVector);
                continue;
            }
            if (columnVector.noNulls && !columnVector.isRepeating && batch.selectedInUse) {
                this.assignDecimalNoNullsNoRepeatingSelection(i, batch.size, columnVector, batch.selected);
                continue;
            }
            if (columnVector.noNulls && columnVector.isRepeating) {
                this.assignDecimalNoNullsRepeating(i, batch.size, columnVector);
                continue;
            }
            if (!(columnVector.noNulls || columnVector.isRepeating || batch.selectedInUse)) {
                this.assignDecimalNullsNoRepeatingNoSelection(keyIndex, i, batch.size, columnVector);
                continue;
            }
            if (!columnVector.noNulls && columnVector.isRepeating) {
                this.assignDecimalNullsRepeating(keyIndex, i, batch.size, columnVector);
                continue;
            }
            if (!columnVector.noNulls && !columnVector.isRepeating && batch.selectedInUse) {
                this.assignDecimalNullsNoRepeatingSelection(keyIndex, i, batch.size, columnVector, batch.selected);
                continue;
            }
            throw new HiveException(String.format("Unimplemented Decimal null/repeat/selected combination %b/%b/%b", columnVector.noNulls, columnVector.isRepeating, batch.selectedInUse));
        }
        for (i = 0; i < this.timestampIndices.length; ++i) {
            keyIndex = this.timestampIndices[i];
            if (groupingSetsOverrideIsNulls[keyIndex]) {
                int batchSize = batch.size;
                for (r = 0; r < batchSize; ++r) {
                    this.vectorHashKeyWrappers[r].assignNullTimestamp(keyIndex, i);
                }
                continue;
            }
            columnIndex = this.keyExpressions[keyIndex].getOutputColumn();
            TimestampColumnVector columnVector = (TimestampColumnVector)batch.cols[columnIndex];
            if (columnVector.noNulls && !columnVector.isRepeating && !batch.selectedInUse) {
                this.assignTimestampNoNullsNoRepeatingNoSelection(i, batch.size, columnVector);
                continue;
            }
            if (columnVector.noNulls && !columnVector.isRepeating && batch.selectedInUse) {
                this.assignTimestampNoNullsNoRepeatingSelection(i, batch.size, columnVector, batch.selected);
                continue;
            }
            if (columnVector.noNulls && columnVector.isRepeating) {
                this.assignTimestampNoNullsRepeating(i, batch.size, columnVector);
                continue;
            }
            if (!(columnVector.noNulls || columnVector.isRepeating || batch.selectedInUse)) {
                this.assignTimestampNullsNoRepeatingNoSelection(keyIndex, i, batch.size, columnVector);
                continue;
            }
            if (!columnVector.noNulls && columnVector.isRepeating) {
                this.assignTimestampNullsRepeating(keyIndex, i, batch.size, columnVector);
                continue;
            }
            if (!columnVector.noNulls && !columnVector.isRepeating && batch.selectedInUse) {
                this.assignTimestampNullsNoRepeatingSelection(keyIndex, i, batch.size, columnVector, batch.selected);
                continue;
            }
            throw new HiveException(String.format("Unimplemented timestamp null/repeat/selected combination %b/%b/%b", columnVector.noNulls, columnVector.isRepeating, batch.selectedInUse));
        }
        for (i = 0; i < this.intervalDayTimeIndices.length; ++i) {
            keyIndex = this.intervalDayTimeIndices[i];
            if (groupingSetsOverrideIsNulls[keyIndex]) {
                int batchSize = batch.size;
                for (r = 0; r < batchSize; ++r) {
                    this.vectorHashKeyWrappers[r].assignNullIntervalDayTime(keyIndex, i);
                }
                continue;
            }
            columnIndex = this.keyExpressions[keyIndex].getOutputColumn();
            IntervalDayTimeColumnVector columnVector = (IntervalDayTimeColumnVector)batch.cols[columnIndex];
            if (columnVector.noNulls && !columnVector.isRepeating && !batch.selectedInUse) {
                this.assignIntervalDayTimeNoNullsNoRepeatingNoSelection(i, batch.size, columnVector);
                continue;
            }
            if (columnVector.noNulls && !columnVector.isRepeating && batch.selectedInUse) {
                this.assignIntervalDayTimeNoNullsNoRepeatingSelection(i, batch.size, columnVector, batch.selected);
                continue;
            }
            if (columnVector.noNulls && columnVector.isRepeating) {
                this.assignIntervalDayTimeNoNullsRepeating(i, batch.size, columnVector);
                continue;
            }
            if (!(columnVector.noNulls || columnVector.isRepeating || batch.selectedInUse)) {
                this.assignIntervalDayTimeNullsNoRepeatingNoSelection(keyIndex, i, batch.size, columnVector);
                continue;
            }
            if (!columnVector.noNulls && columnVector.isRepeating) {
                this.assignIntervalDayTimeNullsRepeating(keyIndex, i, batch.size, columnVector);
                continue;
            }
            if (!columnVector.noNulls && !columnVector.isRepeating && batch.selectedInUse) {
                this.assignIntervalDayTimeNullsNoRepeatingSelection(keyIndex, i, batch.size, columnVector, batch.selected);
                continue;
            }
            throw new HiveException(String.format("Unimplemented intervalDayTime null/repeat/selected combination %b/%b/%b", columnVector.noNulls, columnVector.isRepeating, batch.selectedInUse));
        }
        for (i = 0; i < batch.size; ++i) {
            this.vectorHashKeyWrappers[i].setHashKey();
        }
    }

    private void assignStringNullsNoRepeatingSelection(int keyIndex, int index, int size, BytesColumnVector columnVector, int[] selected) {
        for (int i = 0; i < size; ++i) {
            int row = selected[i];
            if (columnVector.isNull[row]) {
                this.vectorHashKeyWrappers[i].assignNullString(keyIndex, index);
                continue;
            }
            this.vectorHashKeyWrappers[i].assignString(index, columnVector.vector[row], columnVector.start[row], columnVector.length[row]);
        }
    }

    private void assignStringNullsRepeating(int keyIndex, int index, int size, BytesColumnVector columnVector) {
        if (columnVector.isNull[0]) {
            for (int i = 0; i < size; ++i) {
                this.vectorHashKeyWrappers[i].assignNullString(keyIndex, index);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                this.vectorHashKeyWrappers[i].assignString(index, columnVector.vector[0], columnVector.start[0], columnVector.length[0]);
            }
        }
    }

    private void assignStringNullsNoRepeatingNoSelection(int keyIndex, int index, int size, BytesColumnVector columnVector) {
        for (int i = 0; i < size; ++i) {
            if (columnVector.isNull[i]) {
                this.vectorHashKeyWrappers[i].assignNullString(keyIndex, index);
                continue;
            }
            this.vectorHashKeyWrappers[i].assignString(index, columnVector.vector[i], columnVector.start[i], columnVector.length[i]);
        }
    }

    private void assignStringNoNullsRepeating(int index, int size, BytesColumnVector columnVector) {
        for (int i = 0; i < size; ++i) {
            this.vectorHashKeyWrappers[i].assignString(index, columnVector.vector[0], columnVector.start[0], columnVector.length[0]);
        }
    }

    private void assignStringNoNullsNoRepeatingSelection(int index, int size, BytesColumnVector columnVector, int[] selected) {
        for (int i = 0; i < size; ++i) {
            int row = selected[i];
            this.vectorHashKeyWrappers[i].assignString(index, columnVector.vector[row], columnVector.start[row], columnVector.length[row]);
        }
    }

    private void assignStringNoNullsNoRepeatingNoSelection(int index, int size, BytesColumnVector columnVector) {
        for (int i = 0; i < size; ++i) {
            this.vectorHashKeyWrappers[i].assignString(index, columnVector.vector[i], columnVector.start[i], columnVector.length[i]);
        }
    }

    private void assignDoubleNullsNoRepeatingSelection(int keyIndex, int index, int size, DoubleColumnVector columnVector, int[] selected) {
        for (int i = 0; i < size; ++i) {
            int row = selected[i];
            if (!columnVector.isNull[row]) {
                this.vectorHashKeyWrappers[i].assignDouble(index, columnVector.vector[row]);
                continue;
            }
            this.vectorHashKeyWrappers[i].assignNullDouble(keyIndex, index);
        }
    }

    private void assignDoubleNullsRepeating(int keyIndex, int index, int size, DoubleColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignNullDouble(keyIndex, index);
        }
    }

    private void assignDoubleNullsNoRepeatingNoSelection(int keyIndex, int index, int size, DoubleColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            if (!columnVector.isNull[r]) {
                this.vectorHashKeyWrappers[r].assignDouble(index, columnVector.vector[r]);
                continue;
            }
            this.vectorHashKeyWrappers[r].assignNullDouble(keyIndex, index);
        }
    }

    private void assignDoubleNoNullsRepeating(int index, int size, DoubleColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignDouble(index, columnVector.vector[0]);
        }
    }

    private void assignDoubleNoNullsNoRepeatingSelection(int index, int size, DoubleColumnVector columnVector, int[] selected) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignDouble(index, columnVector.vector[selected[r]]);
        }
    }

    private void assignDoubleNoNullsNoRepeatingNoSelection(int index, int size, DoubleColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignDouble(index, columnVector.vector[r]);
        }
    }

    private void assignLongNullsNoRepeatingSelection(int keyIndex, int index, int size, LongColumnVector columnVector, int[] selected) {
        for (int i = 0; i < size; ++i) {
            int row = selected[i];
            if (!columnVector.isNull[row]) {
                this.vectorHashKeyWrappers[i].assignLong(index, columnVector.vector[row]);
                continue;
            }
            this.vectorHashKeyWrappers[i].assignNullLong(keyIndex, index);
        }
    }

    private void assignLongNullsRepeating(int keyIndex, int index, int size, LongColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignNullLong(keyIndex, index);
        }
    }

    private void assignLongNullsNoRepeatingNoSelection(int keyIndex, int index, int size, LongColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            if (!columnVector.isNull[r]) {
                this.vectorHashKeyWrappers[r].assignLong(index, columnVector.vector[r]);
                continue;
            }
            this.vectorHashKeyWrappers[r].assignNullLong(keyIndex, index);
        }
    }

    private void assignLongNoNullsRepeating(int index, int size, LongColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignLong(index, columnVector.vector[0]);
        }
    }

    private void assignLongNoNullsNoRepeatingSelection(int index, int size, LongColumnVector columnVector, int[] selected) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignLong(index, columnVector.vector[selected[r]]);
        }
    }

    private void assignLongNoNullsNoRepeatingNoSelection(int index, int size, LongColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignLong(index, columnVector.vector[r]);
        }
    }

    private void assignDecimalNullsNoRepeatingSelection(int keyIndex, int index, int size, DecimalColumnVector columnVector, int[] selected) {
        for (int i = 0; i < size; ++i) {
            int row = selected[i];
            if (!columnVector.isNull[row]) {
                this.vectorHashKeyWrappers[i].assignDecimal(index, columnVector.vector[row]);
                continue;
            }
            this.vectorHashKeyWrappers[i].assignNullDecimal(keyIndex, index);
        }
    }

    private void assignDecimalNullsRepeating(int keyIndex, int index, int size, DecimalColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignNullDecimal(keyIndex, index);
        }
    }

    private void assignDecimalNullsNoRepeatingNoSelection(int keyIndex, int index, int size, DecimalColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            if (!columnVector.isNull[r]) {
                this.vectorHashKeyWrappers[r].assignDecimal(index, columnVector.vector[r]);
                continue;
            }
            this.vectorHashKeyWrappers[r].assignNullDecimal(keyIndex, index);
        }
    }

    private void assignDecimalNoNullsRepeating(int index, int size, DecimalColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignDecimal(index, columnVector.vector[0]);
        }
    }

    private void assignDecimalNoNullsNoRepeatingSelection(int index, int size, DecimalColumnVector columnVector, int[] selected) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignDecimal(index, columnVector.vector[selected[r]]);
        }
    }

    private void assignDecimalNoNullsNoRepeatingNoSelection(int index, int size, DecimalColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignDecimal(index, columnVector.vector[r]);
        }
    }

    private void assignTimestampNullsNoRepeatingSelection(int keyIndex, int index, int size, TimestampColumnVector columnVector, int[] selected) {
        for (int i = 0; i < size; ++i) {
            int row = selected[i];
            if (!columnVector.isNull[row]) {
                this.vectorHashKeyWrappers[i].assignTimestamp(index, columnVector, row);
                continue;
            }
            this.vectorHashKeyWrappers[i].assignNullTimestamp(keyIndex, index);
        }
    }

    private void assignTimestampNullsRepeating(int keyIndex, int index, int size, TimestampColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignNullTimestamp(keyIndex, index);
        }
    }

    private void assignTimestampNullsNoRepeatingNoSelection(int keyIndex, int index, int size, TimestampColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            if (!columnVector.isNull[r]) {
                this.vectorHashKeyWrappers[r].assignTimestamp(index, columnVector, r);
                continue;
            }
            this.vectorHashKeyWrappers[r].assignNullTimestamp(keyIndex, index);
        }
    }

    private void assignTimestampNoNullsRepeating(int index, int size, TimestampColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignTimestamp(index, columnVector, 0);
        }
    }

    private void assignTimestampNoNullsNoRepeatingSelection(int index, int size, TimestampColumnVector columnVector, int[] selected) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignTimestamp(index, columnVector, selected[r]);
        }
    }

    private void assignTimestampNoNullsNoRepeatingNoSelection(int index, int size, TimestampColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignTimestamp(index, columnVector, r);
        }
    }

    private void assignIntervalDayTimeNullsNoRepeatingSelection(int keyIndex, int index, int size, IntervalDayTimeColumnVector columnVector, int[] selected) {
        for (int i = 0; i < size; ++i) {
            int row = selected[i];
            if (!columnVector.isNull[row]) {
                this.vectorHashKeyWrappers[i].assignIntervalDayTime(index, columnVector, row);
                continue;
            }
            this.vectorHashKeyWrappers[i].assignNullIntervalDayTime(keyIndex, index);
        }
    }

    private void assignIntervalDayTimeNullsRepeating(int keyIndex, int index, int size, IntervalDayTimeColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignNullIntervalDayTime(keyIndex, index);
        }
    }

    private void assignIntervalDayTimeNullsNoRepeatingNoSelection(int keyIndex, int index, int size, IntervalDayTimeColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            if (!columnVector.isNull[r]) {
                this.vectorHashKeyWrappers[r].assignIntervalDayTime(index, columnVector, r);
                continue;
            }
            this.vectorHashKeyWrappers[r].assignNullIntervalDayTime(keyIndex, index);
        }
    }

    private void assignIntervalDayTimeNoNullsRepeating(int index, int size, IntervalDayTimeColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignIntervalDayTime(index, columnVector, 0);
        }
    }

    private void assignIntervalDayTimeNoNullsNoRepeatingSelection(int index, int size, IntervalDayTimeColumnVector columnVector, int[] selected) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignIntervalDayTime(index, columnVector, selected[r]);
        }
    }

    private void assignIntervalDayTimeNoNullsNoRepeatingNoSelection(int index, int size, IntervalDayTimeColumnVector columnVector) {
        for (int r = 0; r < size; ++r) {
            this.vectorHashKeyWrappers[r].assignIntervalDayTime(index, columnVector, r);
        }
    }

    public static VectorHashKeyWrapperBatch compileKeyWrapperBatch(VectorExpression[] keyExpressions) throws HiveException {
        int size = keyExpressions.length;
        ColumnVector.Type[] columnVectorTypes = new ColumnVector.Type[size];
        for (int i = 0; i < size; ++i) {
            String typeName = VectorizationContext.mapTypeNameSynonyms(keyExpressions[i].getOutputType());
            TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString(typeName);
            columnVectorTypes[i] = VectorizationContext.getColumnVectorTypeFromTypeInfo(typeInfo);
        }
        return VectorHashKeyWrapperBatch.compileKeyWrapperBatch(keyExpressions, columnVectorTypes);
    }

    public static VectorHashKeyWrapperBatch compileKeyWrapperBatch(VectorExpression[] keyExpressions, ColumnVector.Type[] columnVectorTypes) throws HiveException {
        int i;
        VectorHashKeyWrapperBatch compiledKeyWrapperBatch = new VectorHashKeyWrapperBatch(keyExpressions.length);
        compiledKeyWrapperBatch.keyExpressions = keyExpressions;
        compiledKeyWrapperBatch.keysFixedSize = 0;
        for (i = 0; i < columnVectorTypes.length; ++i) {
            compiledKeyWrapperBatch.addKey(columnVectorTypes[i]);
        }
        compiledKeyWrapperBatch.finishAdding();
        compiledKeyWrapperBatch.vectorHashKeyWrappers = new VectorHashKeyWrapper[1024];
        for (i = 0; i < 1024; ++i) {
            compiledKeyWrapperBatch.vectorHashKeyWrappers[i] = compiledKeyWrapperBatch.allocateKeyWrapper();
        }
        JavaDataModel model = JavaDataModel.get();
        compiledKeyWrapperBatch.keysFixedSize += JavaDataModel.alignUp(model.object() + model.ref() * 7 + model.primitive1(), model.memoryAlign());
        compiledKeyWrapperBatch.keysFixedSize += model.lengthForLongArrayOfSize(compiledKeyWrapperBatch.longIndices.length);
        compiledKeyWrapperBatch.keysFixedSize += model.lengthForDoubleArrayOfSize(compiledKeyWrapperBatch.doubleIndices.length);
        compiledKeyWrapperBatch.keysFixedSize += model.lengthForObjectArrayOfSize(compiledKeyWrapperBatch.stringIndices.length);
        compiledKeyWrapperBatch.keysFixedSize += model.lengthForObjectArrayOfSize(compiledKeyWrapperBatch.decimalIndices.length);
        compiledKeyWrapperBatch.keysFixedSize += model.lengthForObjectArrayOfSize(compiledKeyWrapperBatch.timestampIndices.length);
        compiledKeyWrapperBatch.keysFixedSize += model.lengthForObjectArrayOfSize(compiledKeyWrapperBatch.intervalDayTimeIndices.length);
        compiledKeyWrapperBatch.keysFixedSize += model.lengthForIntArrayOfSize(compiledKeyWrapperBatch.longIndices.length) * 2;
        compiledKeyWrapperBatch.keysFixedSize += model.lengthForBooleanArrayOfSize(keyExpressions.length);
        return compiledKeyWrapperBatch;
    }

    public VectorHashKeyWrapper allocateKeyWrapper() {
        return VectorHashKeyWrapper.allocate(this.longIndices.length, this.doubleIndices.length, this.stringIndices.length, this.decimalIndices.length, this.timestampIndices.length, this.intervalDayTimeIndices.length, this.keyCount);
    }

    public Object getWritableKeyValue(VectorHashKeyWrapper kw, int keyIndex, VectorExpressionWriter keyOutputWriter) throws HiveException {
        if (kw.isNull(keyIndex)) {
            return null;
        }
        ColumnVector.Type columnVectorType = this.columnVectorTypes[keyIndex];
        int columnTypeSpecificIndex = this.columnTypeSpecificIndices[keyIndex];
        switch (columnVectorType) {
            case LONG: {
                return keyOutputWriter.writeValue(kw.getLongValue(columnTypeSpecificIndex));
            }
            case DOUBLE: {
                return keyOutputWriter.writeValue(kw.getDoubleValue(columnTypeSpecificIndex));
            }
            case BYTES: {
                return keyOutputWriter.writeValue(kw.getBytes(columnTypeSpecificIndex), kw.getByteStart(columnTypeSpecificIndex), kw.getByteLength(columnTypeSpecificIndex));
            }
            case DECIMAL: {
                return keyOutputWriter.writeValue(kw.getDecimal(columnTypeSpecificIndex));
            }
            case TIMESTAMP: {
                return keyOutputWriter.writeValue(kw.getTimestamp(columnTypeSpecificIndex));
            }
            case INTERVAL_DAY_TIME: {
                return keyOutputWriter.writeValue(kw.getIntervalDayTime(columnTypeSpecificIndex));
            }
        }
        throw new HiveException("Unexpected column vector type " + (Object)((Object)columnVectorType));
    }

    public int getVariableSize(int batchSize) {
        int variableSize = 0;
        if (0 < this.stringIndices.length) {
            for (int k = 0; k < batchSize; ++k) {
                VectorHashKeyWrapper hkw = this.vectorHashKeyWrappers[k];
                variableSize += hkw.getVariableSize();
            }
        }
        return variableSize;
    }
}

