/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.hbase.stats.merge.ColumnStatsMerger;
import org.apache.hadoop.hive.metastore.hbase.stats.merge.ColumnStatsMergerFactory;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.hadoop.hive.serde.serdeConstants;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.common.util.HiveStringUtils;
import org.apache.hive.common.util.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaStoreUtils {
    protected static final Logger LOG = LoggerFactory.getLogger((String)"hive.log");
    public static final String DEFAULT_DATABASE_NAME = "default";
    public static final String DEFAULT_DATABASE_COMMENT = "Default Hive database";
    public static final String DEFAULT_SERIALIZATION_FORMAT = "1";
    public static final String DATABASE_WAREHOUSE_SUFFIX = ".db";
    public static final char[] specialCharactersInTableNames = new char[]{'/'};
    public static final String TYPE_FROM_DESERIALIZER = "<derived from deserializer>";
    static HashMap<String, String> typeToThriftTypeMap = new HashMap();
    static Set<String> hiveThriftTypeMap;
    private static final String FROM_SERIALIZER = "from deserializer";
    private static final PathFilter hiddenFileFilter;
    public static String ARCHIVING_LEVEL;
    private static final Function<String, String> transFormNullsToEmptyString;

    public static Table createColumnsetSchema(String name, List<String> columns, List<String> partCols, Configuration conf) throws MetaException {
        if (columns == null) {
            throw new MetaException("columns not specified for table " + name);
        }
        Table tTable = new Table();
        tTable.setTableName(name);
        tTable.setSd(new StorageDescriptor());
        StorageDescriptor sd = tTable.getSd();
        sd.setSerdeInfo(new SerDeInfo());
        SerDeInfo serdeInfo = sd.getSerdeInfo();
        serdeInfo.setSerializationLib(LazySimpleSerDe.class.getName());
        serdeInfo.setParameters(new HashMap<String, String>());
        serdeInfo.getParameters().put("serialization.format", DEFAULT_SERIALIZATION_FORMAT);
        ArrayList<FieldSchema> fields = new ArrayList<FieldSchema>();
        sd.setCols(fields);
        for (String col : columns) {
            FieldSchema field = new FieldSchema(col, "string", "'default'");
            fields.add(field);
        }
        tTable.setPartitionKeys(new ArrayList<FieldSchema>());
        for (String partCol : partCols) {
            FieldSchema part = new FieldSchema();
            part.setName(partCol);
            part.setType("string");
            tTable.getPartitionKeys().add(part);
        }
        sd.setNumBuckets(-1);
        return tTable;
    }

    public static void recursiveDelete(File f) throws IOException {
        if (f.isDirectory()) {
            File[] fs;
            for (File subf : fs = f.listFiles()) {
                MetaStoreUtils.recursiveDelete(subf);
            }
        }
        if (!f.delete()) {
            throw new IOException("could not delete: " + f.getPath());
        }
    }

    public static boolean containsAllFastStats(Map<String, String> partParams) {
        for (String stat : StatsSetupConst.fastStats) {
            if (partParams.containsKey(stat)) continue;
            return false;
        }
        return true;
    }

    public static boolean updateTableStatsFast(Database db, Table tbl, Warehouse wh, boolean madeDir, EnvironmentContext environmentContext) throws MetaException {
        return MetaStoreUtils.updateTableStatsFast(db, tbl, wh, madeDir, false, environmentContext);
    }

    public static boolean updateTableStatsFast(Database db, Table tbl, Warehouse wh, boolean madeDir, boolean forceRecompute, EnvironmentContext environmentContext) throws MetaException {
        if (tbl.getPartitionKeysSize() == 0) {
            FileStatus[] fileStatuses = wh.getFileStatusesForUnpartitionedTable(db, tbl);
            return MetaStoreUtils.updateTableStatsFast(tbl, fileStatuses, madeDir, forceRecompute, environmentContext);
        }
        return false;
    }

    public static boolean updateTableStatsFast(Table tbl, FileStatus[] fileStatus, boolean newDir, boolean forceRecompute, EnvironmentContext environmentContext) throws MetaException {
        Map<String, String> params = tbl.getParameters();
        if (params != null && params.containsKey("DO_NOT_UPDATE_STATS")) {
            boolean doNotUpdateStats = Boolean.valueOf(params.get("DO_NOT_UPDATE_STATS"));
            params.remove("DO_NOT_UPDATE_STATS");
            tbl.setParameters(params);
            if (doNotUpdateStats) {
                return false;
            }
        }
        boolean updated = false;
        if (forceRecompute || params == null || !MetaStoreUtils.containsAllFastStats(params)) {
            if (params == null) {
                params = new HashMap<String, String>();
            }
            if (!newDir) {
                LOG.info("Updating table stats fast for " + tbl.getTableName());
                MetaStoreUtils.populateQuickStats(fileStatus, params);
                LOG.info("Updated size of table " + tbl.getTableName() + " to " + params.get("totalSize"));
                if (environmentContext != null && environmentContext.isSetProperties() && "TASK".equals(environmentContext.getProperties().get("STATS_GENERATED"))) {
                    StatsSetupConst.setBasicStatsState(params, "true");
                } else {
                    StatsSetupConst.setBasicStatsState(params, "false");
                }
            }
            tbl.setParameters(params);
            updated = true;
        }
        return updated;
    }

    public static void populateQuickStats(FileStatus[] fileStatus, Map<String, String> params) {
        int numFiles = 0;
        long tableSize = 0L;
        for (FileStatus status : fileStatus) {
            if (status.isDir()) continue;
            tableSize += status.getLen();
            ++numFiles;
        }
        params.put("numFiles", Integer.toString(numFiles));
        params.put("totalSize", Long.toString(tableSize));
    }

    public static boolean requireCalStats(Configuration hiveConf, Partition oldPart, Partition newPart, Table tbl, EnvironmentContext environmentContext) {
        String statsType;
        if (environmentContext != null && environmentContext.isSetProperties() && "true".equals(environmentContext.getProperties().get("DO_NOT_UPDATE_STATS"))) {
            return false;
        }
        if (MetaStoreUtils.isView(tbl)) {
            return false;
        }
        if (oldPart == null && newPart == null) {
            return true;
        }
        if (newPart == null || newPart.getParameters() == null || !MetaStoreUtils.containsAllFastStats(newPart.getParameters())) {
            return true;
        }
        if (environmentContext != null && environmentContext.isSetProperties() && ("TASK".equals(statsType = environmentContext.getProperties().get("STATS_GENERATED")) || "USER".equals(statsType))) {
            return true;
        }
        return !MetaStoreUtils.isFastStatsSame(oldPart, newPart);
    }

    static boolean isFastStatsSame(Partition oldPart, Partition newPart) {
        if (oldPart != null && oldPart.getParameters() != null) {
            for (String stat : StatsSetupConst.fastStats) {
                if (oldPart.getParameters().containsKey(stat)) {
                    Long oldStat = Long.parseLong(oldPart.getParameters().get(stat));
                    String newStat = newPart.getParameters().get(stat);
                    if (newStat != null && oldStat.equals(Long.parseLong(newStat))) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static String getUser() throws IOException {
        try {
            UserGroupInformation ugi = Utils.getUGI();
            return ugi.getUserName();
        }
        catch (LoginException le) {
            throw new IOException(le);
        }
    }

    public static boolean updatePartitionStatsFast(Partition part, Warehouse wh, EnvironmentContext environmentContext) throws MetaException {
        return MetaStoreUtils.updatePartitionStatsFast(part, wh, false, false, environmentContext);
    }

    public static boolean updatePartitionStatsFast(Partition part, Warehouse wh, boolean madeDir, EnvironmentContext environmentContext) throws MetaException {
        return MetaStoreUtils.updatePartitionStatsFast(part, wh, madeDir, false, environmentContext);
    }

    public static boolean updatePartitionStatsFast(Partition part, Warehouse wh, boolean madeDir, boolean forceRecompute, EnvironmentContext environmentContext) throws MetaException {
        return MetaStoreUtils.updatePartitionStatsFast(new PartitionSpecProxy.SimplePartitionWrapperIterator(part), wh, madeDir, forceRecompute, environmentContext);
    }

    public static boolean updatePartitionStatsFast(PartitionSpecProxy.PartitionIterator part, Warehouse wh, boolean madeDir, boolean forceRecompute, EnvironmentContext environmentContext) throws MetaException {
        Map<String, String> params = part.getParameters();
        boolean updated = false;
        if (forceRecompute || params == null || !MetaStoreUtils.containsAllFastStats(params)) {
            if (params == null) {
                params = new HashMap<String, String>();
            }
            if (!madeDir) {
                LOG.warn("Updating partition stats fast for: " + part.getTableName());
                FileStatus[] fileStatus = wh.getFileStatusesForLocation(part.getLocation());
                MetaStoreUtils.populateQuickStats(fileStatus, params);
                LOG.warn("Updated size to " + params.get("totalSize"));
                MetaStoreUtils.updateBasicState(environmentContext, params);
            }
            part.setParameters(params);
            updated = true;
        }
        return updated;
    }

    static void updateBasicState(EnvironmentContext environmentContext, Map<String, String> params) {
        if (params == null) {
            return;
        }
        if (environmentContext != null && environmentContext.isSetProperties() && "TASK".equals(environmentContext.getProperties().get("STATS_GENERATED"))) {
            StatsSetupConst.setBasicStatsState(params, "true");
        } else {
            StatsSetupConst.setBasicStatsState(params, "false");
        }
    }

    public static Deserializer getDeserializer(Configuration conf, Table table, boolean skipConfError) throws MetaException {
        String lib = table.getSd().getSerdeInfo().getSerializationLib();
        if (lib == null) {
            return null;
        }
        return MetaStoreUtils.getDeserializer(conf, table, skipConfError, lib);
    }

    public static Deserializer getDeserializer(Configuration conf, Table table, boolean skipConfError, String lib) throws MetaException {
        try {
            Deserializer deserializer = ReflectionUtil.newInstance(conf.getClassByName(lib).asSubclass(Deserializer.class), conf);
            if (skipConfError) {
                SerDeUtils.initializeSerDeWithoutErrorCheck(deserializer, conf, MetaStoreUtils.getTableMetadata(table), null);
            } else {
                SerDeUtils.initializeSerDe(deserializer, conf, MetaStoreUtils.getTableMetadata(table), null);
            }
            return deserializer;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("error in initSerDe: " + e.getClass().getName() + " " + e.getMessage(), (Throwable)e);
            throw new MetaException(e.getClass().getName() + " " + e.getMessage());
        }
    }

    public static Class<? extends Deserializer> getDeserializerClass(Configuration conf, Table table) throws Exception {
        String lib = table.getSd().getSerdeInfo().getSerializationLib();
        return lib == null ? null : conf.getClassByName(lib).asSubclass(Deserializer.class);
    }

    public static Deserializer getDeserializer(Configuration conf, Partition part, Table table) throws MetaException {
        String lib = part.getSd().getSerdeInfo().getSerializationLib();
        try {
            Deserializer deserializer = ReflectionUtil.newInstance(conf.getClassByName(lib).asSubclass(Deserializer.class), conf);
            SerDeUtils.initializeSerDe(deserializer, conf, MetaStoreUtils.getTableMetadata(table), MetaStoreUtils.getPartitionMetadata(part, table));
            return deserializer;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("error in initSerDe: " + e.getClass().getName() + " " + e.getMessage(), (Throwable)e);
            throw new MetaException(e.getClass().getName() + " " + e.getMessage());
        }
    }

    public static void deleteWHDirectory(Path path, Configuration conf, boolean use_trash) throws MetaException {
        try {
            if (!path.getFileSystem(conf).exists(path)) {
                LOG.warn("drop data called on table/partition with no directory: " + path);
                return;
            }
            if (use_trash) {
                int count = 0;
                Path newPath = new Path("/Trash/Current" + path.getParent().toUri().getPath());
                if (!path.getFileSystem(conf).exists(newPath)) {
                    path.getFileSystem(conf).mkdirs(newPath);
                }
                do {
                    newPath = new Path("/Trash/Current" + path.toUri().getPath() + "." + count);
                    if (path.getFileSystem(conf).exists(newPath)) {
                        ++count;
                        continue;
                    }
                    if (path.getFileSystem(conf).rename(path, newPath)) break;
                } while (++count < 50);
                if (count >= 50) {
                    throw new MetaException("Rename failed due to maxing out retries");
                }
            } else {
                path.getFileSystem(conf).delete(path, true);
            }
        }
        catch (IOException e) {
            LOG.error("Got exception trying to delete data dir: " + e);
            throw new MetaException(e.getMessage());
        }
        catch (MetaException e) {
            LOG.error("Got exception trying to delete data dir: " + e);
            throw e;
        }
    }

    public static List<String> getPvals(List<FieldSchema> partCols, Map<String, String> partSpec) {
        ArrayList<String> pvals = new ArrayList<String>();
        for (FieldSchema field : partCols) {
            String val = partSpec.get(field.getName());
            if (val == null) {
                val = "";
            }
            pvals.add(val);
        }
        return pvals;
    }

    public static boolean validateName(String name, Configuration conf) {
        Matcher m;
        Pattern tpat = null;
        String allowedCharacters = "\\w_";
        if (conf != null && HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_SUPPORT_SPECICAL_CHARACTERS_IN_TABLE_NAMES)) {
            char[] cArray = specialCharactersInTableNames;
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character c = Character.valueOf(cArray[i]);
                allowedCharacters = allowedCharacters + c;
            }
        }
        return (m = (tpat = Pattern.compile("[" + allowedCharacters + "]+")).matcher(name)).matches();
    }

    public static final boolean validateColumnName(String name) {
        return true;
    }

    public static String validateTblColumns(List<FieldSchema> cols) {
        for (FieldSchema fieldSchema : cols) {
            if (!MetaStoreUtils.validateColumnName(fieldSchema.getName())) {
                return "name: " + fieldSchema.getName();
            }
            String typeError = MetaStoreUtils.validateColumnType(fieldSchema.getType());
            if (typeError == null) continue;
            return typeError;
        }
        return null;
    }

    static void throwExceptionIfIncompatibleColTypeChange(List<FieldSchema> oldCols, List<FieldSchema> newCols) throws InvalidOperationException {
        ArrayList<String> incompatibleCols = new ArrayList<String>();
        int maxCols = Math.min(oldCols.size(), newCols.size());
        for (int i = 0; i < maxCols; ++i) {
            if (MetaStoreUtils.areColTypesCompatible(oldCols.get(i).getType(), newCols.get(i).getType())) continue;
            incompatibleCols.add(newCols.get(i).getName());
        }
        if (!incompatibleCols.isEmpty()) {
            throw new InvalidOperationException("The following columns have types incompatible with the existing columns in their respective positions :\n" + StringUtils.join(incompatibleCols, ','));
        }
    }

    static boolean isCascadeNeededInAlterTable(Table oldTable, Table newTable) {
        List<FieldSchema> newCols;
        List<FieldSchema> oldCols = oldTable.getSd().getCols();
        return !MetaStoreUtils.areSameColumns(oldCols, newCols = newTable.getSd().getCols());
    }

    static boolean areSameColumns(List<FieldSchema> oldCols, List<FieldSchema> newCols) {
        if (oldCols.size() != newCols.size()) {
            return false;
        }
        for (int i = 0; i < oldCols.size(); ++i) {
            FieldSchema newCol;
            FieldSchema oldCol = oldCols.get(i);
            if (oldCol.equals(newCol = newCols.get(i))) continue;
            return false;
        }
        return true;
    }

    static boolean columnsIncluded(List<FieldSchema> oldCols, List<FieldSchema> newCols) {
        if (oldCols.size() > newCols.size()) {
            return false;
        }
        HashSet<FieldSchema> newColsSet = new HashSet<FieldSchema>(newCols);
        for (FieldSchema oldCol : oldCols) {
            if (newColsSet.contains(oldCol)) continue;
            return false;
        }
        return true;
    }

    private static boolean areColTypesCompatible(String oldType, String newType) {
        return TypeInfoUtils.implicitConvertible(TypeInfoUtils.getTypeInfoFromTypeString(oldType), TypeInfoUtils.getTypeInfoFromTypeString(newType));
    }

    public static String validateColumnType(String type) {
        if (type.equals(TYPE_FROM_DESERIALIZER)) {
            return null;
        }
        int last = 0;
        boolean lastAlphaDigit = MetaStoreUtils.isValidTypeChar(type.charAt(last));
        for (int i = 1; i <= type.length(); ++i) {
            if (i != type.length() && MetaStoreUtils.isValidTypeChar(type.charAt(i)) == lastAlphaDigit) continue;
            String token = type.substring(last, i);
            last = i;
            if (hiveThriftTypeMap.contains(token)) break;
            return "type: " + type;
        }
        return null;
    }

    private static boolean isValidTypeChar(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    public static String validateSkewedColNames(List<String> cols) {
        if (null == cols) {
            return null;
        }
        for (String col : cols) {
            if (MetaStoreUtils.validateColumnName(col)) continue;
            return col;
        }
        return null;
    }

    public static String validateSkewedColNamesSubsetCol(List<String> skewedColNames, List<FieldSchema> cols) {
        if (null == skewedColNames) {
            return null;
        }
        ArrayList<String> colNames = new ArrayList<String>();
        for (FieldSchema fieldSchema : cols) {
            colNames.add(fieldSchema.getName());
        }
        ArrayList<String> copySkewedColNames = new ArrayList<String>(skewedColNames);
        copySkewedColNames.removeAll(colNames);
        if (copySkewedColNames.isEmpty()) {
            return null;
        }
        return ((Object)copySkewedColNames).toString();
    }

    public static String getListType(String t) {
        return "array<" + t + ">";
    }

    public static String getMapType(String k, String v) {
        return "map<" + k + "," + v + ">";
    }

    public static void setSerdeParam(SerDeInfo sdi, Properties schema, String param) {
        String val = schema.getProperty(param);
        if (StringUtils.isNotBlank(val)) {
            sdi.getParameters().put(param, val);
        }
    }

    public static String typeToThriftType(String type) {
        StringBuilder thriftType = new StringBuilder();
        int last = 0;
        boolean lastAlphaDigit = Character.isLetterOrDigit(type.charAt(last));
        for (int i = 1; i <= type.length(); ++i) {
            if (i != type.length() && Character.isLetterOrDigit(type.charAt(i)) == lastAlphaDigit) continue;
            String token = type.substring(last, i);
            last = i;
            String thriftToken = typeToThriftTypeMap.get(token);
            thriftType.append(thriftToken == null ? token : thriftToken);
            lastAlphaDigit = !lastAlphaDigit;
        }
        return thriftType.toString();
    }

    public static String getFullDDLFromFieldSchema(String structName, List<FieldSchema> fieldSchemas) {
        StringBuilder ddl = new StringBuilder();
        ddl.append(MetaStoreUtils.getDDLFromFieldSchema(structName, fieldSchemas));
        ddl.append('#');
        StringBuilder colnames = new StringBuilder();
        StringBuilder coltypes = new StringBuilder();
        boolean first = true;
        for (FieldSchema col : fieldSchemas) {
            if (first) {
                first = false;
            } else {
                colnames.append(',');
                coltypes.append(':');
            }
            colnames.append(col.getName());
            coltypes.append(col.getType());
        }
        ddl.append((CharSequence)colnames);
        ddl.append('#');
        ddl.append((CharSequence)coltypes);
        return ddl.toString();
    }

    public static String getDDLFromFieldSchema(String structName, List<FieldSchema> fieldSchemas) {
        StringBuilder ddl = new StringBuilder();
        ddl.append("struct ");
        ddl.append(structName);
        ddl.append(" { ");
        boolean first = true;
        for (FieldSchema col : fieldSchemas) {
            if (first) {
                first = false;
            } else {
                ddl.append(", ");
            }
            ddl.append(MetaStoreUtils.typeToThriftType(col.getType()));
            ddl.append(' ');
            ddl.append(col.getName());
        }
        ddl.append("}");
        LOG.debug("DDL: " + ddl);
        return ddl.toString();
    }

    public static Properties getTableMetadata(Table table) {
        return MetaStoreUtils.getSchema(table.getSd(), table.getSd(), table.getParameters(), table.getDbName(), table.getTableName(), table.getPartitionKeys());
    }

    public static Properties getPartitionMetadata(Partition partition, Table table) {
        return MetaStoreUtils.getSchema(partition.getSd(), partition.getSd(), partition.getParameters(), table.getDbName(), table.getTableName(), table.getPartitionKeys());
    }

    public static Properties getSchema(Partition part, Table table) {
        return MetaStoreUtils.getSchema(part.getSd(), table.getSd(), table.getParameters(), table.getDbName(), table.getTableName(), table.getPartitionKeys());
    }

    public static Properties getPartSchemaFromTableSchema(StorageDescriptor sd, StorageDescriptor tblsd, Map<String, String> parameters, String databaseName, String tableName, List<FieldSchema> partitionKeys, Properties tblSchema) {
        Properties schema = (Properties)tblSchema.clone();
        String inputFormat = sd.getInputFormat();
        if (inputFormat == null || inputFormat.length() == 0) {
            String tblInput = schema.getProperty("file.inputformat");
            inputFormat = tblInput == null ? SequenceFileInputFormat.class.getName() : tblInput;
        }
        schema.setProperty("file.inputformat", inputFormat);
        String outputFormat = sd.getOutputFormat();
        if (outputFormat == null || outputFormat.length() == 0) {
            String tblOutput = schema.getProperty("file.outputformat");
            outputFormat = tblOutput == null ? SequenceFileOutputFormat.class.getName() : tblOutput;
        }
        schema.setProperty("file.outputformat", outputFormat);
        if (sd.getLocation() != null) {
            schema.setProperty("location", sd.getLocation());
        }
        schema.setProperty("bucket_count", Integer.toString(sd.getNumBuckets()));
        if (sd.getBucketCols() != null && sd.getBucketCols().size() > 0) {
            schema.setProperty("bucket_field_name", sd.getBucketCols().get(0));
        }
        if (sd.getSerdeInfo() != null) {
            String cols = "columns";
            String colTypes = "columns.types";
            String parts = "partition_columns";
            for (Map.Entry<String, String> param : sd.getSerdeInfo().getParameters().entrySet()) {
                String key = param.getKey();
                if (schema.get(key) != null && (key.equals(cols) || key.equals(colTypes) || key.equals(parts))) continue;
                schema.put(key, param.getValue() != null ? param.getValue() : "");
            }
            if (sd.getSerdeInfo().getSerializationLib() != null) {
                schema.setProperty("serialization.lib", sd.getSerdeInfo().getSerializationLib());
            }
        }
        if (parameters != null) {
            for (Map.Entry<String, String> e : parameters.entrySet()) {
                schema.setProperty(e.getKey(), e.getValue());
            }
        }
        return schema;
    }

    public static Properties addCols(Properties schema, List<FieldSchema> cols) {
        StringBuilder colNameBuf = new StringBuilder();
        StringBuilder colTypeBuf = new StringBuilder();
        StringBuilder colComment = new StringBuilder();
        boolean first = true;
        String columnNameDelimiter = MetaStoreUtils.getColumnNameDelimiter(cols);
        for (FieldSchema col : cols) {
            if (!first) {
                colNameBuf.append(columnNameDelimiter);
                colTypeBuf.append(":");
                colComment.append('\u0000');
            }
            colNameBuf.append(col.getName());
            colTypeBuf.append(col.getType());
            colComment.append(null != col.getComment() ? col.getComment() : "");
            first = false;
        }
        schema.setProperty("columns", colNameBuf.toString());
        schema.setProperty("column.name.delimiter", columnNameDelimiter);
        String colTypes = colTypeBuf.toString();
        schema.setProperty("columns.types", colTypes);
        schema.setProperty("columns.comments", colComment.toString());
        return schema;
    }

    public static Properties getSchemaWithoutCols(StorageDescriptor sd, StorageDescriptor tblsd, Map<String, String> parameters, String databaseName, String tableName, List<FieldSchema> partitionKeys) {
        Properties schema = new Properties();
        String inputFormat = sd.getInputFormat();
        if (inputFormat == null || inputFormat.length() == 0) {
            inputFormat = SequenceFileInputFormat.class.getName();
        }
        schema.setProperty("file.inputformat", inputFormat);
        String outputFormat = sd.getOutputFormat();
        if (outputFormat == null || outputFormat.length() == 0) {
            outputFormat = SequenceFileOutputFormat.class.getName();
        }
        schema.setProperty("file.outputformat", outputFormat);
        schema.setProperty("name", databaseName + "." + tableName);
        if (sd.getLocation() != null) {
            schema.setProperty("location", sd.getLocation());
        }
        schema.setProperty("bucket_count", Integer.toString(sd.getNumBuckets()));
        if (sd.getBucketCols() != null && sd.getBucketCols().size() > 0) {
            schema.setProperty("bucket_field_name", sd.getBucketCols().get(0));
        }
        if (sd.getSerdeInfo() != null) {
            for (Map.Entry<String, String> param : sd.getSerdeInfo().getParameters().entrySet()) {
                schema.put(param.getKey(), param.getValue() != null ? param.getValue() : "");
            }
            if (sd.getSerdeInfo().getSerializationLib() != null) {
                schema.setProperty("serialization.lib", sd.getSerdeInfo().getSerializationLib());
            }
        }
        if (sd.getCols() != null) {
            schema.setProperty("serialization.ddl", MetaStoreUtils.getDDLFromFieldSchema(tableName, sd.getCols()));
        }
        String partString = "";
        String partStringSep = "";
        String partTypesString = "";
        String partTypesStringSep = "";
        for (FieldSchema fieldSchema : partitionKeys) {
            partString = partString.concat(partStringSep);
            partString = partString.concat(fieldSchema.getName());
            partTypesString = partTypesString.concat(partTypesStringSep);
            partTypesString = partTypesString.concat(fieldSchema.getType());
            if (partStringSep.length() != 0) continue;
            partStringSep = "/";
            partTypesStringSep = ":";
        }
        if (partString.length() > 0) {
            schema.setProperty("partition_columns", partString);
            schema.setProperty("partition_columns.types", partTypesString);
        }
        if (parameters != null) {
            for (Map.Entry entry : parameters.entrySet()) {
                if (entry.getValue() == null) continue;
                schema.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return schema;
    }

    public static Properties getSchema(StorageDescriptor sd, StorageDescriptor tblsd, Map<String, String> parameters, String databaseName, String tableName, List<FieldSchema> partitionKeys) {
        return MetaStoreUtils.addCols(MetaStoreUtils.getSchemaWithoutCols(sd, tblsd, parameters, databaseName, tableName, partitionKeys), tblsd.getCols());
    }

    public static String getColumnNameDelimiter(List<FieldSchema> fieldSchemas) {
        for (int i = 0; i < fieldSchemas.size(); ++i) {
            if (!fieldSchemas.get(i).getName().contains(",")) continue;
            return String.valueOf('\u0000');
        }
        return String.valueOf(',');
    }

    public static String getColumnNamesFromFieldSchema(List<FieldSchema> fieldSchemas) {
        String delimiter = MetaStoreUtils.getColumnNameDelimiter(fieldSchemas);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fieldSchemas.size(); ++i) {
            if (i > 0) {
                sb.append(delimiter);
            }
            sb.append(fieldSchemas.get(i).getName());
        }
        return sb.toString();
    }

    public static String getColumnTypesFromFieldSchema(List<FieldSchema> fieldSchemas) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fieldSchemas.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(fieldSchemas.get(i).getType());
        }
        return sb.toString();
    }

    public static String getColumnCommentsFromFieldSchema(List<FieldSchema> fieldSchemas) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fieldSchemas.size(); ++i) {
            if (i > 0) {
                sb.append('\u0000');
            }
            sb.append(fieldSchemas.get(i).getComment());
        }
        return sb.toString();
    }

    public static void makeDir(Path path, HiveConf hiveConf) throws MetaException {
        try {
            FileSystem fs = path.getFileSystem((Configuration)hiveConf);
            if (!fs.exists(path)) {
                fs.mkdirs(path);
            }
        }
        catch (IOException e) {
            throw new MetaException("Unable to : " + path);
        }
    }

    public static int startMetaStore() throws Exception {
        return MetaStoreUtils.startMetaStore(ShimLoader.getHadoopThriftAuthBridge(), null);
    }

    public static int startMetaStore(HadoopThriftAuthBridge bridge, HiveConf conf) throws Exception {
        int port = MetaStoreUtils.findFreePort();
        MetaStoreUtils.startMetaStore(port, bridge, conf);
        return port;
    }

    public static int startMetaStore(HiveConf conf) throws Exception {
        return MetaStoreUtils.startMetaStore(ShimLoader.getHadoopThriftAuthBridge(), conf);
    }

    public static void startMetaStore(int port, HadoopThriftAuthBridge bridge) throws Exception {
        MetaStoreUtils.startMetaStore(port, bridge, null);
    }

    public static void startMetaStore(final int port, final HadoopThriftAuthBridge bridge, HiveConf hiveConf) throws Exception {
        if (hiveConf == null) {
            hiveConf = new HiveConf(HiveMetaStore.HMSHandler.class);
        }
        final HiveConf finalHiveConf = hiveConf;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    HiveMetaStore.startMetaStore(port, bridge, finalHiveConf);
                }
                catch (Throwable e) {
                    LOG.error("Metastore Thrift Server threw an exception...", e);
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
        MetaStoreUtils.loopUntilHMSReady(port);
    }

    private static void loopUntilHMSReady(int port) throws Exception {
        int retries = 0;
        Exception exc = null;
        while (true) {
            try {
                Socket socket = new Socket();
                socket.connect(new InetSocketAddress(port), 5000);
                socket.close();
                return;
            }
            catch (Exception e) {
                if (retries++ <= 60) {
                    Thread.sleep(1000L);
                    continue;
                }
                exc = e;
                LOG.error("Unable to connect to metastore server: " + exc.getMessage());
                LOG.info("Printing all thread stack traces for debugging before throwing exception.");
                LOG.info(MetaStoreUtils.getAllThreadStacksAsString());
                throw exc;
            }
            break;
        }
    }

    private static String getAllThreadStacksAsString() {
        Map<Thread, StackTraceElement[]> threadStacks = Thread.getAllStackTraces();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Thread, StackTraceElement[]> entry : threadStacks.entrySet()) {
            Thread t = entry.getKey();
            sb.append(System.lineSeparator());
            sb.append("Name: ").append(t.getName()).append(" State: " + (Object)((Object)t.getState()));
            MetaStoreUtils.addStackString(entry.getValue(), sb);
        }
        return sb.toString();
    }

    private static void addStackString(StackTraceElement[] stackElems, StringBuilder sb) {
        sb.append(System.lineSeparator());
        for (StackTraceElement stackElem : stackElems) {
            sb.append(stackElem).append(System.lineSeparator());
        }
    }

    public static int findFreePort() throws IOException {
        ServerSocket socket = new ServerSocket(0);
        int port = socket.getLocalPort();
        socket.close();
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findFreePortExcepting(int portToExclude) throws IOException {
        ServerSocket socket1 = null;
        ServerSocket socket2 = null;
        try {
            socket1 = new ServerSocket(0);
            socket2 = new ServerSocket(0);
            if (socket1.getLocalPort() != portToExclude) {
                int n = socket1.getLocalPort();
                return n;
            }
            int n = socket2.getLocalPort();
            return n;
        }
        finally {
            if (socket1 != null) {
                socket1.close();
            }
            if (socket2 != null) {
                socket2.close();
            }
        }
    }

    static void logAndThrowMetaException(Exception e) throws MetaException {
        String exInfo = "Got exception: " + e.getClass().getName() + " " + e.getMessage();
        LOG.error(exInfo, (Throwable)e);
        LOG.error("Converting exception to MetaException");
        throw new MetaException(exInfo);
    }

    public static List<FieldSchema> getFieldsFromDeserializer(String tableName, Deserializer deserializer) throws SerDeException, MetaException {
        ObjectInspector oi = deserializer.getObjectInspector();
        String[] names = tableName.split("\\.");
        String last_name = names[names.length - 1];
        for (int i = 1; i < names.length; ++i) {
            MapObjectInspector moi;
            if (oi instanceof StructObjectInspector) {
                StructObjectInspector soi = (StructObjectInspector)oi;
                StructField sf = soi.getStructFieldRef(names[i]);
                if (sf == null) {
                    throw new MetaException("Invalid Field " + names[i]);
                }
                oi = sf.getFieldObjectInspector();
                continue;
            }
            if (oi instanceof ListObjectInspector && names[i].equalsIgnoreCase("$elem$")) {
                ListObjectInspector loi = (ListObjectInspector)oi;
                oi = loi.getListElementObjectInspector();
                continue;
            }
            if (oi instanceof MapObjectInspector && names[i].equalsIgnoreCase("$key$")) {
                moi = (MapObjectInspector)oi;
                oi = moi.getMapKeyObjectInspector();
                continue;
            }
            if (oi instanceof MapObjectInspector && names[i].equalsIgnoreCase("$value$")) {
                moi = (MapObjectInspector)oi;
                oi = moi.getMapValueObjectInspector();
                continue;
            }
            throw new MetaException("Unknown type for " + names[i]);
        }
        ArrayList<FieldSchema> str_fields = new ArrayList<FieldSchema>();
        if (oi.getCategory() != ObjectInspector.Category.STRUCT) {
            str_fields.add(new FieldSchema(last_name, oi.getTypeName(), FROM_SERIALIZER));
        } else {
            List<? extends StructField> fields = ((StructObjectInspector)oi).getAllStructFieldRefs();
            for (int i = 0; i < fields.size(); ++i) {
                StructField structField = fields.get(i);
                String fieldName = structField.getFieldName();
                String fieldTypeName = structField.getFieldObjectInspector().getTypeName();
                String fieldComment = MetaStoreUtils.determineFieldComment(structField.getFieldComment());
                str_fields.add(new FieldSchema(fieldName, fieldTypeName, fieldComment));
            }
        }
        return str_fields;
    }

    private static String determineFieldComment(String comment) {
        return comment == null ? FROM_SERIALIZER : comment;
    }

    public static FieldSchema getFieldSchemaFromTypeInfo(String fieldName, TypeInfo typeInfo) {
        return new FieldSchema(fieldName, typeInfo.getTypeName(), "generated by TypeInfoUtils.getFieldSchemaFromTypeInfo");
    }

    public static boolean isExternalTable(Table table) {
        if (table == null) {
            return false;
        }
        Map<String, String> params = table.getParameters();
        if (params == null) {
            return false;
        }
        return "TRUE".equalsIgnoreCase(params.get("EXTERNAL"));
    }

    public static boolean isImmutableTable(Table table) {
        if (table == null) {
            return false;
        }
        Map<String, String> params = table.getParameters();
        if (params == null) {
            return false;
        }
        return "TRUE".equalsIgnoreCase(params.get("immutable"));
    }

    public static boolean isArchived(Partition part) {
        Map<String, String> params = part.getParameters();
        return "true".equalsIgnoreCase(params.get("is_archived"));
    }

    public static Path getOriginalLocation(Partition part) {
        Map<String, String> params = part.getParameters();
        assert (MetaStoreUtils.isArchived(part));
        String originalLocation = params.get("original_location");
        assert (originalLocation != null);
        return new Path(originalLocation);
    }

    public static boolean isNonNativeTable(Table table) {
        if (table == null || table.getParameters() == null) {
            return false;
        }
        return table.getParameters().get("storage_handler") != null;
    }

    public static boolean isDirEmpty(FileSystem fs, Path path) throws IOException {
        FileStatus[] status;
        return !fs.exists(path) || (status = fs.globStatus(new Path(path, "*"), hiddenFileFilter)).length <= 0;
    }

    public static boolean pvalMatches(List<String> partial, List<String> full) {
        if (partial.size() > full.size()) {
            return false;
        }
        Iterator<String> p = partial.iterator();
        Iterator<String> f = full.iterator();
        while (p.hasNext()) {
            String pval = p.next();
            String fval = f.next();
            if (pval.length() == 0 || pval.equals(fval)) continue;
            return false;
        }
        return true;
    }

    public static String getIndexTableName(String dbName, String baseTblName, String indexName) {
        return dbName + "__" + baseTblName + "_" + indexName + "__";
    }

    public static boolean isIndexTable(Table table) {
        if (table == null) {
            return false;
        }
        return TableType.INDEX_TABLE.toString().equals(table.getTableType());
    }

    public static boolean isMaterializedViewTable(Table table) {
        if (table == null) {
            return false;
        }
        return TableType.MATERIALIZED_VIEW.toString().equals(table.getTableType());
    }

    public static String makeFilterStringFromMap(Map<String, String> m) {
        StringBuilder filter = new StringBuilder();
        for (Map.Entry<String, String> e : m.entrySet()) {
            String col = e.getKey();
            String val = e.getValue();
            if (filter.length() == 0) {
                filter.append(col + "=\"" + val + "\"");
                continue;
            }
            filter.append(" and " + col + "=\"" + val + "\"");
        }
        return filter.toString();
    }

    public static boolean isView(Table table) {
        if (table == null) {
            return false;
        }
        return TableType.VIRTUAL_VIEW.toString().equals(table.getTableType());
    }

    static <T> List<T> getMetaStoreListeners(Class<T> clazz, HiveConf conf, String listenerImplList) throws MetaException {
        String[] listenerImpls;
        ArrayList listeners = new ArrayList();
        if ((listenerImplList = listenerImplList.trim()).equals("")) {
            return listeners;
        }
        for (String listenerImpl : listenerImpls = listenerImplList.split(",")) {
            try {
                Object listener = Class.forName(listenerImpl.trim(), true, JavaUtils.getClassLoader()).getConstructor(Configuration.class).newInstance(new Object[]{conf});
                listeners.add(listener);
            }
            catch (InvocationTargetException ie) {
                throw new MetaException("Failed to instantiate listener named: " + listenerImpl + ", reason: " + ie.getCause());
            }
            catch (Exception e) {
                throw new MetaException("Failed to instantiate listener named: " + listenerImpl + ", reason: " + e);
            }
        }
        return listeners;
    }

    public static Class<? extends RawStore> getClass(String rawStoreClassName) throws MetaException {
        try {
            return Class.forName(rawStoreClassName, true, JavaUtils.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new MetaException(rawStoreClassName + " class not found");
        }
    }

    public static <T> T newInstance(Class<T> theClass, Class<?>[] parameterTypes, Object[] initargs) {
        if (parameterTypes.length != initargs.length) {
            throw new IllegalArgumentException("Number of constructor parameter types doesn't match number of arguments");
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> clazz = parameterTypes[i];
            if (initargs[i] == null || clazz.isInstance(initargs[i])) continue;
            throw new IllegalArgumentException("Object : " + initargs[i] + " is not an instance of " + clazz);
        }
        try {
            Constructor<T> meth = theClass.getDeclaredConstructor(parameterTypes);
            meth.setAccessible(true);
            return meth.newInstance(initargs);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate " + theClass.getName(), e);
        }
    }

    public static void validatePartitionNameCharacters(List<String> partVals, Pattern partitionValidationPattern) throws MetaException {
        String invalidPartitionVal = HiveStringUtils.getPartitionValWithInvalidCharacter(partVals, partitionValidationPattern);
        if (invalidPartitionVal != null) {
            throw new MetaException("Partition value '" + invalidPartitionVal + "' contains a character not matched by whitelist pattern '" + partitionValidationPattern.toString() + "'.  (configure with " + HiveConf.ConfVars.METASTORE_PARTITION_NAME_WHITELIST_PATTERN.varname + ")");
        }
    }

    public static boolean partitionNameHasValidCharacters(List<String> partVals, Pattern partitionValidationPattern) {
        return HiveStringUtils.getPartitionValWithInvalidCharacter(partVals, partitionValidationPattern) == null;
    }

    public static boolean compareFieldColumns(List<FieldSchema> schema1, List<FieldSchema> schema2) {
        if (schema1.size() != schema2.size()) {
            return false;
        }
        for (int i = 0; i < schema1.size(); ++i) {
            FieldSchema f1 = schema1.get(i);
            FieldSchema f2 = schema2.get(i);
            if (f1.getName() == null ? f2.getName() != null : !f1.getName().equals(f2.getName())) {
                return false;
            }
            if (!(f1.getType() == null ? f2.getType() != null : !f1.getType().equals(f2.getType()))) continue;
            return false;
        }
        return true;
    }

    public static Map<String, String> getMetaStoreSaslProperties(HiveConf conf) {
        return ShimLoader.getHadoopThriftAuthBridge().getHadoopSaslProperties(conf);
    }

    public static int getArchivingLevel(Partition part) throws MetaException {
        if (!MetaStoreUtils.isArchived(part)) {
            throw new MetaException("Getting level of unarchived partition");
        }
        String lv = part.getParameters().get(ARCHIVING_LEVEL);
        if (lv != null) {
            return Integer.parseInt(lv);
        }
        return part.getValues().size();
    }

    public static String[] getQualifiedName(String defaultDbName, String tableName) {
        String[] names = tableName.split("\\.");
        if (names.length == 1) {
            return new String[]{defaultDbName, tableName};
        }
        return new String[]{names[0], names[1]};
    }

    public static Map<String, String> trimMapNulls(Map<String, String> dnMap, boolean retrieveMapNullsAsEmptyStrings) {
        if (dnMap == null) {
            return null;
        }
        if (retrieveMapNullsAsEmptyStrings) {
            return Maps.newLinkedHashMap(Maps.transformValues(dnMap, transFormNullsToEmptyString));
        }
        return Maps.newLinkedHashMap(Maps.filterValues(dnMap, Predicates.notNull()));
    }

    private static URL urlFromPathString(String onestr) {
        URL oneurl = null;
        try {
            oneurl = StringUtils.indexOf(onestr, "file:/") == 0 ? new URL(onestr) : new File(onestr).toURL();
        }
        catch (Exception err) {
            LOG.error("Bad URL " + onestr + ", ignoring path");
        }
        return oneurl;
    }

    private static List<URL> getCurrentClassPaths(ClassLoader parentLoader) {
        if (parentLoader instanceof URLClassLoader) {
            return Lists.newArrayList(((URLClassLoader)parentLoader).getURLs());
        }
        return Collections.emptyList();
    }

    public static ClassLoader addToClassPath(ClassLoader cloader, String[] newPaths) throws Exception {
        List<URL> curPath = MetaStoreUtils.getCurrentClassPaths(cloader);
        ArrayList<URL> newPath = new ArrayList<URL>();
        for (URL onePath : curPath) {
            newPath.add(onePath);
        }
        curPath = newPath;
        for (String onestr : newPaths) {
            URL oneurl = MetaStoreUtils.urlFromPathString(onestr);
            if (oneurl == null || curPath.contains(oneurl)) continue;
            curPath.add(oneurl);
        }
        return new URLClassLoader(curPath.toArray(new URL[0]), cloader);
    }

    public static String encodeTableName(String name) {
        String ret = "";
        for (char ch : name.toCharArray()) {
            ret = Character.isLetterOrDigit(ch) || ch == '_' ? ret + ch : ret + "-" + ch + "-";
        }
        return ret;
    }

    public static void mergeColStats(ColumnStatistics csNew, ColumnStatistics csOld) throws InvalidObjectException {
        ArrayList<ColumnStatisticsObj> list = new ArrayList<ColumnStatisticsObj>();
        if (csNew.getStatsObj().size() != csOld.getStatsObjSize()) {
            LOG.debug("New ColumnStats size is " + csNew.getStatsObj().size() + ". But old ColumnStats size is " + csOld.getStatsObjSize());
        }
        HashMap<String, ColumnStatisticsObj> map = new HashMap<String, ColumnStatisticsObj>();
        for (ColumnStatisticsObj obj : csOld.getStatsObj()) {
            map.put(obj.getColName(), obj);
        }
        for (int index = 0; index < csNew.getStatsObj().size(); ++index) {
            ColumnStatisticsObj statsObjNew = csNew.getStatsObj().get(index);
            ColumnStatisticsObj statsObjOld = (ColumnStatisticsObj)map.get(statsObjNew.getColName());
            if (statsObjOld != null) {
                ColumnStatsMerger merger = ColumnStatsMergerFactory.getColumnStatsMerger(statsObjNew, statsObjOld);
                merger.merge(statsObjNew, statsObjOld);
            }
            list.add(statsObjNew);
        }
        csNew.setStatsObj(list);
    }

    static {
        typeToThriftTypeMap.put("boolean", "bool");
        typeToThriftTypeMap.put("tinyint", "byte");
        typeToThriftTypeMap.put("smallint", "i16");
        typeToThriftTypeMap.put("int", "i32");
        typeToThriftTypeMap.put("bigint", "i64");
        typeToThriftTypeMap.put("double", "double");
        typeToThriftTypeMap.put("float", "float");
        typeToThriftTypeMap.put("array", "list");
        typeToThriftTypeMap.put("map", "map");
        typeToThriftTypeMap.put("string", "string");
        typeToThriftTypeMap.put("binary", "binary");
        typeToThriftTypeMap.put("date", "date");
        typeToThriftTypeMap.put("datetime", "datetime");
        typeToThriftTypeMap.put("timestamp", "timestamp");
        typeToThriftTypeMap.put("decimal", "decimal");
        typeToThriftTypeMap.put("interval_year_month", "interval_year_month");
        typeToThriftTypeMap.put("interval_day_time", "interval_day_time");
        hiveThriftTypeMap = new HashSet<String>();
        hiveThriftTypeMap.addAll(serdeConstants.PrimitiveTypes);
        hiveThriftTypeMap.addAll(serdeConstants.CollectionTypes);
        hiveThriftTypeMap.add("uniontype");
        hiveThriftTypeMap.add("struct");
        hiddenFileFilter = new PathFilter(){

            public boolean accept(Path p) {
                String name = p.getName();
                return !name.startsWith("_") && !name.startsWith(".");
            }
        };
        ARCHIVING_LEVEL = "archiving_level";
        transFormNullsToEmptyString = new Function<String, String>(){

            @Override
            public String apply(@Nullable String string) {
                if (string == null) {
                    return "";
                }
                return string;
            }
        };
    }
}

