/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.util.Set;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestBlockedUdf {
    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
        FunctionRegistry.setupPermissionsForBuiltinUDFs((String)"", (String)"");
    }

    @Test
    public void testDefaultWhiteList() throws Exception {
        Assert.assertEquals((Object)"", (Object)new HiveConf().getVar(HiveConf.ConfVars.HIVE_SERVER2_BUILTIN_UDF_WHITELIST));
        Assert.assertEquals((Object)"", (Object)new HiveConf().getVar(HiveConf.ConfVars.HIVE_SERVER2_BUILTIN_UDF_BLACKLIST));
        FunctionRegistry.setupPermissionsForBuiltinUDFs((String)"", (String)"");
        Assert.assertEquals((Object)"substr", (Object)FunctionRegistry.getFunctionInfo((String)"substr").getDisplayName());
    }

    @Test
    public void testUdfInWhiteList() throws Exception {
        Set funcNames = FunctionRegistry.getFunctionNames();
        funcNames.remove("reflect");
        FunctionRegistry.setupPermissionsForBuiltinUDFs((String)funcNames.toString(), (String)"");
        Assert.assertEquals((Object)"substr", (Object)FunctionRegistry.getFunctionInfo((String)"substr").getDisplayName());
    }

    @Test(expected=SemanticException.class)
    public void testUdfNotInWhiteList() throws Exception {
        Set funcNames = FunctionRegistry.getFunctionNames();
        funcNames.remove("reflect");
        FunctionRegistry.setupPermissionsForBuiltinUDFs((String)funcNames.toString(), (String)"");
        Assert.assertEquals((Object)"reflect", (Object)FunctionRegistry.getFunctionInfo((String)"reflect").getDisplayName());
    }

    @Test(expected=SemanticException.class)
    public void testUdfInBlackList() throws Exception {
        FunctionRegistry.setupPermissionsForBuiltinUDFs((String)"", (String)"reflect");
        Assert.assertEquals((Object)"reflect", (Object)FunctionRegistry.getFunctionInfo((String)"reflect").getDisplayName());
    }

    @Test(expected=SemanticException.class)
    public void testUdfInBlackAndWhiteList() throws Exception {
        FunctionRegistry.setupPermissionsForBuiltinUDFs((String)"reflect", (String)"reflect");
        Assert.assertEquals((Object)"reflect", (Object)FunctionRegistry.getFunctionInfo((String)"reflect").getDisplayName());
    }

    @Test(expected=SemanticException.class)
    public void testMalformattedListProperty() throws Exception {
        FunctionRegistry.setupPermissionsForBuiltinUDFs((String)",,", (String)" ,reflect,");
        Assert.assertEquals((Object)"reflect", (Object)FunctionRegistry.getFunctionInfo((String)"reflect").getDisplayName());
    }
}

