/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.LinkedList;
import java.util.List;
import junit.framework.Assert;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.TezEdgeProperty;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.mapred.JobConf;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestTezWork {
    private static final String MR_JAR_PROPERTY = "tmpjars";
    private List<BaseWork> nodes;
    private TezWork work;

    @Before
    public void setup() throws Exception {
        this.nodes = new LinkedList<BaseWork>();
        this.work = new TezWork("", null);
        this.addWork(5);
    }

    private void addWork(int n) {
        for (int i = 0; i < n; ++i) {
            MapWork w = new MapWork();
            this.nodes.add((BaseWork)w);
            this.work.add((BaseWork)w);
        }
    }

    @Test
    public void testAdd() throws Exception {
        Assert.assertEquals((int)this.work.getAllWork().size(), (int)this.nodes.size());
        Assert.assertEquals((int)this.work.getRoots().size(), (int)this.nodes.size());
        Assert.assertEquals((int)this.work.getLeaves().size(), (int)this.nodes.size());
        for (BaseWork w : this.nodes) {
            Assert.assertEquals((int)this.work.getParents(w).size(), (int)0);
            Assert.assertEquals((int)this.work.getChildren(w).size(), (int)0);
        }
    }

    @Test
    public void testConnect() throws Exception {
        BaseWork parent = this.nodes.get(0);
        BaseWork child = this.nodes.get(1);
        TezEdgeProperty edgeProp = new TezEdgeProperty(TezEdgeProperty.EdgeType.SIMPLE_EDGE);
        this.work.connect(parent, child, edgeProp);
        Assert.assertEquals((int)this.work.getParents(child).size(), (int)1);
        Assert.assertEquals((int)this.work.getChildren(parent).size(), (int)1);
        Assert.assertEquals(this.work.getChildren(parent).get(0), (Object)child);
        Assert.assertEquals(this.work.getParents(child).get(0), (Object)parent);
        Assert.assertTrue((this.work.getRoots().contains(parent) && !this.work.getRoots().contains(child) ? 1 : 0) != 0);
        Assert.assertTrue((!this.work.getLeaves().contains(parent) && this.work.getLeaves().contains(child) ? 1 : 0) != 0);
        for (BaseWork w : this.nodes) {
            if (w == parent || w == child) continue;
            Assert.assertEquals((int)this.work.getParents(w).size(), (int)0);
            Assert.assertEquals((int)this.work.getChildren(w).size(), (int)0);
        }
        Assert.assertEquals((Object)this.work.getEdgeProperty(parent, child).getEdgeType(), (Object)TezEdgeProperty.EdgeType.SIMPLE_EDGE);
    }

    @Test
    public void testBroadcastConnect() throws Exception {
        BaseWork parent = this.nodes.get(0);
        BaseWork child = this.nodes.get(1);
        TezEdgeProperty edgeProp = new TezEdgeProperty(TezEdgeProperty.EdgeType.BROADCAST_EDGE);
        this.work.connect(parent, child, edgeProp);
        Assert.assertEquals((int)this.work.getParents(child).size(), (int)1);
        Assert.assertEquals((int)this.work.getChildren(parent).size(), (int)1);
        Assert.assertEquals(this.work.getChildren(parent).get(0), (Object)child);
        Assert.assertEquals(this.work.getParents(child).get(0), (Object)parent);
        Assert.assertTrue((this.work.getRoots().contains(parent) && !this.work.getRoots().contains(child) ? 1 : 0) != 0);
        Assert.assertTrue((!this.work.getLeaves().contains(parent) && this.work.getLeaves().contains(child) ? 1 : 0) != 0);
        for (BaseWork w : this.nodes) {
            if (w == parent || w == child) continue;
            Assert.assertEquals((int)this.work.getParents(w).size(), (int)0);
            Assert.assertEquals((int)this.work.getChildren(w).size(), (int)0);
        }
        Assert.assertEquals((Object)this.work.getEdgeProperty(parent, child).getEdgeType(), (Object)TezEdgeProperty.EdgeType.BROADCAST_EDGE);
    }

    @Test
    public void testDisconnect() throws Exception {
        BaseWork parent = this.nodes.get(0);
        BaseWork[] children = new BaseWork[]{this.nodes.get(1), this.nodes.get(2)};
        TezEdgeProperty edgeProp = new TezEdgeProperty(TezEdgeProperty.EdgeType.SIMPLE_EDGE);
        this.work.connect(parent, children[0], edgeProp);
        this.work.connect(parent, children[1], edgeProp);
        this.work.disconnect(parent, children[0]);
        Assert.assertTrue((boolean)this.work.getChildren(parent).contains(children[1]));
        Assert.assertTrue((!this.work.getChildren(parent).contains(children[0]) ? 1 : 0) != 0);
        Assert.assertTrue((this.work.getRoots().contains(parent) && this.work.getRoots().contains(children[0]) && !this.work.getRoots().contains(children[1]) ? 1 : 0) != 0);
        Assert.assertTrue((!this.work.getLeaves().contains(parent) && this.work.getLeaves().contains(children[0]) && this.work.getLeaves().contains(children[1]) ? 1 : 0) != 0);
    }

    @Test
    public void testRemove() throws Exception {
        BaseWork parent = this.nodes.get(0);
        BaseWork[] children = new BaseWork[]{this.nodes.get(1), this.nodes.get(2)};
        TezEdgeProperty edgeProp = new TezEdgeProperty(TezEdgeProperty.EdgeType.SIMPLE_EDGE);
        this.work.connect(parent, children[0], edgeProp);
        this.work.connect(parent, children[1], edgeProp);
        this.work.remove(parent);
        Assert.assertEquals((int)this.work.getParents(children[0]).size(), (int)0);
        Assert.assertEquals((int)this.work.getParents(children[1]).size(), (int)0);
        Assert.assertEquals((int)this.work.getAllWork().size(), (int)(this.nodes.size() - 1));
        Assert.assertEquals((int)this.work.getRoots().size(), (int)(this.nodes.size() - 1));
        Assert.assertEquals((int)this.work.getLeaves().size(), (int)(this.nodes.size() - 1));
    }

    @Test
    public void testGetAllWork() throws Exception {
        TezEdgeProperty edgeProp = new TezEdgeProperty(TezEdgeProperty.EdgeType.SIMPLE_EDGE);
        for (int i = 4; i > 0; --i) {
            this.work.connect(this.nodes.get(i), this.nodes.get(i - 1), edgeProp);
        }
        List sorted = this.work.getAllWork();
        for (int i = 0; i < 5; ++i) {
            Assert.assertEquals(sorted.get(i), (Object)this.nodes.get(4 - i));
        }
    }

    @Test
    public void testConfigureJars() throws Exception {
        final JobConf conf = new JobConf();
        conf.set("fs.default.name", "file:///");
        conf.set(MR_JAR_PROPERTY, "file:///tmp/foo1.jar");
        BaseWork baseWork = (BaseWork)Mockito.mock(BaseWork.class);
        ((BaseWork)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                conf.set(TestTezWork.MR_JAR_PROPERTY, "file:///tmp/foo2.jar");
                return null;
            }
        }).when((Object)baseWork)).configureJobConf(conf);
        this.work.add(baseWork);
        this.work.configureJobConfAndExtractJars(conf);
        Assert.assertEquals((String)"file:///tmp/foo1.jar,file:///tmp/foo2.jar", (String)conf.get(MR_JAR_PROPERTY));
    }

    @Test
    public void testConfigureJarsNoExtraJars() throws Exception {
        JobConf conf = new JobConf();
        conf.set("fs.default.name", "file:///");
        conf.set(MR_JAR_PROPERTY, "file:///tmp/foo1.jar");
        BaseWork baseWork = (BaseWork)Mockito.mock(BaseWork.class);
        this.work.add(baseWork);
        this.work.configureJobConfAndExtractJars(conf);
        Assert.assertEquals((String)"file:///tmp/foo1.jar", (String)conf.get(MR_JAR_PROPERTY));
    }

    @Test
    public void testConfigureJarsWithNull() throws Exception {
        final JobConf conf = new JobConf();
        conf.set("fs.default.name", "file:///");
        conf.set(MR_JAR_PROPERTY, "file:///tmp/foo1.jar");
        BaseWork baseWork = (BaseWork)Mockito.mock(BaseWork.class);
        ((BaseWork)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                conf.unset(TestTezWork.MR_JAR_PROPERTY);
                return null;
            }
        }).when((Object)baseWork)).configureJobConf(conf);
        this.work.add(baseWork);
        this.work.configureJobConfAndExtractJars(conf);
        Assert.assertEquals((String)"file:///tmp/foo1.jar", (String)conf.get(MR_JAR_PROPERTY));
    }

    @Test
    public void testConfigureJarsStartingWithNull() throws Exception {
        final JobConf conf = new JobConf();
        conf.set("fs.default.name", "file:///");
        conf.unset(MR_JAR_PROPERTY);
        BaseWork baseWork = (BaseWork)Mockito.mock(BaseWork.class);
        ((BaseWork)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                conf.setStrings(TestTezWork.MR_JAR_PROPERTY, new String[]{"file:///tmp/foo1.jar", "file:///tmp/foo2.jar"});
                return null;
            }
        }).when((Object)baseWork)).configureJobConf(conf);
        this.work.add(baseWork);
        this.work.configureJobConfAndExtractJars(conf);
        Assert.assertEquals((String)"file:///tmp/foo1.jar,file:///tmp/foo2.jar", (String)conf.get(MR_JAR_PROPERTY));
    }
}

