/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lockmgr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponseElement;
import org.apache.hadoop.hive.metastore.api.TxnInfo;
import org.apache.hadoop.hive.metastore.api.TxnState;
import org.apache.hadoop.hive.metastore.txn.TxnDbUtil;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.lockmgr.DbLockManager;
import org.apache.hadoop.hive.ql.lockmgr.DbTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.lockmgr.TxnManagerFactory;
import org.apache.hadoop.hive.ql.metadata.DummyPartition;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.txn.AcidHouseKeeperService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestDbTxnManager {
    private static final int TEST_TIMED_OUT_TXN_ABORT_BATCH_SIZE = 1000;
    private final HiveConf conf = new HiveConf();
    private HiveTxnManager txnMgr;
    private AcidHouseKeeperService houseKeeperService = null;
    private final Context ctx;
    private int nextInput;
    HashSet<ReadEntity> readEntities;
    HashSet<WriteEntity> writeEntities;

    public TestDbTxnManager() throws Exception {
        this.conf.set("fs.default.name", "file:///");
        this.conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        TxnDbUtil.setConfValues((HiveConf)this.conf);
        SessionState.start((HiveConf)this.conf);
        this.ctx = new Context((Configuration)this.conf);
        this.tearDown();
    }

    @Test
    public void testSingleReadTable() throws Exception {
        this.addTableInput();
        MockQueryPlan qp = new MockQueryPlan(this);
        this.txnMgr.acquireLocks((QueryPlan)qp, this.ctx, "fred");
        List locks = this.ctx.getHiveLocks();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((long)1L, (long)TxnDbUtil.countLockComponents((HiveConf)this.conf, (long)((DbLockManager.DbHiveLock)locks.get((int)0)).lockId));
        this.txnMgr.getLockManager().unlock((HiveLock)locks.get(0));
        locks = this.txnMgr.getLockManager().getLocks(false, false);
        Assert.assertEquals((long)0L, (long)locks.size());
    }

    @Test
    public void testSingleReadPartition() throws Exception {
        this.addPartitionInput(this.newTable(true));
        MockQueryPlan qp = new MockQueryPlan(this);
        this.txnMgr.acquireLocks((QueryPlan)qp, this.ctx, null);
        List locks = this.ctx.getHiveLocks();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((long)1L, (long)TxnDbUtil.countLockComponents((HiveConf)this.conf, (long)((DbLockManager.DbHiveLock)locks.get((int)0)).lockId));
        this.txnMgr.getLockManager().unlock((HiveLock)locks.get(0));
        locks = this.txnMgr.getLockManager().getLocks(false, false);
        Assert.assertEquals((long)0L, (long)locks.size());
    }

    @Test
    public void testSingleReadMultiPartition() throws Exception {
        Table t = this.newTable(true);
        this.addPartitionInput(t);
        this.addPartitionInput(t);
        this.addPartitionInput(t);
        MockQueryPlan qp = new MockQueryPlan(this);
        this.txnMgr.acquireLocks((QueryPlan)qp, this.ctx, "fred");
        List locks = this.ctx.getHiveLocks();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((long)3L, (long)TxnDbUtil.countLockComponents((HiveConf)this.conf, (long)((DbLockManager.DbHiveLock)locks.get((int)0)).lockId));
        this.txnMgr.getLockManager().unlock((HiveLock)locks.get(0));
        locks = this.txnMgr.getLockManager().getLocks(false, false);
        Assert.assertEquals((long)0L, (long)locks.size());
    }

    @Test
    public void testJoin() throws Exception {
        Table t = this.newTable(true);
        this.addPartitionInput(t);
        this.addPartitionInput(t);
        this.addPartitionInput(t);
        this.addTableInput();
        MockQueryPlan qp = new MockQueryPlan(this);
        this.txnMgr.acquireLocks((QueryPlan)qp, this.ctx, "fred");
        List locks = this.ctx.getHiveLocks();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((long)4L, (long)TxnDbUtil.countLockComponents((HiveConf)this.conf, (long)((DbLockManager.DbHiveLock)locks.get((int)0)).lockId));
        this.txnMgr.getLockManager().unlock((HiveLock)locks.get(0));
        locks = this.txnMgr.getLockManager().getLocks(false, false);
        Assert.assertEquals((long)0L, (long)locks.size());
    }

    @Test
    public void testSingleWriteTable() throws Exception {
        WriteEntity we = this.addTableOutput(WriteEntity.WriteType.INSERT);
        MockQueryPlan qp = new MockQueryPlan(this);
        this.txnMgr.openTxn(this.ctx, "fred");
        this.txnMgr.acquireLocks((QueryPlan)qp, this.ctx, "fred");
        List locks = this.ctx.getHiveLocks();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((long)1L, (long)TxnDbUtil.countLockComponents((HiveConf)this.conf, (long)((DbLockManager.DbHiveLock)locks.get((int)0)).lockId));
        this.txnMgr.commitTxn();
        locks = this.txnMgr.getLockManager().getLocks(false, false);
        Assert.assertEquals((long)0L, (long)locks.size());
    }

    @Test
    public void testSingleWritePartition() throws Exception {
        WriteEntity we = this.addPartitionOutput(this.newTable(true), WriteEntity.WriteType.INSERT);
        MockQueryPlan qp = new MockQueryPlan(this);
        this.txnMgr.openTxn(this.ctx, "fred");
        this.txnMgr.acquireLocks((QueryPlan)qp, this.ctx, "fred");
        List locks = this.ctx.getHiveLocks();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((long)1L, (long)TxnDbUtil.countLockComponents((HiveConf)this.conf, (long)((DbLockManager.DbHiveLock)locks.get((int)0)).lockId));
        this.txnMgr.commitTxn();
        locks = this.txnMgr.getLockManager().getLocks(false, false);
        Assert.assertEquals((long)0L, (long)locks.size());
    }

    @Test
    public void testWriteDynamicPartition() throws Exception {
        WriteEntity we = this.addDynamicPartitionedOutput(this.newTable(true), WriteEntity.WriteType.INSERT);
        MockQueryPlan qp = new MockQueryPlan(this);
        this.txnMgr.openTxn(this.ctx, "fred");
        this.txnMgr.acquireLocks((QueryPlan)qp, this.ctx, "fred");
        List locks = this.ctx.getHiveLocks();
        Assert.assertEquals((long)1L, (long)locks.size());
        ShowLocksResponse rsp = ((DbLockManager)this.txnMgr.getLockManager()).getLocks();
        List elms = rsp.getLocks();
        Assert.assertEquals((long)1L, (long)elms.size());
        Assert.assertNotNull((Object)((ShowLocksResponseElement)elms.get(0)).getTablename());
        Assert.assertNull((Object)((ShowLocksResponseElement)elms.get(0)).getPartname());
        this.txnMgr.commitTxn();
        locks = this.txnMgr.getLockManager().getLocks(false, false);
        Assert.assertEquals((long)0L, (long)locks.size());
    }

    private void runReaper() throws Exception {
        int lastCount = this.houseKeeperService.getIsAliveCounter();
        this.houseKeeperService.start(this.conf);
        int maxIter = 10;
        int iterCount = 0;
        while (this.houseKeeperService.getIsAliveCounter() <= lastCount) {
            if (iterCount++ >= maxIter) {
                throw new IllegalStateException("Reaper didn't run after " + iterCount + " waits");
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.houseKeeperService.stop();
    }

    @Test
    public void testExceptions() throws Exception {
        this.addPartitionOutput(this.newTable(true), WriteEntity.WriteType.INSERT);
        MockQueryPlan qp = new MockQueryPlan(this);
        ((DbTxnManager)this.txnMgr).openTxn(this.ctx, "NicholasII", HiveConf.getTimeVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TXN_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS) * 2L);
        Thread.sleep(HiveConf.getTimeVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TXN_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS));
        this.runReaper();
        LockException exception = null;
        try {
            this.txnMgr.commitTxn();
        }
        catch (LockException ex) {
            exception = ex;
        }
        Assert.assertNotNull((String)"Expected exception1", (Object)((Object)exception));
        Assert.assertEquals((String)"Wrong Exception1", (Object)ErrorMsg.TXN_ABORTED, (Object)exception.getCanonicalErrorMsg());
        exception = null;
        ((DbTxnManager)this.txnMgr).openTxn(this.ctx, "AlexanderIII", HiveConf.getTimeVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TXN_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS) * 2L);
        Thread.sleep(HiveConf.getTimeVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TXN_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS));
        this.runReaper();
        TxnStore txnHandler = TxnUtils.getTxnStore((HiveConf)this.conf);
        GetOpenTxnsInfoResponse txnsInfo = txnHandler.getOpenTxnsInfo();
        junit.framework.Assert.assertEquals((long)2L, (long)txnsInfo.getTxn_high_water_mark());
        junit.framework.Assert.assertEquals((int)2, (int)txnsInfo.getOpen_txns().size());
        Assert.assertEquals((Object)TxnState.ABORTED, (Object)((TxnInfo)txnsInfo.getOpen_txns().get(1)).getState());
        this.txnMgr.rollbackTxn();
    }

    @Test
    public void testLockTimeout() throws Exception {
        int i;
        this.addPartitionInput(this.newTable(true));
        MockQueryPlan qp = new MockQueryPlan(this);
        this.testLockExpiration(this.txnMgr, 0, true);
        for (i = 0; i < 5; ++i) {
            ((DbTxnManager)this.txnMgr).acquireLocks((QueryPlan)qp, this.ctx, "PeterI" + i, true);
        }
        this.testLockExpiration(this.txnMgr, 5, true);
        for (i = 0; i < 1017; ++i) {
            ((DbTxnManager)this.txnMgr).acquireLocks((QueryPlan)qp, this.ctx, "PeterI" + i, true);
        }
        this.testLockExpiration(this.txnMgr, 1017, true);
        ((DbTxnManager)this.txnMgr).acquireLocksWithHeartbeatDelay((QueryPlan)qp, this.ctx, "bob", HiveConf.getTimeVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TXN_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS) * 10L);
        this.testLockExpiration(this.txnMgr, 1, true);
        this.txnMgr.acquireLocks((QueryPlan)qp, this.ctx, "peter");
        this.testLockExpiration(this.txnMgr, 1, false);
    }

    private void testLockExpiration(HiveTxnManager txnMgr, int numLocksBefore, boolean shouldExpire) throws Exception {
        DbLockManager lockManager = (DbLockManager)txnMgr.getLockManager();
        ShowLocksResponse resp = lockManager.getLocks();
        Assert.assertEquals((String)"Wrong number of locks before expire", (long)numLocksBefore, (long)resp.getLocks().size());
        Thread.sleep(HiveConf.getTimeVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TXN_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS));
        this.runReaper();
        resp = lockManager.getLocks();
        if (shouldExpire) {
            Assert.assertEquals((String)"Expected all locks to expire", (long)0L, (long)resp.getLocks().size());
            lockManager.clearLocalLockRecords();
        } else {
            Assert.assertEquals((String)"No lock should expire because there is heartbeating", (long)numLocksBefore, (long)resp.getLocks().size());
        }
    }

    @Test
    public void testReadWrite() throws Exception {
        Table t = this.newTable(true);
        this.addPartitionInput(t);
        this.addPartitionInput(t);
        this.addPartitionInput(t);
        WriteEntity we = this.addTableOutput(WriteEntity.WriteType.INSERT);
        MockQueryPlan qp = new MockQueryPlan(this);
        this.txnMgr.openTxn(this.ctx, "fred");
        this.txnMgr.acquireLocks((QueryPlan)qp, this.ctx, "fred");
        List locks = this.ctx.getHiveLocks();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((long)4L, (long)TxnDbUtil.countLockComponents((HiveConf)this.conf, (long)((DbLockManager.DbHiveLock)locks.get((int)0)).lockId));
        this.txnMgr.commitTxn();
        locks = this.txnMgr.getLockManager().getLocks(false, false);
        Assert.assertEquals((long)0L, (long)locks.size());
    }

    @Test
    public void testUpdate() throws Exception {
        WriteEntity we = this.addTableOutput(WriteEntity.WriteType.UPDATE);
        MockQueryPlan qp = new MockQueryPlan(this);
        this.txnMgr.openTxn(this.ctx, "fred");
        this.txnMgr.acquireLocks((QueryPlan)qp, this.ctx, "fred");
        List locks = this.ctx.getHiveLocks();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((long)1L, (long)TxnDbUtil.countLockComponents((HiveConf)this.conf, (long)((DbLockManager.DbHiveLock)locks.get((int)0)).lockId));
        this.txnMgr.commitTxn();
        locks = this.txnMgr.getLockManager().getLocks(false, false);
        Assert.assertEquals((long)0L, (long)locks.size());
    }

    @Test
    public void testDelete() throws Exception {
        WriteEntity we = this.addTableOutput(WriteEntity.WriteType.DELETE);
        MockQueryPlan qp = new MockQueryPlan(this);
        this.txnMgr.openTxn(this.ctx, "fred");
        this.txnMgr.acquireLocks((QueryPlan)qp, this.ctx, "fred");
        List locks = this.ctx.getHiveLocks();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((long)1L, (long)TxnDbUtil.countLockComponents((HiveConf)this.conf, (long)((DbLockManager.DbHiveLock)locks.get((int)0)).lockId));
        this.txnMgr.commitTxn();
        locks = this.txnMgr.getLockManager().getLocks(false, false);
        Assert.assertEquals((long)0L, (long)locks.size());
    }

    @Test
    public void testRollback() throws Exception {
        WriteEntity we = this.addTableOutput(WriteEntity.WriteType.DELETE);
        MockQueryPlan qp = new MockQueryPlan(this);
        this.txnMgr.openTxn(this.ctx, "fred");
        this.txnMgr.acquireLocks((QueryPlan)qp, this.ctx, "fred");
        List locks = this.ctx.getHiveLocks();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((long)1L, (long)TxnDbUtil.countLockComponents((HiveConf)this.conf, (long)((DbLockManager.DbHiveLock)locks.get((int)0)).lockId));
        this.txnMgr.rollbackTxn();
        locks = this.txnMgr.getLockManager().getLocks(false, false);
        Assert.assertEquals((long)0L, (long)locks.size());
    }

    @Test
    public void testDDLExclusive() throws Exception {
        WriteEntity we = this.addTableOutput(WriteEntity.WriteType.DDL_EXCLUSIVE);
        MockQueryPlan qp = new MockQueryPlan(this);
        this.txnMgr.acquireLocks((QueryPlan)qp, this.ctx, "fred");
        List locks = this.ctx.getHiveLocks();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((long)1L, (long)TxnDbUtil.countLockComponents((HiveConf)this.conf, (long)((DbLockManager.DbHiveLock)locks.get((int)0)).lockId));
        this.txnMgr.getLockManager().unlock((HiveLock)locks.get(0));
        locks = this.txnMgr.getLockManager().getLocks(false, false);
        Assert.assertEquals((long)0L, (long)locks.size());
    }

    @Test
    public void testDDLShared() throws Exception {
        WriteEntity we = this.addTableOutput(WriteEntity.WriteType.DDL_SHARED);
        MockQueryPlan qp = new MockQueryPlan(this);
        this.txnMgr.acquireLocks((QueryPlan)qp, this.ctx, "fred");
        List locks = this.ctx.getHiveLocks();
        Assert.assertEquals((long)1L, (long)locks.size());
        Assert.assertEquals((long)1L, (long)TxnDbUtil.countLockComponents((HiveConf)this.conf, (long)((DbLockManager.DbHiveLock)locks.get((int)0)).lockId));
        this.txnMgr.getLockManager().unlock((HiveLock)locks.get(0));
        locks = this.txnMgr.getLockManager().getLocks(false, false);
        Assert.assertEquals((long)0L, (long)locks.size());
    }

    @Test
    public void testDDLNoLock() throws Exception {
        WriteEntity we = this.addTableOutput(WriteEntity.WriteType.DDL_NO_LOCK);
        MockQueryPlan qp = new MockQueryPlan(this);
        this.txnMgr.acquireLocks((QueryPlan)qp, this.ctx, "fred");
        List locks = this.ctx.getHiveLocks();
        Assert.assertNull((Object)locks);
    }

    @Test
    public void concurrencyFalse() throws Exception {
        HiveConf badConf = new HiveConf();
        badConf.setVar(HiveConf.ConfVars.HIVE_TXN_MANAGER, "org.apache.hadoop.hive.ql.lockmgr.DbTxnManager");
        badConf.setBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, false);
        boolean sawException = false;
        try {
            TxnManagerFactory.getTxnManagerFactory().getTxnManager(badConf);
        }
        catch (RuntimeException e) {
            sawException = true;
        }
        Assert.assertTrue((boolean)sawException);
    }

    @Test
    public void testLockAcquisitionAndRelease() throws Exception {
        this.addTableInput();
        MockQueryPlan qp = new MockQueryPlan(this);
        this.txnMgr.acquireLocks((QueryPlan)qp, this.ctx, "fred");
        List locks = this.ctx.getHiveLocks();
        Assert.assertEquals((long)1L, (long)locks.size());
        this.txnMgr.releaseLocks(locks);
        locks = this.txnMgr.getLockManager().getLocks(false, false);
        Assert.assertEquals((long)0L, (long)locks.size());
    }

    @Test
    public void testHeartbeater() throws Exception {
        Assert.assertTrue((boolean)(this.txnMgr instanceof DbTxnManager));
        this.addTableInput();
        LockException exception = null;
        MockQueryPlan qp = new MockQueryPlan(this);
        this.txnMgr.openTxn(this.ctx, "fred");
        this.txnMgr.acquireLocks((QueryPlan)qp, this.ctx, "fred");
        this.runReaper();
        try {
            this.txnMgr.commitTxn();
        }
        catch (LockException e) {
            exception = e;
        }
        Assert.assertNull((String)"Txn commit should be successful", (Object)((Object)exception));
        exception = null;
        ((DbTxnManager)this.txnMgr).openTxn(this.ctx, "tom", HiveConf.getTimeVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TXN_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS) / 2L);
        this.txnMgr.acquireLocks((QueryPlan)qp, this.ctx, "tom");
        this.runReaper();
        try {
            this.txnMgr.commitTxn();
        }
        catch (LockException e) {
            exception = e;
        }
        Assert.assertNull((String)"Txn commit should also be successful", (Object)((Object)exception));
        exception = null;
        ((DbTxnManager)this.txnMgr).openTxn(this.ctx, "jerry", HiveConf.getTimeVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TXN_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS) * 2L);
        this.txnMgr.acquireLocks((QueryPlan)qp, this.ctx, "jerry");
        Thread.sleep(HiveConf.getTimeVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TXN_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS));
        this.runReaper();
        try {
            this.txnMgr.commitTxn();
        }
        catch (LockException e) {
            exception = e;
        }
        Assert.assertNotNull((String)"Txn should have been aborted", (Object)((Object)exception));
        Assert.assertEquals((Object)ErrorMsg.TXN_ABORTED, (Object)exception.getCanonicalErrorMsg());
    }

    @Before
    public void setUp() throws Exception {
        TxnDbUtil.prepDb((HiveConf)this.conf);
        this.txnMgr = TxnManagerFactory.getTxnManagerFactory().getTxnManager(this.conf);
        this.txnMgr.getLockManager();
        Assert.assertTrue((boolean)(this.txnMgr instanceof DbTxnManager));
        this.nextInput = 1;
        this.readEntities = new HashSet();
        this.writeEntities = new HashSet();
        this.conf.setTimeVar(HiveConf.ConfVars.HIVE_TIMEDOUT_TXN_REAPER_START, 0L, TimeUnit.SECONDS);
        this.conf.setTimeVar(HiveConf.ConfVars.HIVE_TXN_TIMEOUT, 10L, TimeUnit.SECONDS);
        this.houseKeeperService = new AcidHouseKeeperService();
    }

    @After
    public void tearDown() throws Exception {
        if (this.houseKeeperService != null) {
            this.houseKeeperService.stop();
        }
        if (this.txnMgr != null) {
            this.txnMgr.closeTxnManager();
        }
        TxnDbUtil.cleanDb((HiveConf)this.conf);
    }

    private Table newTable(boolean isPartitioned) {
        HashMap<String, String> tblProps;
        Table t = new Table("default", "table" + Integer.toString(this.nextInput++));
        if (isPartitioned) {
            FieldSchema fs = new FieldSchema();
            fs.setName("version");
            fs.setType("String");
            ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>(1);
            partCols.add(fs);
            t.setPartCols(partCols);
        }
        if ((tblProps = t.getParameters()) == null) {
            tblProps = new HashMap<String, String>();
        }
        tblProps.put("transactional", "true");
        t.setParameters(tblProps);
        return t;
    }

    private void addTableInput() {
        ReadEntity re = new ReadEntity(this.newTable(false));
        this.readEntities.add(re);
    }

    private void addPartitionInput(Table t) throws Exception {
        HashMap<String, String> partSpec = new HashMap<String, String>();
        partSpec.put("version", Integer.toString(this.nextInput++));
        Partition p = new Partition(t, partSpec, new Path("/dev/null"));
        ReadEntity re = new ReadEntity(p);
        this.readEntities.add(re);
    }

    private WriteEntity addTableOutput(WriteEntity.WriteType writeType) {
        WriteEntity we = new WriteEntity(this.newTable(false), writeType);
        this.writeEntities.add(we);
        return we;
    }

    private WriteEntity addPartitionOutput(Table t, WriteEntity.WriteType writeType) throws Exception {
        HashMap<String, String> partSpec = new HashMap<String, String>();
        partSpec.put("version", Integer.toString(this.nextInput++));
        Partition p = new Partition(t, partSpec, new Path("/dev/null"));
        WriteEntity we = new WriteEntity(p, writeType);
        this.writeEntities.add(we);
        return we;
    }

    private WriteEntity addDynamicPartitionedOutput(Table t, WriteEntity.WriteType writeType) throws Exception {
        DummyPartition dp = new DummyPartition(t, "no clue what I should call this");
        WriteEntity we = new WriteEntity(dp, writeType, false);
        this.writeEntities.add(we);
        return we;
    }

    private static class MockQueryPlan
    extends QueryPlan {
        private final HashSet<ReadEntity> inputs = new HashSet();
        private final HashSet<WriteEntity> outputs = new HashSet();
        private final String queryId;

        MockQueryPlan(TestDbTxnManager test) {
            this.inputs.addAll(test.readEntities);
            this.outputs.addAll(test.writeEntities);
            this.queryId = MockQueryPlan.makeQueryId();
        }

        public HashSet<ReadEntity> getInputs() {
            return this.inputs;
        }

        public HashSet<WriteEntity> getOutputs() {
            return this.outputs;
        }

        public String getQueryId() {
            return this.queryId;
        }
    }
}

