/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFSortArrayByField;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericUDFSortArrayByField {
    private final GenericUDFSortArrayByField udf = new GenericUDFSortArrayByField();

    @Test
    public void testSortPrimitiveTupleOneField() throws HiveException {
        ArrayList<Object> tuple = new ArrayList<Object>();
        tuple.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        tuple.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
        ObjectInspector[] inputOIs = new ObjectInspector[]{ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("Company", "Salary"), tuple)), PrimitiveObjectInspectorFactory.writableHiveVarcharObjectInspector};
        this.udf.initialize(inputOIs);
        List<WritableComparable> i1 = Arrays.asList(new Text("Facebook"), new DoubleWritable(80223.25));
        List<WritableComparable> i2 = Arrays.asList(new Text("Facebook"), new DoubleWritable(50223.25));
        List<WritableComparable> i3 = Arrays.asList(new Text("Facebook"), new DoubleWritable(40223.25));
        List<WritableComparable> i4 = Arrays.asList(new Text("Facebook"), new DoubleWritable(60223.25));
        HiveVarchar vc = new HiveVarchar();
        vc.setValue("Salary");
        GenericUDF.DeferredJavaObject[] argas = new GenericUDF.DeferredJavaObject[]{new GenericUDF.DeferredJavaObject(Arrays.asList(i1, i2, i3, i4)), new GenericUDF.DeferredJavaObject((Object)new HiveVarcharWritable(vc))};
        this.runAndVerify(argas, Arrays.asList(i3, i2, i4, i1));
    }

    @Test
    public void testSortPrimitiveTupleOneFieldOrderASC() throws HiveException {
        ArrayList<Object> tuple = new ArrayList<Object>();
        tuple.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        tuple.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
        ObjectInspector[] inputOIs = new ObjectInspector[]{ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("Company", "Salary"), tuple)), PrimitiveObjectInspectorFactory.writableHiveVarcharObjectInspector, PrimitiveObjectInspectorFactory.writableHiveVarcharObjectInspector};
        this.udf.initialize(inputOIs);
        List<WritableComparable> i1 = Arrays.asList(new Text("Facebook"), new DoubleWritable(80223.25));
        List<WritableComparable> i2 = Arrays.asList(new Text("Facebook"), new DoubleWritable(50223.25));
        List<WritableComparable> i3 = Arrays.asList(new Text("Facebook"), new DoubleWritable(40223.25));
        List<WritableComparable> i4 = Arrays.asList(new Text("Facebook"), new DoubleWritable(60223.25));
        HiveVarchar vc = new HiveVarchar();
        vc.setValue("Salary");
        HiveVarchar order = new HiveVarchar();
        order.setValue("ASC");
        GenericUDF.DeferredJavaObject[] argas = new GenericUDF.DeferredJavaObject[]{new GenericUDF.DeferredJavaObject(Arrays.asList(i1, i2, i3, i4)), new GenericUDF.DeferredJavaObject((Object)new HiveVarcharWritable(vc)), new GenericUDF.DeferredJavaObject((Object)new HiveVarcharWritable(order))};
        this.runAndVerify(argas, Arrays.asList(i3, i2, i4, i1));
    }

    @Test
    public void testSortPrimitiveTupleTwoField() throws HiveException {
        ArrayList<WritableStringObjectInspector> tuple = new ArrayList<WritableStringObjectInspector>();
        tuple.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        tuple.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        ObjectInspector[] inputOIs = new ObjectInspector[]{ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("Company", "Department"), tuple)), PrimitiveObjectInspectorFactory.writableStringObjectInspector, PrimitiveObjectInspectorFactory.writableHiveVarcharObjectInspector};
        this.udf.initialize(inputOIs);
        List<Text> i1 = Arrays.asList(new Text("Linkedin"), new Text("HR"));
        List<Text> i2 = Arrays.asList(new Text("Linkedin"), new Text("IT"));
        List<Text> i3 = Arrays.asList(new Text("Linkedin"), new Text("Finance"));
        List<Text> i4 = Arrays.asList(new Text("Facebook"), new Text("IT"));
        List<Text> i5 = Arrays.asList(new Text("Facebook"), new Text("Finance"));
        List<Text> i6 = Arrays.asList(new Text("Facebook"), new Text("HR"));
        List<Text> i7 = Arrays.asList(new Text("Google"), new Text("Logistics"));
        List<Text> i8 = Arrays.asList(new Text("Google"), new Text("Finance"));
        List<Text> i9 = Arrays.asList(new Text("Google"), new Text("HR"));
        HiveVarchar vc = new HiveVarchar();
        vc.setValue("Department");
        GenericUDF.DeferredJavaObject[] argas = new GenericUDF.DeferredJavaObject[]{new GenericUDF.DeferredJavaObject(Arrays.asList(i1, i2, i3, i4, i5, i6, i7, i8, i9)), new GenericUDF.DeferredJavaObject((Object)new Text("Company")), new GenericUDF.DeferredJavaObject((Object)new HiveVarcharWritable(vc))};
        this.runAndVerify(argas, Arrays.asList(i5, i6, i4, i8, i9, i7, i3, i1, i2));
    }

    @Test
    public void testSortPrimitiveTupleTwoFieldOrderDESC() throws HiveException {
        ArrayList<WritableStringObjectInspector> tuple = new ArrayList<WritableStringObjectInspector>();
        tuple.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        tuple.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        ObjectInspector[] inputOIs = new ObjectInspector[]{ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("Company", "Department"), tuple)), PrimitiveObjectInspectorFactory.writableStringObjectInspector, PrimitiveObjectInspectorFactory.writableHiveVarcharObjectInspector, PrimitiveObjectInspectorFactory.writableStringObjectInspector};
        this.udf.initialize(inputOIs);
        List<Text> i1 = Arrays.asList(new Text("Linkedin"), new Text("HR"));
        List<Text> i2 = Arrays.asList(new Text("Linkedin"), new Text("IT"));
        List<Text> i3 = Arrays.asList(new Text("Linkedin"), new Text("Finance"));
        List<Text> i4 = Arrays.asList(new Text("Facebook"), new Text("IT"));
        List<Text> i5 = Arrays.asList(new Text("Facebook"), new Text("Finance"));
        List<Text> i6 = Arrays.asList(new Text("Facebook"), new Text("HR"));
        List<Text> i7 = Arrays.asList(new Text("Google"), new Text("Logistics"));
        List<Text> i8 = Arrays.asList(new Text("Google"), new Text("Finance"));
        List<Text> i9 = Arrays.asList(new Text("Google"), new Text("HR"));
        HiveVarchar vc = new HiveVarchar();
        vc.setValue("Department");
        GenericUDF.DeferredJavaObject[] argas = new GenericUDF.DeferredJavaObject[]{new GenericUDF.DeferredJavaObject(Arrays.asList(i1, i2, i3, i4, i5, i6, i7, i8, i9)), new GenericUDF.DeferredJavaObject((Object)new Text("Company")), new GenericUDF.DeferredJavaObject((Object)new HiveVarcharWritable(vc)), new GenericUDF.DeferredJavaObject((Object)new Text("DESC"))};
        this.runAndVerify(argas, Arrays.asList(i2, i1, i3, i7, i9, i8, i4, i6, i5));
    }

    @Test
    public void testSortTupleArrayStructOrderDESC() throws HiveException {
        ArrayList<Object> tuple = new ArrayList<Object>();
        tuple.add(PrimitiveObjectInspectorFactory.writableStringObjectInspector);
        tuple.add(ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableIntObjectInspector));
        ConstantObjectInspector field = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.stringTypeInfo, (Object)new Text("Scores"));
        ConstantObjectInspector orderField = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.stringTypeInfo, (Object)new Text("desc"));
        ObjectInspector[] inputOIs = new ObjectInspector[]{ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList("Student", "Scores"), tuple)), field, orderField};
        this.udf.initialize(inputOIs);
        List<Object> i1 = Arrays.asList(new Text("Foo"), Arrays.asList(new IntWritable(4), new IntWritable(3), new IntWritable(2), new IntWritable(1)));
        List<Object> i2 = Arrays.asList(new Text("Boo"), Arrays.asList(new IntWritable(2), new IntWritable(3), new IntWritable(2), new IntWritable(1)));
        List<Object> i3 = Arrays.asList(new Text("Tom"), Arrays.asList(new IntWritable(10), new IntWritable(3), new IntWritable(2), new IntWritable(1)));
        GenericUDF.DeferredJavaObject[] argas = new GenericUDF.DeferredJavaObject[]{new GenericUDF.DeferredJavaObject(Arrays.asList(i1, i2, i3)), new GenericUDF.DeferredJavaObject((Object)field), new GenericUDF.DeferredJavaObject((Object)orderField)};
        this.runAndVerify(argas, Arrays.asList(i3, i1, i2));
    }

    private void runAndVerify(GenericUDF.DeferredJavaObject[] args, List<Object> expected) throws HiveException {
        List result = (List)this.udf.evaluate((GenericUDF.DeferredObject[])args);
        Assert.assertEquals((String)"Check size", (long)expected.size(), (long)result.size());
        Assert.assertArrayEquals((String)"Check content", (Object[])expected.toArray(), (Object[])result.toArray());
    }
}

