/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.io.UnsupportedEncodingException;
import junit.framework.TestCase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDecode;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaBinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;

public class TestGenericUDFDecode
extends TestCase {
    public void testDecode() throws UnsupportedEncodingException, HiveException {
        String[] charsetNames;
        for (String charsetName : charsetNames = new String[]{"US-ASCII", "ISO-8859-1", "UTF-8", "UTF-16BE", "UTF-16LE", "UTF-16"}) {
            this.verifyDecode("A sample string", charsetName);
        }
    }

    public void verifyDecode(String string, String charsetName) throws UnsupportedEncodingException, HiveException {
        GenericUDFDecode udf = new GenericUDFDecode();
        byte[] bytes = string.getBytes(charsetName);
        JavaBinaryObjectInspector valueOI = PrimitiveObjectInspectorFactory.javaByteArrayObjectInspector;
        JavaStringObjectInspector charsetOI = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        ObjectInspector[] initArguments = new ObjectInspector[]{valueOI, charsetOI};
        udf.initialize(initArguments);
        GenericUDF.DeferredJavaObject valueObj = new GenericUDF.DeferredJavaObject((Object)bytes);
        GenericUDF.DeferredJavaObject charsetObj = new GenericUDF.DeferredJavaObject((Object)charsetName);
        GenericUDF.DeferredObject[] arguments = new GenericUDF.DeferredObject[]{valueObj, charsetObj};
        String output = (String)udf.evaluate(arguments);
        TestGenericUDFDecode.assertEquals((String)("Decoding failed for CharSet: " + charsetName), (String)string, (String)output);
    }
}

