/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import java.io.File;
import junit.framework.Assert;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.processors.CompileProcessor;
import org.junit.Test;

public class TestCompileProcessor {
    @Test
    public void testSyntax() throws Exception {
        CompileProcessor cp = new CompileProcessor();
        Assert.assertEquals((int)0, (int)cp.run("` public class x { \n }` AS GROOVY NAMED x.groovy").getResponseCode());
        Assert.assertEquals((String)"GROOVY", (String)cp.getLang());
        Assert.assertEquals((String)" public class x { \n }", (String)cp.getCode());
        Assert.assertEquals((String)"x.groovy", (String)cp.getNamed());
        Assert.assertEquals((int)1, (int)cp.run("").getResponseCode());
        Assert.assertEquals((int)1, (int)cp.run("bla bla ").getResponseCode());
        CompileProcessor cp2 = new CompileProcessor();
        CommandProcessorResponse response = cp2.run("` import org.apache.hadoop.hive.ql.exec.UDF \n public class x { \n }` AS GROOVY NAMED x.groovy");
        Assert.assertEquals((int)0, (int)response.getResponseCode());
        File f = new File(response.getErrorMessage());
        Assert.assertTrue((boolean)f.exists());
        f.delete();
    }
}

