/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.AddToClassPathAction;
import org.apache.hadoop.hive.ql.exec.UDFClassLoader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestAddToClassPathAction {
    private ClassLoader originalClassLoader;

    private static void assertURLsMatch(String message, List<String> expected, URL[] actual) {
        ArrayList<String> actualStrings = new ArrayList<String>();
        for (URL url : actual) {
            actualStrings.add(url.toExternalForm());
        }
        Assert.assertEquals((String)message, expected, actualStrings);
    }

    private static void assertURLsMatch(List<String> expected, URL[] actual) {
        TestAddToClassPathAction.assertURLsMatch("", expected, actual);
    }

    @Before
    public void saveClassLoader() {
        this.originalClassLoader = Thread.currentThread().getContextClassLoader();
    }

    @After
    public void restoreClassLoader() {
        Thread.currentThread().setContextClassLoader(this.originalClassLoader);
    }

    @Test
    public void testNullClassLoader() {
        try {
            new AddToClassPathAction(null, (Collection)Collections.EMPTY_LIST);
            Assert.fail((String)"When pafrent class loader is null, IllegalArgumentException is expected!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNullPaths() {
        ClassLoader rootLoader = Thread.currentThread().getContextClassLoader();
        AddToClassPathAction action = new AddToClassPathAction(rootLoader, null);
        UDFClassLoader childLoader = action.run();
        TestAddToClassPathAction.assertURLsMatch("When newPaths is null, loader shall be created normally with no extra paths.", Collections.EMPTY_LIST, childLoader.getURLs());
    }

    @Test
    public void testUseExisting() {
        ClassLoader rootLoader = Thread.currentThread().getContextClassLoader();
        AddToClassPathAction action1 = new AddToClassPathAction(rootLoader, Arrays.asList("/a/1", "/c/3"));
        UDFClassLoader parentLoader = action1.run();
        AddToClassPathAction action2 = new AddToClassPathAction((ClassLoader)parentLoader, Arrays.asList("/b/2", "/d/4"));
        UDFClassLoader childLoader = action2.run();
        Assert.assertSame((String)"Normally, the existing class loader should be reused (not closed, no force new).", (Object)parentLoader, (Object)childLoader);
        TestAddToClassPathAction.assertURLsMatch("The class path of the class loader should be updated.", Arrays.asList("file:/a/1", "file:/c/3", "file:/b/2", "file:/d/4"), childLoader.getURLs());
    }

    @Test
    public void testClosed() throws IOException {
        ClassLoader rootLoader = Thread.currentThread().getContextClassLoader();
        AddToClassPathAction action1 = new AddToClassPathAction(rootLoader, Arrays.asList("/a/1", "/c/3"));
        UDFClassLoader parentLoader = action1.run();
        parentLoader.close();
        AddToClassPathAction action2 = new AddToClassPathAction((ClassLoader)parentLoader, Arrays.asList("/b/2", "/d/4"));
        UDFClassLoader childLoader = action2.run();
        Assert.assertNotSame((String)"When the parent class loader is closed, a new instance must be created.", (Object)parentLoader, (Object)childLoader);
        TestAddToClassPathAction.assertURLsMatch(Arrays.asList("file:/b/2", "file:/d/4"), childLoader.getURLs());
    }

    @Test
    public void testForceNew() {
        ClassLoader rootLoader = Thread.currentThread().getContextClassLoader();
        AddToClassPathAction action1 = new AddToClassPathAction(rootLoader, Arrays.asList("/a/1", "/c/3"));
        UDFClassLoader parentLoader = action1.run();
        AddToClassPathAction action2 = new AddToClassPathAction((ClassLoader)parentLoader, Arrays.asList("/b/2", "/d/4"), true);
        UDFClassLoader childLoader = action2.run();
        Assert.assertNotSame((String)"When forceNewClassLoader is set, a new instance must be created.", (Object)parentLoader, (Object)childLoader);
        TestAddToClassPathAction.assertURLsMatch(Arrays.asList("file:/b/2", "file:/d/4"), childLoader.getURLs());
    }

    @Test
    public void testLegalPaths() {
        ClassLoader rootLoader = Thread.currentThread().getContextClassLoader();
        List<String> newPaths = Arrays.asList("file://a/aa", "c/cc", "/bb/b");
        String userDir = System.getProperty("user.dir");
        List<String> expectedURLs = Arrays.asList("file://a/aa", "file:" + userDir + "/c/cc", "file:/bb/b");
        AddToClassPathAction action = new AddToClassPathAction(rootLoader, newPaths);
        UDFClassLoader loader = (UDFClassLoader)AccessController.doPrivileged(action);
        TestAddToClassPathAction.assertURLsMatch(expectedURLs, loader.getURLs());
    }
}

