/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl.writer;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.writer.StringBaseTreeWriter;
import org.apache.orc.impl.writer.WriterContext;

public class VarcharTreeWriter
extends StringBaseTreeWriter {
    private final int maxLength;

    VarcharTreeWriter(int columnId, TypeDescription schema, WriterContext writer, boolean nullable) throws IOException {
        super(columnId, schema, writer, nullable);
        this.maxLength = schema.getMaxLength();
    }

    @Override
    public void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
        block10: {
            BytesColumnVector vec;
            block9: {
                super.writeBatch(vector, offset, length);
                vec = (BytesColumnVector)vector;
                if (!vector.isRepeating) break block9;
                if (!vector.noNulls && vector.isNull[0]) break block10;
                int itemLength = Math.min(vec.length[0], this.maxLength);
                if (this.useDictionaryEncoding) {
                    int id = this.dictionary.add(vec.vector[0], vec.start[0], itemLength);
                    for (int i = 0; i < length; ++i) {
                        this.rows.add(id);
                    }
                } else {
                    for (int i = 0; i < length; ++i) {
                        this.directStreamOutput.write(vec.vector[0], vec.start[0], itemLength);
                        this.lengthOutput.write(itemLength);
                    }
                }
                this.indexStatistics.updateString(vec.vector[0], vec.start[0], itemLength, length);
                if (!this.createBloomFilter) break block10;
                if (this.bloomFilter != null) {
                    this.bloomFilter.addString(new String(vec.vector[0], vec.start[0], itemLength, StandardCharsets.UTF_8));
                }
                this.bloomFilterUtf8.addBytes(vec.vector[0], vec.start[0], itemLength);
                break block10;
            }
            for (int i = 0; i < length; ++i) {
                if (!vec.noNulls && vec.isNull[i + offset]) continue;
                int itemLength = Math.min(vec.length[offset + i], this.maxLength);
                if (this.useDictionaryEncoding) {
                    this.rows.add(this.dictionary.add(vec.vector[offset + i], vec.start[offset + i], itemLength));
                } else {
                    this.directStreamOutput.write(vec.vector[offset + i], vec.start[offset + i], itemLength);
                    this.lengthOutput.write(itemLength);
                }
                this.indexStatistics.updateString(vec.vector[offset + i], vec.start[offset + i], itemLength, 1);
                if (!this.createBloomFilter) continue;
                if (this.bloomFilter != null) {
                    this.bloomFilter.addString(new String(vec.vector[offset + i], vec.start[offset + i], itemLength, StandardCharsets.UTF_8));
                }
                this.bloomFilterUtf8.addBytes(vec.vector[offset + i], vec.start[offset + i], itemLength);
            }
        }
    }
}

