/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.io.IOException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLoggedInUser;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestGenericUDFLoggedInUser {
    private GenericUDFLoggedInUser udf = null;

    @Test
    public void testSystemUser() throws HiveException, IOException {
        String userName = "test_user";
        HiveConf conf = (HiveConf)Mockito.spy((Object)new HiveConf());
        conf.set("fs.default.name", "file:///");
        Mockito.when((Object)conf.getUser()).thenReturn((Object)userName);
        this.udf = new GenericUDFLoggedInUser();
        SessionState ss = new SessionState(conf);
        SessionState.start((SessionState)ss);
        ObjectInspector[] arguments = new ObjectInspector[]{};
        this.udf.initialize(arguments);
        GenericUDF.DeferredObject[] evaluateArgs = new GenericUDF.DeferredObject[]{};
        Assert.assertEquals((Object)userName, (Object)this.udf.evaluate(evaluateArgs).toString());
    }

    @Test(expected=UDFArgumentException.class)
    public void testExpectException() throws IOException, HiveException {
        this.udf = new GenericUDFLoggedInUser();
        WritableStringObjectInspector valueOIOne = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOIOne};
        this.udf.initialize(arguments);
        this.udf.close();
    }
}

