/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import junit.framework.Assert;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.DDLTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.plan.ConditionalResolverCommonJoin;
import org.junit.Test;

public class TestConditionalResolverCommonJoin {
    @Test
    public void testResolvingDriverAlias() throws Exception {
        ConditionalResolverCommonJoin resolver = new ConditionalResolverCommonJoin();
        HashMap<Path, ArrayList<String>> pathToAliases = new HashMap<Path, ArrayList<String>>();
        pathToAliases.put(new Path("path1"), new ArrayList<String>(Arrays.asList("alias1", "alias2")));
        pathToAliases.put(new Path("path2"), new ArrayList<String>(Arrays.asList("alias3")));
        HashMap<String, Long> aliasToKnownSize = new HashMap<String, Long>();
        aliasToKnownSize.put("alias1", 1024L);
        aliasToKnownSize.put("alias2", 2048L);
        aliasToKnownSize.put("alias3", 4096L);
        DDLTask task1 = new DDLTask();
        task1.setId("alias2");
        DDLTask task2 = new DDLTask();
        task2.setId("alias3");
        LinkedHashMap<DDLTask, HashSet<String>> taskToAliases = new LinkedHashMap<DDLTask, HashSet<String>>();
        taskToAliases.put(task1, new HashSet<String>(Arrays.asList("alias2")));
        taskToAliases.put(task2, new HashSet<String>(Arrays.asList("alias3")));
        ConditionalResolverCommonJoin.ConditionalResolverCommonJoinCtx ctx = new ConditionalResolverCommonJoin.ConditionalResolverCommonJoinCtx();
        ctx.setPathToAliases(pathToAliases);
        ctx.setTaskToAliases(taskToAliases);
        ctx.setAliasToKnownSize(aliasToKnownSize);
        HiveConf conf = new HiveConf();
        conf.set("fs.default.name", "file:///");
        conf.setLongVar(HiveConf.ConfVars.HIVESMALLTABLESFILESIZE, 4096L);
        Task resolved = resolver.resolveMapJoinTask(ctx, conf);
        Assert.assertEquals((String)"alias3", (String)resolved.getId());
        conf.setLongVar(HiveConf.ConfVars.HIVESMALLTABLESFILESIZE, 65536L);
        resolved = resolver.resolveMapJoinTask(ctx, conf);
        Assert.assertEquals((String)"alias3", (String)resolved.getId());
        conf.setLongVar(HiveConf.ConfVars.HIVESMALLTABLESFILESIZE, 2048L);
        resolved = resolver.resolveMapJoinTask(ctx, conf);
        Assert.assertNull((Object)resolved);
    }
}

