/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestContext {
    private static HiveConf conf = new HiveConf();
    private Context context;

    @Before
    public void setUp() throws IOException {
        SessionState.start((HiveConf)conf);
        SessionState.detachSession();
        this.context = new Context((Configuration)conf);
    }

    @Test
    public void testGetScratchDirectoriesForPaths() throws IOException {
        Context spyContext = (Context)Mockito.spy((Object)this.context);
        Path mrTmpPath = new Path("hdfs://hostname/tmp/scratch");
        ((Context)Mockito.doReturn((Object)mrTmpPath).when((Object)spyContext)).getMRTmpPath();
        Assert.assertEquals((Object)mrTmpPath, (Object)spyContext.getTempDirForPath(new Path("s3a://bucket/dir")));
        Assert.assertEquals((Object)mrTmpPath, (Object)spyContext.getTempDirForPath(new Path("file:/user")));
        Assert.assertEquals((Object)mrTmpPath, (Object)spyContext.getTempDirForPath(new Path("file:///user")));
        Path tmpPathRelTo = new Path("hdfs://hostname/user");
        ((Context)Mockito.doReturn((Object)tmpPathRelTo).when((Object)spyContext)).getExtTmpPathRelTo((Path)Mockito.any(Path.class));
        Assert.assertEquals((Object)tmpPathRelTo, (Object)spyContext.getTempDirForPath(new Path("/user")));
    }

    static {
        conf.set("fs.default.name", "file:///");
    }
}

