/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez.monitoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.hadoop.hive.common.log.ProgressMonitor;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.Progress;
import org.apache.tez.dag.api.client.VertexStatus;

class TezProgressMonitor
implements ProgressMonitor {
    private static final int COLUMN_1_WIDTH = 16;
    private final Map<String, BaseWork> workMap;
    private final SessionState.LogHelper console;
    private final long executionStartTime;
    private final DAGStatus status;
    Map<String, VertexStatus> vertexStatusMap = new HashMap<String, VertexStatus>();
    Map<String, VertexProgress> progressCountsMap = new HashMap<String, VertexProgress>();

    TezProgressMonitor(DAGClient dagClient, DAGStatus status, Map<String, BaseWork> workMap, Map<String, Progress> progressMap, SessionState.LogHelper console, long executionStartTime) throws IOException, TezException {
        this.status = status;
        this.workMap = workMap;
        this.console = console;
        this.executionStartTime = executionStartTime;
        for (Map.Entry<String, Progress> entry : progressMap.entrySet()) {
            String vertexName = entry.getKey();
            this.progressCountsMap.put(vertexName, new VertexProgress(entry.getValue(), status.getState()));
            try {
                this.vertexStatusMap.put(vertexName, dagClient.getVertexStatus(vertexName, null));
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public List<String> headers() {
        return Arrays.asList("VERTICES", "MODE", "STATUS", "TOTAL", "COMPLETED", "RUNNING", "PENDING", "FAILED", "KILLED");
    }

    @Override
    public List<List<String>> rows() {
        try {
            ArrayList<List<String>> results = new ArrayList<List<String>>();
            TreeSet<String> keys = new TreeSet<String>(this.progressCountsMap.keySet());
            for (String s : keys) {
                VertexProgress progress = this.progressCountsMap.get(s);
                results.add(Arrays.asList(this.getNameWithProgress(s, progress.succeededTaskCount, progress.totalTaskCount), this.getMode(s, this.workMap), progress.vertexStatus(this.vertexStatusMap.get(s)), progress.total(), progress.completed(), progress.running(), progress.pending(), progress.failed(), progress.killed()));
            }
            return results;
        }
        catch (Exception e) {
            this.console.printInfo("Getting  Progress Bar table rows failed: " + e.getMessage() + " stack trace: " + Arrays.toString(e.getStackTrace()));
            return Collections.emptyList();
        }
    }

    @Override
    public String footerSummary() {
        return String.format("VERTICES: %02d/%02d", this.completed(), this.progressCountsMap.keySet().size());
    }

    @Override
    public long startTime() {
        return this.executionStartTime;
    }

    @Override
    public double progressedPercentage() {
        int sumTotal = 0;
        int sumComplete = 0;
        for (String s : this.progressCountsMap.keySet()) {
            VertexProgress progress = this.progressCountsMap.get(s);
            int complete = progress.succeededTaskCount;
            int total = progress.totalTaskCount;
            if (total <= 0) continue;
            sumTotal += total;
            sumComplete += complete;
        }
        return sumTotal == 0 ? 0.0 : (double)((float)sumComplete / (float)sumTotal);
    }

    @Override
    public String executionStatus() {
        return this.status.getState().name();
    }

    private int completed() {
        HashSet<String> completed = new HashSet<String>();
        for (String s : this.progressCountsMap.keySet()) {
            VertexProgress progress = this.progressCountsMap.get(s);
            int complete = progress.succeededTaskCount;
            int total = progress.totalTaskCount;
            if (total <= 0 || complete != total) continue;
            completed.add(s);
        }
        return completed.size();
    }

    private String getNameWithProgress(String s, int complete, int total) {
        String result = "";
        if (s != null) {
            float percent = total == 0 ? 0.0f : (float)complete / (float)total;
            int spaceRemaining = 16 - s.length() - 1;
            String trimmedVName = s;
            if (s.length() > 16) {
                trimmedVName = s.substring(0, 15);
                trimmedVName = trimmedVName + "..";
            }
            result = trimmedVName + " ";
            int toFill = (int)((float)spaceRemaining * percent);
            for (int i = 0; i < toFill; ++i) {
                result = result + ".";
            }
        }
        return result;
    }

    private String getMode(String name, Map<String, BaseWork> workMap) {
        String mode = "container";
        BaseWork work = workMap.get(name);
        if (work != null) {
            mode = work.getUberMode() ? "uber" : (work.getLlapMode() ? "llap" : "container");
        }
        return mode;
    }

    static class VertexProgress {
        private final int totalTaskCount;
        private final int succeededTaskCount;
        private final int failedTaskAttemptCount;
        private final long killedTaskAttemptCount;
        private final int runningTaskCount;
        private final DAGStatus.State dagState;

        VertexProgress(Progress progress, DAGStatus.State dagState) {
            this(progress.getTotalTaskCount(), progress.getSucceededTaskCount(), progress.getFailedTaskAttemptCount(), progress.getKilledTaskAttemptCount(), progress.getRunningTaskCount(), dagState);
        }

        VertexProgress(int totalTaskCount, int succeededTaskCount, int failedTaskAttemptCount, int killedTaskAttemptCount, int runningTaskCount, DAGStatus.State dagState) {
            this.totalTaskCount = totalTaskCount;
            this.succeededTaskCount = succeededTaskCount;
            this.failedTaskAttemptCount = failedTaskAttemptCount;
            this.killedTaskAttemptCount = killedTaskAttemptCount;
            this.runningTaskCount = runningTaskCount;
            this.dagState = dagState;
        }

        boolean isRunning() {
            return this.succeededTaskCount < this.totalTaskCount && (this.succeededTaskCount > 0 || this.runningTaskCount > 0 || this.failedTaskAttemptCount > 0);
        }

        String vertexStatus(VertexStatus vertexStatus) {
            VertexStatus.State vertexState = VertexStatus.State.INITIALIZING;
            if (this.totalTaskCount > 0) {
                vertexState = VertexStatus.State.INITED;
            }
            if (this.isRunning()) {
                vertexState = VertexStatus.State.RUNNING;
            }
            if (this.succeededTaskCount == this.totalTaskCount) {
                vertexState = VertexStatus.State.SUCCEEDED;
            }
            if (this.dagState == DAGStatus.State.KILLED && vertexStatus != null) {
                vertexState = vertexStatus.getState();
            }
            return vertexState.toString();
        }

        String total() {
            return String.valueOf(this.totalTaskCount);
        }

        String completed() {
            return String.valueOf(this.succeededTaskCount);
        }

        String running() {
            return String.valueOf(this.runningTaskCount);
        }

        String pending() {
            return String.valueOf(this.totalTaskCount - this.succeededTaskCount - this.runningTaskCount);
        }

        String failed() {
            return String.valueOf(this.failedTaskAttemptCount);
        }

        String killed() {
            return String.valueOf(this.killedTaskAttemptCount);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VertexProgress that = (VertexProgress)o;
            if (this.totalTaskCount != that.totalTaskCount) {
                return false;
            }
            if (this.succeededTaskCount != that.succeededTaskCount) {
                return false;
            }
            if (this.failedTaskAttemptCount != that.failedTaskAttemptCount) {
                return false;
            }
            if (this.killedTaskAttemptCount != that.killedTaskAttemptCount) {
                return false;
            }
            if (this.runningTaskCount != that.runningTaskCount) {
                return false;
            }
            return this.dagState == that.dagState;
        }

        public int hashCode() {
            int result = this.totalTaskCount;
            result = 31 * result + this.succeededTaskCount;
            result = 31 * result + this.failedTaskAttemptCount;
            result = 31 * result + (int)(this.killedTaskAttemptCount ^ this.killedTaskAttemptCount >>> 32);
            result = 31 * result + this.runningTaskCount;
            result = 31 * result + this.dagState.hashCode();
            return result;
        }
    }
}

