/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.hep.HepMatchOrder;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.CachingRelMetadataProvider;
import org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelRecordType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveDefaultRelMetadataProvider;
import org.apache.hadoop.hive.ql.optimizer.calcite.HivePlannerContext;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRulesRegistry;
import org.junit.Assert;
import org.junit.Test;

public class TestCBORuleFiredOnlyOnce {
    @Test
    public void testRuleFiredOnlyOnce() {
        HiveConf conf = new HiveConf();
        conf.set("fs.default.name", "file:///");
        HepProgramBuilder programBuilder = new HepProgramBuilder();
        programBuilder.addMatchOrder(HepMatchOrder.TOP_DOWN);
        programBuilder = programBuilder.addRuleCollection((Collection)ImmutableList.of((Object)((Object)DummyRule.INSTANCE)));
        HiveRulesRegistry registry = new HiveRulesRegistry();
        HivePlannerContext context = new HivePlannerContext(null, registry, null);
        HepPlanner planner = new HepPlanner(programBuilder.build(), (Context)context);
        RexBuilder rexBuilder = new RexBuilder((RelDataTypeFactory)new JavaTypeFactoryImpl());
        RelOptCluster cluster = RelOptCluster.create((RelOptPlanner)planner, (RexBuilder)rexBuilder);
        HiveDefaultRelMetadataProvider mdProvider = new HiveDefaultRelMetadataProvider(conf);
        ArrayList list = Lists.newArrayList();
        list.add(mdProvider.getMetadataProvider());
        planner.registerMetadataProviders((List)list);
        RelMetadataProvider chainedProvider = ChainedRelMetadataProvider.of((List)list);
        DummyNode node = new DummyNode(cluster, cluster.traitSet());
        node.getCluster().setMetadataProvider((RelMetadataProvider)new CachingRelMetadataProvider(chainedProvider, (RelOptPlanner)planner));
        planner.setRoot((RelNode)node);
        planner.findBestExp();
        Assert.assertEquals((long)3L, (long)DummyRule.INSTANCE.numberMatches);
        Assert.assertEquals((long)1L, (long)DummyRule.INSTANCE.numberOnMatch);
    }

    public static class DummyNode
    extends AbstractRelNode {
        protected DummyNode(RelOptCluster cluster, RelTraitSet traits) {
            super(cluster, cluster.traitSet());
        }

        protected RelDataType deriveRowType() {
            return new RelRecordType((List)Lists.newArrayList());
        }
    }

    public static class DummyRule
    extends RelOptRule {
        public static final DummyRule INSTANCE = new DummyRule();
        public int numberMatches = 0;
        public int numberOnMatch = 0;

        private DummyRule() {
            super(DummyRule.operand(RelNode.class, (RelOptRuleOperandChildren)DummyRule.any()));
        }

        public boolean matches(RelOptRuleCall call) {
            RelNode node = call.rel(0);
            ++this.numberMatches;
            HiveRulesRegistry registry = (HiveRulesRegistry)call.getPlanner().getContext().unwrap(HiveRulesRegistry.class);
            return registry == null || !registry.getVisited((RelOptRule)this).contains(node);
        }

        public void onMatch(RelOptRuleCall call) {
            RelNode node = call.rel(0);
            ++this.numberOnMatch;
            if (this.numberOnMatch > 1) {
                return;
            }
            HiveRulesRegistry registry = (HiveRulesRegistry)call.getPlanner().getContext().unwrap(HiveRulesRegistry.class);
            if (registry != null) {
                registry.registerVisited((RelOptRule)this, node);
            }
            DummyNode newNode = new DummyNode(node.getCluster(), node.getTraitSet());
            if (registry != null) {
                registry.registerVisited((RelOptRule)this, (RelNode)newNode);
            }
            call.transformTo((RelNode)newNode);
        }
    }
}

