/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.ExplainTask;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.parse.ExplainConfiguration;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExplainWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.junit.Assert;
import org.junit.Test;

public class TestExplainTask {
    @Test
    public void testExplainDoesSortTopLevelMapEntries() throws Exception {
        LinkedHashMap<String, String> explainMap1 = new LinkedHashMap<String, String>();
        explainMap1.put("/k1", "v");
        explainMap1.put("k3", "v");
        explainMap1.put("hdfs:///k2", "v");
        explainMap1.put("hdfs:///k1", "v");
        LinkedHashMap<String, String> explainMap2 = new LinkedHashMap<String, String>();
        explainMap2.put("hdfs:///k1", "v");
        explainMap2.put("hdfs:///k2", "v");
        explainMap2.put("/k1", "v");
        explainMap2.put("k3", "v");
        String result1 = this.explainToString(explainMap1);
        String result2 = this.explainToString(explainMap2);
        Assert.assertEquals((String)"both maps should be ordered, regardless of input order", (Object)result1, (Object)result2);
    }

    @Test
    public void testExplainDoesSortPathAsStrings() throws Exception {
        LinkedHashMap<String, String> explainMap1 = new LinkedHashMap<String, String>();
        explainMap1.put("/k1", "v");
        explainMap1.put("k3", "v");
        explainMap1.put("hdfs:/k2", "v");
        explainMap1.put("hdfs:/k1", "v");
        LinkedHashMap<Path, String> explainMap2 = new LinkedHashMap<Path, String>();
        explainMap2.put(new Path("hdfs:/k1"), "v");
        explainMap2.put(new Path("hdfs:/k2"), "v");
        explainMap2.put(new Path("/k1"), "v");
        explainMap2.put(new Path("k3"), "v");
        String result1 = this.explainToString(explainMap1);
        String result2 = this.explainToString(explainMap2);
        Assert.assertEquals((String)"both maps should be sorted the same way", (Object)result1, (Object)result2);
    }

    @Test
    public void testExplainDoesSortMapValues() throws Exception {
        LinkedHashMap<String, String> explainMap1Val = new LinkedHashMap<String, String>();
        explainMap1Val.put("a", "v");
        explainMap1Val.put("b", "v");
        LinkedHashMap<String, LinkedHashMap<String, String>> explainMap1 = new LinkedHashMap<String, LinkedHashMap<String, String>>();
        explainMap1.put("k", explainMap1Val);
        LinkedHashMap<String, String> explainMap2Val = new LinkedHashMap<String, String>();
        explainMap2Val.put("b", "v");
        explainMap2Val.put("a", "v");
        LinkedHashMap<String, LinkedHashMap<String, String>> explainMap2 = new LinkedHashMap<String, LinkedHashMap<String, String>>();
        explainMap2.put("k", explainMap2Val);
        String result1 = this.explainToString(explainMap1);
        String result2 = this.explainToString(explainMap2);
        Assert.assertEquals((String)"both maps should be sorted the same way", (Object)result1, (Object)result2);
    }

    private <K, V> String explainToString(Map<K, V> explainMap) throws Exception {
        ExplainWork work = new ExplainWork();
        ParseContext pCtx = new ParseContext();
        HashMap<String, DummyOperator> topOps = new HashMap<String, DummyOperator>();
        DummyOperator scanOp = new DummyOperator(new DummyExplainDesc<K, V>(explainMap));
        topOps.put("sample", scanOp);
        pCtx.setTopOps(topOps);
        work.setParseContext(pCtx);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        work.setConfig(new ExplainConfiguration());
        new ExplainTask().getJSONLogicalPlan(new PrintStream((OutputStream)baos), work);
        baos.close();
        return baos.toString();
    }

    public static class DummyOperator
    extends TableScanOperator {
        private static final long serialVersionUID = 1L;

        public DummyOperator(TableScanDesc conf) {
            this.setConf((OperatorDesc)conf);
        }
    }

    public static class DummyExplainDesc<K, V>
    extends TableScanDesc {
        private static final long serialVersionUID = 1L;
        private Map<K, V> explainResult;

        public DummyExplainDesc(Map<K, V> explainResult) {
            this.explainResult = explainResult;
        }

        @Explain(displayName="test", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
        public Map<K, V> explainMethod() {
            return this.explainResult;
        }
    }
}

