/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.authorization;

import java.util.List;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.session.SessionState;

public class AuthorizationTestUtil {
    public static DDLWork analyze(ASTNode ast, QueryState queryState, Hive db) throws Exception {
        DDLSemanticAnalyzer analyzer = new DDLSemanticAnalyzer(queryState, db);
        SessionState.start((HiveConf)queryState.getConf());
        analyzer.analyze(ast, new Context((Configuration)queryState.getConf()));
        List rootTasks = analyzer.getRootTasks();
        return (DDLWork)((Task)AuthorizationTestUtil.inList(rootTasks).ofSize(1).get(0)).getWork();
    }

    public static DDLWork analyze(String command, QueryState queryState, Hive db) throws Exception {
        return AuthorizationTestUtil.analyze(AuthorizationTestUtil.parse(command, queryState.getConf()), queryState, db);
    }

    private static ASTNode parse(String command, HiveConf conf) throws Exception {
        return ParseUtils.parse((String)command, (HiveConf)conf);
    }

    public static <E> ListSizeMatcher<E> inList(List<E> list) {
        return new ListSizeMatcher(list);
    }

    public static class ListSizeMatcher<E> {
        private final List<E> list;

        private ListSizeMatcher(List<E> list) {
            this.list = list;
        }

        private List<E> ofSize(int size) {
            Assert.assertEquals((String)this.list.toString(), (int)size, (int)this.list.size());
            return this.list;
        }
    }
}

