/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.router;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectSortedMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hive.druid.com.google.common.base.Charsets;
import org.apache.hive.druid.com.google.common.hash.HashFunction;
import org.apache.hive.druid.com.google.common.hash.Hashing;

public class ConsistentHasher {
    private static final int REPLICATION_FACTOR = 128;
    private static final HashFunction DEFAULT_HASH_FN = Hashing.murmur3_128();
    private final Long2ObjectRBTreeMap<String> nodeKeySlots = new Long2ObjectRBTreeMap();
    private final HashFunction hashFn;
    private final Map<String, long[]> nodeKeyHashes;
    private Set<String> previousKeys;

    public ConsistentHasher(HashFunction hashFunction) {
        this.nodeKeySlots.defaultReturnValue(null);
        this.nodeKeyHashes = new HashMap<String, long[]>();
        this.previousKeys = new HashSet<String>();
        this.hashFn = hashFunction == null ? DEFAULT_HASH_FN : hashFunction;
    }

    public void updateKeys(Set<String> currentKeys) {
        HashSet<String> added = new HashSet<String>(currentKeys);
        added.removeAll(this.previousKeys);
        HashSet<String> removed = new HashSet<String>(this.previousKeys);
        removed.removeAll(currentKeys);
        for (String key : added) {
            this.addKey(key);
        }
        for (String key : removed) {
            this.removeKey(key);
        }
        this.previousKeys = new HashSet<String>(currentKeys);
    }

    public String findKey(byte[] obj) {
        if (this.nodeKeySlots.size() == 0) {
            return null;
        }
        long objHash = this.hashFn.hashBytes(obj).asLong();
        Long2ObjectSortedMap<String> subMap = this.nodeKeySlots.tailMap(objHash);
        if (subMap.isEmpty()) {
            return (String)((Long2ObjectMap.Entry)this.nodeKeySlots.long2ObjectEntrySet().first()).getValue();
        }
        Long2ObjectMap.Entry firstEntry = (Long2ObjectMap.Entry)subMap.long2ObjectEntrySet().first();
        return (String)firstEntry.getValue();
    }

    private void addKey(String key) {
        if (this.nodeKeyHashes.containsKey(key)) {
            return;
        }
        this.addNodeKeyHashes(key);
        this.addNodeKeySlots(key);
    }

    private void removeKey(String key) {
        if (!this.nodeKeyHashes.containsKey(key)) {
            return;
        }
        this.removeNodeKeySlots(key);
        this.removeNodeKeyHashes(key);
    }

    private void addNodeKeyHashes(String key) {
        long[] hashes = new long[128];
        for (int i = 0; i < 128; ++i) {
            String vnode = key + "-" + i;
            hashes[i] = this.hashFn.hashString(vnode, Charsets.UTF_8).asLong();
        }
        this.nodeKeyHashes.put(key, hashes);
    }

    private void addNodeKeySlots(String key) {
        long[] hashes;
        for (long hash : hashes = this.nodeKeyHashes.get(key)) {
            this.nodeKeySlots.put(hash, key);
        }
    }

    private void removeNodeKeyHashes(String key) {
        this.nodeKeyHashes.remove(key);
    }

    private void removeNodeKeySlots(String key) {
        long[] hashes;
        for (long hash : hashes = this.nodeKeyHashes.get(key)) {
            this.nodeKeySlots.remove(hash);
        }
    }
}

