/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server;

import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.io.druid.client.ServerViewUtil;
import org.apache.hive.druid.io.druid.client.TimelineServerView;
import org.apache.hive.druid.io.druid.guice.annotations.Json;
import org.apache.hive.druid.io.druid.guice.annotations.Smile;
import org.apache.hive.druid.io.druid.query.GenericQueryMetricsFactory;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.server.QueryLifecycleFactory;
import org.apache.hive.druid.io.druid.server.QueryManager;
import org.apache.hive.druid.io.druid.server.QueryResource;
import org.apache.hive.druid.io.druid.server.http.security.StateResourceFilter;
import org.apache.hive.druid.io.druid.server.security.AuthConfig;
import org.apache.hive.druid.io.druid.server.security.AuthorizerMapper;

@Path(value="/druid/v2/")
public class BrokerQueryResource
extends QueryResource {
    private final TimelineServerView brokerServerView;

    @Inject
    public BrokerQueryResource(QueryLifecycleFactory queryLifecycleFactory, @Json ObjectMapper jsonMapper, @Smile ObjectMapper smileMapper, QueryManager queryManager, AuthConfig authConfig, AuthorizerMapper authorizerMapper, GenericQueryMetricsFactory queryMetricsFactory, TimelineServerView brokerServerView) {
        super(queryLifecycleFactory, jsonMapper, smileMapper, queryManager, authConfig, authorizerMapper, queryMetricsFactory);
        this.brokerServerView = brokerServerView;
    }

    @POST
    @Path(value="/candidates")
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Consumes(value={"application/json", "application/x-jackson-smile", "application/smile"})
    @ResourceFilters(value={StateResourceFilter.class})
    public Response getQueryTargets(InputStream in, @QueryParam(value="pretty") String pretty, @QueryParam(value="numCandidates") @DefaultValue(value="-1") int numCandidates, @Context HttpServletRequest req) throws IOException {
        QueryResource.ResponseContext context = this.createContext(req.getContentType(), pretty != null);
        try {
            Query query = context.getObjectMapper().readValue(in, Query.class);
            return context.ok(ServerViewUtil.getTargetLocations(this.brokerServerView, query.getDataSource(), query.getIntervals(), numCandidates));
        }
        catch (Exception e) {
            return context.gotError(e);
        }
    }
}

