/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.virtual;

import javax.annotation.Nonnull;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.math.expr.Expr;
import org.apache.hive.druid.io.druid.math.expr.ExprEval;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.ColumnValueSelector;

public class ExpressionColumnValueSelector
implements ColumnValueSelector<ExprEval> {
    private final Expr.ObjectBinding bindings;
    private final Expr expression;

    public ExpressionColumnValueSelector(Expr expression, Expr.ObjectBinding bindings) {
        this.bindings = Preconditions.checkNotNull(bindings, "bindings");
        this.expression = Preconditions.checkNotNull(expression, "expression");
    }

    @Override
    public double getDouble() {
        return this.getObject().asDouble();
    }

    @Override
    public float getFloat() {
        return (float)this.getObject().asDouble();
    }

    @Override
    public long getLong() {
        return this.getObject().asLong();
    }

    @Override
    public Class<ExprEval> classOfObject() {
        return ExprEval.class;
    }

    @Override
    @Nonnull
    public ExprEval getObject() {
        return this.expression.eval(this.bindings);
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        inspector.visit("expression", this.expression);
        inspector.visit("bindings", this.bindings);
    }
}

