/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.realtime.appenderator;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.SegmentIdentifier;

public class Committed {
    private static final Committed NIL = new Committed(ImmutableMap.of(), null);
    private final ImmutableMap<String, Integer> hydrants;
    private final Object metadata;

    @JsonCreator
    public Committed(@JsonProperty(value="hydrants") Map<String, Integer> hydrants, @JsonProperty(value="metadata") Object metadata) {
        this.hydrants = ImmutableMap.copyOf(hydrants);
        this.metadata = metadata;
    }

    public static Committed create(Map<SegmentIdentifier, Integer> hydrants0, Object metadata) {
        ImmutableMap.Builder<String, Integer> hydrants = ImmutableMap.builder();
        for (Map.Entry<SegmentIdentifier, Integer> entry : hydrants0.entrySet()) {
            hydrants.put(entry.getKey().getIdentifierAsString(), entry.getValue());
        }
        return new Committed(hydrants.build(), metadata);
    }

    @JsonProperty
    public ImmutableMap<String, Integer> getHydrants() {
        return this.hydrants;
    }

    @JsonProperty
    public Object getMetadata() {
        return this.metadata;
    }

    public int getCommittedHydrants(String identifierAsString) {
        Integer committedHydrant = this.hydrants.get(identifierAsString);
        return committedHydrant == null ? 0 : committedHydrant;
    }

    public Committed without(String identifierAsString) {
        HashMap<String, Integer> newHydrants = Maps.newHashMap();
        newHydrants.putAll(this.hydrants);
        newHydrants.remove(identifierAsString);
        return new Committed(newHydrants, this.metadata);
    }

    public Committed with(Map<String, Integer> hydrantsToAdd) {
        HashMap<String, Integer> newHydrants = Maps.newHashMap();
        newHydrants.putAll(this.hydrants);
        newHydrants.putAll(hydrantsToAdd);
        return new Committed(newHydrants, this.metadata);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Committed committed = (Committed)o;
        return Objects.equals(this.hydrants, committed.hydrants) && Objects.equals(this.metadata, committed.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.hydrants, this.metadata);
    }

    public String toString() {
        return "Committed{hydrants=" + this.hydrants + ", metadata=" + this.metadata + '}';
    }

    public static Committed nil() {
        return NIL;
    }
}

