/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import com.google.inject.Inject;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.com.google.common.io.FileWriteMode;
import org.apache.hive.druid.com.google.common.io.Files;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.com.google.common.primitives.Longs;
import org.apache.hive.druid.io.druid.collections.CombiningIterable;
import org.apache.hive.druid.io.druid.io.ZeroCopyByteArrayOutputStream;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.java.util.common.ISE;
import org.apache.hive.druid.io.druid.java.util.common.JodaUtils;
import org.apache.hive.druid.io.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.io.druid.java.util.common.guava.FunctionalIterable;
import org.apache.hive.druid.io.druid.java.util.common.guava.MergeIterable;
import org.apache.hive.druid.io.druid.java.util.common.io.Closer;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.SmooshedWriter;
import org.apache.hive.druid.io.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.segment.BaseProgressIndicator;
import org.apache.hive.druid.io.druid.segment.DimensionHandler;
import org.apache.hive.druid.io.druid.segment.DimensionHandlerUtils;
import org.apache.hive.druid.io.druid.segment.DimensionMerger;
import org.apache.hive.druid.io.druid.segment.DimensionMergerV9;
import org.apache.hive.druid.io.druid.segment.DoubleColumnSerializer;
import org.apache.hive.druid.io.druid.segment.FloatColumnSerializer;
import org.apache.hive.druid.io.druid.segment.GenericColumnSerializer;
import org.apache.hive.druid.io.druid.segment.IndexIO;
import org.apache.hive.druid.io.druid.segment.IndexMerger;
import org.apache.hive.druid.io.druid.segment.IndexSpec;
import org.apache.hive.druid.io.druid.segment.IndexableAdapter;
import org.apache.hive.druid.io.druid.segment.LongColumnSerializer;
import org.apache.hive.druid.io.druid.segment.Metadata;
import org.apache.hive.druid.io.druid.segment.ProgressIndicator;
import org.apache.hive.druid.io.druid.segment.QueryableIndex;
import org.apache.hive.druid.io.druid.segment.QueryableIndexIndexableAdapter;
import org.apache.hive.druid.io.druid.segment.Rowboat;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilities;
import org.apache.hive.druid.io.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.hive.druid.io.druid.segment.column.ColumnDescriptor;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.CompressionFactory;
import org.apache.hive.druid.io.druid.segment.data.CompressionStrategy;
import org.apache.hive.druid.io.druid.segment.data.GenericIndexed;
import org.apache.hive.druid.io.druid.segment.data.Indexed;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndex;
import org.apache.hive.druid.io.druid.segment.incremental.IncrementalIndexAdapter;
import org.apache.hive.druid.io.druid.segment.loading.MMappedQueryableSegmentizerFactory;
import org.apache.hive.druid.io.druid.segment.serde.ComplexColumnPartSerde;
import org.apache.hive.druid.io.druid.segment.serde.ComplexMetricSerde;
import org.apache.hive.druid.io.druid.segment.serde.ComplexMetrics;
import org.apache.hive.druid.io.druid.segment.serde.DoubleGenericColumnPartSerde;
import org.apache.hive.druid.io.druid.segment.serde.FloatGenericColumnPartSerde;
import org.apache.hive.druid.io.druid.segment.serde.LongGenericColumnPartSerde;
import org.apache.hive.druid.io.druid.segment.writeout.SegmentWriteOutMedium;
import org.apache.hive.druid.io.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class IndexMergerV9
implements IndexMerger {
    private static final Logger log = new Logger(IndexMergerV9.class);
    private final ObjectMapper mapper;
    private final IndexIO indexIO;
    private final SegmentWriteOutMediumFactory defaultSegmentWriteOutMediumFactory;

    @Inject
    public IndexMergerV9(ObjectMapper mapper, IndexIO indexIO, SegmentWriteOutMediumFactory defaultSegmentWriteOutMediumFactory) {
        this.mapper = Preconditions.checkNotNull(mapper, "null ObjectMapper");
        this.indexIO = Preconditions.checkNotNull(indexIO, "null IndexIO");
        this.defaultSegmentWriteOutMediumFactory = Preconditions.checkNotNull(defaultSegmentWriteOutMediumFactory, "null SegmentWriteOutMediumFactory");
    }

    private File makeIndexFiles(List<IndexableAdapter> adapters, AggregatorFactory[] metricAggs, File outDir, ProgressIndicator progress, List<String> mergedDimensions, List<String> mergedMetrics, Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>> rowMergerFn, IndexSpec indexSpec, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) throws IOException {
        progress.start();
        progress.progress();
        List<Metadata> metadataList = Lists.transform(adapters, new Function<IndexableAdapter, Metadata>(){

            @Override
            public Metadata apply(IndexableAdapter input) {
                return input.getMetadata();
            }
        });
        Metadata segmentMetadata = null;
        if (metricAggs != null) {
            AggregatorFactory[] combiningMetricAggs = new AggregatorFactory[metricAggs.length];
            for (int i = 0; i < metricAggs.length; ++i) {
                combiningMetricAggs[i] = metricAggs[i].getCombiningFactory();
            }
            segmentMetadata = Metadata.merge(metadataList, combiningMetricAggs);
        } else {
            segmentMetadata = Metadata.merge(metadataList, null);
        }
        try (Closer closer = Closer.create();){
            FileSmoosher v9Smoosher = new FileSmoosher(outDir);
            FileUtils.forceMkdir((File)outDir);
            SegmentWriteOutMediumFactory omf = segmentWriteOutMediumFactory != null ? segmentWriteOutMediumFactory : this.defaultSegmentWriteOutMediumFactory;
            log.info("Using SegmentWriteOutMediumFactory[%s]", omf.getClass().getSimpleName());
            SegmentWriteOutMedium segmentWriteOutMedium = omf.makeSegmentWriteOutMedium(outDir);
            closer.register(segmentWriteOutMedium);
            long startTime = System.currentTimeMillis();
            Files.asByteSink(new File(outDir, "version.bin"), new FileWriteMode[0]).write(Ints.toByteArray(9));
            log.info("Completed version.bin in %,d millis.", System.currentTimeMillis() - startTime);
            progress.progress();
            startTime = System.currentTimeMillis();
            try (FileOutputStream fos = new FileOutputStream(new File(outDir, "factory.json"));){
                this.mapper.writeValue(fos, (Object)new MMappedQueryableSegmentizerFactory(this.indexIO));
            }
            log.info("Completed factory.json in %,d millis", System.currentTimeMillis() - startTime);
            progress.progress();
            TreeMap<String, ValueType> metricsValueTypes = Maps.newTreeMap(Comparators.naturalNullsFirst());
            TreeMap<String, String> metricTypeNames = Maps.newTreeMap(Comparators.naturalNullsFirst());
            ArrayList<ColumnCapabilitiesImpl> dimCapabilities = Lists.newArrayListWithCapacity(mergedDimensions.size());
            this.mergeCapabilities(adapters, mergedDimensions, metricsValueTypes, metricTypeNames, dimCapabilities);
            DimensionHandler[] handlers = this.makeDimensionHandlers(mergedDimensions, dimCapabilities);
            ArrayList<DimensionMerger> mergers = new ArrayList<DimensionMerger>();
            for (int i = 0; i < mergedDimensions.size(); ++i) {
                mergers.add(handlers[i].makeMerger(indexSpec, segmentWriteOutMedium, (ColumnCapabilities)dimCapabilities.get(i), progress));
            }
            progress.progress();
            startTime = System.currentTimeMillis();
            this.writeDimValueAndSetupDimConversion(adapters, progress, mergedDimensions, mergers);
            log.info("Completed dim conversions in %,d millis.", System.currentTimeMillis() - startTime);
            progress.progress();
            Iterable<Rowboat> theRows = this.makeRowIterable(adapters, mergedDimensions, mergedMetrics, rowMergerFn, handlers, mergers);
            LongColumnSerializer timeWriter = this.setupTimeWriter(segmentWriteOutMedium, indexSpec);
            ArrayList<GenericColumnSerializer> metWriters = this.setupMetricsWriters(segmentWriteOutMedium, mergedMetrics, metricsValueTypes, metricTypeNames, indexSpec);
            ArrayList<IntBuffer> rowNumConversions = Lists.newArrayListWithCapacity(adapters.size());
            this.mergeIndexesAndWriteColumns(adapters, progress, theRows, timeWriter, metWriters, rowNumConversions, mergers);
            String section = "build inverted index and columns";
            progress.startSection("build inverted index and columns");
            this.makeTimeColumn(v9Smoosher, progress, timeWriter);
            this.makeMetricsColumns(v9Smoosher, progress, mergedMetrics, metricsValueTypes, metricTypeNames, metWriters);
            for (int i = 0; i < mergedDimensions.size(); ++i) {
                DimensionMergerV9 merger = (DimensionMergerV9)mergers.get(i);
                merger.writeIndexes(rowNumConversions);
                if (merger.canSkip()) continue;
                ColumnDescriptor columnDesc = merger.makeColumnDescriptor();
                this.makeColumn(v9Smoosher, mergedDimensions.get(i), columnDesc);
            }
            progress.stopSection("build inverted index and columns");
            progress.progress();
            this.makeIndexBinary(v9Smoosher, adapters, outDir, mergedDimensions, mergedMetrics, progress, indexSpec, mergers);
            this.makeMetadataBinary(v9Smoosher, progress, segmentMetadata);
            v9Smoosher.close();
            progress.stop();
            File file = outDir;
            return file;
        }
    }

    private void makeMetadataBinary(FileSmoosher v9Smoosher, ProgressIndicator progress, Metadata segmentMetadata) throws IOException {
        if (segmentMetadata != null) {
            progress.startSection("make metadata.drd");
            v9Smoosher.add("metadata.drd", ByteBuffer.wrap(this.mapper.writeValueAsBytes(segmentMetadata)));
            progress.stopSection("make metadata.drd");
        }
    }

    private void makeIndexBinary(FileSmoosher v9Smoosher, List<IndexableAdapter> adapters, File outDir, List<String> mergedDimensions, List<String> mergedMetrics, ProgressIndicator progress, IndexSpec indexSpec, List<DimensionMerger> mergers) throws IOException {
        String section = "make index.drd";
        progress.startSection("make index.drd");
        long startTime = System.currentTimeMillis();
        LinkedHashSet<String> finalDimensions = Sets.newLinkedHashSet();
        LinkedHashSet<String> finalColumns = Sets.newLinkedHashSet();
        finalColumns.addAll(mergedMetrics);
        for (int i = 0; i < mergedDimensions.size(); ++i) {
            if (mergers.get(i).canSkip()) continue;
            finalColumns.add(mergedDimensions.get(i));
            finalDimensions.add(mergedDimensions.get(i));
        }
        GenericIndexed<String> cols = GenericIndexed.fromIterable(finalColumns, GenericIndexed.STRING_STRATEGY);
        GenericIndexed<String> dims = GenericIndexed.fromIterable(finalDimensions, GenericIndexed.STRING_STRATEGY);
        String bitmapSerdeFactoryType = this.mapper.writeValueAsString(indexSpec.getBitmapSerdeFactory());
        long numBytes = cols.getSerializedSize() + dims.getSerializedSize() + 16L + (long)serializerUtils.getSerializedStringByteSize(bitmapSerdeFactoryType);
        SmooshedWriter writer = v9Smoosher.addWithSmooshedWriter("index.drd", numBytes);
        cols.writeTo(writer, v9Smoosher);
        dims.writeTo(writer, v9Smoosher);
        DateTime minTime = DateTimes.MAX;
        DateTime maxTime = DateTimes.MIN;
        for (IndexableAdapter index : adapters) {
            minTime = JodaUtils.minDateTime(minTime, index.getDataInterval().getStart());
            maxTime = JodaUtils.maxDateTime(maxTime, index.getDataInterval().getEnd());
        }
        Interval dataInterval = new Interval((ReadableInstant)minTime, (ReadableInstant)maxTime);
        serializerUtils.writeLong(writer, dataInterval.getStartMillis());
        serializerUtils.writeLong(writer, dataInterval.getEndMillis());
        serializerUtils.writeString(writer, bitmapSerdeFactoryType);
        writer.close();
        IndexIO.checkFileSize(new File(outDir, "index.drd"));
        log.info("Completed index.drd in %,d millis.", System.currentTimeMillis() - startTime);
        progress.stopSection("make index.drd");
    }

    private void makeMetricsColumns(FileSmoosher v9Smoosher, ProgressIndicator progress, List<String> mergedMetrics, Map<String, ValueType> metricsValueTypes, Map<String, String> metricTypeNames, List<GenericColumnSerializer> metWriters) throws IOException {
        String section = "make metric columns";
        progress.startSection("make metric columns");
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < mergedMetrics.size(); ++i) {
            String metric = mergedMetrics.get(i);
            long metricStartTime = System.currentTimeMillis();
            GenericColumnSerializer writer = metWriters.get(i);
            ColumnDescriptor.Builder builder = ColumnDescriptor.builder();
            ValueType type = metricsValueTypes.get(metric);
            switch (type) {
                case LONG: {
                    builder.setValueType(ValueType.LONG);
                    builder.addSerde(LongGenericColumnPartSerde.serializerBuilder().withByteOrder(IndexIO.BYTE_ORDER).withDelegate((LongColumnSerializer)writer).build());
                    break;
                }
                case FLOAT: {
                    builder.setValueType(ValueType.FLOAT);
                    builder.addSerde(FloatGenericColumnPartSerde.serializerBuilder().withByteOrder(IndexIO.BYTE_ORDER).withDelegate((FloatColumnSerializer)writer).build());
                    break;
                }
                case DOUBLE: {
                    builder.setValueType(ValueType.DOUBLE);
                    builder.addSerde(DoubleGenericColumnPartSerde.serializerBuilder().withByteOrder(IndexIO.BYTE_ORDER).withDelegate((DoubleColumnSerializer)writer).build());
                    break;
                }
                case COMPLEX: {
                    String typeName = metricTypeNames.get(metric);
                    builder.setValueType(ValueType.COMPLEX);
                    builder.addSerde(ComplexColumnPartSerde.serializerBuilder().withTypeName(typeName).withDelegate(writer).build());
                    break;
                }
                default: {
                    throw new ISE("Unknown type[%s]", new Object[]{type});
                }
            }
            this.makeColumn(v9Smoosher, metric, builder.build());
            log.info("Completed metric column[%s] in %,d millis.", metric, System.currentTimeMillis() - metricStartTime);
        }
        log.info("Completed metric columns in %,d millis.", System.currentTimeMillis() - startTime);
        progress.stopSection("make metric columns");
    }

    private void makeTimeColumn(FileSmoosher v9Smoosher, ProgressIndicator progress, LongColumnSerializer timeWriter) throws IOException {
        String section = "make time column";
        progress.startSection("make time column");
        long startTime = System.currentTimeMillis();
        ColumnDescriptor serdeficator = ColumnDescriptor.builder().setValueType(ValueType.LONG).addSerde(LongGenericColumnPartSerde.serializerBuilder().withByteOrder(IndexIO.BYTE_ORDER).withDelegate(timeWriter).build()).build();
        this.makeColumn(v9Smoosher, "__time", serdeficator);
        log.info("Completed time column in %,d millis.", System.currentTimeMillis() - startTime);
        progress.stopSection("make time column");
    }

    private void makeColumn(FileSmoosher v9Smoosher, String columnName, ColumnDescriptor serdeficator) throws IOException {
        ZeroCopyByteArrayOutputStream specBytes = new ZeroCopyByteArrayOutputStream();
        serializerUtils.writeString(specBytes, this.mapper.writeValueAsString(serdeficator));
        try (SmooshedWriter channel = v9Smoosher.addWithSmooshedWriter(columnName, (long)specBytes.size() + serdeficator.getSerializedSize());){
            specBytes.writeTo(channel);
            serdeficator.writeTo(channel, v9Smoosher);
        }
    }

    private void mergeIndexesAndWriteColumns(List<IndexableAdapter> adapters, ProgressIndicator progress, Iterable<Rowboat> theRows, LongColumnSerializer timeWriter, ArrayList<GenericColumnSerializer> metWriters, List<IntBuffer> rowNumConversions, List<DimensionMerger> mergers) throws IOException {
        String section = "walk through and merge rows";
        progress.startSection("walk through and merge rows");
        long startTime = System.currentTimeMillis();
        int rowCount = 0;
        for (IndexableAdapter adapter : adapters) {
            int[] arr = new int[adapter.getNumRows()];
            Arrays.fill(arr, -1);
            rowNumConversions.add(IntBuffer.wrap(arr));
        }
        long time = System.currentTimeMillis();
        for (Rowboat theRow : theRows) {
            progress.progress();
            timeWriter.serialize(theRow.getTimestamp());
            Object[] metrics = theRow.getMetrics();
            for (int i = 0; i < metrics.length; ++i) {
                metWriters.get(i).serialize(metrics[i]);
            }
            Object[] dims = theRow.getDims();
            for (int i = 0; i < dims.length; ++i) {
                DimensionMerger merger = mergers.get(i);
                if (merger.canSkip()) continue;
                merger.processMergedRow(dims[i]);
            }
            ObjectIterator rowsIterator = theRow.getComprisedRows().int2ObjectEntrySet().fastIterator();
            while (rowsIterator.hasNext()) {
                Int2ObjectMap.Entry comprisedRow = (Int2ObjectMap.Entry)rowsIterator.next();
                IntBuffer conversionBuffer = rowNumConversions.get(comprisedRow.getIntKey());
                IntBidirectionalIterator setIterator = ((IntSortedSet)comprisedRow.getValue()).iterator();
                while (setIterator.hasNext()) {
                    int rowNum = setIterator.nextInt();
                    while (conversionBuffer.position() < rowNum) {
                        conversionBuffer.put(-1);
                    }
                    conversionBuffer.put(rowCount);
                }
            }
            if (++rowCount % 500000 != 0) continue;
            log.info("walked 500,000/%d rows in %,d millis.", rowCount, System.currentTimeMillis() - time);
            time = System.currentTimeMillis();
        }
        for (IntBuffer rowNumConversion : rowNumConversions) {
            rowNumConversion.rewind();
        }
        log.info("completed walk through of %,d rows in %,d millis.", rowCount, System.currentTimeMillis() - startTime);
        progress.stopSection("walk through and merge rows");
    }

    private LongColumnSerializer setupTimeWriter(SegmentWriteOutMedium segmentWriteOutMedium, IndexSpec indexSpec) throws IOException {
        LongColumnSerializer timeWriter = LongColumnSerializer.create(segmentWriteOutMedium, "little_end_time", CompressionStrategy.DEFAULT_COMPRESSION_STRATEGY, indexSpec.getLongEncoding());
        timeWriter.open();
        return timeWriter;
    }

    private ArrayList<GenericColumnSerializer> setupMetricsWriters(SegmentWriteOutMedium segmentWriteOutMedium, List<String> mergedMetrics, Map<String, ValueType> metricsValueTypes, Map<String, String> metricTypeNames, IndexSpec indexSpec) throws IOException {
        ArrayList<GenericColumnSerializer> metWriters = Lists.newArrayListWithCapacity(mergedMetrics.size());
        CompressionStrategy metCompression = indexSpec.getMetricCompression();
        CompressionFactory.LongEncodingStrategy longEncoding = indexSpec.getLongEncoding();
        for (String metric : mergedMetrics) {
            GenericColumnSerializer writer;
            ValueType type = metricsValueTypes.get(metric);
            switch (type) {
                case LONG: {
                    writer = LongColumnSerializer.create(segmentWriteOutMedium, metric, metCompression, longEncoding);
                    break;
                }
                case FLOAT: {
                    writer = FloatColumnSerializer.create(segmentWriteOutMedium, metric, metCompression);
                    break;
                }
                case DOUBLE: {
                    writer = DoubleColumnSerializer.create(segmentWriteOutMedium, metric, metCompression);
                    break;
                }
                case COMPLEX: {
                    String typeName = metricTypeNames.get(metric);
                    ComplexMetricSerde serde = ComplexMetrics.getSerdeForType(typeName);
                    if (serde == null) {
                        throw new ISE("Unknown type[%s]", typeName);
                    }
                    writer = serde.getSerializer(segmentWriteOutMedium, metric);
                    break;
                }
                default: {
                    throw new ISE("Unknown type[%s]", new Object[]{type});
                }
            }
            writer.open();
            metWriters.add(writer);
        }
        return metWriters;
    }

    private void writeDimValueAndSetupDimConversion(List<IndexableAdapter> indexes, ProgressIndicator progress, List<String> mergedDimensions, List<DimensionMerger> mergers) throws IOException {
        String section = "setup dimension conversions";
        progress.startSection("setup dimension conversions");
        for (int dimIndex = 0; dimIndex < mergedDimensions.size(); ++dimIndex) {
            mergers.get(dimIndex).writeMergedValueMetadata(indexes);
        }
        progress.stopSection("setup dimension conversions");
    }

    private void mergeCapabilities(List<IndexableAdapter> adapters, List<String> mergedDimensions, Map<String, ValueType> metricsValueTypes, Map<String, String> metricTypeNames, List<ColumnCapabilitiesImpl> dimCapabilities) {
        HashMap<String, ColumnCapabilitiesImpl> capabilitiesMap = Maps.newHashMap();
        for (IndexableAdapter adapter : adapters) {
            ColumnCapabilitiesImpl mergedCapabilities;
            for (String dimension : adapter.getDimensionNames()) {
                mergedCapabilities = (ColumnCapabilitiesImpl)capabilitiesMap.get(dimension);
                if (mergedCapabilities == null) {
                    mergedCapabilities = new ColumnCapabilitiesImpl();
                    mergedCapabilities.setType(null);
                }
                capabilitiesMap.put(dimension, mergedCapabilities.merge(adapter.getCapabilities(dimension)));
            }
            for (String metric : adapter.getMetricNames()) {
                mergedCapabilities = (ColumnCapabilitiesImpl)capabilitiesMap.get(metric);
                ColumnCapabilities capabilities = adapter.getCapabilities(metric);
                if (mergedCapabilities == null) {
                    mergedCapabilities = new ColumnCapabilitiesImpl();
                }
                capabilitiesMap.put(metric, mergedCapabilities.merge(capabilities));
                metricsValueTypes.put(metric, capabilities.getType());
                metricTypeNames.put(metric, adapter.getMetricType(metric));
            }
        }
        for (String dim : mergedDimensions) {
            dimCapabilities.add((ColumnCapabilitiesImpl)capabilitiesMap.get(dim));
        }
    }

    @Override
    public File persist(IncrementalIndex index, File outDir, IndexSpec indexSpec, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) throws IOException {
        return this.persist(index, index.getInterval(), outDir, indexSpec, segmentWriteOutMediumFactory);
    }

    @Override
    public File persist(IncrementalIndex index, Interval dataInterval, File outDir, IndexSpec indexSpec, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) throws IOException {
        return this.persist(index, dataInterval, outDir, indexSpec, new BaseProgressIndicator(), segmentWriteOutMediumFactory);
    }

    @Override
    public File persist(IncrementalIndex index, Interval dataInterval, File outDir, IndexSpec indexSpec, ProgressIndicator progress, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) throws IOException {
        if (index.isEmpty()) {
            throw new IAE("Trying to persist an empty index!", new Object[0]);
        }
        DateTime firstTimestamp = index.getMinTime();
        DateTime lastTimestamp = index.getMaxTime();
        if (!dataInterval.contains((ReadableInstant)firstTimestamp) || !dataInterval.contains((ReadableInstant)lastTimestamp)) {
            throw new IAE("interval[%s] does not encapsulate the full range of timestamps[%s, %s]", dataInterval, firstTimestamp, lastTimestamp);
        }
        FileUtils.forceMkdir((File)outDir);
        log.info("Starting persist for interval[%s], rows[%,d]", dataInterval, index.size());
        return this.merge(Arrays.asList(new IncrementalIndexAdapter(dataInterval, index, indexSpec.getBitmapSerdeFactory().getBitmapFactory())), false, index.getMetricAggs(), outDir, indexSpec, progress, segmentWriteOutMediumFactory);
    }

    @Override
    public File mergeQueryableIndex(List<QueryableIndex> indexes, boolean rollup, AggregatorFactory[] metricAggs, File outDir, IndexSpec indexSpec, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) throws IOException {
        return this.mergeQueryableIndex(indexes, rollup, metricAggs, outDir, indexSpec, new BaseProgressIndicator(), segmentWriteOutMediumFactory);
    }

    @Override
    public File mergeQueryableIndex(List<QueryableIndex> indexes, boolean rollup, AggregatorFactory[] metricAggs, File outDir, IndexSpec indexSpec, ProgressIndicator progress, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) throws IOException {
        return this.merge(IndexMerger.toIndexableAdapters(indexes), rollup, metricAggs, outDir, indexSpec, progress, segmentWriteOutMediumFactory);
    }

    @Override
    public File merge(List<IndexableAdapter> indexes, boolean rollup, AggregatorFactory[] metricAggs, File outDir, IndexSpec indexSpec) throws IOException {
        return this.merge(indexes, rollup, metricAggs, outDir, indexSpec, new BaseProgressIndicator(), null);
    }

    private File merge(List<IndexableAdapter> indexes, final boolean rollup, AggregatorFactory[] metricAggs, File outDir, IndexSpec indexSpec, ProgressIndicator progress, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) throws IOException {
        int i;
        FileUtils.deleteDirectory((File)outDir);
        FileUtils.forceMkdir((File)outDir);
        List<String> mergedDimensions = IndexMerger.getMergedDimensions(indexes);
        List<String> mergedMetrics = Lists.transform(IndexMerger.mergeIndexed(Lists.newArrayList(FunctionalIterable.create(indexes).transform(new Function<IndexableAdapter, Iterable<String>>(){

            @Override
            public Iterable<String> apply(@Nullable IndexableAdapter input) {
                return input.getMetricNames();
            }
        }))), new Function<String, String>(){

            @Override
            public String apply(@Nullable String input) {
                return input;
            }
        });
        final AggregatorFactory[] sortedMetricAggs = new AggregatorFactory[mergedMetrics.size()];
        for (AggregatorFactory metricAgg : metricAggs) {
            int metricIndex = mergedMetrics.indexOf(metricAgg.getName());
            if (metricIndex <= -1) continue;
            sortedMetricAggs[metricIndex] = metricAgg;
        }
        for (i = 0; i < sortedMetricAggs.length; ++i) {
            if (sortedMetricAggs[i] != null) continue;
            throw new IAE("Indices to merge contained metric[%s], but requested metrics did not", mergedMetrics.get(i));
        }
        for (i = 0; i < mergedMetrics.size(); ++i) {
            if (sortedMetricAggs[i].getName().equals(mergedMetrics.get(i))) continue;
            throw new IAE("Metric mismatch, index[%d] [%s] != [%s]", i, sortedMetricAggs[i].getName(), mergedMetrics.get(i));
        }
        Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>> rowMergerFn = new Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>>(){

            @Override
            public Iterable<Rowboat> apply(@Nullable ArrayList<Iterable<Rowboat>> boats) {
                if (rollup) {
                    return CombiningIterable.create(new MergeIterable(Comparators.naturalNullsFirst(), boats), Comparators.naturalNullsFirst(), new IndexMerger.RowboatMergeFunction(sortedMetricAggs));
                }
                return new MergeIterable<Rowboat>(new Ordering<Rowboat>(){

                    @Override
                    public int compare(Rowboat left, Rowboat right) {
                        return Longs.compare(left.getTimestamp(), right.getTimestamp());
                    }
                }.nullsFirst(), boats);
            }
        };
        return this.makeIndexFiles(indexes, sortedMetricAggs, outDir, progress, mergedDimensions, mergedMetrics, rowMergerFn, indexSpec, segmentWriteOutMediumFactory);
    }

    @Override
    public File convert(File inDir, File outDir, IndexSpec indexSpec) throws IOException {
        return this.convert(inDir, outDir, indexSpec, new BaseProgressIndicator(), this.defaultSegmentWriteOutMediumFactory);
    }

    @Override
    public File convert(File inDir, File outDir, IndexSpec indexSpec, ProgressIndicator progress, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) throws IOException {
        try (QueryableIndex index = this.indexIO.loadIndex(inDir);){
            QueryableIndexIndexableAdapter adapter = new QueryableIndexIndexableAdapter(index);
            File file = this.makeIndexFiles(ImmutableList.of(adapter), null, outDir, progress, Lists.newArrayList(adapter.getDimensionNames()), Lists.newArrayList(adapter.getMetricNames()), new Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>>(){

                @Override
                @Nullable
                public Iterable<Rowboat> apply(ArrayList<Iterable<Rowboat>> input) {
                    return input.get(0);
                }
            }, indexSpec, segmentWriteOutMediumFactory);
            return file;
        }
    }

    @Override
    public File append(List<IndexableAdapter> indexes, AggregatorFactory[] aggregators, File outDir, IndexSpec indexSpec, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) throws IOException {
        FileUtils.deleteDirectory((File)outDir);
        FileUtils.forceMkdir((File)outDir);
        List<String> mergedDimensions = IndexMerger.getMergedDimensions(indexes);
        ArrayList<String> mergedMetrics = IndexMerger.mergeIndexed(Lists.transform(indexes, new Function<IndexableAdapter, Iterable<String>>(){

            @Override
            public Iterable<String> apply(@Nullable IndexableAdapter input) {
                return Iterables.transform(input.getMetricNames(), new Function<String, String>(){

                    @Override
                    public String apply(@Nullable String input) {
                        return input;
                    }
                });
            }
        }));
        Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>> rowMergerFn = new Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>>(){

            @Override
            public Iterable<Rowboat> apply(@Nullable ArrayList<Iterable<Rowboat>> boats) {
                return new MergeIterable<Rowboat>(Comparators.naturalNullsFirst(), boats);
            }
        };
        return this.makeIndexFiles(indexes, aggregators, outDir, new BaseProgressIndicator(), mergedDimensions, mergedMetrics, rowMergerFn, indexSpec, segmentWriteOutMediumFactory);
    }

    private DimensionHandler[] makeDimensionHandlers(List<String> mergedDimensions, List<ColumnCapabilitiesImpl> dimCapabilities) {
        DimensionHandler[] handlers = new DimensionHandler[mergedDimensions.size()];
        for (int i = 0; i < mergedDimensions.size(); ++i) {
            ColumnCapabilities capabilities = dimCapabilities.get(i);
            String dimName = mergedDimensions.get(i);
            handlers[i] = DimensionHandlerUtils.getHandlerFromCapabilities(dimName, capabilities, null);
        }
        return handlers;
    }

    private Iterable<Rowboat> makeRowIterable(List<IndexableAdapter> indexes, final List<String> mergedDimensions, final List<String> mergedMetrics, Function<ArrayList<Iterable<Rowboat>>, Iterable<Rowboat>> rowMergerFn, final DimensionHandler[] handlers, List<DimensionMerger> mergers) {
        ArrayList<IndexMerger.MMappedIndexRowIterable> boats = Lists.newArrayListWithCapacity(indexes.size());
        for (int i = 0; i < indexes.size(); ++i) {
            IndexableAdapter adapter = indexes.get(i);
            final int[] dimLookup = this.getColumnIndexReorderingMap(adapter.getDimensionNames(), mergedDimensions);
            final int[] metricLookup = this.getColumnIndexReorderingMap(adapter.getMetricNames(), mergedMetrics);
            Iterable<Rowboat> target = indexes.get(i).getRows();
            if (dimLookup != null || metricLookup != null) {
                target = Iterables.transform(target, new Function<Rowboat, Rowboat>(){

                    @Override
                    public Rowboat apply(Rowboat input) {
                        int n;
                        Object[] newDims;
                        if (dimLookup != null) {
                            newDims = new Object[mergedDimensions.size()];
                            int j = 0;
                            Object[] objectArray = input.getDims();
                            int n2 = objectArray.length;
                            for (n = 0; n < n2; ++n) {
                                Object dim;
                                newDims[dimLookup[j]] = dim = objectArray[n];
                                ++j;
                            }
                        } else {
                            newDims = input.getDims();
                        }
                        Object[] newMetrics = input.getMetrics();
                        if (metricLookup != null) {
                            newMetrics = new Object[mergedMetrics.size()];
                            int j = 0;
                            Object[] objectArray = input.getMetrics();
                            n = objectArray.length;
                            for (int i = 0; i < n; ++i) {
                                Object met;
                                newMetrics[metricLookup[j]] = met = objectArray[i];
                                ++j;
                            }
                        }
                        return new Rowboat(input.getTimestamp(), newDims, newMetrics, input.getRowNum(), handlers);
                    }
                });
            }
            boats.add(new IndexMerger.MMappedIndexRowIterable(target, mergedDimensions, i, mergers));
        }
        return rowMergerFn.apply(boats);
    }

    private int[] getColumnIndexReorderingMap(Indexed<String> adapterColumnNames, List<String> mergedColumnNames) {
        if (this.isSame(adapterColumnNames, mergedColumnNames)) {
            return null;
        }
        int[] dimLookup = new int[mergedColumnNames.size()];
        for (int i = 0; i < adapterColumnNames.size(); ++i) {
            dimLookup[i] = mergedColumnNames.indexOf(adapterColumnNames.get(i));
        }
        return dimLookup;
    }

    private boolean isSame(Indexed<String> indexed, List<String> values) {
        if (indexed.size() != values.size()) {
            return false;
        }
        for (int i = 0; i < indexed.size(); ++i) {
            if (indexed.get(i).equals(values.get(i))) continue;
            return false;
        }
        return true;
    }
}

