/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.io.IOException;
import java.nio.IntBuffer;
import java.util.List;
import org.apache.hive.druid.io.druid.segment.DimensionMergerV9;
import org.apache.hive.druid.io.druid.segment.FloatColumnSerializer;
import org.apache.hive.druid.io.druid.segment.IndexIO;
import org.apache.hive.druid.io.druid.segment.IndexSpec;
import org.apache.hive.druid.io.druid.segment.IndexableAdapter;
import org.apache.hive.druid.io.druid.segment.column.ColumnDescriptor;
import org.apache.hive.druid.io.druid.segment.column.ValueType;
import org.apache.hive.druid.io.druid.segment.data.CompressionStrategy;
import org.apache.hive.druid.io.druid.segment.serde.FloatGenericColumnPartSerde;
import org.apache.hive.druid.io.druid.segment.writeout.SegmentWriteOutMedium;

public class FloatDimensionMergerV9
implements DimensionMergerV9<Float> {
    protected String dimensionName;
    protected final IndexSpec indexSpec;
    private FloatColumnSerializer serializer;

    public FloatDimensionMergerV9(String dimensionName, IndexSpec indexSpec, SegmentWriteOutMedium segmentWriteOutMedium) {
        this.dimensionName = dimensionName;
        this.indexSpec = indexSpec;
        try {
            this.setupEncodedValueWriter(segmentWriteOutMedium);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private void setupEncodedValueWriter(SegmentWriteOutMedium segmentWriteOutMedium) throws IOException {
        CompressionStrategy metCompression = this.indexSpec.getMetricCompression();
        this.serializer = FloatColumnSerializer.create(segmentWriteOutMedium, this.dimensionName, metCompression);
        this.serializer.open();
    }

    @Override
    public void writeMergedValueMetadata(List<IndexableAdapter> adapters) throws IOException {
    }

    @Override
    public Float convertSegmentRowValuesToMergedRowValues(Float segmentRow, int segmentIndexNumber) {
        return segmentRow;
    }

    @Override
    public void processMergedRow(Float rowValues) throws IOException {
        this.serializer.serialize(rowValues);
    }

    @Override
    public void writeIndexes(List<IntBuffer> segmentRowNumConversions) throws IOException {
    }

    @Override
    public boolean canSkip() {
        return false;
    }

    @Override
    public ColumnDescriptor makeColumnDescriptor() throws IOException {
        ColumnDescriptor.Builder builder = ColumnDescriptor.builder();
        builder.setValueType(ValueType.FLOAT);
        builder.addSerde(FloatGenericColumnPartSerde.serializerBuilder().withByteOrder(IndexIO.BYTE_ORDER).withDelegate(this.serializer).build());
        return builder.build();
    }
}

