/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment;

import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.hive.druid.io.druid.segment.GenericColumnSerializer;
import org.apache.hive.druid.io.druid.segment.IndexIO;
import org.apache.hive.druid.io.druid.segment.data.ColumnarFloatsSerializer;
import org.apache.hive.druid.io.druid.segment.data.CompressionFactory;
import org.apache.hive.druid.io.druid.segment.data.CompressionStrategy;
import org.apache.hive.druid.io.druid.segment.writeout.SegmentWriteOutMedium;

public class FloatColumnSerializer
implements GenericColumnSerializer {
    private final SegmentWriteOutMedium segmentWriteOutMedium;
    private final String filenameBase;
    private final ByteOrder byteOrder;
    private final CompressionStrategy compression;
    private ColumnarFloatsSerializer writer;

    public static FloatColumnSerializer create(SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, CompressionStrategy compression) {
        return new FloatColumnSerializer(segmentWriteOutMedium, filenameBase, IndexIO.BYTE_ORDER, compression);
    }

    private FloatColumnSerializer(SegmentWriteOutMedium segmentWriteOutMedium, String filenameBase, ByteOrder byteOrder, CompressionStrategy compression) {
        this.segmentWriteOutMedium = segmentWriteOutMedium;
        this.filenameBase = filenameBase;
        this.byteOrder = byteOrder;
        this.compression = compression;
    }

    @Override
    public void open() throws IOException {
        this.writer = CompressionFactory.getFloatSerializer(this.segmentWriteOutMedium, StringUtils.format("%s.float_column", this.filenameBase), this.byteOrder, this.compression);
        this.writer.open();
    }

    @Override
    public void serialize(Object obj) throws IOException {
        float val = obj == null ? 0.0f : ((Number)obj).floatValue();
        this.writer.add(val);
    }

    @Override
    public long getSerializedSize() throws IOException {
        return this.writer.getSerializedSize();
    }

    @Override
    public void writeTo(WritableByteChannel channel, FileSmoosher smoosher) throws IOException {
        this.writer.writeTo(channel, smoosher);
    }
}

