/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.select;

import com.google.inject.Inject;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Functions;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.base.Supplier;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.google.common.collect.Ordering;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.io.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.nary.BinaryFn;
import org.apache.hive.druid.io.druid.query.CacheStrategy;
import org.apache.hive.druid.io.druid.query.IntervalChunkingQueryRunnerDecorator;
import org.apache.hive.druid.io.druid.query.Query;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.QueryToolChest;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.ResultGranularTimestampComparator;
import org.apache.hive.druid.io.druid.query.ResultMergeQueryRunner;
import org.apache.hive.druid.io.druid.query.aggregation.MetricManipulationFn;
import org.apache.hive.druid.io.druid.query.dimension.DimensionSpec;
import org.apache.hive.druid.io.druid.query.filter.DimFilter;
import org.apache.hive.druid.io.druid.query.select.DefaultSelectQueryMetricsFactory;
import org.apache.hive.druid.io.druid.query.select.EventHolder;
import org.apache.hive.druid.io.druid.query.select.PagingSpec;
import org.apache.hive.druid.io.druid.query.select.SelectBinaryFn;
import org.apache.hive.druid.io.druid.query.select.SelectQuery;
import org.apache.hive.druid.io.druid.query.select.SelectQueryConfig;
import org.apache.hive.druid.io.druid.query.select.SelectQueryMetrics;
import org.apache.hive.druid.io.druid.query.select.SelectQueryMetricsFactory;
import org.apache.hive.druid.io.druid.query.select.SelectResultValue;
import org.apache.hive.druid.io.druid.timeline.DataSegmentUtils;
import org.apache.hive.druid.io.druid.timeline.LogicalSegment;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class SelectQueryQueryToolChest
extends QueryToolChest<Result<SelectResultValue>, SelectQuery> {
    private static final byte SELECT_QUERY = 22;
    private static final TypeReference<Object> OBJECT_TYPE_REFERENCE = new TypeReference<Object>(){};
    private static final TypeReference<Result<SelectResultValue>> TYPE_REFERENCE = new TypeReference<Result<SelectResultValue>>(){};
    private final ObjectMapper jsonMapper;
    private final IntervalChunkingQueryRunnerDecorator intervalChunkingQueryRunnerDecorator;
    private final SelectQueryMetricsFactory queryMetricsFactory;

    public SelectQueryQueryToolChest(ObjectMapper jsonMapper, IntervalChunkingQueryRunnerDecorator intervalChunkingQueryRunnerDecorator, Supplier<SelectQueryConfig> configSupplier) {
        this(jsonMapper, intervalChunkingQueryRunnerDecorator, configSupplier, DefaultSelectQueryMetricsFactory.instance());
    }

    @Inject
    public SelectQueryQueryToolChest(ObjectMapper jsonMapper, IntervalChunkingQueryRunnerDecorator intervalChunkingQueryRunnerDecorator, Supplier<SelectQueryConfig> configSupplier, SelectQueryMetricsFactory queryMetricsFactory) {
        this.jsonMapper = jsonMapper;
        this.intervalChunkingQueryRunnerDecorator = intervalChunkingQueryRunnerDecorator;
        this.queryMetricsFactory = queryMetricsFactory;
    }

    @Override
    public QueryRunner<Result<SelectResultValue>> mergeResults(QueryRunner<Result<SelectResultValue>> queryRunner) {
        return new ResultMergeQueryRunner<Result<SelectResultValue>>(queryRunner){

            @Override
            protected Ordering<Result<SelectResultValue>> makeOrdering(Query<Result<SelectResultValue>> query) {
                return ResultGranularTimestampComparator.create(((SelectQuery)query).getGranularity(), query.isDescending());
            }

            @Override
            protected BinaryFn<Result<SelectResultValue>, Result<SelectResultValue>, Result<SelectResultValue>> createMergeFn(Query<Result<SelectResultValue>> input) {
                SelectQuery query = (SelectQuery)input;
                return new SelectBinaryFn(query.getGranularity(), query.getPagingSpec(), query.isDescending());
            }
        };
    }

    public SelectQueryMetrics makeMetrics(SelectQuery query) {
        SelectQueryMetrics queryMetrics = this.queryMetricsFactory.makeMetrics(query);
        queryMetrics.query(query);
        return queryMetrics;
    }

    @Override
    public Function<Result<SelectResultValue>, Result<SelectResultValue>> makePreComputeManipulatorFn(SelectQuery query, MetricManipulationFn fn) {
        return Functions.identity();
    }

    @Override
    public TypeReference<Result<SelectResultValue>> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public CacheStrategy<Result<SelectResultValue>, Object, SelectQuery> getCacheStrategy(final SelectQuery query) {
        return new CacheStrategy<Result<SelectResultValue>, Object, SelectQuery>(){
            private final List<DimensionSpec> dimensionSpecs;
            private final List<String> dimOutputNames;
            {
                this.dimensionSpecs = query.getDimensions() != null ? query.getDimensions() : Collections.emptyList();
                this.dimOutputNames = this.dimensionSpecs.size() > 0 ? Lists.transform(this.dimensionSpecs, DimensionSpec::getOutputName) : Collections.emptyList();
            }

            @Override
            public boolean isCacheable(SelectQuery query2, boolean willMergeRunners) {
                return true;
            }

            @Override
            public byte[] computeCacheKey(SelectQuery query2) {
                DimFilter dimFilter = query2.getDimensionsFilter();
                byte[] filterBytes = dimFilter == null ? new byte[]{} : dimFilter.getCacheKey();
                byte[] granularityBytes = query2.getGranularity().getCacheKey();
                List<Object> dimensionSpecs = query2.getDimensions() != null ? query2.getDimensions() : Collections.emptyList();
                byte[][] dimensionsBytes = new byte[dimensionSpecs.size()][];
                int dimensionsBytesSize = 0;
                int index = 0;
                for (DimensionSpec dimensionSpec : dimensionSpecs) {
                    dimensionsBytes[index] = dimensionSpec.getCacheKey();
                    dimensionsBytesSize += dimensionsBytes[index].length;
                    ++index;
                }
                TreeSet<String> metrics = Sets.newTreeSet();
                if (query2.getMetrics() != null) {
                    metrics.addAll(query2.getMetrics());
                }
                byte[][] byArrayArray = new byte[metrics.size()][];
                int metricBytesSize = 0;
                index = 0;
                for (String metric : metrics) {
                    byArrayArray[index] = StringUtils.toUtf8(metric);
                    metricBytesSize += byArrayArray[index].length;
                    ++index;
                }
                byte[] virtualColumnsCacheKey = query2.getVirtualColumns().getCacheKey();
                byte isDescendingByte = query2.isDescending() ? (byte)1 : 0;
                ByteBuffer queryCacheKey = ByteBuffer.allocate(2 + granularityBytes.length + filterBytes.length + query2.getPagingSpec().getCacheKey().length + dimensionsBytesSize + metricBytesSize + virtualColumnsCacheKey.length).put((byte)22).put(granularityBytes).put(filterBytes).put(query2.getPagingSpec().getCacheKey()).put(isDescendingByte);
                for (byte[] dimensionsByte : dimensionsBytes) {
                    queryCacheKey.put(dimensionsByte);
                }
                for (byte[] metricByte : byArrayArray) {
                    queryCacheKey.put(metricByte);
                }
                queryCacheKey.put(virtualColumnsCacheKey);
                return queryCacheKey.array();
            }

            @Override
            public TypeReference<Object> getCacheObjectClazz() {
                return OBJECT_TYPE_REFERENCE;
            }

            @Override
            public Function<Result<SelectResultValue>, Object> prepareForCache() {
                return new Function<Result<SelectResultValue>, Object>(){

                    @Override
                    public Object apply(Result<SelectResultValue> input) {
                        if (!dimOutputNames.isEmpty()) {
                            return Arrays.asList(input.getTimestamp().getMillis(), input.getValue().getPagingIdentifiers(), input.getValue().getDimensions(), input.getValue().getMetrics(), input.getValue().getEvents(), dimOutputNames);
                        }
                        return Arrays.asList(input.getTimestamp().getMillis(), input.getValue().getPagingIdentifiers(), input.getValue().getDimensions(), input.getValue().getMetrics(), input.getValue().getEvents());
                    }
                };
            }

            @Override
            public Function<Object, Result<SelectResultValue>> pullFromCache() {
                return new Function<Object, Result<SelectResultValue>>(){
                    private final Granularity granularity;
                    {
                        this.granularity = query.getGranularity();
                    }

                    @Override
                    public Result<SelectResultValue> apply(Object input) {
                        List results = (List)input;
                        Iterator resultIter = results.iterator();
                        DateTime timestamp = this.granularity.toDateTime(((Number)resultIter.next()).longValue());
                        Map<String, Integer> pageIdentifier = SelectQueryQueryToolChest.this.jsonMapper.convertValue(resultIter.next(), new TypeReference<Map<String, Integer>>(){});
                        Set<String> dimensionSet = SelectQueryQueryToolChest.this.jsonMapper.convertValue(resultIter.next(), new TypeReference<Set<String>>(){});
                        Set<String> metricSet = SelectQueryQueryToolChest.this.jsonMapper.convertValue(resultIter.next(), new TypeReference<Set<String>>(){});
                        List<EventHolder> eventHolders = SelectQueryQueryToolChest.this.jsonMapper.convertValue(resultIter.next(), new TypeReference<List<EventHolder>>(){});
                        if (resultIter.hasNext()) {
                            List cachedOutputNames = (List)resultIter.next();
                            Preconditions.checkArgument(cachedOutputNames.size() == dimOutputNames.size(), "Cache hit but different number of dimensions??");
                            for (int idx = 0; idx < dimOutputNames.size(); ++idx) {
                                if (((String)cachedOutputNames.get(idx)).equals(dimOutputNames.get(idx))) continue;
                                for (EventHolder eventHolder : eventHolders) {
                                    Object obj = eventHolder.getEvent().remove(cachedOutputNames.get(idx));
                                    if (obj == null) continue;
                                    eventHolder.getEvent().put((String)dimOutputNames.get(idx), obj);
                                }
                            }
                        }
                        return new Result<SelectResultValue>(timestamp, new SelectResultValue(pageIdentifier, dimensionSet, metricSet, eventHolders));
                    }
                };
            }
        };
    }

    @Override
    public QueryRunner<Result<SelectResultValue>> preMergeQueryDecoration(final QueryRunner<Result<SelectResultValue>> runner) {
        return this.intervalChunkingQueryRunnerDecorator.decorate(new QueryRunner<Result<SelectResultValue>>(){

            @Override
            public Sequence<Result<SelectResultValue>> run(QueryPlus<Result<SelectResultValue>> queryPlus, Map<String, Object> responseContext) {
                SelectQuery selectQuery = (SelectQuery)queryPlus.getQuery();
                if (selectQuery.getDimensionsFilter() != null) {
                    selectQuery = selectQuery.withDimFilter(selectQuery.getDimensionsFilter().optimize());
                    queryPlus = queryPlus.withQuery(selectQuery);
                }
                return runner.run(queryPlus, responseContext);
            }
        }, this);
    }

    @Override
    public <T extends LogicalSegment> List<T> filterSegments(SelectQuery query, List<T> segments) {
        final String dataSource = Iterables.getOnlyElement(query.getDataSource().getNames());
        PagingSpec pagingSpec = query.getPagingSpec();
        Map<String, Integer> paging = pagingSpec.getPagingIdentifiers();
        if (paging == null || paging.isEmpty()) {
            return segments;
        }
        Granularity granularity = query.getGranularity();
        Iterable<String> filteredPagingKeys = Iterables.filter(paging.keySet(), new Predicate<String>(){

            @Override
            public boolean apply(String input) {
                return DataSegmentUtils.valueOf(dataSource, input) != null;
            }
        });
        ArrayList<Interval> intervals = Lists.newArrayList(Iterables.transform(filteredPagingKeys, DataSegmentUtils.INTERVAL_EXTRACTOR(dataSource)));
        Collections.sort(intervals, query.isDescending() ? Comparators.intervalsByEndThenStart() : Comparators.intervalsByStartThenEnd());
        TreeMap<Long, Long> granularThresholds = Maps.newTreeMap();
        for (Interval interval : intervals) {
            if (query.isDescending()) {
                long granularEnd = granularity.bucketStart(interval.getEnd()).getMillis();
                Long currentEnd = (Long)granularThresholds.get(granularEnd);
                if (currentEnd != null && interval.getEndMillis() <= currentEnd) continue;
                granularThresholds.put(granularEnd, interval.getEndMillis());
                continue;
            }
            long granularStart = granularity.bucketStart(interval.getStart()).getMillis();
            Long currentStart = (Long)granularThresholds.get(granularStart);
            if (currentStart != null && interval.getStartMillis() >= currentStart) continue;
            granularThresholds.put(granularStart, interval.getStartMillis());
        }
        ArrayList<T> queryIntervals = Lists.newArrayList(segments);
        Iterator it = queryIntervals.iterator();
        if (query.isDescending()) {
            while (it.hasNext()) {
                Interval interval = ((LogicalSegment)it.next()).getInterval();
                Map.Entry ceiling = granularThresholds.ceilingEntry(granularity.bucketStart(interval.getEnd()).getMillis());
                if (ceiling != null && interval.getStartMillis() < (Long)ceiling.getValue()) continue;
                it.remove();
            }
        } else {
            while (it.hasNext()) {
                Interval interval = ((LogicalSegment)it.next()).getInterval();
                Map.Entry floor = granularThresholds.floorEntry(granularity.bucketStart(interval.getStart()).getMillis());
                if (floor != null && interval.getEndMillis() > (Long)floor.getValue()) continue;
                it.remove();
            }
        }
        return queryIntervals;
    }
}

