/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.lookup;

import java.util.Objects;
import javax.validation.constraints.Min;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Strings;

public class LookupConfig {
    @JsonProperty(value="snapshotWorkingDir")
    private String snapshotWorkingDir;
    @JsonProperty(value="enableLookupSyncOnStartup")
    private boolean enableLookupSyncOnStartup = true;
    @Min(value=1L)
    @JsonProperty(value="numLookupLoadingThreads")
    private int numLookupLoadingThreads = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
    @Min(value=1L)
    @JsonProperty(value="coordinatorFetchRetries")
    private int coordinatorFetchRetries = 3;
    @Min(value=1L)
    @JsonProperty(value="lookupStartRetries")
    private int lookupStartRetries = 3;

    @JsonCreator
    public LookupConfig(@JsonProperty(value="snapshotWorkingDir") String snapshotWorkingDir) {
        this.snapshotWorkingDir = Strings.nullToEmpty(snapshotWorkingDir);
    }

    public String getSnapshotWorkingDir() {
        return this.snapshotWorkingDir;
    }

    public int getNumLookupLoadingThreads() {
        return this.numLookupLoadingThreads;
    }

    public boolean getEnableLookupSyncOnStartup() {
        return this.enableLookupSyncOnStartup;
    }

    public int getCoordinatorFetchRetries() {
        return this.coordinatorFetchRetries;
    }

    public int getLookupStartRetries() {
        return this.lookupStartRetries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LookupConfig)) {
            return false;
        }
        LookupConfig that = (LookupConfig)o;
        return Objects.equals(this.snapshotWorkingDir, that.snapshotWorkingDir) && this.enableLookupSyncOnStartup == that.enableLookupSyncOnStartup && this.numLookupLoadingThreads == that.numLookupLoadingThreads && this.coordinatorFetchRetries == that.coordinatorFetchRetries && this.lookupStartRetries == that.lookupStartRetries;
    }

    public int hashCode() {
        return Objects.hash(this.snapshotWorkingDir, this.enableLookupSyncOnStartup, this.numLookupLoadingThreads, this.coordinatorFetchRetries, this.lookupStartRetries);
    }

    public String toString() {
        return "LookupConfig{snapshotWorkingDir='" + this.snapshotWorkingDir + '\'' + ", enableLookupSyncOnStartup=" + this.enableLookupSyncOnStartup + ", numLookupLoadingThreads=" + this.numLookupLoadingThreads + ", coordinatorFetchRetries=" + this.coordinatorFetchRetries + ", lookupStartRetries=" + this.lookupStartRetries + '}';
    }
}

