/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.aggregation.first;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.primitives.Doubles;
import org.apache.hive.druid.com.google.common.primitives.Longs;
import org.apache.hive.druid.io.druid.collections.SerializablePair;
import org.apache.hive.druid.io.druid.java.util.common.StringUtils;
import org.apache.hive.druid.io.druid.java.util.common.UOE;
import org.apache.hive.druid.io.druid.query.aggregation.AggregateCombiner;
import org.apache.hive.druid.io.druid.query.aggregation.Aggregator;
import org.apache.hive.druid.io.druid.query.aggregation.AggregatorFactory;
import org.apache.hive.druid.io.druid.query.aggregation.BufferAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.first.DoubleFirstAggregator;
import org.apache.hive.druid.io.druid.query.aggregation.first.DoubleFirstBufferAggregator;
import org.apache.hive.druid.io.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.hive.druid.io.druid.segment.ColumnSelectorFactory;
import org.apache.hive.druid.io.druid.segment.ColumnValueSelector;
import org.apache.hive.druid.io.druid.segment.column.Column;

public class DoubleFirstAggregatorFactory
extends AggregatorFactory {
    public static final Comparator VALUE_COMPARATOR = (o1, o2) -> Doubles.compare((Double)((SerializablePair)o1).rhs, (Double)((SerializablePair)o2).rhs);
    public static final Comparator TIME_COMPARATOR = (o1, o2) -> Longs.compare((Long)((SerializablePair)o1).lhs, (Long)((SerializablePair)o2).lhs);
    private final String fieldName;
    private final String name;
    private final boolean storeDoubleAsFloat;

    @JsonCreator
    public DoubleFirstAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName) {
        Preconditions.checkNotNull(name, "Must have a valid, non-null aggregator name");
        Preconditions.checkNotNull(fieldName, "Must have a valid, non-null fieldName");
        this.name = name;
        this.fieldName = fieldName;
        this.storeDoubleAsFloat = Column.storeDoubleAsFloat();
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        return new DoubleFirstAggregator(metricFactory.makeColumnValueSelector("__time"), metricFactory.makeColumnValueSelector(this.fieldName));
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        return new DoubleFirstBufferAggregator(metricFactory.makeColumnValueSelector("__time"), metricFactory.makeColumnValueSelector(this.fieldName));
    }

    @Override
    public Comparator getComparator() {
        return VALUE_COMPARATOR;
    }

    @Override
    public Object combine(Object lhs, Object rhs) {
        return TIME_COMPARATOR.compare(lhs, rhs) <= 0 ? lhs : rhs;
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        throw new UOE("DoubleFirstAggregatorFactory is not supported during ingestion for rollup", new Object[0]);
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new DoubleFirstAggregatorFactory(this.name, this.name){

            @Override
            public Aggregator factorize(ColumnSelectorFactory metricFactory) {
                final ColumnValueSelector selector = metricFactory.makeColumnValueSelector(DoubleFirstAggregatorFactory.this.name);
                return new DoubleFirstAggregator(null, null){

                    @Override
                    public void aggregate() {
                        SerializablePair pair = (SerializablePair)selector.getObject();
                        if ((Long)pair.lhs < this.firstTime) {
                            this.firstTime = (Long)pair.lhs;
                            this.firstValue = (Double)pair.rhs;
                        }
                    }
                };
            }

            @Override
            public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
                final ColumnValueSelector selector = metricFactory.makeColumnValueSelector(DoubleFirstAggregatorFactory.this.name);
                return new DoubleFirstBufferAggregator(null, null){

                    @Override
                    public void aggregate(ByteBuffer buf, int position) {
                        SerializablePair pair = (SerializablePair)selector.getObject();
                        long firstTime = buf.getLong(position);
                        if ((Long)pair.lhs < firstTime) {
                            buf.putLong(position, (Long)pair.lhs);
                            buf.putDouble(position + 8, (Double)pair.rhs);
                        }
                    }

                    @Override
                    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                        inspector.visit("selector", selector);
                    }
                };
            }
        };
    }

    @Override
    public List<AggregatorFactory> getRequiredColumns() {
        return Arrays.asList(new DoubleFirstAggregatorFactory(this.fieldName, this.fieldName));
    }

    @Override
    public Object deserialize(Object object) {
        Map map = (Map)object;
        return new SerializablePair<Long, Double>(((Number)map.get("lhs")).longValue(), ((Number)map.get("rhs")).doubleValue());
    }

    @Override
    public Object finalizeComputation(Object object) {
        return ((SerializablePair)object).rhs;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public List<String> requiredFields() {
        return Arrays.asList("__time", this.fieldName);
    }

    @Override
    public byte[] getCacheKey() {
        byte[] fieldNameBytes = StringUtils.toUtf8(this.fieldName);
        return ByteBuffer.allocate(1 + fieldNameBytes.length).put((byte)20).put(fieldNameBytes).array();
    }

    @Override
    public String getTypeName() {
        if (this.storeDoubleAsFloat) {
            return "float";
        }
        return "double";
    }

    @Override
    public int getMaxIntermediateSize() {
        return 16;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleFirstAggregatorFactory that = (DoubleFirstAggregatorFactory)o;
        return this.fieldName.equals(that.fieldName) && this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.name);
    }

    public String toString() {
        return "DoubleFirstAggregatorFactory{name='" + this.name + '\'' + ", fieldName='" + this.fieldName + '\'' + '}';
    }
}

