/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query;

import java.io.Closeable;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.base.Predicates;
import org.apache.hive.druid.io.druid.java.util.common.granularity.Granularity;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.io.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.io.druid.query.QueryPlus;
import org.apache.hive.druid.io.druid.query.QueryRunner;
import org.apache.hive.druid.io.druid.query.Result;
import org.apache.hive.druid.io.druid.query.filter.Filter;
import org.apache.hive.druid.io.druid.segment.Cursor;
import org.apache.hive.druid.io.druid.segment.StorageAdapter;
import org.apache.hive.druid.io.druid.segment.VirtualColumns;
import org.joda.time.Interval;

public class QueryRunnerHelper {
    public static <T> Sequence<Result<T>> makeCursorBasedQuery(StorageAdapter adapter, List<Interval> queryIntervals, Filter filter, VirtualColumns virtualColumns, boolean descending, Granularity granularity, final Function<Cursor, Result<T>> mapFn) {
        Preconditions.checkArgument(queryIntervals.size() == 1, "Can only handle a single interval, got[%s]", new Object[]{queryIntervals});
        return Sequences.filter(Sequences.map(adapter.makeCursors(filter, queryIntervals.get(0), virtualColumns, granularity, descending, null), new Function<Cursor, Result<T>>(){

            @Override
            public Result<T> apply(Cursor input) {
                return (Result)mapFn.apply(input);
            }
        }), Predicates.notNull());
    }

    public static <T> QueryRunner<T> makeClosingQueryRunner(final QueryRunner<T> runner, final Closeable closeable) {
        return new QueryRunner<T>(){

            @Override
            public Sequence<T> run(QueryPlus<T> queryPlus, Map<String, Object> responseContext) {
                return Sequences.withBaggage(runner.run(queryPlus, responseContext), closeable);
            }
        };
    }
}

