/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scope;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.apache.hive.druid.io.druid.guice.KeyHolder;
import org.apache.hive.druid.io.druid.guice.LazySingleton;
import org.apache.hive.druid.io.druid.guice.LifecycleScope;
import org.apache.hive.druid.io.druid.guice.ManageLifecycle;
import org.apache.hive.druid.io.druid.guice.ManageLifecycleLast;
import org.apache.hive.druid.io.druid.java.util.common.lifecycle.Lifecycle;

public class LifecycleModule
implements Module {
    private final LifecycleScope scope = new LifecycleScope(Lifecycle.Stage.NORMAL);
    private final LifecycleScope lastScope = new LifecycleScope(Lifecycle.Stage.LAST);

    public static void register(Binder binder, Class<?> clazz) {
        LifecycleModule.registerKey(binder, Key.get(clazz));
    }

    public static void register(Binder binder, Class<?> clazz, Class<? extends Annotation> annotation) {
        LifecycleModule.registerKey(binder, Key.get(clazz, annotation));
    }

    public static void registerKey(Binder binder, Key<?> key) {
        LifecycleModule.getEagerBinder(binder).addBinding().toInstance(new KeyHolder(key));
    }

    private static Multibinder<KeyHolder> getEagerBinder(Binder binder) {
        return Multibinder.newSetBinder((Binder)binder, KeyHolder.class, (Annotation)Names.named((String)"lifecycle"));
    }

    public void configure(Binder binder) {
        LifecycleModule.getEagerBinder(binder);
        binder.bindScope(ManageLifecycle.class, (Scope)this.scope);
        binder.bindScope(ManageLifecycleLast.class, (Scope)this.lastScope);
    }

    @Provides
    @LazySingleton
    public Lifecycle getLifecycle(final Injector injector) {
        Key keyHolderKey = Key.get((TypeLiteral)new TypeLiteral<Set<KeyHolder>>(){}, (Annotation)Names.named((String)"lifecycle"));
        final Set eagerClasses = (Set)injector.getInstance(keyHolderKey);
        Lifecycle lifecycle = new Lifecycle(){

            @Override
            public void start() throws Exception {
                for (KeyHolder holder : eagerClasses) {
                    injector.getInstance(holder.getKey());
                }
                super.start();
            }
        };
        this.scope.setLifecycle(lifecycle);
        this.lastScope.setLifecycle(lifecycle);
        return lifecycle;
    }
}

