/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.collections.spatial;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.collections.bitmap.BitmapFactory;
import org.apache.hive.druid.io.druid.collections.bitmap.MutableBitmap;

public class Node {
    private final float[] minCoordinates;
    private final float[] maxCoordinates;
    private final List<Node> children;
    private final boolean isLeaf;
    private final MutableBitmap bitmap;
    private Node parent;

    public Node(float[] minCoordinates, float[] maxCoordinates, boolean isLeaf, BitmapFactory bitmapFactory) {
        this(minCoordinates, maxCoordinates, Lists.newArrayList(), isLeaf, null, bitmapFactory.makeEmptyMutableBitmap());
    }

    public Node(float[] minCoordinates, float[] maxCoordinates, List<Node> children, boolean isLeaf, Node parent, MutableBitmap bitmap) {
        Preconditions.checkArgument(minCoordinates.length == maxCoordinates.length);
        this.minCoordinates = minCoordinates;
        this.maxCoordinates = maxCoordinates;
        this.children = children;
        for (Node child : children) {
            child.setParent(this);
        }
        this.isLeaf = isLeaf;
        this.bitmap = bitmap;
        this.parent = parent;
    }

    public int getNumDims() {
        return this.minCoordinates.length;
    }

    public float[] getMinCoordinates() {
        return this.minCoordinates;
    }

    public float[] getMaxCoordinates() {
        return this.maxCoordinates;
    }

    public Node getParent() {
        return this.parent;
    }

    private void setParent(Node p) {
        this.parent = p;
    }

    public void addChild(Node node) {
        node.setParent(this);
        this.children.add(node);
    }

    public List<Node> getChildren() {
        return this.children;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public double getArea() {
        return this.calculateArea();
    }

    public boolean contains(float[] coords) {
        Preconditions.checkArgument(this.getNumDims() == coords.length);
        for (int i = 0; i < this.getNumDims(); ++i) {
            if (!(coords[i] < this.minCoordinates[i]) && !(coords[i] > this.maxCoordinates[i])) continue;
            return false;
        }
        return true;
    }

    public boolean enclose() {
        boolean retVal = false;
        float[] minCoords = new float[this.getNumDims()];
        Arrays.fill(minCoords, Float.POSITIVE_INFINITY);
        float[] maxCoords = new float[this.getNumDims()];
        Arrays.fill(maxCoords, Float.NEGATIVE_INFINITY);
        for (Node child : this.getChildren()) {
            for (int i = 0; i < this.getNumDims(); ++i) {
                minCoords[i] = Math.min(child.getMinCoordinates()[i], minCoords[i]);
                maxCoords[i] = Math.max(child.getMaxCoordinates()[i], maxCoords[i]);
            }
        }
        if (!Arrays.equals(minCoords, this.minCoordinates)) {
            System.arraycopy(minCoords, 0, this.minCoordinates, 0, this.minCoordinates.length);
            retVal = true;
        }
        if (!Arrays.equals(maxCoords, this.maxCoordinates)) {
            System.arraycopy(maxCoords, 0, this.maxCoordinates, 0, this.maxCoordinates.length);
            retVal = true;
        }
        return retVal;
    }

    public MutableBitmap getBitmap() {
        return this.bitmap;
    }

    public void addToBitmapIndex(Node node) {
        this.bitmap.or(node.getBitmap());
    }

    public void clear() {
        this.children.clear();
        this.bitmap.clear();
    }

    public int getSizeInBytes() {
        return 2 + 2 * this.getNumDims() * 4 + 4 + this.bitmap.getSizeInBytes() + this.getChildren().size() * 4;
    }

    public int storeInByteBuffer(ByteBuffer buffer, int position) {
        buffer.position(position);
        buffer.putShort((short)((this.isLeaf ? 1 : 0) << 15 | this.getChildren().size()));
        for (float v : this.getMinCoordinates()) {
            buffer.putFloat(v);
        }
        for (float v : this.getMaxCoordinates()) {
            buffer.putFloat(v);
        }
        byte[] bytes = this.bitmap.toBytes();
        buffer.putInt(bytes.length);
        buffer.put(bytes);
        int pos = buffer.position();
        int childStartOffset = pos + this.getChildren().size() * 4;
        for (Node child : this.getChildren()) {
            buffer.putInt(pos, childStartOffset);
            childStartOffset = child.storeInByteBuffer(buffer, childStartOffset);
            pos += 4;
        }
        return childStartOffset;
    }

    private double calculateArea() {
        double area = 1.0;
        for (int i = 0; i < this.minCoordinates.length; ++i) {
            area *= (double)(this.maxCoordinates[i] - this.minCoordinates[i]);
        }
        return area;
    }
}

