/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.emitter.service;

import java.util.Arrays;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonValue;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Maps;
import org.apache.hive.druid.com.metamx.common.ISE;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEvent;
import org.apache.hive.druid.com.metamx.emitter.service.ServiceEventBuilder;
import org.joda.time.DateTime;

public class ServiceMetricEvent
implements ServiceEvent {
    private final DateTime createdTime;
    private final ImmutableMap<String, String> serviceDims;
    private final Map<String, Object> userDims;
    private final String feed;
    private final String metric;
    private final Number value;

    public static Builder builder() {
        return new Builder();
    }

    private ServiceMetricEvent(DateTime createdTime, ImmutableMap<String, String> serviceDims, Map<String, Object> userDims, String feed, String metric, Number value) {
        this.createdTime = createdTime != null ? createdTime : new DateTime();
        this.serviceDims = serviceDims;
        this.userDims = userDims;
        this.feed = feed;
        this.metric = metric;
        this.value = value;
    }

    @Override
    public DateTime getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public String getFeed() {
        return this.feed;
    }

    @Override
    public String getService() {
        return this.serviceDims.get("service");
    }

    @Override
    public String getHost() {
        return this.serviceDims.get("host");
    }

    public Map<String, Object> getUserDims() {
        return ImmutableMap.copyOf(this.userDims);
    }

    public String getMetric() {
        return this.metric;
    }

    public Number getValue() {
        return this.value;
    }

    @Override
    public boolean isSafeToBuffer() {
        return true;
    }

    @Override
    @JsonValue
    public Map<String, Object> toMap() {
        return ImmutableMap.builder().put("feed", this.getFeed()).put("timestamp", this.createdTime.toString()).putAll(this.serviceDims).put("metric", this.metric).put("value", (String)((Object)this.value)).putAll(Maps.filterEntries(this.userDims, new Predicate<Map.Entry<String, Object>>(){

            @Override
            public boolean apply(Map.Entry<String, Object> input) {
                return input.getKey() != null;
            }
        })).build();
    }

    public static class Builder {
        private final Map<String, Object> userDims = Maps.newTreeMap();
        private String feed = "metrics";

        public Builder setFeed(String feed) {
            this.feed = feed;
            return this;
        }

        public Builder setDimension(String dim, String[] values) {
            this.userDims.put(dim, Arrays.asList(values));
            return this;
        }

        public Builder setDimension(String dim, String value) {
            this.userDims.put(dim, value);
            return this;
        }

        public Object getDimension(String dim) {
            return this.userDims.get(dim);
        }

        public ServiceEventBuilder<ServiceMetricEvent> build(String metric, Number value) {
            return this.build(null, metric, value);
        }

        public ServiceEventBuilder<ServiceMetricEvent> build(final DateTime createdTime, final String metric, final Number value) {
            if (Double.isNaN(value.doubleValue())) {
                throw new ISE("Value of NaN is not allowed!", new Object[0]);
            }
            if (Double.isInfinite(value.doubleValue())) {
                throw new ISE("Value of Infinite is not allowed!", new Object[0]);
            }
            return new ServiceEventBuilder<ServiceMetricEvent>(){

                @Override
                public ServiceMetricEvent build(ImmutableMap<String, String> serviceDimensions) {
                    return new ServiceMetricEvent(createdTime, serviceDimensions, userDims, feed, metric, value);
                }
            };
        }
    }
}

