/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.com.metamx.common;

import java.io.File;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.base.Throwables;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.io.ByteSource;
import org.apache.hive.druid.com.google.common.io.FileWriteMode;
import org.apache.hive.druid.com.google.common.io.Files;
import org.apache.hive.druid.com.metamx.common.MappedByteBufferHandler;
import org.apache.hive.druid.com.metamx.common.StreamUtils;

public class FileUtils {
    public static final Predicate<Throwable> IS_EXCEPTION = new Predicate<Throwable>(){

        @Override
        public boolean apply(Throwable input) {
            return input instanceof Exception;
        }
    };

    public static FileCopyResult retryCopy(ByteSource byteSource, File outFile, Predicate<Throwable> shouldRetry, int maxAttempts) {
        try {
            StreamUtils.retryCopy(byteSource, Files.asByteSink(outFile, new FileWriteMode[0]), shouldRetry, maxAttempts);
            return new FileCopyResult(outFile);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    public static MappedByteBufferHandler map(File file) throws IOException {
        MappedByteBuffer mappedByteBuffer = Files.map(file);
        return new MappedByteBufferHandler(mappedByteBuffer);
    }

    public static class FileCopyResult {
        private final Collection<File> files = Lists.newArrayList();
        private long size = 0L;

        public Collection<File> getFiles() {
            return ImmutableList.copyOf(this.files);
        }

        public long size() {
            return this.size;
        }

        public FileCopyResult(File ... files) {
            this(files == null ? ImmutableList.of() : Arrays.asList(files));
        }

        public FileCopyResult(Collection<File> files) {
            this.addSizedFiles(files);
        }

        protected void addSizedFiles(Collection<File> files) {
            if (files == null || files.isEmpty()) {
                return;
            }
            long size = 0L;
            for (File file : files) {
                size += file.length();
            }
            this.files.addAll(files);
            this.size += size;
        }

        public void addFiles(Collection<File> files) {
            this.addSizedFiles(files);
        }

        public void addFile(File file) {
            this.addFiles(ImmutableList.of(file));
        }
    }
}

