/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.serde;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hive.druid.DruidStorageHandlerUtils;
import org.apache.hadoop.hive.druid.serde.DruidQueryRecordReader;
import org.apache.hadoop.hive.druid.serde.DruidWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JavaType;
import org.apache.hive.druid.io.druid.query.scan.ScanQuery;
import org.apache.hive.druid.io.druid.query.scan.ScanResultValue;

public class DruidScanQueryRecordReader
extends DruidQueryRecordReader<ScanQuery, ScanResultValue> {
    private static final TypeReference<ScanResultValue> TYPE_REFERENCE = new TypeReference<ScanResultValue>(){};
    private ScanResultValue current;
    private Iterator<List<Object>> compactedValues = Collections.emptyIterator();

    @Override
    protected JavaType getResultTypeDef() {
        return DruidStorageHandlerUtils.JSON_MAPPER.getTypeFactory().constructType(TYPE_REFERENCE);
    }

    @Override
    public boolean nextKeyValue() throws IOException {
        if (this.compactedValues.hasNext()) {
            return true;
        }
        if (this.queryResultsIterator.hasNext()) {
            this.current = (ScanResultValue)this.queryResultsIterator.next();
            this.compactedValues = ((List)this.current.getEvents()).iterator();
            return this.nextKeyValue();
        }
        return false;
    }

    @Override
    public NullWritable getCurrentKey() throws IOException, InterruptedException {
        return NullWritable.get();
    }

    @Override
    public DruidWritable getCurrentValue() throws IOException, InterruptedException {
        DruidWritable value = new DruidWritable();
        List<Object> e = this.compactedValues.next();
        for (int i = 0; i < this.current.getColumns().size(); ++i) {
            value.getValue().put(this.current.getColumns().get(i), e.get(i));
        }
        return value;
    }

    @Override
    public boolean next(NullWritable key, DruidWritable value) throws IOException {
        if (this.nextKeyValue()) {
            value.getValue().clear();
            List<Object> e = this.compactedValues.next();
            for (int i = 0; i < this.current.getColumns().size(); ++i) {
                value.getValue().put(this.current.getColumns().get(i), e.get(i));
            }
            return true;
        }
        return false;
    }

    @Override
    public float getProgress() {
        return this.queryResultsIterator.hasNext() || this.compactedValues.hasNext() ? 0.0f : 1.0f;
    }
}

