/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.druid.serde;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.druid.DruidStorageHandlerUtils;
import org.apache.hadoop.hive.druid.serde.DruidQueryRecordReader;
import org.apache.hadoop.hive.druid.serde.DruidWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JavaType;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.metamx.http.client.HttpClient;
import org.apache.hive.druid.io.druid.data.input.MapBasedRow;
import org.apache.hive.druid.io.druid.data.input.Row;
import org.apache.hive.druid.io.druid.query.groupby.GroupByQuery;

public class DruidGroupByQueryRecordReader
extends DruidQueryRecordReader<GroupByQuery, Row> {
    private static final TypeReference<Row> TYPE_REFERENCE = new TypeReference<Row>(){};
    private MapBasedRow currentRow;
    private Map<String, Object> currentEvent;

    @Override
    public void initialize(InputSplit split, Configuration conf) throws IOException {
        super.initialize(split, conf);
    }

    @Override
    public void initialize(InputSplit split, Configuration conf, ObjectMapper mapper, ObjectMapper smileMapper, HttpClient httpClient) throws IOException {
        super.initialize(split, conf, mapper, smileMapper, httpClient);
    }

    @Override
    protected JavaType getResultTypeDef() {
        return DruidStorageHandlerUtils.JSON_MAPPER.getTypeFactory().constructType(TYPE_REFERENCE);
    }

    @Override
    public boolean nextKeyValue() {
        if (this.queryResultsIterator.hasNext()) {
            Row row = (Row)this.queryResultsIterator.next();
            this.currentRow = (MapBasedRow)row;
            this.currentEvent = this.currentRow.getEvent();
            return true;
        }
        return false;
    }

    @Override
    public NullWritable getCurrentKey() throws IOException, InterruptedException {
        return NullWritable.get();
    }

    @Override
    public DruidWritable getCurrentValue() throws IOException, InterruptedException {
        DruidWritable value = new DruidWritable();
        value.getValue().put("timestamp", this.currentRow.getTimestamp() == null ? null : Long.valueOf(this.currentRow.getTimestamp().getMillis()));
        value.getValue().putAll(this.currentEvent);
        return value;
    }

    @Override
    public boolean next(NullWritable key, DruidWritable value) {
        if (this.nextKeyValue()) {
            value.getValue().clear();
            value.getValue().put("timestamp", this.currentRow.getTimestamp() == null ? null : Long.valueOf(this.currentRow.getTimestamp().getMillis()));
            value.getValue().putAll(this.currentEvent);
            return true;
        }
        return false;
    }

    @Override
    public float getProgress() throws IOException {
        return this.queryResultsIterator.hasNext() ? 0.0f : 1.0f;
    }
}

