/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.ws;

import java.net.SocketAddress;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.hive.druid.io.netty.buffer.Unpooled;
import org.apache.hive.druid.io.netty.channel.Channel;
import org.apache.hive.druid.io.netty.handler.codec.http.HttpHeaders;
import org.apache.hive.druid.io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import org.apache.hive.druid.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.apache.hive.druid.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import org.apache.hive.druid.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import org.apache.hive.druid.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.asynchttpclient.netty.util.ByteBufUtils;
import org.asynchttpclient.ws.WebSocket;
import org.asynchttpclient.ws.WebSocketByteListener;
import org.asynchttpclient.ws.WebSocketCloseCodeReasonListener;
import org.asynchttpclient.ws.WebSocketListener;
import org.asynchttpclient.ws.WebSocketPingListener;
import org.asynchttpclient.ws.WebSocketPongListener;
import org.asynchttpclient.ws.WebSocketTextListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyWebSocket
implements WebSocket {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyWebSocket.class);
    protected final Channel channel;
    protected final HttpHeaders upgradeHeaders;
    protected final Collection<WebSocketListener> listeners;
    private volatile boolean interestedInByteMessages;
    private volatile boolean interestedInTextMessages;

    public NettyWebSocket(Channel channel, HttpHeaders upgradeHeaders) {
        this(channel, upgradeHeaders, new ConcurrentLinkedQueue<WebSocketListener>());
    }

    public NettyWebSocket(Channel channel, HttpHeaders upgradeHeaders, Collection<WebSocketListener> listeners) {
        this.channel = channel;
        this.upgradeHeaders = upgradeHeaders;
        this.listeners = listeners;
    }

    @Override
    public HttpHeaders getUpgradeHeaders() {
        return this.upgradeHeaders;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.channel.remoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.channel.localAddress();
    }

    @Override
    public WebSocket sendMessage(byte[] message) {
        this.channel.writeAndFlush(new BinaryWebSocketFrame(Unpooled.wrappedBuffer(message)), this.channel.voidPromise());
        return this;
    }

    @Override
    public WebSocket stream(byte[] fragment, boolean last) {
        this.channel.writeAndFlush(new BinaryWebSocketFrame(last, 0, Unpooled.wrappedBuffer(fragment)), this.channel.voidPromise());
        return this;
    }

    @Override
    public WebSocket stream(byte[] fragment, int offset, int len, boolean last) {
        this.channel.writeAndFlush(new BinaryWebSocketFrame(last, 0, Unpooled.wrappedBuffer(fragment, offset, len)), this.channel.voidPromise());
        return this;
    }

    @Override
    public WebSocket sendMessage(String message) {
        this.channel.writeAndFlush(new TextWebSocketFrame(message), this.channel.voidPromise());
        return this;
    }

    @Override
    public WebSocket stream(String fragment, boolean last) {
        this.channel.writeAndFlush(new TextWebSocketFrame(last, 0, fragment), this.channel.voidPromise());
        return this;
    }

    @Override
    public WebSocket sendPing(byte[] payload) {
        this.channel.writeAndFlush(new PingWebSocketFrame(Unpooled.wrappedBuffer(payload)), this.channel.voidPromise());
        return this;
    }

    @Override
    public WebSocket sendPong(byte[] payload) {
        this.channel.writeAndFlush(new PongWebSocketFrame(Unpooled.wrappedBuffer(payload)), this.channel.voidPromise());
        return this;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() {
        if (this.channel.isOpen()) {
            this.channel.writeAndFlush(new CloseWebSocketFrame(1000, "normal closure"));
        }
    }

    public void close(int statusCode, String reason) {
        this.onClose(statusCode, reason);
        this.listeners.clear();
    }

    public void onError(Throwable t) {
        for (WebSocketListener listener : this.listeners) {
            try {
                listener.onError(t);
            }
            catch (Throwable t2) {
                LOGGER.error("WebSocketListener.onError crash", t2);
            }
        }
    }

    public void onClose(int code, String reason) {
        for (WebSocketListener l : this.listeners) {
            try {
                if (l instanceof WebSocketCloseCodeReasonListener) {
                    ((WebSocketCloseCodeReasonListener)WebSocketCloseCodeReasonListener.class.cast(l)).onClose(this, code, reason);
                }
                l.onClose(this);
            }
            catch (Throwable t) {
                l.onError(t);
            }
        }
    }

    public String toString() {
        return "NettyWebSocket{channel=" + this.channel + '}';
    }

    private boolean hasWebSocketByteListener() {
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketByteListener)) continue;
            return true;
        }
        return false;
    }

    private boolean hasWebSocketTextListener() {
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketTextListener)) continue;
            return true;
        }
        return false;
    }

    @Override
    public WebSocket addWebSocketListener(WebSocketListener l) {
        this.listeners.add(l);
        this.interestedInByteMessages = this.interestedInByteMessages || l instanceof WebSocketByteListener;
        this.interestedInTextMessages = this.interestedInTextMessages || l instanceof WebSocketTextListener;
        return this;
    }

    @Override
    public WebSocket removeWebSocketListener(WebSocketListener l) {
        this.listeners.remove(l);
        if (l instanceof WebSocketByteListener) {
            this.interestedInByteMessages = this.hasWebSocketByteListener();
        }
        if (l instanceof WebSocketTextListener) {
            this.interestedInTextMessages = this.hasWebSocketTextListener();
        }
        return this;
    }

    private void notifyByteListeners(byte[] message) {
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketByteListener)) continue;
            ((WebSocketByteListener)WebSocketByteListener.class.cast(listener)).onMessage(message);
        }
    }

    private void notifyTextListeners(String message) {
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketTextListener)) continue;
            ((WebSocketTextListener)WebSocketTextListener.class.cast(listener)).onMessage(message);
        }
    }

    public void onBinaryFrame(BinaryWebSocketFrame frame) {
        if (this.interestedInByteMessages) {
            this.notifyByteListeners(ByteBufUtils.byteBuf2Bytes(frame.content()));
        }
    }

    public void onTextFrame(TextWebSocketFrame frame) {
        if (this.interestedInTextMessages) {
            try {
                this.notifyTextListeners(ByteBufUtils.byteBuf2String(StandardCharsets.UTF_8, frame.content()));
            }
            catch (CharacterCodingException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public void onPing(PingWebSocketFrame frame) {
        byte[] bytes = ByteBufUtils.byteBuf2Bytes(frame.content());
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketPingListener)) continue;
            ((WebSocketPingListener)WebSocketPingListener.class.cast(listener)).onPing(bytes);
        }
    }

    public void onPong(PongWebSocketFrame frame) {
        byte[] bytes = ByteBufUtils.byteBuf2Bytes(frame.content());
        for (WebSocketListener listener : this.listeners) {
            if (!(listener instanceof WebSocketPongListener)) continue;
            ((WebSocketPongListener)WebSocketPongListener.class.cast(listener)).onPong(bytes);
        }
    }
}

