/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.sql.fun;

import java.util.List;
import org.apache.hive.druid.org.apache.calcite.sql.SqlCall;
import org.apache.hive.druid.org.apache.calcite.sql.SqlFunction;
import org.apache.hive.druid.org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlNodeList;
import org.apache.hive.druid.org.apache.calcite.sql.fun.SqlCase;
import org.apache.hive.druid.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hive.druid.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.hive.druid.org.apache.calcite.sql.type.OperandTypes;
import org.apache.hive.druid.org.apache.calcite.sql.type.ReturnTypes;
import org.apache.hive.druid.org.apache.calcite.sql.validate.SqlValidator;
import org.apache.hive.druid.org.apache.calcite.util.Util;

public class SqlCoalesceFunction
extends SqlFunction {
    public SqlCoalesceFunction() {
        super("COALESCE", SqlKind.COALESCE, ReturnTypes.LEAST_RESTRICTIVE, null, OperandTypes.SAME_VARIADIC, SqlFunctionCategory.SYSTEM);
    }

    @Override
    public SqlNode rewriteCall(SqlValidator validator, SqlCall call) {
        this.validateQuantifier(validator, call);
        List<SqlNode> operands = call.getOperandList();
        if (operands.size() == 1) {
            return operands.get(0);
        }
        SqlParserPos pos = call.getParserPosition();
        SqlNodeList whenList = new SqlNodeList(pos);
        SqlNodeList thenList = new SqlNodeList(pos);
        for (SqlNode operand : Util.skipLast(operands)) {
            whenList.add(SqlStdOperatorTable.IS_NOT_NULL.createCall(pos, operand));
            thenList.add(SqlNode.clone(operand));
        }
        SqlNode elseExpr = Util.last(operands);
        assert (call.getFunctionQuantifier() == null);
        return SqlCase.createSwitched(pos, null, whenList, thenList, elseExpr);
    }
}

